/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.CommonBundle;
import com.intellij.ExtensionPoints;
import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.credentialStore.Credentials;
import com.intellij.diagnostic.AbstractMessage;
import com.intellij.diagnostic.Developer;
import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.diagnostic.ErrorReportConfigurable;
import com.intellij.diagnostic.GroupedLogMessage;
import com.intellij.diagnostic.ITNProxy;
import com.intellij.diagnostic.ITNReporter;
import com.intellij.diagnostic.IdeaReportingEvent;
import com.intellij.diagnostic.JetBrainsAccountDialogKt;
import com.intellij.diagnostic.LogMessage;
import com.intellij.diagnostic.MessagePool;
import com.intellij.diagnostic.MessagePoolListener;
import com.intellij.diagnostic.PluginException;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.ide.plugins.cl.PluginClassLoader;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.ErrorReportSubmitter;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.SubmittedReportInfo;
import com.intellij.openapi.extensions.ExtensionException;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.CheckBoxList;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.HideableDecorator;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.zip.CRC32;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeErrorsDialog
extends DialogWrapper
implements MessagePoolListener,
DataProvider {
    private static final Logger LOG = Logger.getInstance(IdeErrorsDialog.class);
    public static final DataKey<String> CURRENT_TRACE_KEY = DataKey.create((String)"current_stack_trace_key");
    private static final String STACKTRACE_ATTACHMENT = "stacktrace.txt";
    private static final String ACCEPTED_NOTICES_KEY = "exception.accepted.notices";
    private static final String ACCEPTED_NOTICES_SEPARATOR = ":";
    private static List<Developer> ourDevelopersList = Collections.emptyList();
    private final MessagePool myMessagePool;
    private final Project myProject;
    private final boolean myInternalMode;
    private final Set<String> myAcceptedNotices;
    private final List<MessageCluster> myMessageClusters;
    private int myIndex;
    private JLabel myCountLabel;
    private HyperlinkLabel.Croppable myInfoLabel;
    private HyperlinkLabel.Croppable myDisableLink;
    private HyperlinkLabel.Croppable myForeignPluginWarningLabel;
    private JTextArea myCommentArea;
    private AttachmentsList myAttachmentsList;
    private JTextArea myAttachmentArea;
    private JPanel myAssigneePanel;
    private JPanel myNoticePanel;
    private HideableDecorator myNoticeDecorator;
    private JEditorPane myNoticeArea;
    private ComboBox<Developer> myAssigneeCombo;
    private HyperlinkLabel myCredentialsLabel;

    public IdeErrorsDialog(@NotNull MessagePool messagePool, @Nullable Project project, @Nullable LogMessage defaultMessage) {
        if (messagePool == null) {
            IdeErrorsDialog.$$$reportNull$$$0(0);
        }
        super(project, true);
        this.myMessageClusters = new ArrayList<MessageCluster>();
        this.myMessagePool = messagePool;
        this.myProject = project;
        this.myInternalMode = ApplicationManager.getApplication().isInternal();
        this.setTitle(DiagnosticBundle.message("error.list.title", new Object[0]));
        this.setModal(false);
        this.init();
        this.setCancelButtonText(CommonBundle.message((String)"close.action.name", (Object[])new Object[0]));
        if (this.myInternalMode) {
            this.loadDevelopersList();
        }
        String rawValue = PropertiesComponent.getInstance().getValue(ACCEPTED_NOTICES_KEY, "");
        this.myAcceptedNotices = ContainerUtil.newLinkedHashSet((Iterable)StringUtil.split((String)rawValue, (String)ACCEPTED_NOTICES_SEPARATOR));
        this.updateMessages();
        this.selectMessage(defaultMessage);
        this.updateControls();
        messagePool.addListener(this);
    }

    private void loadDevelopersList() {
        if (!ourDevelopersList.isEmpty()) {
            this.myAssigneeCombo.setModel((ComboBoxModel)new CollectionComboBoxModel(ourDevelopersList));
        } else {
            new Task.Backgroundable(null, "Loading Developers List", true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    try {
                        List<Developer> developers = ITNProxy.fetchDevelopers(indicator);
                        ourDevelopersList = developers;
                        UIUtil.invokeLaterIfNeeded(() -> {
                            if (IdeErrorsDialog.this.isShowing()) {
                                IdeErrorsDialog.this.myAssigneeCombo.setModel((ComboBoxModel)new CollectionComboBoxModel(developers));
                            }
                        });
                    }
                    catch (IOException e) {
                        LOG.warn((Throwable)e);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diagnostic/IdeErrorsDialog$1", "run"));
                }
            }.queue();
        }
    }

    private void selectMessage(@Nullable LogMessage defaultMessage) {
        for (int i = 0; i < this.myMessageClusters.size(); ++i) {
            for (AbstractMessage message : this.myMessageClusters.get(i).messages) {
                if ((defaultMessage == null || message != defaultMessage) && (defaultMessage != null || message.isRead())) continue;
                this.myIndex = i;
                return;
            }
        }
    }

    @Nullable
    protected JComponent createNorthPanel() {
        this.myCountLabel = new JBLabel();
        this.myInfoLabel = new HyperlinkLabel.Croppable();
        this.myDisableLink = new HyperlinkLabel.Croppable();
        this.myDisableLink.setHyperlinkText(UIUtil.removeMnemonic((String)DiagnosticBundle.message("error.list.disable.plugin", new Object[0])));
        this.myDisableLink.addHyperlinkListener(e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                this.disablePlugin();
            }
        });
        this.myForeignPluginWarningLabel = new HyperlinkLabel.Croppable();
        JPanel controls = new JPanel(new BorderLayout());
        controls.add((Component)IdeErrorsDialog.actionToolbar("IdeErrorsBack", new BackAction()), "West");
        controls.add((Component)this.myCountLabel, "Center");
        controls.add((Component)IdeErrorsDialog.actionToolbar("IdeErrorsForward", new ForwardAction()), "East");
        JPanel panel2 = new JPanel(new GridBagLayout());
        panel2.add((Component)controls, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, (Insets)JBUI.insets((int)2), 0, 0));
        panel2.add((Component)this.myInfoLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, (Insets)JBUI.emptyInsets(), 0, 0));
        panel2.add((Component)this.myDisableLink, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, (Insets)JBUI.emptyInsets(), 0, 0));
        panel2.add((Component)new JPanel(), new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 1, (Insets)JBUI.emptyInsets(), 0, 0));
        panel2.add((Component)this.myForeignPluginWarningLabel, new GridBagConstraints(1, 1, 3, 1, 0.0, 0.0, 17, 0, (Insets)JBUI.emptyInsets(), 0, 0));
        return panel2;
    }

    private static JComponent actionToolbar(String id, AnAction action) {
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar(id, (ActionGroup)new DefaultActionGroup(new AnAction[]{action}), true);
        toolbar.setLayoutPolicy(0);
        toolbar.getComponent().setBorder((Border)JBUI.Borders.empty());
        return toolbar.getComponent();
    }

    protected JComponent createCenterPanel() {
        JBLabel commentLabel = new JBLabel(DiagnosticBundle.message("error.dialog.comment.prompt", new Object[0]));
        this.myCommentArea = new JTextArea(5, 0);
        this.myCommentArea.setMargin((Insets)JBUI.insets((int)2));
        this.myCommentArea.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                IdeErrorsDialog.this.selectedMessage().setAdditionalInfo(IdeErrorsDialog.this.myCommentArea.getText().trim());
            }
        });
        JBLabel attachmentsLabel = new JBLabel(DiagnosticBundle.message("error.dialog.attachments.prompt", new Object[0]));
        this.myAttachmentsList = new AttachmentsList();
        this.myAttachmentsList.addListSelectionListener(e -> {
            int index = this.myAttachmentsList.getSelectedIndex();
            if (index < 0) {
                this.myAttachmentArea.setText("");
                this.myAttachmentArea.setEditable(false);
            } else if (index == 0) {
                MessageCluster cluster = this.selectedCluster();
                this.myAttachmentArea.setText(cluster.detailsText);
                this.myAttachmentArea.setEditable(cluster.isUnsent());
            } else {
                this.myAttachmentArea.setText(this.selectedMessage().getAllAttachments().get(index - 1).getDisplayText());
                this.myAttachmentArea.setEditable(false);
            }
            this.myAttachmentArea.setCaretPosition(0);
        });
        this.myAttachmentsList.setCheckBoxListListener((index, value) -> {
            if (index > 0) {
                this.selectedMessage().getAllAttachments().get(index - 1).setIncluded(value);
            }
        });
        this.myAttachmentArea = new JTextArea();
        this.myAttachmentArea.setMargin((Insets)JBUI.insets((int)2));
        this.myAttachmentArea.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                if (IdeErrorsDialog.this.myAttachmentsList.getSelectedIndex() == 0) {
                    String detailsText = IdeErrorsDialog.this.myAttachmentArea.getText();
                    MessageCluster cluster = IdeErrorsDialog.this.selectedCluster();
                    cluster.detailsText = detailsText;
                    IdeErrorsDialog.this.setOKActionEnabled(cluster.canSubmit() && !StringUtil.isEmptyOrSpaces((String)detailsText));
                }
            }
        });
        if (this.myInternalMode) {
            this.myAssigneeCombo = new ComboBox();
            this.myAssigneeCombo.setRenderer((ListCellRenderer)new ListCellRendererWrapper<Developer>(){

                public void customize(JList list2, Developer value, int index, boolean selected, boolean hasFocus) {
                    this.setText(value == null ? "<none>" : value.getDisplayText());
                }
            });
            this.myAssigneeCombo.setPrototypeDisplayValue((Object)new Developer(0, StringUtil.repeatSymbol((char)'-', (int)30)));
            this.myAssigneeCombo.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    Developer developer = (Developer)e.getItem();
                    this.selectedMessage().setAssigneeId(developer == null ? null : developer.getId());
                }
            });
            new ComboboxSpeedSearch((JComboBox)this.myAssigneeCombo){

                @Override
                protected String getElementText(Object element) {
                    return element == null ? "" : ((Developer)element).getDisplayText();
                }
            };
            this.myAssigneePanel = new JPanel();
            this.myAssigneePanel.add((Component)new JBLabel("Assignee:"));
            this.myAssigneePanel.add((Component)this.myAssigneeCombo);
        }
        this.myCredentialsLabel = new HyperlinkLabel();
        this.myCredentialsLabel.addHyperlinkListener(e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                JetBrainsAccountDialogKt.showJetBrainsAccountDialog(this.getRootPane()).show();
                this.updateControls();
            }
        });
        this.myNoticeArea = new JEditorPane();
        this.myNoticeArea.setEditable(false);
        this.myNoticeArea.setFocusable(false);
        this.myNoticeArea.setBackground(UIUtil.getPanelBackground());
        this.myNoticeArea.setEditorKit(UIUtil.getHTMLEditorKit());
        this.myNoticeArea.addHyperlinkListener((HyperlinkListener)BrowserHyperlinkListener.INSTANCE);
        JPanel decoratorPanel = new JPanel(new BorderLayout());
        this.myNoticeDecorator = new NoticeDecorator(decoratorPanel);
        this.myNoticeDecorator.setContentComponent(this.myNoticeArea);
        JPanel commentPanel = new JPanel(new BorderLayout());
        commentPanel.setBorder((Border)JBUI.Borders.emptyTop((int)5));
        commentPanel.add((Component)commentLabel, "North");
        commentPanel.add((Component)IdeErrorsDialog.scrollPane(this.myCommentArea, 0, 0), "Center");
        JPanel attachmentsPanel = new JPanel(new BorderLayout(JBUI.scale((int)5), 0));
        attachmentsPanel.setBorder((Border)JBUI.Borders.emptyTop((int)5));
        attachmentsPanel.add((Component)attachmentsLabel, "North");
        attachmentsPanel.add((Component)IdeErrorsDialog.scrollPane((JComponent)((Object)this.myAttachmentsList), 150, 350), "West");
        attachmentsPanel.add((Component)IdeErrorsDialog.scrollPane(this.myAttachmentArea, 500, 350), "Center");
        JPanel accountRow = new JPanel(new BorderLayout());
        if (this.myInternalMode) {
            accountRow.add((Component)this.myAssigneePanel, "West");
        }
        accountRow.add((Component)this.myCredentialsLabel, "East");
        this.myNoticePanel = new JPanel(new GridBagLayout());
        this.myNoticePanel.add((Component)new JBLabel(UIUtil.getBalloonWarningIcon()), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 0, (Insets)JBUI.insets((int)7, (int)0, (int)0, (int)5), 0, 0));
        this.myNoticePanel.add((Component)decoratorPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, (Insets)JBUI.emptyInsets(), 0, 0));
        JPanel bottomRow = new JPanel(new BorderLayout());
        bottomRow.add((Component)accountRow, "North");
        bottomRow.add((Component)this.myNoticePanel, "Center");
        JPanel rootPanel = new JPanel(new BorderLayout());
        rootPanel.setPreferredSize((Dimension)JBUI.size((int)800, (int)400));
        rootPanel.add((Component)commentPanel, "North");
        rootPanel.add((Component)attachmentsPanel, "Center");
        rootPanel.add((Component)bottomRow, "South");
        return rootPanel;
    }

    private static JScrollPane scrollPane(JComponent component, int width, int height) {
        JBScrollPane scrollPane = new JBScrollPane((Component)component);
        if (width > 0 && height > 0) {
            scrollPane.setMinimumSize((Dimension)JBUI.size((int)width, (int)height));
        }
        return scrollPane;
    }

    @NotNull
    protected Action[] createActions() {
        AnAction action;
        ArrayList<Action> actions = new ArrayList<Action>();
        if (this.myInternalMode && this.myProject != null && !this.myProject.isDefault() && (action = ActionManager.getInstance().getAction("AnalyzeStacktraceOnError")) != null) {
            actions.add(new AnalyzeAction(action));
        }
        actions.add(new ClearErrorsAction());
        actions.add(this.getOKAction());
        actions.add(this.getCancelAction());
        Action[] actionArray = actions.toArray(new Action[0]);
        if (actionArray == null) {
            IdeErrorsDialog.$$$reportNull$$$0(1);
        }
        return actionArray;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myCommentArea;
    }

    protected String getDimensionServiceKey() {
        return "IDE.errors.dialog";
    }

    public void doOKAction() {
        if (this.getOKAction().isEnabled()) {
            boolean closeDialog = this.myMessageClusters.size() == 1;
            boolean reportingStarted = this.reportMessage(this.selectedCluster(), closeDialog);
            if (!closeDialog) {
                this.updateControls();
            } else if (reportingStarted) {
                super.doOKAction();
            }
        }
    }

    protected void dispose() {
        this.myMessagePool.removeListener(this);
        super.dispose();
    }

    private MessageCluster selectedCluster() {
        return this.myMessageClusters.get(this.myIndex);
    }

    private AbstractMessage selectedMessage() {
        return this.selectedCluster().first;
    }

    private void updateMessages() {
        List<AbstractMessage> rawMessages = this.myMessagePool.getFatalErrors(true, true);
        LinkedHashMap<Long, MessageCluster> clusters = new LinkedHashMap<Long, MessageCluster>();
        for (AbstractMessage raw : rawMessages) {
            AbstractMessage message = raw instanceof GroupedLogMessage ? ((GroupedLogMessage)raw).getProxyMessage() : raw;
            CRC32 digest = new CRC32();
            digest.update(ExceptionUtil.getThrowableText((Throwable)message.getThrowable()).getBytes(StandardCharsets.UTF_8));
            clusters.computeIfAbsent(digest.getValue(), k -> new MessageCluster(message)).messages.add(message);
        }
        this.myMessageClusters.clear();
        this.myMessageClusters.addAll(clusters.values());
    }

    private void updateControls() {
        MessageCluster cluster = this.selectedCluster();
        ErrorReportSubmitter submitter = cluster.submitter;
        cluster.messages.forEach(m -> m.setRead(true));
        this.updateLabels(cluster);
        this.updateDetails(cluster);
        if (this.myInternalMode) {
            this.updateAssigneePanel(cluster);
        }
        this.updateCredentialsPanel(submitter);
        this.setOKActionEnabled(cluster.canSubmit());
        this.setOKButtonText(submitter != null ? submitter.getReportActionText() : DiagnosticBundle.message("error.report.impossible.action", new Object[0]));
        this.setOKButtonTooltip(submitter != null ? null : DiagnosticBundle.message("error.report.impossible.tooltip", new Object[0]));
    }

    private void updateLabels(MessageCluster cluster) {
        String notice;
        AbstractMessage message = cluster.first;
        this.myCountLabel.setText(DiagnosticBundle.message("error.list.message.index.count", this.myIndex + 1, this.myMessageClusters.size()));
        Throwable t = message.getThrowable();
        if (t instanceof MessagePool.TooManyErrorsException) {
            this.myInfoLabel.setText(t.getMessage());
            this.myDisableLink.setVisible(false);
            this.myForeignPluginWarningLabel.setVisible(false);
            this.myNoticePanel.setVisible(false);
            return;
        }
        PluginId pluginId = cluster.pluginId;
        IdeaPluginDescriptor plugin = cluster.plugin;
        StringBuilder info = new StringBuilder();
        String url = null;
        if (pluginId != null) {
            info.append(DiagnosticBundle.message("error.list.message.blame.plugin", plugin != null ? plugin.getName() : pluginId));
        } else if (t instanceof AbstractMethodError) {
            info.append(DiagnosticBundle.message("error.list.message.blame.unknown.plugin", new Object[0]));
        } else {
            info.append(DiagnosticBundle.message("error.list.message.blame.core", ApplicationNamesInfo.getInstance().getProductName()));
        }
        String date = DateFormatUtil.formatPrettyDateTime((Date)message.getDate());
        int count = cluster.messages.size();
        info.append(' ').append(DiagnosticBundle.message("error.list.message.info", date, count));
        if (message.isSubmitted()) {
            SubmittedReportInfo submissionInfo = message.getSubmissionInfo();
            IdeErrorsDialog.appendSubmissionInformation(submissionInfo, info);
            info.append('.');
            url = submissionInfo.getURL();
        } else if (message.isSubmitting()) {
            info.append(' ').append(DiagnosticBundle.message("error.list.message.submitting", new Object[0]));
        }
        this.myInfoLabel.setHtmlText(XmlStringUtil.wrapInHtml((CharSequence)info));
        this.myInfoLabel.setHyperlinkTarget(url);
        this.myInfoLabel.setToolTipText(url);
        this.myDisableLink.setVisible(pluginId != null && !ApplicationInfoEx.getInstanceEx().isEssentialPlugin(pluginId.getIdString()));
        ErrorReportSubmitter submitter = cluster.submitter;
        if (submitter == null && plugin != null && !PluginManagerMain.isDevelopedByJetBrains(plugin)) {
            this.myForeignPluginWarningLabel.setVisible(true);
            String vendor = plugin.getVendor();
            String contactUrl = plugin.getVendorUrl();
            String contactEmail = plugin.getVendorEmail();
            if (!StringUtil.isEmpty((String)vendor) && !StringUtil.isEmpty((String)contactUrl)) {
                this.myForeignPluginWarningLabel.setHtmlText(DiagnosticBundle.message("error.dialog.foreign.plugin.warning.vendor", vendor));
                this.myForeignPluginWarningLabel.setHyperlinkTarget(contactUrl);
            } else if (!StringUtil.isEmpty((String)contactUrl)) {
                this.myForeignPluginWarningLabel.setHtmlText(DiagnosticBundle.message("error.dialog.foreign.plugin.warning.unknown", new Object[0]));
                this.myForeignPluginWarningLabel.setHyperlinkTarget(contactUrl);
            } else if (!StringUtil.isEmpty((String)contactEmail)) {
                contactEmail = StringUtil.trimStart((String)contactEmail, (String)"mailto:");
                this.myForeignPluginWarningLabel.setHtmlText(DiagnosticBundle.message("error.dialog.foreign.plugin.warning.vendor", contactEmail));
                this.myForeignPluginWarningLabel.setHyperlinkTarget("mailto:" + contactEmail);
            } else {
                this.myForeignPluginWarningLabel.setHtmlText(DiagnosticBundle.message("error.dialog.foreign.plugin.warning", new Object[0]));
                this.myForeignPluginWarningLabel.setHyperlinkTarget(null);
            }
            this.myForeignPluginWarningLabel.setToolTipText(contactUrl);
        } else {
            this.myForeignPluginWarningLabel.setVisible(false);
        }
        String string = notice = submitter != null ? submitter.getPrivacyNoticeText() : null;
        if (notice != null) {
            this.myNoticePanel.setVisible(true);
            String hash = Integer.toHexString(StringUtil.stringHashCodeIgnoreWhitespaces((CharSequence)notice));
            this.myNoticeDecorator.setOn(!this.myAcceptedNotices.contains(hash));
            this.myNoticeArea.setText(notice);
        } else {
            this.myNoticePanel.setVisible(false);
        }
    }

    private void updateDetails(MessageCluster cluster) {
        AbstractMessage message = cluster.first;
        boolean canReport = cluster.canSubmit();
        this.myCommentArea.setText(message.getAdditionalInfo());
        this.myCommentArea.setCaretPosition(0);
        this.myCommentArea.setEditable(canReport);
        this.myAttachmentsList.clear();
        this.myAttachmentsList.addItem(STACKTRACE_ATTACHMENT, true);
        for (Attachment attachment : message.getAllAttachments()) {
            this.myAttachmentsList.addItem(attachment.getName(), attachment.isIncluded());
        }
        this.myAttachmentsList.setSelectedIndex(0);
        this.myAttachmentsList.setEditable(canReport);
    }

    private void updateAssigneePanel(MessageCluster cluster) {
        if (cluster.submitter instanceof ITNReporter) {
            this.myAssigneePanel.setVisible(true);
            this.myAssigneeCombo.setEnabled(cluster.isUnsent());
            Integer assignee = cluster.first.getAssigneeId();
            if (assignee == null) {
                this.myAssigneeCombo.setSelectedIndex(-1);
            } else {
                Condition lookup = d -> Objects.equals(assignee, d.getId());
                this.myAssigneeCombo.setSelectedIndex(ContainerUtil.indexOf(ourDevelopersList, (Condition)lookup));
            }
        } else {
            this.myAssigneePanel.setVisible(false);
        }
    }

    private void updateCredentialsPanel(ErrorReportSubmitter submitter) {
        if (submitter instanceof ITNReporter) {
            this.myCredentialsLabel.setVisible(true);
            Credentials credentials = ErrorReportConfigurable.getCredentials();
            if (CredentialAttributesKt.isFulfilled((Credentials)credentials)) {
                this.myCredentialsLabel.setHtmlText(DiagnosticBundle.message("error.dialog.submit.named", credentials.getUserName()));
            } else {
                this.myCredentialsLabel.setHtmlText(DiagnosticBundle.message("error.dialog.submit.anonymous", new Object[0]));
            }
        } else {
            this.myCredentialsLabel.setVisible(false);
        }
    }

    private boolean reportMessage(MessageCluster cluster, boolean dialogClosed) {
        String hash;
        ErrorReportSubmitter submitter = cluster.submitter;
        if (submitter == null) {
            return false;
        }
        AbstractMessage message = cluster.first;
        message.setSubmitting(true);
        String notice = submitter.getPrivacyNoticeText();
        if (notice != null && this.myAcceptedNotices.add(hash = Integer.toHexString(StringUtil.stringHashCodeIgnoreWhitespaces((CharSequence)notice)))) {
            PropertiesComponent.getInstance().setValue(ACCEPTED_NOTICES_KEY, StringUtil.join(this.myAcceptedNotices, (String)ACCEPTED_NOTICES_SEPARATOR));
        }
        Pair pair = cluster.decouple();
        IdeaLoggingEvent[] events = new IdeaLoggingEvent[]{new IdeaReportingEvent(message, (String)pair.first, (String)pair.second, cluster.plugin)};
        Container parentComponent = this.getRootPane();
        if (dialogClosed) {
            IdeFrame frame = (IdeFrame)UIUtil.getParentOfType(IdeFrame.class, (Component)parentComponent);
            parentComponent = frame != null ? frame.getComponent() : WindowManager.getInstance().findVisibleFrame();
        }
        return submitter.submit(events, message.getAdditionalInfo(), (Component)parentComponent, reportInfo -> {
            message.setSubmitting(false);
            message.setSubmitted((SubmittedReportInfo)reportInfo);
            UIUtil.invokeLaterIfNeeded(() -> this.updateOnSubmit());
        });
    }

    private void disablePlugin() {
        IdeaPluginDescriptor plugin = this.selectedCluster().plugin;
        if (plugin != null) {
            boolean doRestart;
            boolean doDisable;
            Ref hasDependants = new Ref((Object)false);
            PluginManagerCore.checkDependants(plugin, (Function<PluginId, IdeaPluginDescriptor>)((Function)PluginManager::getPlugin), (Condition<PluginId>)((Condition)dependantId -> {
                if ("com.intellij".equals(dependantId.getIdString())) {
                    return true;
                }
                hasDependants.set((Object)true);
                return false;
            }));
            boolean canRestart = ApplicationManager.getApplication().isRestartCapable();
            String message = "<html>" + DiagnosticBundle.message("error.dialog.disable.prompt", plugin.getName()) + "<br/>" + DiagnosticBundle.message((Boolean)hasDependants.get() != false ? "error.dialog.disable.prompt.deps" : "error.dialog.disable.prompt.lone", new Object[0]) + "<br/><br/>" + DiagnosticBundle.message(canRestart ? "error.dialog.disable.plugin.can.restart" : "error.dialog.disable.plugin.no.restart", new Object[0]) + "</html>";
            String title = DiagnosticBundle.message("error.dialog.disable.plugin.title", new Object[0]);
            String disable = DiagnosticBundle.message("error.dialog.disable.plugin.action.disable", new Object[0]);
            String cancel = IdeBundle.message((String)"button.cancel", (Object[])new Object[0]);
            if (canRestart) {
                String restart = DiagnosticBundle.message("error.dialog.disable.plugin.action.disableAndRestart", new Object[0]);
                int result2 = Messages.showYesNoCancelDialog((Project)this.myProject, (String)message, (String)title, (String)disable, (String)restart, (String)cancel, (Icon)Messages.getQuestionIcon());
                doDisable = result2 == 0 || result2 == 1;
                doRestart = result2 == 1;
            } else {
                int result3 = Messages.showYesNoDialog((Project)this.myProject, (String)message, (String)title, (String)disable, (String)cancel, (Icon)Messages.getQuestionIcon());
                doDisable = result3 == 0;
                doRestart = false;
            }
            if (doDisable) {
                PluginManagerCore.disablePlugin(plugin.getPluginId().getIdString());
                if (doRestart) {
                    ApplicationManager.getApplication().restart();
                }
            }
        }
    }

    protected void updateOnSubmit() {
        if (this.isShowing()) {
            this.updateControls();
        }
    }

    @Override
    public void newEntryAdded() {
        UIUtil.invokeLaterIfNeeded(() -> {
            this.updateMessages();
            this.updateControls();
        });
    }

    @Override
    public void poolCleared() {
        UIUtil.invokeLaterIfNeeded(() -> this.doCancelAction());
    }

    @Override
    public void entryWasRead() {
    }

    public Object getData(String dataId) {
        return CURRENT_TRACE_KEY.is(dataId) ? this.selectedMessage().getThrowableText() : null;
    }

    @Nullable
    public static Pair<String, String> getPluginInfo(@NotNull IdeaLoggingEvent event) {
        if (event == null) {
            IdeErrorsDialog.$$$reportNull$$$0(2);
        }
        IdeaPluginDescriptor plugin = null;
        if (event instanceof IdeaReportingEvent) {
            plugin = ((IdeaReportingEvent)event).getPlugin();
        } else {
            Throwable t = event.getThrowable();
            if (t != null) {
                plugin = PluginManager.getPlugin(IdeErrorsDialog.findPluginId(t));
            }
        }
        return plugin != null && (!plugin.isBundled() || plugin.allowBundledUpdate()) ? Pair.pair((Object)plugin.getName(), (Object)plugin.getVersion()) : null;
    }

    @Nullable
    public static PluginId findPluginId(@NotNull Throwable t) {
        CharSequence className;
        if (t == null) {
            IdeErrorsDialog.$$$reportNull$$$0(3);
        }
        if (t instanceof PluginException) {
            return ((PluginException)t).getPluginId();
        }
        HashSet visitedClassNames = ContainerUtil.newHashSet();
        for (StackTraceElement element : t.getStackTrace()) {
            String className2;
            if (element == null || !visitedClassNames.add(className2 = element.getClassName()) || !PluginManagerCore.isPluginClass(className2)) continue;
            PluginId id = PluginManagerCore.getPluginByClassName(className2);
            IdeErrorsDialog.logPluginDetection(className2, id);
            return id;
        }
        if (t instanceof NoSuchMethodException) {
            if (t.getMessage() != null) {
                className = new StringBuilder();
                StringTokenizer tok = new StringTokenizer(t.getMessage(), ".");
                while (tok.hasMoreTokens()) {
                    String token = tok.nextToken();
                    if (token.isEmpty() || !Character.isJavaIdentifierStart(token.charAt(0))) continue;
                    ((StringBuilder)className).append(token);
                }
                PluginId pluginId = PluginManagerCore.getPluginByClassName(((StringBuilder)className).toString());
                if (pluginId != null) {
                    return pluginId;
                }
            }
        } else if (t instanceof ClassNotFoundException) {
            if (t.getMessage() != null && PluginManagerCore.isPluginClass((String)(className = t.getMessage()))) {
                return PluginManagerCore.getPluginByClassName((String)className);
            }
        } else if (t instanceof AbstractMethodError && t.getMessage() != null) {
            String s = t.getMessage();
            int pos = s.indexOf(40);
            if (pos >= 0 && (pos = (s = s.substring(0, pos)).lastIndexOf(46)) >= 0 && PluginManagerCore.isPluginClass(s = s.substring(0, pos))) {
                return PluginManagerCore.getPluginByClassName(s);
            }
        } else if (t instanceof ExtensionException && PluginManagerCore.isPluginClass((String)(className = ((ExtensionException)t).getExtensionClass().getName()))) {
            return PluginManagerCore.getPluginByClassName((String)className);
        }
        return null;
    }

    private static void logPluginDetection(String className, PluginId id) {
        if (LOG.isDebugEnabled()) {
            String message = "Detected plugin " + id + " by class " + className;
            IdeaPluginDescriptor descriptor2 = PluginManager.getPlugin(id);
            if (descriptor2 != null) {
                ClassLoader loader = descriptor2.getPluginClassLoader();
                message = message + "; loader=" + loader + '/' + loader.getClass();
                if (loader instanceof PluginClassLoader) {
                    message = message + "; loaded class: " + ((PluginClassLoader)((Object)loader)).hasLoadedClass(className);
                }
            }
            LOG.debug(message);
        }
    }

    @Nullable
    static ErrorReportSubmitter getSubmitter(@NotNull Throwable t) {
        if (t == null) {
            IdeErrorsDialog.$$$reportNull$$$0(4);
        }
        PluginId pluginId = IdeErrorsDialog.findPluginId(t);
        IdeaPluginDescriptor plugin = PluginManager.getPlugin(pluginId);
        return IdeErrorsDialog.getSubmitter(t, pluginId, plugin);
    }

    private static ErrorReportSubmitter getSubmitter(Throwable t, PluginId pluginId, IdeaPluginDescriptor plugin) {
        PluginDescriptor descriptor2;
        ErrorReportSubmitter[] reporters;
        if (t instanceof MessagePool.TooManyErrorsException || t instanceof AbstractMethodError) {
            return null;
        }
        try {
            reporters = (ErrorReportSubmitter[])Extensions.getExtensions((ExtensionPointName)ExtensionPoints.ERROR_HANDLER_EP);
        }
        catch (Throwable ignored) {
            return null;
        }
        if (plugin != null) {
            for (ErrorReportSubmitter reporter : reporters) {
                descriptor2 = reporter.getPluginDescriptor();
                if (descriptor2 == null || !Comparing.equal((Object)pluginId, (Object)descriptor2.getPluginId())) continue;
                return reporter;
            }
        }
        if (plugin == null || PluginManagerMain.isDevelopedByJetBrains(plugin)) {
            for (ErrorReportSubmitter reporter : reporters) {
                descriptor2 = reporter.getPluginDescriptor();
                if (descriptor2 != null && PluginId.getId((String)"com.intellij") != descriptor2.getPluginId()) continue;
                return reporter;
            }
        }
        return null;
    }

    public static void appendSubmissionInformation(@NotNull SubmittedReportInfo info, @NotNull StringBuilder out) {
        if (info == null) {
            IdeErrorsDialog.$$$reportNull$$$0(5);
        }
        if (out == null) {
            IdeErrorsDialog.$$$reportNull$$$0(6);
        }
        if (info.getStatus() == SubmittedReportInfo.SubmissionStatus.FAILED) {
            out.append(' ').append(DiagnosticBundle.message("error.list.message.submission.failed", new Object[0]));
        } else if (info.getURL() != null && info.getLinkText() != null) {
            out.append(' ').append(DiagnosticBundle.message("error.list.message.submitted.as.link", info.getURL(), info.getLinkText()));
            if (info.getStatus() == SubmittedReportInfo.SubmissionStatus.DUPLICATE) {
                out.append(' ').append(DiagnosticBundle.message("error.list.message.duplicate", new Object[0]));
            }
        } else {
            out.append(' ').append(DiagnosticBundle.message("error.list.message.submitted", new Object[0]));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messagePool";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagnostic/IdeErrorsDialog";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagnostic/IdeErrorsDialog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPluginInfo";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findPluginId";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSubmitter";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "appendSubmissionInformation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MessageCluster {
        private final AbstractMessage first;
        @Nullable
        private final PluginId pluginId;
        @Nullable
        private final IdeaPluginDescriptor plugin;
        @Nullable
        private final ErrorReportSubmitter submitter;
        private String detailsText;
        private final List<AbstractMessage> messages = new ArrayList<AbstractMessage>();

        private MessageCluster(AbstractMessage message) {
            this.first = message;
            this.pluginId = IdeErrorsDialog.findPluginId(message.getThrowable());
            this.plugin = PluginManager.getPlugin(this.pluginId);
            this.submitter = IdeErrorsDialog.getSubmitter(message.getThrowable(), this.pluginId, this.plugin);
            this.detailsText = this.detailsText();
        }

        private String detailsText() {
            Throwable t;
            AbstractMessage message = this.first;
            if (message instanceof GroupedLogMessage) {
                message = ((GroupedLogMessage)message).getMessages().get(0);
            }
            if ((t = message.getThrowable()) instanceof MessagePool.TooManyErrorsException) {
                return t.getMessage();
            }
            String userMessage = message.getMessage();
            String stacktrace = message.getThrowableText();
            return StringUtil.isEmptyOrSpaces((String)userMessage) ? stacktrace : userMessage + "\n\n" + stacktrace;
        }

        private boolean isUnsent() {
            return !this.first.isSubmitted() && !this.first.isSubmitting();
        }

        private boolean canSubmit() {
            return this.submitter != null && this.isUnsent();
        }

        private Pair<String, String> decouple() {
            String className = this.first.getThrowable().getClass().getName();
            int p = this.detailsText.indexOf(className);
            if (p == 0) {
                return Pair.pair(null, (Object)this.detailsText);
            }
            if (p > 0 && this.detailsText.charAt(p - 1) == '\n') {
                return Pair.pair((Object)this.detailsText.substring(0, p).trim(), (Object)this.detailsText.substring(p));
            }
            return Pair.pair((Object)"*** exception class was changed or removed", (Object)this.detailsText);
        }
    }

    private static class NoticeDecorator
    extends HideableDecorator {
        private NoticeDecorator(JPanel panel2) {
            super(panel2, "...", false);
        }

        @Override
        protected void on() {
            super.on();
            this.setTitle(DiagnosticBundle.message("error.dialog.notice.label.expanded", new Object[0]));
        }

        @Override
        protected void off() {
            super.off();
            this.setTitle(DiagnosticBundle.message("error.dialog.notice.label", new Object[0]));
        }
    }

    private static class AttachmentsList
    extends CheckBoxList<String> {
        private boolean myEditable = true;

        private AttachmentsList() {
        }

        private void addItem(String item, boolean selected) {
            super.addItem((Object)item, item + "  ", selected);
        }

        public void setEditable(boolean editable) {
            this.myEditable = editable;
        }

        protected boolean isEnabled(int index) {
            return this.myEditable && index > 0;
        }
    }

    private class AnalyzeAction
    extends AbstractAction {
        private final AnAction myAnalyze;

        private AnalyzeAction(AnAction analyze) {
            super(analyze.getTemplatePresentation().getText());
            this.putValue("MnemonicKey", analyze.getTemplatePresentation().getMnemonic());
            this.myAnalyze = analyze;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DataContext ctx = DataManager.getInstance().getDataContext((Component)e.getSource());
            AnActionEvent event = AnActionEvent.createFromAnAction((AnAction)this.myAnalyze, null, (String)"unknown", (DataContext)ctx);
            this.myAnalyze.actionPerformed(event);
            IdeErrorsDialog.this.doCancelAction();
        }
    }

    private class ClearErrorsAction
    extends AbstractAction {
        private ClearErrorsAction() {
            super(DiagnosticBundle.message("error.dialog.clear.all.action", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            IdeErrorsDialog.this.myMessagePool.clearErrors();
            IdeErrorsDialog.this.doCancelAction();
        }
    }

    private class ForwardAction
    extends AnAction
    implements DumbAware {
        public ForwardAction() {
            super("Next", null, AllIcons.Actions.Forward);
            AnAction action = ActionManager.getInstance().getAction("NextTab");
            if (action != null) {
                this.registerCustomShortcutSet(action.getShortcutSet(), IdeErrorsDialog.this.getRootPane(), IdeErrorsDialog.this.getDisposable());
            }
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(IdeErrorsDialog.this.myIndex < IdeErrorsDialog.this.myMessageClusters.size() - 1);
        }

        public void actionPerformed(AnActionEvent e) {
            IdeErrorsDialog.this.myIndex++;
            IdeErrorsDialog.this.updateControls();
        }
    }

    private class BackAction
    extends AnAction
    implements DumbAware {
        public BackAction() {
            super("Previous", null, AllIcons.Actions.Back);
            AnAction action = ActionManager.getInstance().getAction("PreviousTab");
            if (action != null) {
                this.registerCustomShortcutSet(action.getShortcutSet(), IdeErrorsDialog.this.getRootPane(), IdeErrorsDialog.this.getDisposable());
            }
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(IdeErrorsDialog.this.myIndex > 0);
        }

        public void actionPerformed(AnActionEvent e) {
            IdeErrorsDialog.this.myIndex--;
            IdeErrorsDialog.this.updateControls();
        }
    }
}

