/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison;

import com.intellij.diff.comparison.MergeResolveUtil;
import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.util.MergeRange;
import com.intellij.diff.util.Range;
import com.intellij.diff.util.Side;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.containers.PeekableIterator;
import com.intellij.util.containers.PeekableIteratorWrapper;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComparisonMergeUtil {
    @NotNull
    public static List<MergeRange> buildFair(@NotNull FairDiffIterable fragments1, @NotNull FairDiffIterable fragments2, @NotNull ProgressIndicator indicator) {
        if (fragments1 == null) {
            ComparisonMergeUtil.$$$reportNull$$$0(0);
        }
        if (fragments2 == null) {
            ComparisonMergeUtil.$$$reportNull$$$0(1);
        }
        if (indicator == null) {
            ComparisonMergeUtil.$$$reportNull$$$0(2);
        }
        assert (fragments1.getLength1() == fragments2.getLength1());
        List<MergeRange> list2 = new FairMergeBuilder().execute(fragments1, fragments2);
        if (list2 == null) {
            ComparisonMergeUtil.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @Nullable
    public static CharSequence tryResolveConflict(@NotNull CharSequence leftText, @NotNull CharSequence baseText, @NotNull CharSequence rightText) {
        if (leftText == null) {
            ComparisonMergeUtil.$$$reportNull$$$0(4);
        }
        if (baseText == null) {
            ComparisonMergeUtil.$$$reportNull$$$0(5);
        }
        if (rightText == null) {
            ComparisonMergeUtil.$$$reportNull$$$0(6);
        }
        if (Registry.is((String)"diff.merge.resolve.conflict.action.use.greedy.approach")) {
            return MergeResolveUtil.tryGreedyResolve(leftText, baseText, rightText);
        }
        return MergeResolveUtil.tryResolve(leftText, baseText, rightText);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragments1";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragments2";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/comparison/ComparisonMergeUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftText";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseText";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/comparison/ComparisonMergeUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFair";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildFair";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "tryResolveConflict";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ChangeBuilder {
        @NotNull
        private final List<MergeRange> myChanges = new ArrayList<MergeRange>();
        private int myIndex1 = 0;
        private int myIndex2 = 0;
        private int myIndex3 = 0;

        private ChangeBuilder() {
        }

        private void addChange(int start1, int start2, int start3, int end1, int end2, int end3) {
            if (start1 == end1 && start2 == end2 && start3 == end3) {
                return;
            }
            this.myChanges.add(new MergeRange(start1, end1, start2, end2, start3, end3));
        }

        public void markEqual(int start1, int start2, int start3, int end1, int end2, int end3) {
            assert (this.myIndex1 <= start1);
            assert (this.myIndex2 <= start2);
            assert (this.myIndex3 <= start3);
            assert (start1 <= end1);
            assert (start2 <= end2);
            assert (start3 <= end3);
            this.addChange(this.myIndex1, this.myIndex2, this.myIndex3, start1, start2, start3);
            this.myIndex1 = end1;
            this.myIndex2 = end2;
            this.myIndex3 = end3;
        }

        @NotNull
        public List<MergeRange> finish(int length1, int length2, int length3) {
            assert (this.myIndex1 <= length1);
            assert (this.myIndex2 <= length2);
            assert (this.myIndex3 <= length3);
            this.addChange(this.myIndex1, this.myIndex2, this.myIndex3, length1, length2, length3);
            List<MergeRange> list2 = this.myChanges;
            if (list2 == null) {
                ChangeBuilder.$$$reportNull$$$0(0);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonMergeUtil$ChangeBuilder", "finish"));
        }
    }

    private static class FairMergeBuilder {
        @NotNull
        private final ChangeBuilder myChangesBuilder = new ChangeBuilder();

        private FairMergeBuilder() {
        }

        @NotNull
        public List<MergeRange> execute(@NotNull FairDiffIterable fragments1, @NotNull FairDiffIterable fragments2) {
            if (fragments1 == null) {
                FairMergeBuilder.$$$reportNull$$$0(0);
            }
            if (fragments2 == null) {
                FairMergeBuilder.$$$reportNull$$$0(1);
            }
            PeekableIteratorWrapper unchanged1 = new PeekableIteratorWrapper(fragments1.unchanged());
            PeekableIteratorWrapper unchanged2 = new PeekableIteratorWrapper(fragments2.unchanged());
            while (unchanged1.hasNext() && unchanged2.hasNext()) {
                Side side = this.add((Range)unchanged1.peek(), (Range)unchanged2.peek());
                ((PeekableIterator)side.select((Object)unchanged1, (Object)unchanged2)).next();
            }
            List<MergeRange> list2 = this.finish(fragments1, fragments2);
            if (list2 == null) {
                FairMergeBuilder.$$$reportNull$$$0(2);
            }
            return list2;
        }

        @NotNull
        private Side add(@NotNull Range range1, @NotNull Range range2) {
            if (range1 == null) {
                FairMergeBuilder.$$$reportNull$$$0(3);
            }
            if (range2 == null) {
                FairMergeBuilder.$$$reportNull$$$0(4);
            }
            int start1 = range1.start1;
            int end1 = range1.end1;
            int start2 = range2.start1;
            int end2 = range2.end1;
            if (end1 <= start2) {
                Side side = Side.LEFT;
                if (side == null) {
                    FairMergeBuilder.$$$reportNull$$$0(5);
                }
                return side;
            }
            if (end2 <= start1) {
                Side side = Side.RIGHT;
                if (side == null) {
                    FairMergeBuilder.$$$reportNull$$$0(6);
                }
                return side;
            }
            int startBase = Math.max(start1, start2);
            int endBase = Math.min(end1, end2);
            int startShift1 = startBase - start1;
            int endCut1 = end1 - endBase;
            int startShift2 = startBase - start2;
            int endCut2 = end2 - endBase;
            int startLeft = range1.start2 + startShift1;
            int endLeft = range1.end2 - endCut1;
            int startRight = range2.start2 + startShift2;
            int endRight = range2.end2 - endCut2;
            this.myChangesBuilder.markEqual(startLeft, startBase, startRight, endLeft, endBase, endRight);
            Side side = Side.fromLeft((end1 <= end2 ? 1 : 0) != 0);
            if (side == null) {
                FairMergeBuilder.$$$reportNull$$$0(7);
            }
            return side;
        }

        @NotNull
        private List<MergeRange> finish(@NotNull FairDiffIterable fragments1, @NotNull FairDiffIterable fragments2) {
            if (fragments1 == null) {
                FairMergeBuilder.$$$reportNull$$$0(8);
            }
            if (fragments2 == null) {
                FairMergeBuilder.$$$reportNull$$$0(9);
            }
            int length1 = fragments1.getLength2();
            int length2 = fragments1.getLength1();
            int length3 = fragments2.getLength2();
            List<MergeRange> list2 = this.myChangesBuilder.finish(length1, length2, length3);
            if (list2 == null) {
                FairMergeBuilder.$$$reportNull$$$0(10);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 5: 
                case 6: 
                case 7: 
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 5: 
                case 6: 
                case 7: 
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fragments1";
                    break;
                }
                case 1: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fragments2";
                    break;
                }
                case 2: 
                case 5: 
                case 6: 
                case 7: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/comparison/ComparisonMergeUtil$FairMergeBuilder";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range1";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range2";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/comparison/ComparisonMergeUtil$FairMergeBuilder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "execute";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "add";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "finish";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "execute";
                    break;
                }
                case 2: 
                case 5: 
                case 6: 
                case 7: 
                case 10: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "add";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "finish";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 5: 
                case 6: 
                case 7: 
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

