/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.engine;

import com.intellij.formatting.LeafBlockWrapper;
import com.intellij.openapi.util.TextRange;
import gnu.trove.TIntObjectHashMap;
import org.jetbrains.annotations.Nullable;

public class BlockRangesMap {
    private final LeafBlockWrapper myLastBlock;
    private final TIntObjectHashMap<LeafBlockWrapper> myTextRangeToWrapper;

    public BlockRangesMap(LeafBlockWrapper first, LeafBlockWrapper last) {
        this.myLastBlock = last;
        this.myTextRangeToWrapper = BlockRangesMap.buildTextRangeToInfoMap(first);
    }

    private static TIntObjectHashMap<LeafBlockWrapper> buildTextRangeToInfoMap(LeafBlockWrapper first) {
        TIntObjectHashMap result2 = new TIntObjectHashMap();
        for (LeafBlockWrapper current = first; current != null; current = current.getNextBlock()) {
            result2.put(current.getStartOffset(), (Object)current);
        }
        return result2;
    }

    public boolean containsLineFeeds(TextRange dependency) {
        LeafBlockWrapper child = (LeafBlockWrapper)this.myTextRangeToWrapper.get(dependency.getStartOffset());
        if (child == null) {
            return false;
        }
        if (child.containsLineFeeds()) {
            return true;
        }
        int endOffset = dependency.getEndOffset();
        while (child.getEndOffset() < endOffset) {
            if ((child = child.getNextBlock()) == null) {
                return false;
            }
            if (child.getWhiteSpace().containsLineFeeds()) {
                return true;
            }
            if (!child.containsLineFeeds()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public LeafBlockWrapper getBlockAtOrAfter(int startOffset) {
        LeafBlockWrapper prevBlock;
        LeafBlockWrapper result2 = null;
        for (int current = startOffset; current < this.myLastBlock.getEndOffset(); ++current) {
            LeafBlockWrapper currentValue = (LeafBlockWrapper)this.myTextRangeToWrapper.get(current);
            if (currentValue == null) continue;
            result2 = currentValue;
            break;
        }
        if ((prevBlock = this.getPrevBlock(result2)) != null && prevBlock.contains(startOffset)) {
            return prevBlock;
        }
        return result2;
    }

    @Nullable
    private LeafBlockWrapper getPrevBlock(@Nullable LeafBlockWrapper result2) {
        if (result2 != null) {
            return result2.getPreviousBlock();
        }
        return this.myLastBlock;
    }
}

