/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.ide.actions.SearchEverywherePsiRenderer;
import com.intellij.ide.actions.searcheverywhere.ContributorSearchResult;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributorFilter;
import com.intellij.ide.util.EditSourceUtil;
import com.intellij.ide.util.gotoByName.ChooseByNameModel;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.ide.util.gotoByName.FilteringGotoByModel;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Processor;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractGotoSEContributor<F>
implements SearchEverywhereContributor<F> {
    protected static final Pattern patternToDetectLinesAndColumns = Pattern.compile("(.+?)(?::|@|,| |#|#L|\\?l=| on line | at line |:?\\(|:?\\[)(\\d+)?(?:(?:\\D)(\\d+)?)?[)\\]]?");
    protected static final Pattern patternToDetectAnonymousClasses = Pattern.compile("([\\.\\w]+)((\\$[\\d]+)*(\\$)?)");
    protected static final Pattern patternToDetectMembers = Pattern.compile("(.+)(#)(.*)");
    protected static final Pattern patternToDetectSignatures = Pattern.compile("(.+#.*)\\(.*\\)");
    private static final String fullMatchSearchSuffix = " ";
    protected final Project myProject;
    private static final Logger LOG = Logger.getInstance(AbstractGotoSEContributor.class);

    protected AbstractGotoSEContributor(Project project) {
        this.myProject = project;
    }

    @NotNull
    public String getSearchProviderId() {
        String string = this.getClass().getSimpleName();
        if (string == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isShownInSeparateTab() {
        return true;
    }

    public ContributorSearchResult<Object> search(String pattern, boolean everywhere, SearchEverywhereContributorFilter<F> filter, ProgressIndicator progressIndicator, int elementsLimit) {
        if (!this.isDumbModeSupported() && DumbService.getInstance((Project)this.myProject).isDumb()) {
            return ContributorSearchResult.empty();
        }
        String suffix = pattern.endsWith(fullMatchSearchSuffix) ? fullMatchSearchSuffix : "";
        String searchString = this.filterControlSymbols(pattern) + suffix;
        FilteringGotoByModel<F> model = this.createModel(this.myProject);
        model.setFilterItems(filter.getSelectedElements());
        ChooseByNamePopup popup2 = ChooseByNamePopup.createPopup(this.myProject, model, (PsiElement)null);
        ContributorSearchResult.Builder builder2 = ContributorSearchResult.builder();
        ApplicationManager.getApplication().runReadAction(() -> popup2.getProvider().filterElements(popup2, searchString, everywhere, progressIndicator, (Processor<Object>)((Processor)o -> this.addFoundElement(o, model, (ContributorSearchResult.Builder<Object>)builder2, progressIndicator, elementsLimit))));
        Disposer.dispose((Disposable)popup2);
        return builder2.build();
    }

    protected boolean addFoundElement(Object element, ChooseByNameModel model, ContributorSearchResult.Builder<Object> resultBuilder, ProgressIndicator progressIndicator, int elementsLimit) {
        if (progressIndicator.isCanceled()) {
            return false;
        }
        if (element == null) {
            LOG.error("Null returned from " + model + " in " + this);
            return true;
        }
        if (resultBuilder.itemsCount() < elementsLimit) {
            resultBuilder.addItem(element);
            return true;
        }
        resultBuilder.setHasMore(true);
        return false;
    }

    protected abstract FilteringGotoByModel<F> createModel(Project var1);

    public String filterControlSymbols(String pattern) {
        if (StringUtil.containsAnyChar((String)pattern, (String)":,;@[( #") || pattern.contains(" line ") || pattern.contains("?l=")) {
            return AbstractGotoSEContributor.applyPatternFilter(pattern, patternToDetectLinesAndColumns);
        }
        return pattern;
    }

    protected static String applyPatternFilter(String str, Pattern regex) {
        Matcher matcher = regex.matcher(str);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return str;
    }

    public boolean showInFindResults() {
        return true;
    }

    public boolean processSelectedItem(Object selected, int modifiers, String searchText) {
        if (selected instanceof PsiElement) {
            if (!((PsiElement)selected).isValid()) {
                LOG.warn("Cannot navigate to invalid PsiElement");
                return true;
            }
            PsiElement psiElement = this.preparePsi((PsiElement)selected, modifiers, searchText);
            Navigatable extNavigatable = this.createExtendedNavigatable(psiElement, searchText, modifiers);
            if (extNavigatable != null && extNavigatable.canNavigate()) {
                extNavigatable.navigate(true);
                return true;
            }
            NavigationUtil.activateFileWithPsiElement(psiElement, AbstractGotoSEContributor.openInCurrentWindow(modifiers));
        } else {
            EditSourceUtil.navigate((NavigationItem)((NavigationItem)selected), (boolean)true, (boolean)AbstractGotoSEContributor.openInCurrentWindow(modifiers));
        }
        return true;
    }

    public Object getDataForItem(Object element, String dataId) {
        if (CommonDataKeys.PSI_ELEMENT.is(dataId) && element instanceof PsiElement) {
            return element;
        }
        return null;
    }

    public boolean isMultiselectSupported() {
        return true;
    }

    public ListCellRenderer getElementsRenderer(JList<?> list2) {
        return new SearchEverywherePsiRenderer(list2){

            @Override
            public String getElementText(PsiElement element) {
                if (element instanceof NavigationItem) {
                    return Optional.ofNullable(((NavigationItem)element).getPresentation()).map(presentation -> presentation.getPresentableText()).orElse(super.getElementText(element));
                }
                return super.getElementText(element);
            }
        };
    }

    protected boolean isDumbModeSupported() {
        return false;
    }

    @Nullable
    protected Navigatable createExtendedNavigatable(PsiElement psi, String searchText, int modifiers) {
        boolean positionSpecified;
        VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)psi);
        Pair<Integer, Integer> position = AbstractGotoSEContributor.getLineAndColumn(searchText);
        boolean bl = positionSpecified = (Integer)position.first >= 0 || (Integer)position.second >= 0;
        if (file2 != null && positionSpecified) {
            OpenFileDescriptor descriptor2 = new OpenFileDescriptor(psi.getProject(), file2, ((Integer)position.first).intValue(), ((Integer)position.second).intValue());
            return descriptor2.setUseCurrentWindow(AbstractGotoSEContributor.openInCurrentWindow(modifiers));
        }
        return null;
    }

    protected PsiElement preparePsi(PsiElement psiElement, int modifiers, String searchText) {
        return psiElement.getNavigationElement();
    }

    protected static Pair<Integer, Integer> getLineAndColumn(String text2) {
        int line = AbstractGotoSEContributor.getLineAndColumnRegexpGroup(text2, 2);
        int column = AbstractGotoSEContributor.getLineAndColumnRegexpGroup(text2, 3);
        if (line == -1 && column != -1) {
            line = 0;
        }
        return new Pair((Object)line, (Object)column);
    }

    private static int getLineAndColumnRegexpGroup(String text2, int groupNumber) {
        Matcher matcher = patternToDetectLinesAndColumns.matcher(text2);
        if (matcher.matches()) {
            try {
                String group;
                if (groupNumber <= matcher.groupCount() && (group = matcher.group(groupNumber)) != null) {
                    return Integer.parseInt(group) - 1;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    protected static boolean openInCurrentWindow(int modifiers) {
        return (modifiers & 1) == 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/searcheverywhere/AbstractGotoSEContributor", "getSearchProviderId"));
    }
}

