/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.icons.AllIcons;
import com.intellij.ide.HelpTooltip;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.InstalledPluginsManagerMain;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.InstalledPluginsTableModel;
import com.intellij.ide.plugins.PluginHostsConfigurable;
import com.intellij.ide.plugins.PluginInstaller;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerColumnInfo;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.RatesPanel;
import com.intellij.ide.plugins.RepositoryHelper;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.search.SearchableOptionsRegistrar;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.idea.IdeaApplication;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileChooser.ex.FileTextFieldImpl;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.options.newEditor.SettingsDialog;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.openapi.wm.impl.status.InlineProgressIndicator;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.ui.CardLayoutPanel;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBOptionButton;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.breadcrumbs.Breadcrumbs;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.components.panels.OpaquePanel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.Alarm;
import com.intellij.util.BooleanFunction;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.IconUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.URLUtil;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.ui.AbstractLayoutManager;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.JsonReaderEx;
import sun.swing.SwingUtilities2;

public class PluginManagerConfigurableNew
implements SearchableConfigurable,
Configurable.NoScroll,
Configurable.NoMargin,
Configurable.TopComponentProvider {
    public static final String ID = "preferences.pluginManager";
    private static final String SELECTION_TAB_KEY = "PluginConfigurable.selectionTab";
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("MMM dd, yyyy");
    private static final DecimalFormat K_FORMAT = new DecimalFormat("###.#K");
    private static final DecimalFormat M_FORMAT = new DecimalFormat("###.#M");
    private static final Color MAIN_BG_COLOR = new JBColor(() -> JBColor.isBright() ? UIUtil.getListBackground() : new Color(0x313335));
    private final TagBuilder myTagBuilder;
    private LinkListener<IdeaPluginDescriptor> myNameListener;
    private LinkListener<String> mySearchListener;
    private CardLayoutPanel<Object, Object, JComponent> myCardPanel;
    private TabHeaderComponent myTabHeaderComponent;
    private CountTabName myUpdatesTabName;
    private Configurable.TopComponentController myTopController;
    private final SearchTextField mySearchTextField;
    private SearchResultInfo mySearchResultInfo;
    private boolean mySkipDocumentEvents;
    private final Alarm mySearchUpdateAlarm = new Alarm();
    private JBPopup mySearchPopup;
    private CollectionListModel<IdeaPluginDescriptor> mySearchPopupModel;
    private JList<IdeaPluginDescriptor> mySearchPopupList;
    private Pair<PluginsGroup, PluginsGroup> mySearchFlyResult;
    private final MyPluginModel myPluginsModel = new MyPluginModel();
    private Runnable myShutdownCallback;
    private Map<String, IdeaPluginDescriptor> myJBRepositoryMap;
    private List<IdeaPluginDescriptor> myJBRepositoryList;
    private static final Color DisabledColor = new JBColor(0xC6C6C6, 5724249);
    private static final Color WhiteForeground = new JBColor(Color.white, new Color(0xBBBBBB));
    private static final Color WhiteBackground = new JBColor(Color.white, new Color(3948353));
    private static final Color BlueColor = new JBColor(1930175, 1265024);
    private static final Color GreenColor = new JBColor(6134599, 4551477);
    private static final Color GreenFocusedBackground = new Color(14808794);

    public PluginManagerConfigurableNew() {
        this.myTagBuilder = new TagBuilder(){

            @Override
            @NotNull
            public TagComponent createTagComponent(@NotNull String tag) {
                JBColor color;
                if (tag == null) {
                    1.$$$reportNull$$$0(0);
                }
                String tooltip = null;
                if ("EAP".equals(tag)) {
                    color = new JBColor(15913679, 15913679);
                    tooltip = "The EAP version does not guarantee the stability\nand availability of the plugin.";
                } else {
                    color = new JBColor(0xEAEAEC, 0x4D4D4D);
                }
                TagComponent tagComponent = (TagComponent)((Object)PluginManagerConfigurableNew.installTiny((Component)((Object)new TagComponent(tag, tooltip, (Color)color))));
                if (tagComponent == null) {
                    1.$$$reportNull$$$0(1);
                }
                return tagComponent;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "tag";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/plugins/PluginManagerConfigurableNew$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurableNew$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createTagComponent";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createTagComponent";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        this.mySearchTextField = new SearchTextField(){

            public void setBounds(int x, int y, int width, int height) {
                super.setBounds(x - 1, y, width + 2, height);
            }

            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                size.height = JBUI.scale((int)38);
                return size;
            }

            protected boolean preprocessEventForTextField(KeyEvent event) {
                int keyCode = event.getKeyCode();
                int id = event.getID();
                if (keyCode == 10 || event.getKeyChar() == '\n') {
                    if (id == 401) {
                        if (PluginManagerConfigurableNew.this.mySearchPopupList != null && PluginManagerConfigurableNew.this.mySearchPopupList.getSelectedIndex() != -1) {
                            PluginManagerConfigurableNew.this.mySearchPopupList.dispatchEvent(event);
                        } else {
                            PluginManagerConfigurableNew.this.showSearchResultPanel();
                        }
                    }
                    return true;
                }
                if ((keyCode == 40 || keyCode == 38) && id == 401 && PluginManagerConfigurableNew.this.mySearchPopupList != null) {
                    if (keyCode == 40 && PluginManagerConfigurableNew.this.mySearchPopupList.getSelectedIndex() == -1) {
                        PluginManagerConfigurableNew.this.mySearchPopupList.setSelectedIndex(0);
                    } else {
                        PluginManagerConfigurableNew.this.mySearchPopupList.dispatchEvent(event);
                    }
                    return true;
                }
                return super.preprocessEventForTextField(event);
            }

            protected void onFieldCleared() {
                PluginManagerConfigurableNew.this.hideSearchResultPanel();
            }
        };
        this.mySearchTextField.setBorder(JBUI.Borders.customLine((Color)new JBColor(0xC5C5C5, 0x515151)));
        JBTextField editor = this.mySearchTextField.getTextEditor();
        editor.putClientProperty((Object)"JTextField.Search.Gap", (Object)JBUI.scale((int)-17));
        editor.putClientProperty((Object)"JTextField.Search.GapEmptyText", (Object)JBUI.scale((int)8));
        editor.putClientProperty((Object)"StatusVisibleFunction", field -> field.getText().isEmpty());
        editor.setBorder((Border)JBUI.Borders.empty((int)0, (int)25));
        editor.getEmptyText().appendText("Search plugins");
        editor.setOpaque(true);
        editor.setBackground(MAIN_BG_COLOR);
    }

    @NotNull
    public String getId() {
        if (ID == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(0);
        }
        return ID;
    }

    @Nls
    public String getDisplayName() {
        return IdeBundle.message((String)"title.plugins", (Object[])new Object[0]);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.mySearchTextField.getTextEditor();
    }

    @Nullable
    public JComponent createComponent() {
        final JPanel panel2 = new JPanel(new BorderLayout());
        panel2.setMinimumSize(new Dimension(JBUI.scale((int)580), -1));
        DefaultActionGroup actions = new DefaultActionGroup();
        actions.add((AnAction)new DumbAwareAction("Manage Plugin Repositories..."){

            public void actionPerformed(AnActionEvent e) {
                if (ShowSettingsUtil.getInstance().editConfigurable((Component)panel2, (Configurable)new PluginHostsConfigurable())) {
                    // empty if block
                }
            }
        });
        actions.add((AnAction)new DumbAwareAction(IdeBundle.message((String)"button.http.proxy.settings", (Object[])new Object[0])){

            public void actionPerformed(AnActionEvent e) {
                if (HttpConfigurable.editConfigurable((JComponent)panel2)) {
                    // empty if block
                }
            }
        });
        actions.addSeparator();
        actions.add((AnAction)new DumbAwareAction("Install Plugin from Disk..."){

            public void actionPerformed(AnActionEvent e) {
                InstalledPluginsManagerMain.chooseAndInstall(PluginManagerConfigurableNew.this.myPluginsModel, (Consumer<Pair<File, IdeaPluginDescriptor>>)((Consumer)pair -> PluginManagerConfigurableNew.this.myPluginsModel.appendOrUpdateDescriptor((IdeaPluginDescriptor)pair.second)), panel2);
            }
        });
        panel2.add((Component)this.mySearchTextField, "North");
        this.myNameListener = (_0, descriptor2) -> {
            assert (this.myPluginsModel.detailPanel == null);
            JButton backButton = new JButton(this.mySearchResultInfo == null ? "Plugins" : "Search");
            PluginManagerConfigurableNew.configureBackButton(backButton);
            if (this.mySearchResultInfo == null) {
                int currentTab = this.myTabHeaderComponent.getSelectionTab();
                backButton.addActionListener(event -> {
                    this.removeDetailsPanel();
                    this.myCardPanel.select(currentTab, true);
                    PluginManagerConfigurableNew.storeSelectionTab(currentTab);
                    this.myTabHeaderComponent.setSelection(currentTab);
                });
                this.myCardPanel.select(Pair.create((Object)descriptor2, (Object)(currentTab == 2 ? 1 : 0)), true);
                this.myPluginsModel.detailPanel.backTabIndex = currentTab;
            } else {
                backButton.addActionListener(event -> {
                    this.removeDetailsPanel();
                    this.mySearchResultInfo.setText();
                    this.myCardPanel.select(this.mySearchResultInfo.key, true);
                });
                this.mySearchResultInfo.clearText();
                this.myCardPanel.select(Pair.create((Object)descriptor2, (Object)Boolean.FALSE), true);
            }
            this.myTopController.setLeftComponent((Component)backButton);
            this.myTabHeaderComponent.clearSelection();
        };
        this.mySearchListener = (_0, query) -> this.showSearchResultPanel((String)query, true);
        this.mySearchTextField.getTextEditor().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                if (PluginManagerConfigurableNew.this.mySkipDocumentEvents) {
                    return;
                }
                PluginManagerConfigurableNew.this.mySearchUpdateAlarm.cancelAllRequests();
                PluginManagerConfigurableNew.this.mySearchUpdateAlarm.addRequest(this::searchOnTheFly, 100, ModalityState.stateForComponent((Component)PluginManagerConfigurableNew.this.mySearchTextField));
            }

            private void searchOnTheFly() {
                String query = PluginManagerConfigurableNew.this.mySearchTextField.getText();
                boolean empty = StringUtil.isEmptyOrSpaces((String)query);
                if (empty || query.length() < 3) {
                    PluginManagerConfigurableNew.this.hideSearchPopup();
                    if (empty) {
                        PluginManagerConfigurableNew.this.hideSearchResultPanel();
                    }
                    return;
                }
                PluginManagerConfigurableNew.this.mySearchFlyResult = PluginManagerConfigurableNew.this.localSearchPlugins(query);
                if (((PluginManagerConfigurableNew)PluginManagerConfigurableNew.this).mySearchFlyResult.first == null && ((PluginManagerConfigurableNew)PluginManagerConfigurableNew.this).mySearchFlyResult.second == null) {
                    PluginManagerConfigurableNew.this.hideSearchPopup();
                    return;
                }
                if (PluginManagerConfigurableNew.this.mySearchPopupModel == null) {
                    PluginManagerConfigurableNew.this.mySearchPopupModel = new CollectionListModel((Object[])new IdeaPluginDescriptor[0]);
                } else {
                    PluginManagerConfigurableNew.this.mySearchPopupModel.removeAll();
                }
                if (((PluginManagerConfigurableNew)PluginManagerConfigurableNew.this).mySearchFlyResult.first != null) {
                    PluginManagerConfigurableNew.this.mySearchPopupModel.addAll(PluginManagerConfigurableNew.this.mySearchPopupModel.getSize(), ((PluginsGroup)((PluginManagerConfigurableNew)PluginManagerConfigurableNew.this).mySearchFlyResult.first).descriptors);
                }
                if (((PluginManagerConfigurableNew)PluginManagerConfigurableNew.this).mySearchFlyResult.second != null) {
                    PluginManagerConfigurableNew.this.mySearchPopupModel.addAll(PluginManagerConfigurableNew.this.mySearchPopupModel.getSize(), ((PluginsGroup)((PluginManagerConfigurableNew)PluginManagerConfigurableNew.this).mySearchFlyResult.second).descriptors);
                }
                JBTextField editor = PluginManagerConfigurableNew.this.mySearchTextField.getTextEditor();
                Point location = FileTextFieldImpl.getLocationForCaret((JTextComponent)editor);
                if (PluginManagerConfigurableNew.this.mySearchPopup != null) {
                    PluginManagerConfigurableNew.this.mySearchPopup.setLocation(location);
                    PluginManagerConfigurableNew.this.mySearchPopup.pack(false, true);
                    return;
                }
                Consumer callback2 = descriptor2 -> {
                    PluginManagerConfigurableNew.this.hideSearchPopup();
                    PluginManagerConfigurableNew.this.setSearchTextIgnoreEvents("");
                    PluginManagerConfigurableNew.this.myNameListener.linkSelected(null, descriptor2);
                };
                ColoredListCellRenderer renderer = new ColoredListCellRenderer(){

                    protected void customizeCellRenderer(@NotNull JList list2, Object value, int index, boolean selected, boolean hasFocus) {
                        if (list2 == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        IdeaPluginDescriptor descriptor2 = (IdeaPluginDescriptor)value;
                        this.append(descriptor2.getName(), ((PluginManagerConfigurableNew)PluginManagerConfigurableNew.this).mySearchFlyResult.first != null && ((PluginsGroup)((PluginManagerConfigurableNew)PluginManagerConfigurableNew.this).mySearchFlyResult.first).descriptors.contains(descriptor2) ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
                        if (PluginManagerConfigurableNew.isJBPlugin(descriptor2)) {
                            this.append(" by JetBrains", SimpleTextAttributes.GRAY_ATTRIBUTES);
                        } else {
                            String vendor = descriptor2.getVendor();
                            if (!StringUtil.isEmptyOrSpaces((String)vendor)) {
                                this.append(" by " + vendor, SimpleTextAttributes.GRAY_ATTRIBUTES);
                            }
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/ide/plugins/PluginManagerConfigurableNew$6$1", "customizeCellRenderer"));
                    }
                };
                PluginManagerConfigurableNew.this.mySearchPopup = JBPopupFactory.getInstance().createListPopupBuilder(PluginManagerConfigurableNew.this.mySearchPopupList = (JList)new JBList((ListModel)PluginManagerConfigurableNew.this.mySearchPopupModel)).setMovable(false).setResizable(false).setRequestFocus(false).setItemChosenCallback(callback2).setRenderer((ListCellRenderer)renderer).createPopup();
                PluginManagerConfigurableNew.this.mySearchPopup.addListener((JBPopupListener)new JBPopupAdapter(){

                    public void onClosed(LightweightWindowEvent event) {
                        PluginManagerConfigurableNew.this.mySearchPopup = null;
                        PluginManagerConfigurableNew.this.mySearchPopupModel = null;
                        PluginManagerConfigurableNew.this.mySearchPopupList = null;
                        PluginManagerConfigurableNew.this.mySearchFlyResult = null;
                    }
                });
                PluginManagerConfigurableNew.this.mySearchPopupList.clearSelection();
                PluginManagerConfigurableNew.this.mySearchPopup.showInScreenCoordinates((Component)editor, location);
            }
        });
        this.myCardPanel = new CardLayoutPanel<Object, Object, JComponent>(){

            @Override
            protected Object prepare(Object key) {
                return key;
            }

            @Override
            protected JComponent create(Object key) {
                if (key instanceof Integer) {
                    Integer index = (Integer)key;
                    if (index == 0) {
                        return PluginManagerConfigurableNew.this.createTrendingPanel();
                    }
                    if (index == 1) {
                        return PluginManagerConfigurableNew.this.createInstalledPanel();
                    }
                    if (index == 2) {
                        return PluginManagerConfigurableNew.this.createUpdatesPanel();
                    }
                }
                if (key instanceof String) {
                    assert (PluginManagerConfigurableNew.this.mySearchResultInfo == null);
                    PluginManagerConfigurableNew.this.mySearchResultInfo = new SearchResultInfo((String)key);
                    return PluginManagerConfigurableNew.this.mySearchResultInfo.createScrollPane();
                }
                Pair data = (Pair)key;
                ((PluginManagerConfigurableNew)PluginManagerConfigurableNew.this).myPluginsModel.detailPanel = new DetailsPagePluginComponent((IdeaPluginDescriptor)data.first, (Boolean)data.second);
                return ((PluginManagerConfigurableNew)PluginManagerConfigurableNew.this).myPluginsModel.detailPanel;
            }
        };
        panel2.add(this.myCardPanel);
        this.myTabHeaderComponent = new TabHeaderComponent(actions, index -> {
            this.removeDetailsPanel();
            this.removeSearchResultPanel();
            this.myCardPanel.select(index, true);
            PluginManagerConfigurableNew.storeSelectionTab(index);
        });
        this.myTabHeaderComponent.addTab("Trending");
        this.myTabHeaderComponent.addTab("Installed");
        this.myUpdatesTabName = new CountTabName(this.myTabHeaderComponent, "Updates");
        this.myTabHeaderComponent.addTab(this.myUpdatesTabName);
        int selectionTab = PluginManagerConfigurableNew.getStoredSelectionTab();
        this.myTabHeaderComponent.setSelection(selectionTab);
        this.myCardPanel.select(selectionTab, true);
        return panel2;
    }

    private void removeDetailsPanel() {
        if (this.myPluginsModel.detailPanel != null) {
            this.myPluginsModel.detailPanel.close();
            this.myPluginsModel.detailPanel = null;
            this.myTopController.setLeftComponent(null);
            this.myCardPanel.remove(this.myCardPanel.getComponentCount() - 1);
        }
    }

    private void showSearchResultPanel() {
        this.hideSearchPopup();
        String query = this.mySearchTextField.getText();
        if (StringUtil.isEmptyOrSpaces((String)query)) {
            this.hideSearchResultPanel();
        } else if (this.mySearchResultInfo == null) {
            this.showSearchResultPanel(query, false);
        } else {
            this.mySearchResultInfo.setQuery(query);
        }
    }

    private void hideSearchResultPanel() {
        if (this.mySearchResultInfo != null) {
            int index = this.mySearchResultInfo.backTabIndex;
            this.removeSearchResultPanel();
            this.myCardPanel.select(index, true);
            this.myTabHeaderComponent.setSelection(index);
            PluginManagerConfigurableNew.storeSelectionTab(index);
        }
    }

    private void showSearchResultPanel(@NotNull String query, boolean updateText) {
        if (query == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(1);
        }
        int index = this.mySearchResultInfo == null ? (this.myPluginsModel.detailPanel == null ? this.myTabHeaderComponent.getSelectionTab() : this.myPluginsModel.detailPanel.backTabIndex) : this.mySearchResultInfo.backTabIndex;
        this.removeDetailsPanel();
        this.removeSearchResultPanel();
        this.myCardPanel.select(query, true);
        this.mySearchResultInfo.backTabIndex = index;
        if (updateText) {
            this.mySearchResultInfo.setText();
        }
        this.myTabHeaderComponent.clearSelection();
    }

    private void removeSearchResultPanel() {
        if (this.mySearchResultInfo != null) {
            this.mySearchResultInfo.close();
            this.mySearchResultInfo = null;
            this.mySearchTextField.setText("");
            this.myCardPanel.remove(this.myCardPanel.getComponentCount() - 1);
        }
    }

    private static int getStoredSelectionTab() {
        return PropertiesComponent.getInstance().getInt(SELECTION_TAB_KEY, 0);
    }

    private static void storeSelectionTab(int value) {
        PropertiesComponent.getInstance().setValue(SELECTION_TAB_KEY, value, 0);
    }

    public void disposeUIResources() {
        this.myPluginsModel.toBackground();
        Disposer.dispose((Disposable)this.mySearchUpdateAlarm);
        if (this.myShutdownCallback != null) {
            this.myShutdownCallback.run();
            this.myShutdownCallback = null;
        }
    }

    public void apply() throws ConfigurationException {
        HashMap<PluginId, Set<PluginId>> dependencies = new HashMap<PluginId, Set<PluginId>>(this.myPluginsModel.getDependentToRequiredListMap());
        Iterator I = dependencies.entrySet().iterator();
        while (I.hasNext()) {
            Map.Entry entry = I.next();
            boolean hasNonModuleDeps = false;
            for (PluginId pluginId2 : (Set)entry.getValue()) {
                if (PluginManagerCore.isModuleDependency(pluginId2)) continue;
                hasNonModuleDeps = true;
                break;
            }
            if (hasNonModuleDeps) continue;
            I.remove();
        }
        if (!dependencies.isEmpty()) {
            throw new ConfigurationException("<html><body style=\"padding: 5px;\">Unable to apply changes: plugin" + (dependencies.size() == 1 ? " " : "s ") + StringUtil.join(dependencies.keySet(), pluginId -> {
                IdeaPluginDescriptor descriptor2 = PluginManager.getPlugin(pluginId);
                return "\"" + (descriptor2 == null ? pluginId.getIdString() : descriptor2.getName()) + "\"";
            }, (String)", ") + " won't be able to load.</body></html>");
        }
        int rowCount = this.myPluginsModel.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IdeaPluginDescriptor descriptor2 = this.myPluginsModel.getObjectAt(i);
            descriptor2.setEnabled(this.myPluginsModel.isEnabled(descriptor2.getPluginId()));
        }
        ArrayList<String> disableIds = new ArrayList<String>();
        for (Map.Entry<PluginId, Boolean> entry : this.myPluginsModel.getEnabledMap().entrySet()) {
            Boolean enabled = entry.getValue();
            if (enabled == null || enabled.booleanValue()) continue;
            disableIds.add(entry.getKey().getIdString());
        }
        try {
            PluginManagerCore.saveDisabledPlugins(disableIds, false);
        }
        catch (IOException e) {
            PluginManagerMain.LOG.error((Throwable)e);
        }
        if (this.myShutdownCallback == null && this.myPluginsModel.createShutdownCallback) {
            this.myShutdownCallback = () -> ApplicationManager.getApplication().invokeLater(() -> PluginManagerConfigurable.shutdownOrRestartApp(IdeBundle.message((String)"update.notifications.title", (Object[])new Object[0])), ModalityState.any());
        }
    }

    public boolean isModified() {
        if (this.myPluginsModel.needRestart) {
            return true;
        }
        List<String> disabledPlugins = PluginManagerCore.getDisabledPlugins();
        int rowCount = this.myPluginsModel.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IdeaPluginDescriptor descriptor2 = this.myPluginsModel.getObjectAt(i);
            PluginId pluginId = descriptor2.getPluginId();
            boolean enabledInTable = this.myPluginsModel.isEnabled(pluginId);
            if (descriptor2.isEnabled() == enabledInTable || enabledInTable && !disabledPlugins.contains(pluginId.getIdString())) continue;
            return true;
        }
        for (Map.Entry<PluginId, Boolean> entry : this.myPluginsModel.getEnabledMap().entrySet()) {
            Boolean enabled = entry.getValue();
            if (enabled == null || enabled.booleanValue() || disabledPlugins.contains(entry.getKey().getIdString())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public Component getCenterComponent(@NotNull Configurable.TopComponentController controller) {
        if (controller == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(2);
        }
        this.myTopController = controller;
        this.myPluginsModel.setTopController(controller);
        TabHeaderComponent tabHeaderComponent = this.myTabHeaderComponent;
        if (tabHeaderComponent == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(3);
        }
        return tabHeaderComponent;
    }

    @NotNull
    private JComponent createTrendingPanel() {
        PluginsGroupComponentWithProgress panel2 = new PluginsGroupComponentWithProgress((LayoutManager)((Object)new PluginsGridLayout()), EventHandler.EMPTY, this.myNameListener, this.mySearchListener, (Function<IdeaPluginDescriptor, CellPluginComponent>)((Function)descriptor2 -> new GridCellPluginComponent(this.myPluginsModel, (IdeaPluginDescriptor)descriptor2, this.myTagBuilder)));
        panel2.getEmptyText().setText("Trending plugins are not loaded.").appendSecondaryText("Check the interner connection.", StatusText.DEFAULT_ATTRIBUTES, null);
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            ArrayList<PluginsGroup> groups = new ArrayList<PluginsGroup>();
            try {
                this.myJBRepositoryMap = new HashMap<String, IdeaPluginDescriptor>();
                this.myJBRepositoryList = RepositoryHelper.loadPlugins(null);
                for (IdeaPluginDescriptor plugin : this.myJBRepositoryList) {
                    this.myJBRepositoryMap.put(plugin.getPluginId().getIdString(), plugin);
                }
                HashSet<String> excludeDescriptors = new HashSet<String>();
                this.addGroup(groups, excludeDescriptors, "Featured", "is_featured_search=true", "sort by:featured");
                this.addGroup(groups, excludeDescriptors, "New and Updated", "orderBy=update+date", "sort by:updates");
                this.addGroup(groups, excludeDescriptors, "Top Downloads", "orderBy=downloads", "sort by:downloads");
                this.addGroup(groups, excludeDescriptors, "Top Rated", "orderBy=rating", "sort by:rating");
            }
            catch (IOException e) {
                PluginManagerMain.LOG.info((Throwable)e);
            }
            finally {
                ApplicationManager.getApplication().invokeLater(() -> {
                    panel2.stopLoading();
                    for (PluginsGroup group : groups) {
                        panel2.addGroup(group);
                    }
                    panel2.doLayout();
                    panel2.initialSelection();
                }, ModalityState.any());
            }
        });
        JComponent jComponent = PluginManagerConfigurableNew.createScrollPane(panel2, false);
        if (jComponent == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(4);
        }
        return jComponent;
    }

    private void addGroup(@NotNull List<PluginsGroup> groups, @NotNull Set<String> excludeDescriptors, @NotNull String name, @NotNull String query, @NotNull String showAllQuery) throws IOException {
        if (groups == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(5);
        }
        if (excludeDescriptors == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(6);
        }
        if (name == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(7);
        }
        if (query == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(8);
        }
        if (showAllQuery == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(9);
        }
        PluginsGroup group = new PluginsGroup(name);
        PluginManagerConfigurableNew.loadPlugins(group.descriptors, this.myJBRepositoryMap, excludeDescriptors, query, 6);
        if (!group.descriptors.isEmpty()) {
            group.rightAction = new LinkLabel("Show All", null, this.mySearchListener, (Object)showAllQuery);
            groups.add(group);
        }
    }

    @NotNull
    private JComponent createInstalledPanel() {
        PluginsGroupComponent panel2 = new PluginsGroupComponent((LayoutManager)((Object)new PluginsListLayout()), new MultiSelectionEventHandler(), this.myNameListener, this.mySearchListener, (Function<IdeaPluginDescriptor, CellPluginComponent>)((Function)descriptor2 -> new ListPluginComponent(this.myPluginsModel, (IdeaPluginDescriptor)descriptor2, false)));
        PluginsGroup installing = new PluginsGroup("Installing");
        installing.descriptors.addAll(MyPluginModel.getInstallingPlugins());
        if (!installing.descriptors.isEmpty()) {
            installing.sortByName();
            installing.titleWithCount();
            panel2.addGroup(installing);
        }
        PluginsGroup downloaded = new PluginsGroup("Downloaded");
        PluginsGroup bundled = new PluginsGroup("Bundled");
        downloaded.descriptors.addAll(InstalledPluginsState.getInstance().getInstalledPlugins());
        ApplicationInfoEx appInfo = ApplicationInfoEx.getInstanceEx();
        int bundledEnabled = 0;
        int downloadedEnabled = 0;
        for (IdeaPluginDescriptor descriptor3 : PluginManagerCore.getPlugins()) {
            if (appInfo.isEssentialPlugin(descriptor3.getPluginId().getIdString())) continue;
            if (descriptor3.isBundled()) {
                bundled.descriptors.add(descriptor3);
                if (!descriptor3.isEnabled()) continue;
                ++bundledEnabled;
                continue;
            }
            downloaded.descriptors.add(descriptor3);
            if (!descriptor3.isEnabled()) continue;
            ++downloadedEnabled;
        }
        if (!downloaded.descriptors.isEmpty()) {
            downloaded.sortByName();
            downloaded.titleWithCount(downloadedEnabled);
            panel2.addGroup(downloaded);
            this.myPluginsModel.addEnabledGroup(downloaded);
        }
        this.myPluginsModel.setDownloadedGroup(panel2, downloaded, installing);
        bundled.sortByName();
        bundled.titleWithCount(bundledEnabled);
        panel2.addGroup(bundled);
        this.myPluginsModel.addEnabledGroup(bundled);
        JComponent jComponent = PluginManagerConfigurableNew.createScrollPane(panel2, true);
        if (jComponent == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(10);
        }
        return jComponent;
    }

    @NotNull
    private JComponent createUpdatesPanel() {
        PluginsGroupComponentWithProgress panel2 = new PluginsGroupComponentWithProgress((LayoutManager)((Object)new PluginsListLayout()), new MultiSelectionEventHandler(), this.myNameListener, this.mySearchListener, (Function<IdeaPluginDescriptor, CellPluginComponent>)((Function)descriptor2 -> new ListPluginComponent(this.myPluginsModel, (IdeaPluginDescriptor)descriptor2, true)));
        panel2.getEmptyText().setText("No updates available.");
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            Collection<PluginDownloader> updates = UpdateChecker.getPluginUpdates();
            ApplicationManager.getApplication().invokeLater(() -> {
                panel2.stopLoading();
                if (ContainerUtil.isEmpty((Collection)updates)) {
                    this.myUpdatesTabName.setCount(0);
                } else {
                    final PluginsGroup group = new PluginsGroup("Available Updates"){

                        @Override
                        public void titleWithCount() {
                            int count = 0;
                            for (CellPluginComponent component : this.ui.plugins) {
                                if (((ListPluginComponent)component).myUpdateButton == null) continue;
                                ++count;
                            }
                            this.title = this.myTitlePrefix + " (" + count + ")";
                            this.updateTitle();
                            this.rightAction.setVisible(count > 0);
                            PluginManagerConfigurableNew.this.myUpdatesTabName.setCount(count);
                        }
                    };
                    group.rightAction = new LinkLabel("Update All", null);
                    group.rightAction.setListener((LinkListener)new LinkListener<Object>(){

                        public void linkSelected(LinkLabel aSource, Object aLinkData) {
                            for (CellPluginComponent component : group.ui.plugins) {
                                ((ListPluginComponent)component).updatePlugin();
                            }
                        }
                    }, null);
                    for (PluginDownloader toUpdateDownloader : updates) {
                        group.descriptors.add(toUpdateDownloader.getDescriptor());
                    }
                    group.sortByName();
                    panel2.addGroup(group);
                    group.titleWithCount();
                    this.myPluginsModel.setUpdateGroup(group);
                }
                panel2.doLayout();
                panel2.initialSelection();
            }, ModalityState.any());
        });
        JComponent jComponent = PluginManagerConfigurableNew.createScrollPane(panel2, false);
        if (jComponent == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(11);
        }
        return jComponent;
    }

    @Nullable
    private static String recognizeServerSearchQuery(@NotNull String query) {
        if (query == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(12);
        }
        if (query.equals("sort by:featured")) {
            return "is_featured_search=true";
        }
        if (query.equals("sort by:updates")) {
            return "orderBy=update+date";
        }
        if (query.equals("sort by:downloads")) {
            return "orderBy=downloads";
        }
        if (query.equals("sort by:rating")) {
            return "orderBy=rating";
        }
        if (query.startsWith("tag:")) {
            return "tags=" + URLUtil.encodeURIComponent((String)query.substring(4));
        }
        return null;
    }

    private static void loadPlugins(@NotNull List<IdeaPluginDescriptor> descriptors, @NotNull Map<String, IdeaPluginDescriptor> allDescriptors, @NotNull Set<String> excludeDescriptors, @NotNull String query, int count) throws IOException {
        Url baseUrl;
        if (descriptors == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(13);
        }
        if (allDescriptors == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(14);
        }
        if (excludeDescriptors == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(15);
        }
        if (query == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(16);
        }
        boolean forceHttps = PluginManagerConfigurableNew.forceHttps();
        Url offsetUrl = baseUrl = PluginManagerConfigurableNew.createSearchUrl(query, count);
        HashMap<String, String> offsetParameters = new HashMap<String, String>();
        int offset = 0;
        List<String> pluginIds;
        while (!(pluginIds = PluginManagerConfigurableNew.requestToPluginRepository(offsetUrl, forceHttps)).isEmpty()) {
            for (String pluginId : pluginIds) {
                IdeaPluginDescriptor descriptor2 = allDescriptors.get(pluginId);
                if (descriptor2 == null || !excludeDescriptors.add(pluginId) || PluginManager.getPlugin(descriptor2.getPluginId()) != null) continue;
                descriptors.add(descriptor2);
                if (descriptors.size() != count) continue;
                return;
            }
            offsetParameters.put("offset", Integer.toString(offset += pluginIds.size()));
            offsetUrl = baseUrl.addParameters(offsetParameters);
        }
        return;
    }

    @NotNull
    private static List<String> requestToPluginRepository(@NotNull Url url, boolean forceHttps) throws IOException {
        if (url == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(17);
        }
        ArrayList<String> ids = new ArrayList<String>();
        HttpRequests.request((Url)url).forceHttps(forceHttps).productNameAsUserAgent().connect(request -> {
            URLConnection connection = request.getConnection();
            if (connection instanceof HttpURLConnection && ((HttpURLConnection)connection).getResponseCode() != 200) {
                return null;
            }
            try (JsonReaderEx json = new JsonReaderEx(FileUtil.loadTextAndClose((Reader)request.getReader()));){
                json.beginArray();
                while (json.hasNext()) {
                    ids.add(json.nextString());
                }
                json.endArray();
            }
            return null;
        });
        ArrayList<String> arrayList = ids;
        if (arrayList == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    @NotNull
    private static Url createSearchUrl(@NotNull String query, int count) {
        if (query == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(19);
        }
        Url url = Urls.newFromEncoded("http://plugins.jetbrains.com/api/search?" + query + "&build=" + ApplicationInfoImpl.getShadowInstance().getApiVersion() + "&max=" + count);
        if (url == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(20);
        }
        return url;
    }

    private static boolean forceHttps() {
        return IdeaApplication.isLoaded() && UpdateSettings.getInstance().canUseSecureConnection();
    }

    @NotNull
    private Pair<PluginsGroup, PluginsGroup> localSearchPlugins(@NotNull String query) {
        if (query == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(21);
        }
        Set search2 = SearchableOptionsRegistrar.getInstance().getProcessedWords(query);
        PluginsGroup installed = new PluginsGroup("Installed");
        PluginManagerConfigurableNew.localSearchPlugins(MyPluginModel.getInstallingPlugins(), installed.descriptors, (BooleanFunction<IdeaPluginDescriptor>)((BooleanFunction)descriptor2 -> true), query, (Set<String>)search2);
        PluginManagerConfigurableNew.localSearchPlugins(InstalledPluginsState.getInstance().getInstalledPlugins(), installed.descriptors, (BooleanFunction<IdeaPluginDescriptor>)((BooleanFunction)descriptor2 -> true), query, (Set<String>)search2);
        HashSet<String> installedIds = new HashSet<String>();
        for (IdeaPluginDescriptor descriptor3 : installed.descriptors) {
            installedIds.add(descriptor3.getPluginId().getIdString());
        }
        ApplicationInfoEx appInfo = ApplicationInfoEx.getInstanceEx();
        PluginManagerConfigurableNew.localSearchPlugins(PluginManagerCore.getPlugins(), installed.descriptors, (BooleanFunction<IdeaPluginDescriptor>)((BooleanFunction)descriptor2 -> !appInfo.isEssentialPlugin(descriptor2.getPluginId().getIdString())), query, (Set<String>)search2);
        PluginsGroup repository = new PluginsGroup("Search Result");
        PluginManagerConfigurableNew.localSearchPlugins(this.myJBRepositoryList, repository.descriptors, (BooleanFunction<IdeaPluginDescriptor>)((BooleanFunction)descriptor2 -> !installedIds.contains(descriptor2.getPluginId().getIdString())), query, (Set<String>)search2);
        if (installed.descriptors.isEmpty()) {
            installed = null;
        } else {
            installed.sortByName();
        }
        if (repository.descriptors.isEmpty()) {
            repository = null;
        } else {
            repository.sortByName();
        }
        Pair pair = Pair.create((Object)installed, (Object)repository);
        if (pair == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(22);
        }
        return pair;
    }

    private static void localSearchPlugins(@NotNull Collection<IdeaPluginDescriptor> source, @NotNull List<IdeaPluginDescriptor> result2, @NotNull BooleanFunction<IdeaPluginDescriptor> accept, @NotNull String query, @NotNull Set<String> search2) {
        if (source == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(23);
        }
        if (result2 == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(24);
        }
        if (accept == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(25);
        }
        if (query == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(26);
        }
        if (search2 == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(27);
        }
        for (IdeaPluginDescriptor descriptor2 : source) {
            if (!accept.fun((Object)descriptor2) || !PluginManagerMain.isAccepted(query, search2, descriptor2)) continue;
            result2.add(descriptor2);
        }
    }

    private static void localSearchPlugins(@NotNull IdeaPluginDescriptor[] source, @NotNull List<IdeaPluginDescriptor> result2, @NotNull BooleanFunction<IdeaPluginDescriptor> accept, @NotNull String query, @NotNull Set<String> search2) {
        if (source == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(28);
        }
        if (result2 == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(29);
        }
        if (accept == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(30);
        }
        if (query == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(31);
        }
        if (search2 == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(32);
        }
        for (IdeaPluginDescriptor descriptor2 : source) {
            if (!accept.fun((Object)descriptor2) || !PluginManagerMain.isAccepted(query, search2, descriptor2)) continue;
            result2.add(descriptor2);
        }
    }

    @NotNull
    private static JPanel createLabelsPanel(@NotNull JPanel parent, @NotNull List<JLabel> labels, @NotNull String labelText, @NotNull String text2, @Nullable String link) {
        if (parent == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(33);
        }
        if (labels == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(34);
        }
        if (labelText == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(35);
        }
        if (text2 == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(36);
        }
        NonOpaquePanel linePanel = new NonOpaquePanel((LayoutManager)((Object)new HorizontalLayout(5)));
        parent.add((Component)linePanel);
        JLabel label2 = new JLabel(labelText);
        linePanel.add(label2);
        labels.add(label2);
        if (StringUtil.isEmptyOrSpaces((String)link)) {
            linePanel.add(new JLabel(text2));
        } else {
            linePanel.add((Component)new LinkLabel(text2, null));
        }
        NonOpaquePanel nonOpaquePanel = linePanel;
        if (nonOpaquePanel == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(37);
        }
        return nonOpaquePanel;
    }

    @NotNull
    private static JComponent createScrollPane(@NotNull PluginsGroupComponent panel2, boolean initSelection) {
        if (panel2 == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(38);
        }
        JBScrollPane pane = new JBScrollPane((Component)((Object)panel2));
        pane.setBorder((Border)JBUI.Borders.empty());
        if (initSelection) {
            panel2.initialSelection();
        }
        JBScrollPane jBScrollPane = pane;
        if (jBScrollPane == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(39);
        }
        return jBScrollPane;
    }

    @NotNull
    private static String getErrorMessage(@NotNull InstalledPluginsTableModel pluginsModel, @NotNull PluginDescriptor pluginDescriptor, @NotNull Ref<Boolean> enableAction) {
        String message;
        Set<PluginId> requiredPlugins;
        if (pluginsModel == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(40);
        }
        if (pluginDescriptor == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(41);
        }
        if (enableAction == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(42);
        }
        if (ContainerUtil.isEmpty(requiredPlugins = pluginsModel.getRequiredPlugins(pluginDescriptor.getPluginId()))) {
            message = "Incompatible with the current " + ApplicationNamesInfo.getInstance().getFullProductName() + " version.";
        } else if (requiredPlugins.contains(PluginId.getId((String)"com.intellij.modules.ultimate"))) {
            message = "The plugin requires IntelliJ IDEA Ultimate.";
        } else {
            String deps = StringUtil.join(requiredPlugins, id -> {
                IdeaPluginDescriptor plugin = PluginManager.getPlugin(id);
                if (plugin == null && PluginManagerCore.isModuleDependency(id)) {
                    for (IdeaPluginDescriptor descriptor2 : PluginManagerCore.getPlugins()) {
                        List<String> modules;
                        if (!(descriptor2 instanceof IdeaPluginDescriptorImpl) || (modules = ((IdeaPluginDescriptorImpl)descriptor2).getModules()) == null || !modules.contains(id.getIdString())) continue;
                        plugin = descriptor2;
                        break;
                    }
                }
                return plugin != null ? plugin.getName() : id.getIdString();
            }, (String)", ");
            message = IdeBundle.message((String)"new.plugin.manager.incompatible.deps.tooltip", (Object[])new Object[]{requiredPlugins.size(), deps});
            enableAction.set((Object)Boolean.TRUE);
        }
        String string = message;
        if (string == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(43);
        }
        return string;
    }

    @NotNull
    private static List<String> getTags(@NotNull IdeaPluginDescriptor plugin) {
        if (plugin == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(44);
        }
        List<String> tags = null;
        if (plugin instanceof PluginNode) {
            tags = ((PluginNode)plugin).getTags();
        }
        if (ContainerUtil.isEmpty(tags)) {
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                PluginManagerConfigurableNew.$$$reportNull$$$0(45);
            }
            return list2;
        }
        int eap = tags.indexOf("EAP");
        if (eap > 0) {
            tags = new ArrayList<String>(tags);
            tags.remove(eap);
            tags.add(0, "EAP");
        }
        List<String> list3 = tags;
        if (list3 == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(46);
        }
        return list3;
    }

    @Nullable
    private static String getDownloads(@NotNull IdeaPluginDescriptor plugin) {
        String downloads;
        if (plugin == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(47);
        }
        if (!StringUtil.isEmptyOrSpaces((String)(downloads = ((PluginNode)plugin).getDownloads()))) {
            try {
                Long value = Long.valueOf(downloads);
                if (value > 1000L) {
                    return value < 1000000L ? K_FORMAT.format((double)value.longValue() / 1000.0) : M_FORMAT.format((double)value.longValue() / 1000000.0);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    private static String getLastUpdatedDate(@NotNull IdeaPluginDescriptor plugin) {
        long date;
        if (plugin == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(48);
        }
        return (date = ((PluginNode)plugin).getDate()) > 0L ? DATE_FORMAT.format(new Date(date)) : null;
    }

    @Nullable
    private static String getRating(@NotNull IdeaPluginDescriptor plugin) {
        String rating;
        if (plugin == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(49);
        }
        if ((rating = ((PluginNode)plugin).getRating()) != null) {
            try {
                if (Double.valueOf(rating) > 0.0) {
                    return StringUtil.trimEnd((String)rating, (String)".0");
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    @NotNull
    private static JComponent createToolbar(final @NotNull DefaultActionGroup actions) {
        if (actions == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(50);
        }
        DefaultActionGroup toolbarActionGroup = new DefaultActionGroup();
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("NavBarToolbar", (ActionGroup)toolbarActionGroup, true);
        toolbar.setReservePlaceAutoPopupIcon(false);
        toolbar.setLayoutPolicy(0);
        final JComponent toolbarComponent = toolbar.getComponent();
        toolbarActionGroup.add((AnAction)new DumbAwareAction(null, null, AllIcons.General.Gear){

            public void actionPerformed(AnActionEvent e) {
                ListPopup actionGroupPopup = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)actions, e.getDataContext(), true, null, Integer.MAX_VALUE);
                HelpTooltip.setMasterPopup((Component)e.getInputEvent().getComponent(), (JBPopup)actionGroupPopup);
                actionGroupPopup.show(new RelativePoint((Component)toolbarComponent, this.getPopupPoint()));
            }

            private Point getPopupPoint() {
                int dH = UIUtil.isUnderWin10LookAndFeel() ? JBUI.scale((int)1) : 0;
                return new Point(JBUI.scale((int)2), toolbarComponent.getHeight() - dH);
            }
        });
        toolbarComponent.setBorder((Border)JBUI.Borders.empty());
        JComponent jComponent = toolbarComponent;
        if (jComponent == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(51);
        }
        return jComponent;
    }

    private static int getParentWidth(@NotNull Container parent) {
        int width;
        if (parent == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(52);
        }
        if ((width = parent.getWidth()) > 0) {
            Container container = parent.getParent();
            int parentWidth = container.getWidth();
            if (container instanceof JViewport && parentWidth < width) {
                width = parentWidth;
            }
        }
        return width;
    }

    private void hideSearchPopup() {
        if (this.mySearchPopup != null) {
            this.mySearchPopup.cancel();
            this.mySearchPopup = null;
            this.mySearchPopupModel = null;
            this.mySearchPopupList = null;
            this.mySearchFlyResult = null;
        }
    }

    private void setSearchTextIgnoreEvents(@NotNull String text2) {
        if (text2 == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(53);
        }
        try {
            this.mySkipDocumentEvents = true;
            this.mySearchTextField.setText(text2);
        }
        finally {
            this.mySkipDocumentEvents = false;
        }
    }

    @NotNull
    private static <T extends Component> T installTiny(@NotNull T component) {
        if (component == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(54);
        }
        Object object = SystemInfo.isMac ? RelativeFont.TINY.install(component) : component;
        if (object == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(55);
        }
        return object;
    }

    private static int offset5() {
        return JBUI.scale((int)5);
    }

    private static void configureBackButton(@NotNull JButton button) {
        if (button == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(56);
        }
        button.setIcon(new Icon(){

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                AllIcons.Actions.Back.paintIcon(c, g, x + JBUI.scale((int)7), y);
            }

            @Override
            public int getIconWidth() {
                return AllIcons.Actions.Back.getIconWidth() + JBUI.scale((int)7);
            }

            @Override
            public int getIconHeight() {
                return AllIcons.Actions.Back.getIconHeight();
            }
        });
        button.setHorizontalAlignment(2);
        Dimension size = button.getPreferredSize();
        size.width -= JBUI.scale((int)15);
        button.setPreferredSize(size);
    }

    private static void setWidth72(@NotNull JButton button) {
        if (button == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(57);
        }
        int width = JBUI.scale((int)72);
        if (button instanceof JBOptionButton && button.getComponentCount() == 2) {
            width += button.getComponent((int)1).getPreferredSize().width;
        } else {
            Border border = button.getBorder();
            if (border != null) {
                Insets insets = border.getBorderInsets(button);
                width += insets.left + insets.right;
            }
        }
        button.setPreferredSize(new Dimension(width, button.getPreferredSize().height));
    }

    private static boolean isJBPlugin(@NotNull IdeaPluginDescriptor plugin) {
        if (plugin == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(58);
        }
        return plugin.isBundled() || PluginManagerMain.isDevelopedByJetBrains(plugin);
    }

    @Nullable
    private static String getShortDescription(@NotNull IdeaPluginDescriptor plugin, boolean shortSize) {
        if (plugin == null) {
            PluginManagerConfigurableNew.$$$reportNull$$$0(59);
        }
        return PluginSiteUtils.preparePluginDescription(plugin.getDescription(), shortSize);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/PluginManagerConfigurableNew";
                break;
            }
            case 1: 
            case 8: 
            case 12: 
            case 16: 
            case 19: 
            case 21: 
            case 26: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 6: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludeDescriptors";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "showAllQuery";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allDescriptors";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 23: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 24: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 25: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accept";
                break;
            }
            case 27: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "search";
                break;
            }
            case 33: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "labels";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "labelText";
                break;
            }
            case 36: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginsModel";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enableAction";
                break;
            }
            case 44: 
            case 47: 
            case 48: 
            case 49: 
            case 58: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugin";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 56: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "button";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurableNew";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCenterComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createTrendingPanel";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createInstalledPanel";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createUpdatesPanel";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "requestToPluginRepository";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createSearchUrl";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "localSearchPlugins";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "createLabelsPanel";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "createScrollPane";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorMessage";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getTags";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbar";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "installTiny";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "showSearchResultPanel";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getCenterComponent";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addGroup";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "recognizeServerSearchQuery";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "loadPlugins";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "requestToPluginRepository";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createSearchUrl";
                break;
            }
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "localSearchPlugins";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "createLabelsPanel";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "createScrollPane";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getErrorMessage";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getTags";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getDownloads";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getLastUpdatedDate";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getRating";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "createToolbar";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getParentWidth";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "setSearchTextIgnoreEvents";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "installTiny";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "configureBackButton";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "setWidth72";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "isJBPlugin";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getShortDescription";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class PluginLogoInfo {
        private static LayeredIcon PluginLogoJB_40;
        private static LayeredIcon PluginLogoError_40;
        private static LayeredIcon PluginLogoJBError_40;
        private static LayeredIcon PluginLogoDisabledJB_40;
        private static LayeredIcon PluginLogoDisabledError_40;
        private static LayeredIcon PluginLogoDisabledJBError_40;
        private static LayeredIcon PluginLogoJB_80;
        private static LayeredIcon PluginLogoError_80;
        private static LayeredIcon PluginLogoJBError_80;
        private static LayeredIcon PluginLogoDisabledJB_80;
        private static LayeredIcon PluginLogoDisabledError_80;
        private static LayeredIcon PluginLogoDisabledJBError_80;
        private static boolean myCreateIcons;

        private PluginLogoInfo() {
        }

        private static void createIcons() {
            if (!myCreateIcons) {
                return;
            }
            myCreateIcons = false;
            PluginLogoJB_40 = new LayeredIcon(2);
            PluginLogoInfo.setSouthEast(PluginLogoJB_40, AllIcons.Plugins.PluginLogo_40, AllIcons.Plugins.ModifierJBLogo);
            PluginLogoError_40 = new LayeredIcon(2);
            PluginLogoInfo.setSouthWest(PluginLogoError_40, AllIcons.Plugins.PluginLogo_40, AllIcons.Plugins.ModifierInvalid);
            PluginLogoJBError_40 = new LayeredIcon(3);
            PluginLogoInfo.setSouthEastWest(PluginLogoJBError_40, AllIcons.Plugins.PluginLogo_40, AllIcons.Plugins.ModifierJBLogo, AllIcons.Plugins.ModifierInvalid);
            Icon disabledJBLogo = IconLoader.getDisabledIcon((Icon)AllIcons.Plugins.ModifierJBLogo);
            assert (disabledJBLogo != null);
            PluginLogoDisabledJB_40 = new LayeredIcon(2);
            PluginLogoInfo.setSouthEast(PluginLogoDisabledJB_40, AllIcons.Plugins.PluginLogoDisabled_40, disabledJBLogo);
            PluginLogoDisabledError_40 = new LayeredIcon(2);
            PluginLogoInfo.setSouthWest(PluginLogoDisabledError_40, AllIcons.Plugins.PluginLogoDisabled_40, AllIcons.Plugins.ModifierInvalid);
            PluginLogoDisabledJBError_40 = new LayeredIcon(3);
            PluginLogoInfo.setSouthEastWest(PluginLogoDisabledJBError_40, AllIcons.Plugins.PluginLogoDisabled_40, disabledJBLogo, AllIcons.Plugins.ModifierInvalid);
            Icon jbLogo2x = IconUtil.scale((Icon)AllIcons.Plugins.ModifierJBLogo, null, (float)2.0f);
            Icon errorLogo2x = IconUtil.scale((Icon)AllIcons.Plugins.ModifierInvalid, null, (float)2.0f);
            PluginLogoJB_80 = new LayeredIcon(2);
            PluginLogoInfo.setSouthEast(PluginLogoJB_80, AllIcons.Plugins.PluginLogo_80, jbLogo2x);
            PluginLogoError_80 = new LayeredIcon(2);
            PluginLogoInfo.setSouthWest(PluginLogoError_80, AllIcons.Plugins.PluginLogo_80, errorLogo2x);
            PluginLogoJBError_80 = new LayeredIcon(3);
            PluginLogoInfo.setSouthEastWest(PluginLogoJBError_80, AllIcons.Plugins.PluginLogo_80, jbLogo2x, errorLogo2x);
            Icon disabledJBLogo2x = IconLoader.getDisabledIcon((Icon)jbLogo2x);
            assert (disabledJBLogo2x != null);
            PluginLogoDisabledJB_80 = new LayeredIcon(2);
            PluginLogoInfo.setSouthEast(PluginLogoDisabledJB_80, AllIcons.Plugins.PluginLogoDisabled_80, disabledJBLogo2x);
            PluginLogoDisabledError_80 = new LayeredIcon(2);
            PluginLogoInfo.setSouthWest(PluginLogoDisabledError_80, AllIcons.Plugins.PluginLogoDisabled_80, errorLogo2x);
            PluginLogoDisabledJBError_80 = new LayeredIcon(3);
            PluginLogoInfo.setSouthEastWest(PluginLogoDisabledJBError_80, AllIcons.Plugins.PluginLogoDisabled_80, disabledJBLogo2x, errorLogo2x);
        }

        private static void setSouthEast(@NotNull LayeredIcon layeredIcon, @NotNull Icon main, @NotNull Icon southEast) {
            if (layeredIcon == null) {
                PluginLogoInfo.$$$reportNull$$$0(0);
            }
            if (main == null) {
                PluginLogoInfo.$$$reportNull$$$0(1);
            }
            if (southEast == null) {
                PluginLogoInfo.$$$reportNull$$$0(2);
            }
            layeredIcon.setIcon(main, 0);
            layeredIcon.setIcon(southEast, 1, 4);
        }

        private static void setSouthWest(@NotNull LayeredIcon layeredIcon, @NotNull Icon main, @NotNull Icon southWest) {
            if (layeredIcon == null) {
                PluginLogoInfo.$$$reportNull$$$0(3);
            }
            if (main == null) {
                PluginLogoInfo.$$$reportNull$$$0(4);
            }
            if (southWest == null) {
                PluginLogoInfo.$$$reportNull$$$0(5);
            }
            layeredIcon.setIcon(main, 0);
            layeredIcon.setIcon(southWest, 1, 6);
        }

        private static void setSouthEastWest(@NotNull LayeredIcon layeredIcon, @NotNull Icon main, @NotNull Icon southEast, @NotNull Icon southWest) {
            if (layeredIcon == null) {
                PluginLogoInfo.$$$reportNull$$$0(6);
            }
            if (main == null) {
                PluginLogoInfo.$$$reportNull$$$0(7);
            }
            if (southEast == null) {
                PluginLogoInfo.$$$reportNull$$$0(8);
            }
            if (southWest == null) {
                PluginLogoInfo.$$$reportNull$$$0(9);
            }
            layeredIcon.setIcon(main, 0);
            layeredIcon.setIcon(southEast, 1, 4);
            layeredIcon.setIcon(southWest, 2, 6);
        }

        @NotNull
        public static Icon getIcon(boolean big, boolean jb, boolean error, boolean disabled) {
            PluginLogoInfo.createIcons();
            if (jb && !error) {
                if (big) {
                    LayeredIcon layeredIcon = disabled ? PluginLogoDisabledJB_80 : PluginLogoJB_80;
                    if (layeredIcon == null) {
                        PluginLogoInfo.$$$reportNull$$$0(10);
                    }
                    return layeredIcon;
                }
                LayeredIcon layeredIcon = disabled ? PluginLogoDisabledJB_40 : PluginLogoJB_40;
                if (layeredIcon == null) {
                    PluginLogoInfo.$$$reportNull$$$0(11);
                }
                return layeredIcon;
            }
            if (!jb && error) {
                if (big) {
                    LayeredIcon layeredIcon = disabled ? PluginLogoDisabledError_80 : PluginLogoError_80;
                    if (layeredIcon == null) {
                        PluginLogoInfo.$$$reportNull$$$0(12);
                    }
                    return layeredIcon;
                }
                LayeredIcon layeredIcon = disabled ? PluginLogoDisabledError_40 : PluginLogoError_40;
                if (layeredIcon == null) {
                    PluginLogoInfo.$$$reportNull$$$0(13);
                }
                return layeredIcon;
            }
            if (jb) {
                if (big) {
                    LayeredIcon layeredIcon = disabled ? PluginLogoDisabledJBError_80 : PluginLogoJBError_80;
                    if (layeredIcon == null) {
                        PluginLogoInfo.$$$reportNull$$$0(14);
                    }
                    return layeredIcon;
                }
                LayeredIcon layeredIcon = disabled ? PluginLogoDisabledJBError_40 : PluginLogoJBError_40;
                if (layeredIcon == null) {
                    PluginLogoInfo.$$$reportNull$$$0(15);
                }
                return layeredIcon;
            }
            if (big) {
                Icon icon = disabled ? AllIcons.Plugins.PluginLogoDisabled_80 : AllIcons.Plugins.PluginLogo_80;
                if (icon == null) {
                    PluginLogoInfo.$$$reportNull$$$0(16);
                }
                return icon;
            }
            Icon icon = disabled ? AllIcons.Plugins.PluginLogoDisabled_40 : AllIcons.Plugins.PluginLogo_40;
            if (icon == null) {
                PluginLogoInfo.$$$reportNull$$$0(17);
            }
            return icon;
        }

        static {
            myCreateIcons = true;
            LafManager.getInstance().addLafManagerListener(source -> {
                myCreateIcons = true;
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "layeredIcon";
                    break;
                }
                case 1: 
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "main";
                    break;
                }
                case 2: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "southEast";
                    break;
                }
                case 5: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "southWest";
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/plugins/PluginManagerConfigurableNew$PluginLogoInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurableNew$PluginLogoInfo";
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "setSouthEast";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "setSouthWest";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "setSouthEastWest";
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class PluginSiteUtils {
        private static final Pattern TAG_PATTERN = Pattern.compile("</?\\w+((\\s+\\w+(\\s*=\\s*(?:\".*?\"|'.*?'|[\\^'\">\\s]+))?)+\\s*|\\s*)/?>");
        private static final int SHORT_DESC_SIZE = 170;
        private static final Pattern BR_PATTERN = Pattern.compile("<br\\s*/?>");

        @Nullable
        public static String preparePluginDescription(@Nullable String s, boolean shortSize) {
            if (s == null || s.isEmpty()) {
                return null;
            }
            String description = PluginSiteUtils.prepareDescription(s, shortSize);
            return description.isEmpty() || description.endsWith(".") ? description : description + ".";
        }

        @NotNull
        private static String prepareDescription(@NotNull String s, boolean shortSize) {
            String[] sanitize;
            String[] split;
            if (s == null) {
                PluginSiteUtils.$$$reportNull$$$0(0);
            }
            if (shortSize && (split = BR_PATTERN.split(s)).length > 1 && (sanitize = PluginSiteUtils.stripTags(split[0])).length() <= 170) {
                if (sanitize == null) {
                    PluginSiteUtils.$$$reportNull$$$0(1);
                }
                return sanitize;
            }
            String stripped = PluginSiteUtils.stripTags(s);
            if (shortSize) {
                for (String sep : new String[]{". ", ".\n", ": ", ":\n"}) {
                    String by = PluginSiteUtils.substringBy(stripped, sep);
                    if (by == null) continue;
                    String string = by;
                    if (string == null) {
                        PluginSiteUtils.$$$reportNull$$$0(2);
                    }
                    return string;
                }
                if (stripped.length() > 170) {
                    int index = (stripped = stripped.substring(0, 170)).lastIndexOf(32);
                    if (index == -1) {
                        index = stripped.length();
                    }
                    stripped = stripped.substring(0, index) + "...";
                }
            }
            String string = stripped;
            if (string == null) {
                PluginSiteUtils.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Nullable
        private static String substringBy(@NotNull String str, @NotNull String separator) {
            int end;
            if (str == null) {
                PluginSiteUtils.$$$reportNull$$$0(4);
            }
            if (separator == null) {
                PluginSiteUtils.$$$reportNull$$$0(5);
            }
            if ((end = str.indexOf(separator)) > 0 && end <= 170) {
                return str.substring(0, end + (separator.contains(":") ? 0 : separator.length())).trim();
            }
            return null;
        }

        @NotNull
        private static String stripTags(@NotNull String s) {
            if (s == null) {
                PluginSiteUtils.$$$reportNull$$$0(6);
            }
            String string = TAG_PATTERN.matcher(s).replaceAll("").trim();
            if (string == null) {
                PluginSiteUtils.$$$reportNull$$$0(7);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "s";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/plugins/PluginManagerConfigurableNew$PluginSiteUtils";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "str";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "separator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurableNew$PluginSiteUtils";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "prepareDescription";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "stripTags";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "prepareDescription";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 7: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "substringBy";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "stripTags";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyBgProgressIndicator
    extends AbstractProgressIndicatorExBase {
        public MyBgProgressIndicator() {
            this.setText("Downloading...");
            this.setIndeterminate(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeStateDelegate(@Nullable ProgressIndicatorEx delegate) {
            List stateDelegates = (List)ReflectionUtil.getField(AbstractProgressIndicatorExBase.class, (Object)this, List.class, (String)"myStateDelegates");
            MyBgProgressIndicator myBgProgressIndicator = this;
            synchronized (myBgProgressIndicator) {
                if (delegate == null) {
                    stateDelegates.clear();
                } else {
                    stateDelegates.remove(delegate);
                }
            }
        }
    }

    private static class MyProgressIndicator
    extends InlineProgressIndicator {
        private Runnable myCancelRunnable;

        public MyProgressIndicator() {
            super(true, MyProgressIndicator.task());
            this.myText.putClientProperty("NoFillPanelColorForDarcula", Boolean.TRUE);
            this.updateProgressNow();
            this.getComponent().setToolTipText(null);
        }

        public void setCancelRunnable(@NotNull Runnable runnable2) {
            if (runnable2 == null) {
                MyProgressIndicator.$$$reportNull$$$0(0);
            }
            this.myCancelRunnable = runnable2;
        }

        @Override
        protected void cancelRequest() {
            super.cancelRequest();
            this.myCancelRunnable.run();
        }

        @NotNull
        public JComponent createBaselineWrapper() {
            Wrapper wrapper2 = new Wrapper(this.getComponent()){

                public int getBaseline(int width, int height) {
                    return (int)((double)height * 0.85);
                }
            };
            if (wrapper2 == null) {
                MyProgressIndicator.$$$reportNull$$$0(1);
            }
            return wrapper2;
        }

        @NotNull
        private static TaskInfo task() {
            Task.Modal modal = new Task.Modal(null, "Downloading...", true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        2.$$$reportNull$$$0(0);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ide/plugins/PluginManagerConfigurableNew$MyProgressIndicator$2", "run"));
                }
            };
            if (modal == null) {
                MyProgressIndicator.$$$reportNull$$$0(2);
            }
            return modal;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runnable";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/plugins/PluginManagerConfigurableNew$MyProgressIndicator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurableNew$MyProgressIndicator";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createBaselineWrapper";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "task";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "setCancelRunnable";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyTwoLineProgressIndicator
    extends MyProgressIndicator {
        private MyTwoLineProgressIndicator() {
        }

        @Override
        protected void createCompactTextAndProgress() {
            NonOpaquePanel textWrapper = new NonOpaquePanel((LayoutManager)new BorderLayout());
            textWrapper.add((Component)this.myText, "Center");
            this.myText.recomputeSize();
            NonOpaquePanel progressWrapper = new NonOpaquePanel((LayoutManager)new BorderLayout());
            progressWrapper.setBorder((Border)JBUI.Borders.emptyRight((int)4));
            progressWrapper.add((Component)this.myProgress, (Object)"Center");
            JComponent component = this.getComponent();
            component.add((Component)textWrapper, "North");
            component.add((Component)progressWrapper, "Center");
        }
    }

    private static class InstallPluginInfo {
        public final MyBgProgressIndicator indicator;
        private final IdeaPluginDescriptor myDescriptor;
        private MyPluginModel myPluginModel;
        public final boolean install;
        private TaskInfo myStatusBarTaskInfo;

        public InstallPluginInfo(@NotNull IdeaPluginDescriptor descriptor2, @NotNull MyPluginModel pluginModel, boolean install) {
            if (descriptor2 == null) {
                InstallPluginInfo.$$$reportNull$$$0(0);
            }
            if (pluginModel == null) {
                InstallPluginInfo.$$$reportNull$$$0(1);
            }
            this.indicator = new MyBgProgressIndicator();
            this.myDescriptor = descriptor2;
            this.myPluginModel = pluginModel;
            this.install = install;
        }

        public synchronized void toBackground(@Nullable StatusBarEx statusBar) {
            this.myPluginModel = null;
            this.indicator.removeStateDelegate(null);
            if (statusBar != null) {
                this.myStatusBarTaskInfo = MyProgressIndicator.task();
                statusBar.addProgress(this.indicator, this.myStatusBarTaskInfo);
            }
        }

        public synchronized void fromBackground(@NotNull MyPluginModel pluginModel) {
            if (pluginModel == null) {
                InstallPluginInfo.$$$reportNull$$$0(2);
            }
            this.myPluginModel = pluginModel;
            this.closeStatusBarIndicator();
        }

        public synchronized void finish(boolean success2, boolean cancel) {
            if (this.myPluginModel == null) {
                MyPluginModel.finishInstall(this.myDescriptor);
                this.closeStatusBarIndicator();
            } else if (!cancel) {
                this.myPluginModel.finishInstall(this.myDescriptor, success2);
            }
        }

        private void closeStatusBarIndicator() {
            if (this.myStatusBarTaskInfo != null) {
                this.indicator.finish(this.myStatusBarTaskInfo);
                this.myStatusBarTaskInfo = null;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pluginModel";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurableNew$InstallPluginInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fromBackground";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyPluginModel
    extends InstalledPluginsTableModel
    implements PluginManagerMain.PluginEnabler {
        private final List<ListPluginComponent> myListComponents = new ArrayList<ListPluginComponent>();
        private final Map<IdeaPluginDescriptor, List<ListPluginComponent>> myListMap = new HashMap<IdeaPluginDescriptor, List<ListPluginComponent>>();
        private final Map<IdeaPluginDescriptor, List<GridCellPluginComponent>> myGridMap = new HashMap<IdeaPluginDescriptor, List<GridCellPluginComponent>>();
        private final List<PluginsGroup> myEnabledGroups = new ArrayList<PluginsGroup>();
        private PluginsGroupComponent myDownloadedPanel;
        private PluginsGroup myDownloaded;
        private PluginsGroup myInstalling;
        private PluginsGroup myUpdates;
        private Configurable.TopComponentController myTopController;
        private static final Set<IdeaPluginDescriptor> myInstallingPlugins = new HashSet<IdeaPluginDescriptor>();
        private static final Set<IdeaPluginDescriptor> myInstallingWithUpdatesPlugins = new HashSet<IdeaPluginDescriptor>();
        private static final Map<IdeaPluginDescriptor, InstallPluginInfo> myInstallingInfos = new HashMap<IdeaPluginDescriptor, InstallPluginInfo>();
        public boolean needRestart;
        public boolean createShutdownCallback = true;
        public DetailsPagePluginComponent detailPanel;
        private StatusBarEx myStatusBar;

        public MyPluginModel() {
            Window window = ProjectUtil.getActiveFrameOrWelcomeScreen();
            this.myStatusBar = MyPluginModel.getStatusBar(window);
            if (this.myStatusBar == null && window != null) {
                this.myStatusBar = MyPluginModel.getStatusBar(window.getOwner());
            }
        }

        @Nullable
        private static StatusBarEx getStatusBar(@Nullable Window frame) {
            if (frame instanceof IdeFrame && !(frame instanceof WelcomeFrame)) {
                return (StatusBarEx)((IdeFrame)frame).getStatusBar();
            }
            return null;
        }

        public void addComponent(@NotNull CellPluginComponent component) {
            if (component == null) {
                MyPluginModel.$$$reportNull$$$0(0);
            }
            if (component instanceof ListPluginComponent) {
                if (myInstallingPlugins.contains(component.myPlugin)) {
                    return;
                }
                this.myListComponents.add((ListPluginComponent)component);
                List<ListPluginComponent> components = this.myListMap.get(component.myPlugin);
                if (components == null) {
                    components = new ArrayList<ListPluginComponent>();
                    this.myListMap.put(component.myPlugin, components);
                }
                components.add((ListPluginComponent)component);
            } else {
                List<GridCellPluginComponent> components = this.myGridMap.get(component.myPlugin);
                if (components == null) {
                    components = new ArrayList<GridCellPluginComponent>();
                    this.myGridMap.put(component.myPlugin, components);
                }
                components.add((GridCellPluginComponent)component);
            }
        }

        public void removeComponent(@NotNull CellPluginComponent component) {
            if (component == null) {
                MyPluginModel.$$$reportNull$$$0(1);
            }
            if (component instanceof ListPluginComponent) {
                this.myListComponents.remove((ListPluginComponent)component);
                List<ListPluginComponent> components = this.myListMap.get(component.myPlugin);
                if (components != null) {
                    components.remove(component);
                    if (components.isEmpty()) {
                        this.myListMap.remove(component.myPlugin);
                    }
                }
            } else {
                List<GridCellPluginComponent> components = this.myGridMap.get(component.myPlugin);
                if (components != null) {
                    components.remove(component);
                    if (components.isEmpty()) {
                        this.myGridMap.remove(component.myPlugin);
                    }
                }
            }
        }

        public void setTopController(@NotNull Configurable.TopComponentController topController) {
            if (topController == null) {
                MyPluginModel.$$$reportNull$$$0(2);
            }
            this.myTopController = topController;
            for (InstallPluginInfo info : myInstallingInfos.values()) {
                info.fromBackground(this);
            }
            if (!myInstallingInfos.isEmpty()) {
                this.myTopController.showProgress(true);
            }
        }

        @NotNull
        public static Set<IdeaPluginDescriptor> getInstallingPlugins() {
            Set<IdeaPluginDescriptor> set2 = myInstallingPlugins;
            if (set2 == null) {
                MyPluginModel.$$$reportNull$$$0(3);
            }
            return set2;
        }

        public static boolean isInstallingOrUpdate(@NotNull IdeaPluginDescriptor descriptor2) {
            if (descriptor2 == null) {
                MyPluginModel.$$$reportNull$$$0(4);
            }
            return myInstallingWithUpdatesPlugins.contains(descriptor2);
        }

        public void installOrUpdatePlugin(@NotNull IdeaPluginDescriptor descriptor2, boolean install) {
            PluginNode pluginNode;
            if (descriptor2 == null) {
                MyPluginModel.$$$reportNull$$$0(5);
            }
            if (!PluginManagerMain.checkThirdPartyPluginsAllowed(Collections.singletonList(descriptor2))) {
                return;
            }
            if (descriptor2 instanceof PluginNode) {
                pluginNode = (PluginNode)descriptor2;
            } else {
                pluginNode = new PluginNode(descriptor2.getPluginId(), descriptor2.getName(), "-1");
                pluginNode.setDepends(Arrays.asList(descriptor2.getDependentPluginIds()), descriptor2.getOptionalDependentPluginIds());
                pluginNode.setRepositoryName("__unknown_repository__");
            }
            ArrayList pluginsToInstall = ContainerUtil.newArrayList((Object[])new PluginNode[]{pluginNode});
            PluginManagerMain.suggestToEnableInstalledDependantPlugins(this, pluginsToInstall);
            this.needRestart = true;
            MyPluginModel.installPlugin(pluginsToInstall, this.getAllPlugins(), this, this.prepareToInstall(descriptor2, install));
        }

        private static void installPlugin(@NotNull List<PluginNode> pluginsToInstall, @NotNull List<IdeaPluginDescriptor> allPlugins, @NotNull PluginManagerMain.PluginEnabler pluginEnabler, @NotNull InstallPluginInfo info) {
            if (pluginsToInstall == null) {
                MyPluginModel.$$$reportNull$$$0(6);
            }
            if (allPlugins == null) {
                MyPluginModel.$$$reportNull$$$0(7);
            }
            if (pluginEnabler == null) {
                MyPluginModel.$$$reportNull$$$0(8);
            }
            if (info == null) {
                MyPluginModel.$$$reportNull$$$0(9);
            }
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                if (pluginsToInstall == null) {
                    MyPluginModel.$$$reportNull$$$0(34);
                }
                if (allPlugins == null) {
                    MyPluginModel.$$$reportNull$$$0(35);
                }
                if (pluginEnabler == null) {
                    MyPluginModel.$$$reportNull$$$0(36);
                }
                if (info == null) {
                    MyPluginModel.$$$reportNull$$$0(37);
                }
                boolean cancel = false;
                boolean error = false;
                try {
                    error = !PluginInstaller.prepareToInstall(pluginsToInstall, allPlugins, pluginEnabler, info.indicator);
                }
                catch (ProcessCanceledException e) {
                    cancel = true;
                }
                catch (Throwable e) {
                    PluginManagerMain.LOG.error(e);
                    error = true;
                }
                boolean success2 = !error;
                boolean _cancel = cancel;
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (info == null) {
                        MyPluginModel.$$$reportNull$$$0(38);
                    }
                    info.finish(success2, _cancel);
                }, ModalityState.any());
            });
        }

        public void toBackground() {
            for (InstallPluginInfo info : myInstallingInfos.values()) {
                info.toBackground(this.myStatusBar);
            }
        }

        @NotNull
        private InstallPluginInfo prepareToInstall(@NotNull IdeaPluginDescriptor descriptor2, boolean install) {
            List<ListPluginComponent> listComponents;
            List<GridCellPluginComponent> gridComponents;
            if (descriptor2 == null) {
                MyPluginModel.$$$reportNull$$$0(10);
            }
            InstallPluginInfo info = new InstallPluginInfo(descriptor2, this, install);
            myInstallingInfos.put(descriptor2, info);
            if (myInstallingWithUpdatesPlugins.isEmpty()) {
                this.myTopController.showProgress(true);
            }
            myInstallingWithUpdatesPlugins.add(descriptor2);
            if (install) {
                myInstallingPlugins.add(descriptor2);
            }
            if (install && this.myInstalling != null) {
                if (this.myInstalling.ui == null) {
                    this.myInstalling.descriptors.add(descriptor2);
                    this.myDownloadedPanel.addGroup(this.myInstalling, 0);
                } else {
                    this.myDownloadedPanel.addToGroup(this.myInstalling, descriptor2);
                }
                this.myInstalling.titleWithCount();
                this.myDownloadedPanel.doLayout();
            }
            if ((gridComponents = this.myGridMap.get(descriptor2)) != null) {
                for (GridCellPluginComponent gridComponent : gridComponents) {
                    gridComponent.showProgress();
                }
            }
            if ((listComponents = this.myListMap.get(descriptor2)) != null) {
                for (ListPluginComponent listComponent : listComponents) {
                    listComponent.showProgress();
                }
            }
            if (this.detailPanel != null) {
                assert (this.detailPanel.myPlugin == descriptor2);
                this.detailPanel.showProgress();
            }
            InstallPluginInfo installPluginInfo = info;
            if (installPluginInfo == null) {
                MyPluginModel.$$$reportNull$$$0(11);
            }
            return installPluginInfo;
        }

        public void finishInstall(@NotNull IdeaPluginDescriptor descriptor2, boolean success2) {
            List<ListPluginComponent> listComponents;
            List<GridCellPluginComponent> gridComponents;
            if (descriptor2 == null) {
                MyPluginModel.$$$reportNull$$$0(12);
            }
            InstallPluginInfo info = MyPluginModel.finishInstall(descriptor2);
            if (myInstallingWithUpdatesPlugins.isEmpty()) {
                this.myTopController.showProgress(false);
            }
            if ((gridComponents = this.myGridMap.get(descriptor2)) != null) {
                for (GridCellPluginComponent gridCellPluginComponent : gridComponents) {
                    gridCellPluginComponent.hideProgress(success2);
                }
            }
            if ((listComponents = this.myListMap.get(descriptor2)) != null) {
                for (ListPluginComponent listComponent : listComponents) {
                    listComponent.hideProgress(success2);
                }
            }
            if (this.detailPanel != null) {
                assert (this.detailPanel.myPlugin == descriptor2);
                this.detailPanel.hideProgress(success2);
            }
            if (info.install) {
                if (this.myInstalling != null && this.myInstalling.ui != null) {
                    if (myInstallingPlugins.isEmpty()) {
                        this.myDownloadedPanel.removeGroup(this.myInstalling);
                    } else {
                        this.myDownloadedPanel.removeFromGroup(this.myInstalling, descriptor2);
                        this.myInstalling.titleWithCount();
                    }
                    this.myDownloadedPanel.doLayout();
                }
                if (success2) {
                    this.appendOrUpdateDescriptor(descriptor2);
                }
            } else if (success2) {
                PluginId pluginId;
                CellPluginComponent component;
                if (this.myDownloaded != null && this.myDownloaded.ui != null && (component = (CellPluginComponent)ContainerUtil.find(this.myDownloaded.ui.plugins, arg_0 -> MyPluginModel.lambda$finishInstall$2(pluginId = descriptor2.getPluginId(), arg_0))) != null) {
                    ((ListPluginComponent)component).changeUpdateToRestart();
                }
                if (this.myUpdates != null) {
                    this.myUpdates.titleWithCount();
                }
            }
            info.indicator.cancel();
            if (!success2) {
                Messages.showErrorDialog((String)("Plugin " + descriptor2.getName() + " download or installing failed"), (String)IdeBundle.message((String)"action.download.and.install.plugin", (Object[])new Object[0]));
            }
        }

        @NotNull
        public static InstallPluginInfo finishInstall(@NotNull IdeaPluginDescriptor descriptor2) {
            if (descriptor2 == null) {
                MyPluginModel.$$$reportNull$$$0(13);
            }
            InstallPluginInfo info = myInstallingInfos.remove(descriptor2);
            myInstallingWithUpdatesPlugins.remove(descriptor2);
            if (info.install) {
                myInstallingPlugins.remove(descriptor2);
            }
            InstallPluginInfo installPluginInfo = info;
            if (installPluginInfo == null) {
                MyPluginModel.$$$reportNull$$$0(14);
            }
            return installPluginInfo;
        }

        public void addProgress(@NotNull IdeaPluginDescriptor descriptor2, @NotNull ProgressIndicatorEx indicator) {
            if (descriptor2 == null) {
                MyPluginModel.$$$reportNull$$$0(15);
            }
            if (indicator == null) {
                MyPluginModel.$$$reportNull$$$0(16);
            }
            MyPluginModel.myInstallingInfos.get((Object)descriptor2).indicator.addStateDelegate(indicator);
        }

        public void removeProgress(@NotNull IdeaPluginDescriptor descriptor2, @NotNull ProgressIndicatorEx indicator) {
            if (descriptor2 == null) {
                MyPluginModel.$$$reportNull$$$0(17);
            }
            if (indicator == null) {
                MyPluginModel.$$$reportNull$$$0(18);
            }
            MyPluginModel.myInstallingInfos.get((Object)descriptor2).indicator.removeStateDelegate(indicator);
        }

        public void addEnabledGroup(@NotNull PluginsGroup group) {
            if (group == null) {
                MyPluginModel.$$$reportNull$$$0(19);
            }
            this.myEnabledGroups.add(group);
        }

        public void setDownloadedGroup(@NotNull PluginsGroupComponent panel2, @NotNull PluginsGroup downloaded, @NotNull PluginsGroup installing) {
            if (panel2 == null) {
                MyPluginModel.$$$reportNull$$$0(20);
            }
            if (downloaded == null) {
                MyPluginModel.$$$reportNull$$$0(21);
            }
            if (installing == null) {
                MyPluginModel.$$$reportNull$$$0(22);
            }
            this.myDownloadedPanel = panel2;
            this.myDownloaded = downloaded;
            this.myInstalling = installing;
        }

        public void setUpdateGroup(@NotNull PluginsGroup group) {
            if (group == null) {
                MyPluginModel.$$$reportNull$$$0(23);
            }
            this.myUpdates = group;
        }

        @Override
        public void appendOrUpdateDescriptor(@NotNull IdeaPluginDescriptor descriptor2) {
            if (descriptor2 == null) {
                MyPluginModel.$$$reportNull$$$0(24);
            }
            super.appendOrUpdateDescriptor(descriptor2);
            this.needRestart = true;
            if (this.myDownloaded == null) {
                return;
            }
            if (this.myDownloaded.ui == null) {
                this.myDownloaded.descriptors.add(descriptor2);
                this.myDownloaded.titleWithEnabled(this);
                this.myDownloadedPanel.addGroup(this.myDownloaded, this.myInstalling == null || this.myInstalling.ui == null ? 0 : 1);
                this.myDownloadedPanel.setSelection(this.myDownloaded.ui.plugins.get(0));
                this.myDownloadedPanel.doLayout();
                this.addEnabledGroup(this.myDownloaded);
            } else {
                this.myDownloadedPanel.addToGroup(this.myDownloaded, descriptor2);
                this.myDownloaded.titleWithEnabled(this);
                this.myDownloadedPanel.setSelection(this.myDownloaded.ui.plugins.get(this.myDownloaded.descriptors.indexOf(descriptor2)));
                this.myDownloadedPanel.doLayout();
            }
        }

        public boolean isEnabled(@NotNull IdeaPluginDescriptor plugin) {
            if (plugin == null) {
                MyPluginModel.$$$reportNull$$$0(25);
            }
            return this.isEnabled(plugin.getPluginId());
        }

        @NotNull
        public String getEnabledTitle(@NotNull IdeaPluginDescriptor plugin) {
            if (plugin == null) {
                MyPluginModel.$$$reportNull$$$0(26);
            }
            String string = this.isEnabled(plugin) ? "Disable" : "Enable";
            if (string == null) {
                MyPluginModel.$$$reportNull$$$0(27);
            }
            return string;
        }

        public void changeEnableDisable(@NotNull IdeaPluginDescriptor plugin) {
            if (plugin == null) {
                MyPluginModel.$$$reportNull$$$0(28);
            }
            this.enableRows(new IdeaPluginDescriptor[]{plugin}, !this.isEnabled(plugin.getPluginId()));
            this.updateAfterEnableDisable();
        }

        public void changeEnableDisable(@NotNull IdeaPluginDescriptor[] plugins2, boolean state2) {
            if (plugins2 == null) {
                MyPluginModel.$$$reportNull$$$0(29);
            }
            this.enableRows(plugins2, state2);
            this.updateAfterEnableDisable();
        }

        @Override
        public void enablePlugins(Set<IdeaPluginDescriptor> disabled) {
            this.changeEnableDisable(disabled.toArray(new IdeaPluginDescriptor[0]), true);
        }

        @Override
        public void disablePlugins(Set<IdeaPluginDescriptor> disabled) {
            this.changeEnableDisable(disabled.toArray(new IdeaPluginDescriptor[0]), false);
        }

        public void enableRequiredPlugins(@NotNull IdeaPluginDescriptor descriptor2) {
            Set<PluginId> requiredPluginIds;
            if (descriptor2 == null) {
                MyPluginModel.$$$reportNull$$$0(30);
            }
            if (ContainerUtil.isEmpty(requiredPluginIds = this.getRequiredPlugins(descriptor2.getPluginId()))) {
                return;
            }
            List<IdeaPluginDescriptor> allPlugins = this.getAllPlugins();
            HashSet<IdeaPluginDescriptor> requiredPlugins = new HashSet<IdeaPluginDescriptor>();
            for (PluginId pluginId : requiredPluginIds) {
                IdeaPluginDescriptor result2 = (IdeaPluginDescriptor)ContainerUtil.find(allPlugins, d -> pluginId.equals(d.getPluginId()));
                if (result2 == null && PluginManagerCore.isModuleDependency(pluginId) && (result2 = (IdeaPluginDescriptor)ContainerUtil.find(allPlugins, d -> {
                    if (d instanceof IdeaPluginDescriptorImpl) {
                        List<String> modules = ((IdeaPluginDescriptorImpl)d).getModules();
                        return modules != null && modules.contains(pluginId.getIdString());
                    }
                    return false;
                })) != null) {
                    this.getEnabledMap().put(pluginId, Boolean.TRUE);
                }
                if (result2 == null) continue;
                requiredPlugins.add(result2);
            }
            if (!requiredPlugins.isEmpty()) {
                this.enablePlugins(requiredPlugins);
            }
        }

        private void updateAfterEnableDisable() {
            for (ListPluginComponent component : this.myListComponents) {
                component.updateEnabledState();
            }
            for (PluginsGroup group : this.myEnabledGroups) {
                group.titleWithEnabled(this);
            }
        }

        public void doUninstall(@NotNull Component uiParent, @NotNull IdeaPluginDescriptor descriptor2, @Nullable Runnable update) {
            List<ListPluginComponent> listComponents;
            String title;
            String message;
            if (uiParent == null) {
                MyPluginModel.$$$reportNull$$$0(31);
            }
            if (descriptor2 == null) {
                MyPluginModel.$$$reportNull$$$0(32);
            }
            if (!this.dependent((IdeaPluginDescriptorImpl)descriptor2).isEmpty() && Messages.showYesNoDialog((Component)uiParent, (String)(message = IdeBundle.message((String)"several.plugins.depend.on.0.continue.to.remove", (Object[])new Object[]{descriptor2.getName()})), (String)(title = IdeBundle.message((String)"title.plugin.uninstall", (Object[])new Object[0])), (Icon)Messages.getQuestionIcon()) != 0) {
                return;
            }
            try {
                ((IdeaPluginDescriptorImpl)descriptor2).setDeleted(true);
                PluginInstaller.prepareToUninstall(descriptor2.getPluginId());
                this.needRestart |= descriptor2.isEnabled();
            }
            catch (IOException e) {
                PluginManagerMain.LOG.error((Throwable)e);
            }
            if (update != null) {
                update.run();
            }
            if ((listComponents = this.myListMap.get(descriptor2)) != null) {
                for (ListPluginComponent listComponent : listComponents) {
                    listComponent.updateAfterUninstall();
                }
            }
            for (ListPluginComponent component : this.myListComponents) {
                component.updateErrors();
            }
        }

        public boolean hasErrors(@NotNull IdeaPluginDescriptor plugin) {
            if (plugin == null) {
                MyPluginModel.$$$reportNull$$$0(33);
            }
            return PluginManagerCore.isIncompatible(plugin) || this.hasProblematicDependencies(plugin.getPluginId());
        }

        private static /* synthetic */ boolean lambda$finishInstall$2(PluginId pluginId, CellPluginComponent _component) {
            return pluginId.equals(_component.myPlugin.getPluginId());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 11: 
                case 14: 
                case 27: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 11: 
                case 14: 
                case 27: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "topController";
                    break;
                }
                case 3: 
                case 11: 
                case 14: 
                case 27: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/plugins/PluginManagerConfigurableNew$MyPluginModel";
                    break;
                }
                case 4: 
                case 5: 
                case 10: 
                case 12: 
                case 13: 
                case 15: 
                case 17: 
                case 24: 
                case 30: 
                case 32: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 6: 
                case 34: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pluginsToInstall";
                    break;
                }
                case 7: 
                case 35: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "allPlugins";
                    break;
                }
                case 8: 
                case 36: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pluginEnabler";
                    break;
                }
                case 9: 
                case 37: 
                case 38: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 16: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 19: 
                case 23: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "group";
                    break;
                }
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "panel";
                    break;
                }
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "downloaded";
                    break;
                }
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "installing";
                    break;
                }
                case 25: 
                case 26: 
                case 28: 
                case 33: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "plugin";
                    break;
                }
                case 29: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "plugins";
                    break;
                }
                case 31: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "uiParent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurableNew$MyPluginModel";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInstallingPlugins";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "prepareToInstall";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "finishInstall";
                    break;
                }
                case 27: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEnabledTitle";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addComponent";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "removeComponent";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setTopController";
                    break;
                }
                case 3: 
                case 11: 
                case 14: 
                case 27: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "isInstallingOrUpdate";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "installOrUpdatePlugin";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "installPlugin";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "prepareToInstall";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "finishInstall";
                    break;
                }
                case 15: 
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "addProgress";
                    break;
                }
                case 17: 
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "removeProgress";
                    break;
                }
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "addEnabledGroup";
                    break;
                }
                case 20: 
                case 21: 
                case 22: {
                    objectArray = objectArray;
                    objectArray[2] = "setDownloadedGroup";
                    break;
                }
                case 23: {
                    objectArray = objectArray;
                    objectArray[2] = "setUpdateGroup";
                    break;
                }
                case 24: {
                    objectArray = objectArray;
                    objectArray[2] = "appendOrUpdateDescriptor";
                    break;
                }
                case 25: {
                    objectArray = objectArray;
                    objectArray[2] = "isEnabled";
                    break;
                }
                case 26: {
                    objectArray = objectArray;
                    objectArray[2] = "getEnabledTitle";
                    break;
                }
                case 28: 
                case 29: {
                    objectArray = objectArray;
                    objectArray[2] = "changeEnableDisable";
                    break;
                }
                case 30: {
                    objectArray = objectArray;
                    objectArray[2] = "enableRequiredPlugins";
                    break;
                }
                case 31: 
                case 32: {
                    objectArray = objectArray;
                    objectArray[2] = "doUninstall";
                    break;
                }
                case 33: {
                    objectArray = objectArray;
                    objectArray[2] = "hasErrors";
                    break;
                }
                case 34: 
                case 35: 
                case 36: 
                case 37: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$installPlugin$1";
                    break;
                }
                case 38: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$null$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 11: 
                case 14: 
                case 27: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ColorButton
    extends JButton {
        public ColorButton() {
            this.setOpaque(false);
        }

        protected final void setTextColor(@NotNull Color color) {
            if (color == null) {
                ColorButton.$$$reportNull$$$0(0);
            }
            this.putClientProperty("JButton.textColor", color);
        }

        protected final void setFocusedTextColor(@NotNull Color color) {
            if (color == null) {
                ColorButton.$$$reportNull$$$0(1);
            }
            this.putClientProperty("JButton.focusedTextColor", color);
        }

        protected final void setBgColor(@NotNull Color color) {
            if (color == null) {
                ColorButton.$$$reportNull$$$0(2);
            }
            this.putClientProperty("JButton.backgroundColor", color);
        }

        protected final void setFocusedBgColor(@NotNull Color color) {
            if (color == null) {
                ColorButton.$$$reportNull$$$0(3);
            }
            this.putClientProperty("JButton.focusedBackgroundColor", color);
        }

        protected final void setBorderColor(@NotNull Color color) {
            if (color == null) {
                ColorButton.$$$reportNull$$$0(4);
            }
            this.putClientProperty("JButton.borderColor", color);
        }

        protected final void setFocusedBorderColor(@NotNull Color color) {
            if (color == null) {
                ColorButton.$$$reportNull$$$0(5);
            }
            this.putClientProperty("JButton.focusedBorderColor", color);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "color";
            objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurableNew$ColorButton";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setTextColor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setFocusedTextColor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setBgColor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setFocusedBgColor";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setBorderColor";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setFocusedBorderColor";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class InstallButton
    extends ColorButton {
        public InstallButton(boolean fill) {
            if (fill) {
                this.setTextColor(WhiteForeground);
                this.setBgColor(GreenColor);
            } else {
                this.setTextColor(GreenColor);
                this.setFocusedTextColor(GreenColor);
                this.setBgColor(WhiteBackground);
            }
            this.setFocusedBgColor(GreenFocusedBackground);
            this.setBorderColor(GreenColor);
            this.setFocusedBorderColor(GreenColor);
            this.setTextAndSize();
        }

        protected void setTextAndSize() {
            this.setText("Install");
            PluginManagerConfigurableNew.setWidth72(this);
        }
    }

    private static class RestartButton
    extends InstallButton {
        public RestartButton(@NotNull MyPluginModel pluginModel) {
            if (pluginModel == null) {
                RestartButton.$$$reportNull$$$0(0);
            }
            super(true);
            this.addActionListener(e -> {
                if (pluginModel == null) {
                    RestartButton.$$$reportNull$$$0(1);
                }
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> {
                    if (pluginModel == null) {
                        RestartButton.$$$reportNull$$$0(2);
                    }
                    pluginModel.needRestart = true;
                    pluginModel.createShutdownCallback = false;
                    DialogWrapper settings = DialogWrapper.findInstance((Component)IdeFocusManager.findInstance().getFocusOwner());
                    assert (settings instanceof SettingsDialog) : settings;
                    ((SettingsDialog)settings).doOKAction();
                    ((ApplicationImpl)ApplicationManager.getApplication()).exit(true, false, true);
                }, ModalityState.current());
            });
        }

        @Override
        protected void setTextAndSize() {
            this.setText("Restart IDE");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "pluginModel";
            objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurableNew$RestartButton";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$new$1";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$null$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class UpdateButton
    extends ColorButton {
        public UpdateButton() {
            this.setTextColor(WhiteForeground);
            this.setBgColor(BlueColor);
            this.setBorderColor(BlueColor);
            this.setText("Update");
            PluginManagerConfigurableNew.setWidth72(this);
        }
    }

    private static class VerticalLayout
    extends AbstractLayoutManager {
        public static final String FILL_HORIZONTAL = "fill_h";
        private final int myOffset;
        private final int myWidth;
        private final Set<Component> myFillComponents = new HashSet<Component>();
        private final Map<Component, Integer> myMaxComponents = new HashMap<Component, Integer>();

        public VerticalLayout(int offset) {
            this(offset, 0);
        }

        public VerticalLayout(int offset, int width) {
            this.myOffset = offset;
            this.myWidth = width;
        }

        public void addLayoutComponent(Component component, Object constraints) {
            if (FILL_HORIZONTAL.equals(constraints)) {
                this.myFillComponents.add(component);
            } else if (constraints instanceof Integer) {
                this.myMaxComponents.put(component, (Integer)constraints);
            }
        }

        public void removeLayoutComponent(Component component) {
            this.myFillComponents.remove(component);
        }

        public Dimension preferredLayoutSize(Container parent) {
            int width = 0;
            int height = 0;
            int count = parent.getComponentCount();
            for (int i = 0; i < count; ++i) {
                Dimension size = parent.getComponent(i).getPreferredSize();
                width = Math.max(width, size.width);
                height += size.height;
            }
            Dimension size = new Dimension(this.myWidth > 0 ? this.myWidth : width, height += (count - 1) * this.myOffset);
            JBInsets.addTo((Dimension)size, (Insets)parent.getInsets());
            return size;
        }

        public void layoutContainer(Container parent) {
            Insets insets = parent.getInsets();
            int width = parent.getWidth() - insets.left - insets.right;
            int y = insets.top;
            int count = parent.getComponentCount();
            for (int i = 0; i < count; ++i) {
                int componentWidth;
                Component component = parent.getComponent(i);
                Dimension size = component.getPreferredSize();
                if (this.myFillComponents.contains(component)) {
                    componentWidth = width;
                } else {
                    componentWidth = Math.min(width, size.width);
                    Integer maxWidth = this.myMaxComponents.get(component);
                    if (maxWidth != null) {
                        componentWidth = Math.min(componentWidth, maxWidth);
                    }
                }
                component.setBounds(insets.left, y, componentWidth, size.height);
                y += size.height + this.myOffset;
            }
        }
    }

    private static class HorizontalLayout
    extends AbstractLayoutManager {
        protected final int myOffset;

        public HorizontalLayout(int offset) {
            this.myOffset = offset;
        }

        public Dimension preferredLayoutSize(Container parent) {
            int width = 0;
            int height = 0;
            int count = parent.getComponentCount();
            for (int i = 0; i < count; ++i) {
                Dimension size = parent.getComponent(i).getPreferredSize();
                width += size.width;
                height = Math.max(height, size.height);
            }
            Dimension size = new Dimension(width += (count - 1) * this.myOffset, height);
            JBInsets.addTo((Dimension)size, (Insets)parent.getInsets());
            return size;
        }

        public void layoutContainer(Container parent) {
            Insets insets = parent.getInsets();
            int height = parent.getHeight() - insets.top - insets.bottom;
            int x = insets.left;
            int count = parent.getComponentCount();
            for (int i = 0; i < count; ++i) {
                Component component = parent.getComponent(i);
                Dimension size = component.getPreferredSize();
                component.setBounds(x, insets.top + (height - size.height) / 2, size.width, size.height);
                x += size.width + this.myOffset;
            }
        }
    }

    private static class MyOptionButton
    extends JBOptionButton {
        public MyOptionButton(Action action, Action option) {
            super(action, new Action[]{option});
            PluginManagerConfigurableNew.setWidth72((JButton)((Object)this));
        }

        public void setBackground(Color bg) {
            super.setBackground(bg);
            int count = this.getComponentCount();
            for (int i = 0; i < count; ++i) {
                this.getComponent(i).setBackground(bg);
            }
        }

        public int getBaseline(int width, int height) {
            if (this.getComponentCount() == 2) {
                Component component = this.getComponent(0);
                Dimension size = component.getPreferredSize();
                return component.getBaseline(size.width, size.height);
            }
            return super.getBaseline(width, height);
        }
    }

    private static interface TagBuilder {
        @NotNull
        public TagComponent createTagComponent(@NotNull String var1);
    }

    private static class TagComponent
    extends LinkComponent {
        private final Color myColor;

        public TagComponent(@NotNull String name, @Nullable String tooltip, @NotNull Color color) {
            if (name == null) {
                TagComponent.$$$reportNull$$$0(0);
            }
            if (color == null) {
                TagComponent.$$$reportNull$$$0(1);
            }
            this.myColor = color;
            this.setText(name);
            if (tooltip != null) {
                this.setToolTipText(tooltip);
            }
            this.setForeground((Color)new JBColor(0x787878, 0x999999));
            this.setPaintUnderline(false);
            this.setOpaque(false);
            this.setBorder((Border)JBUI.Borders.empty((int)1, (int)8));
        }

        protected void paintComponent(Graphics g) {
            g.setColor(this.myUnderline ? new Color(this.myColor.getRed(), this.myColor.getGreen(), this.myColor.getBlue(), 178) : this.myColor);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            super.paintComponent(g);
        }

        protected boolean isInClickableArea(Point pt) {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "color";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ide/plugins/PluginManagerConfigurableNew$TagComponent";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class LinkComponent
    extends LinkLabel {
        public LinkComponent() {
            super("", null);
        }

        protected Color getTextColor() {
            return this.getForeground();
        }
    }

    private class DetailsPagePluginComponent
    extends OpaquePanel {
        private final IdeaPluginDescriptor myPlugin;
        private JLabel myNameComponent;
        private JLabel myIconLabel;
        private JButton myUpdateButton;
        private JButton myInstallButton;
        private JButton myEnableDisableButton;
        private RestartButton myRestartButton;
        private JBOptionButton myEnableDisableUninstallButton;
        private JPanel myButtonsPanel;
        private final JPanel myCenterPanel;
        private MyProgressIndicator myIndicator;
        public int backTabIndex;

        public DetailsPagePluginComponent(IdeaPluginDescriptor plugin, boolean update) {
            if (plugin == null) {
                DetailsPagePluginComponent.$$$reportNull$$$0(0);
            }
            super((LayoutManager)new BorderLayout(0, JBUI.scale((int)32)), MAIN_BG_COLOR);
            this.myPlugin = plugin;
            this.setBorder((Border)JBUI.Borders.empty((int)15, (int)20, (int)0, (int)0));
            JPanel header = this.createHeaderPanel();
            this.myCenterPanel = this.createCenterPanel(update);
            header.add(this.myCenterPanel);
            this.createTagPanel();
            this.createMetricsPanel();
            this.createErrorPanel();
            this.createProgressPanel(!update);
            this.createBottomPanel();
        }

        @NotNull
        private JPanel createCenterPanel(boolean update) {
            String version;
            NonOpaquePanel centerPanel = new NonOpaquePanel((LayoutManager)((Object)new VerticalLayout(PluginManagerConfigurableNew.offset5())));
            NonOpaquePanel nameButtons = new NonOpaquePanel((LayoutManager)new BorderLayout(PluginManagerConfigurableNew.offset5(), 0));
            this.myNameComponent = new JLabel(this.myPlugin.getName());
            this.myNameComponent.setOpaque(false);
            Font font = this.myNameComponent.getFont();
            if (font != null) {
                this.myNameComponent.setFont(font.deriveFont(1, 30.0f));
            }
            if (!(this.myPlugin instanceof PluginNode) && !PluginManagerConfigurableNew.this.myPluginsModel.isEnabled(this.myPlugin)) {
                this.myNameComponent.setForeground(DisabledColor);
            }
            nameButtons.add((Component)this.myNameComponent, "West");
            this.myButtonsPanel = this.createButtons(update);
            nameButtons.add((Component)this.myButtonsPanel, "East");
            centerPanel.add((Component)nameButtons, "fill_h");
            boolean bundled = this.myPlugin.isBundled();
            String string = version = bundled ? "bundled" : this.myPlugin.getVersion();
            if (!StringUtil.isEmptyOrSpaces((String)version)) {
                if (!bundled) {
                    version = "v" + version;
                }
                JLabel versionComponent = new JLabel(version);
                versionComponent.setOpaque(false);
                versionComponent.setForeground((Color)new JBColor((Color)Gray._130, (Color)Gray._120));
                nameButtons.add(versionComponent);
                int nameBaseline = this.myNameComponent.getBaseline(this.myNameComponent.getWidth(), this.myNameComponent.getHeight());
                int versionBaseline = versionComponent.getBaseline(versionComponent.getWidth(), versionComponent.getHeight());
                versionComponent.setBorder((Border)JBUI.Borders.empty((int)(nameBaseline - versionBaseline + 6), (int)4, (int)0, (int)0));
            }
            NonOpaquePanel nonOpaquePanel = centerPanel;
            if (nonOpaquePanel == null) {
                DetailsPagePluginComponent.$$$reportNull$$$0(1);
            }
            return nonOpaquePanel;
        }

        @NotNull
        private JPanel createButtons(boolean update) {
            NonOpaquePanel buttons = new NonOpaquePanel((LayoutManager)((Object)new HorizontalLayout(JBUI.scale((int)6))));
            buttons.setBorder((Border)JBUI.Borders.emptyTop((int)1));
            InstalledPluginsState pluginsState = InstalledPluginsState.getInstance();
            PluginId id = this.myPlugin.getPluginId();
            if (this.myPlugin instanceof IdeaPluginDescriptorImpl && ((IdeaPluginDescriptorImpl)this.myPlugin).isDeleted() || pluginsState.wasInstalled(id) || pluginsState.wasUpdated(id)) {
                this.myRestartButton = new RestartButton(PluginManagerConfigurableNew.this.myPluginsModel);
                buttons.add(this.myRestartButton);
            } else {
                boolean stateActions = true;
                if (update) {
                    this.myUpdateButton = new UpdateButton();
                    buttons.add(this.myUpdateButton);
                } else if (this.myPlugin instanceof PluginNode) {
                    this.myInstallButton = new InstallButton(true);
                    buttons.add(this.myInstallButton);
                    this.myInstallButton.setEnabled(PluginManager.getPlugin(this.myPlugin.getPluginId()) == null);
                    stateActions = false;
                }
                if (stateActions) {
                    if (this.myPlugin.isBundled()) {
                        this.myEnableDisableButton = new JButton(PluginManagerConfigurableNew.this.myPluginsModel.getEnabledTitle(this.myPlugin));
                        this.myEnableDisableButton.addActionListener(e -> this.changeEnableDisable());
                        PluginManagerConfigurableNew.setWidth72(this.myEnableDisableButton);
                        buttons.add(this.myEnableDisableButton);
                    } else {
                        AbstractAction enableDisableAction = new AbstractAction(PluginManagerConfigurableNew.this.myPluginsModel.getEnabledTitle(this.myPlugin)){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                DetailsPagePluginComponent.this.changeEnableDisable();
                            }
                        };
                        AbstractAction uninstallAction = new AbstractAction("Uninstall"){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                DetailsPagePluginComponent.this.doUninstall();
                            }
                        };
                        this.myEnableDisableUninstallButton = new MyOptionButton(enableDisableAction, uninstallAction);
                        buttons.add((Component)this.myEnableDisableUninstallButton);
                    }
                }
            }
            for (Component component : UIUtil.uiChildren((Component)buttons)) {
                component.setBackground(MAIN_BG_COLOR);
            }
            NonOpaquePanel nonOpaquePanel = buttons;
            if (nonOpaquePanel == null) {
                DetailsPagePluginComponent.$$$reportNull$$$0(2);
            }
            return nonOpaquePanel;
        }

        @NotNull
        private JPanel createHeaderPanel() {
            NonOpaquePanel header = new NonOpaquePanel((LayoutManager)new BorderLayout(JBUI.scale((int)20), 0));
            header.setBorder((Border)JBUI.Borders.emptyRight((int)20));
            this.add((Component)header, "North");
            this.myIconLabel = new JLabel();
            this.updateIcon();
            this.myIconLabel.setVerticalAlignment(1);
            this.myIconLabel.setOpaque(false);
            this.myIconLabel.setEnabled(this.myPlugin instanceof PluginNode || PluginManagerConfigurableNew.this.myPluginsModel.isEnabled(this.myPlugin));
            header.add((Component)this.myIconLabel, "West");
            NonOpaquePanel nonOpaquePanel = header;
            if (nonOpaquePanel == null) {
                DetailsPagePluginComponent.$$$reportNull$$$0(3);
            }
            return nonOpaquePanel;
        }

        private void updateIcon() {
            boolean jb = PluginManagerConfigurableNew.isJBPlugin(this.myPlugin);
            boolean errors = PluginManagerConfigurableNew.this.myPluginsModel.hasErrors(this.myPlugin);
            this.myIconLabel.setIcon(PluginLogoInfo.getIcon(true, jb, errors, false));
            this.myIconLabel.setDisabledIcon(PluginLogoInfo.getIcon(true, jb, errors, true));
        }

        private void createTagPanel() {
            List tags = PluginManagerConfigurableNew.getTags(this.myPlugin);
            if (!tags.isEmpty()) {
                NonOpaquePanel tagPanel = new NonOpaquePanel((LayoutManager)((Object)new HorizontalLayout(JBUI.scale((int)6))));
                tagPanel.setBorder((Border)JBUI.Borders.emptyTop((int)2));
                this.myCenterPanel.add((Component)tagPanel);
                for (String tag : tags) {
                    TagComponent component = PluginManagerConfigurableNew.this.myTagBuilder.createTagComponent(tag);
                    component.setListener(PluginManagerConfigurableNew.this.mySearchListener, "tag:" + tag);
                    tagPanel.add((Component)((Object)component));
                }
            }
        }

        private void createMetricsPanel() {
            if (!(this.myPlugin instanceof PluginNode)) {
                return;
            }
            JBColor grayedFg = new JBColor((Color)Gray._130, (Color)Gray._120);
            String downloads = PluginManagerConfigurableNew.getDownloads(this.myPlugin);
            String date = PluginManagerConfigurableNew.getLastUpdatedDate(this.myPlugin);
            String rating = PluginManagerConfigurableNew.getRating(this.myPlugin);
            if (downloads != null || date != null || rating != null) {
                NonOpaquePanel metrics = new NonOpaquePanel((LayoutManager)((Object)new HorizontalLayout(JBUI.scale((int)20))));
                metrics.setBorder((Border)JBUI.Borders.emptyTop((int)3));
                this.myCenterPanel.add((Component)metrics);
                if (date != null) {
                    JLabel lastUpdated = new JLabel(date, AllIcons.Plugins.Updated, 0);
                    lastUpdated.setOpaque(false);
                    lastUpdated.setForeground((Color)grayedFg);
                    metrics.add(PluginManagerConfigurableNew.installTiny(lastUpdated));
                }
                if (downloads != null) {
                    JLabel downloadsComponent = new JLabel(downloads, AllIcons.Plugins.Downloads, 0);
                    downloadsComponent.setOpaque(false);
                    downloadsComponent.setForeground((Color)grayedFg);
                    metrics.add(PluginManagerConfigurableNew.installTiny(downloadsComponent));
                }
                if (rating != null) {
                    RatesPanel ratesPanel = new RatesPanel();
                    ratesPanel.setRate(rating);
                    metrics.add(PluginManagerConfigurableNew.installTiny(ratesPanel));
                }
            }
        }

        private void createErrorPanel() {
            if (PluginManagerConfigurableNew.this.myPluginsModel.hasErrors(this.myPlugin)) {
                NonOpaquePanel errorPanel = new NonOpaquePanel((LayoutManager)((Object)new HorizontalLayout(JBUI.scale((int)8))));
                errorPanel.setBorder((Border)JBUI.Borders.emptyTop((int)15));
                this.myCenterPanel.add((Component)errorPanel);
                JLabel errorMessage = new JLabel();
                errorMessage.setForeground((Color)JBColor.red);
                errorMessage.setOpaque(false);
                errorPanel.add(errorMessage);
                Ref enableAction = new Ref();
                errorMessage.setText(PluginManagerConfigurableNew.getErrorMessage(PluginManagerConfigurableNew.this.myPluginsModel, (PluginDescriptor)this.myPlugin, (Ref<Boolean>)enableAction));
                if (!enableAction.isNull()) {
                    LinkLabel errorAction = new LinkLabel("Enable", null);
                    errorAction.setOpaque(false);
                    errorPanel.add((Component)errorAction);
                    errorAction.setListener((arg_0, arg_1) -> this.lambda$createErrorPanel$1((JPanel)errorPanel, arg_0, arg_1), null);
                }
            }
        }

        private void createProgressPanel(boolean install) {
            JButton button;
            JButton jButton = button = this.myInstallButton == null ? this.myUpdateButton : this.myInstallButton;
            if (button == null) {
                return;
            }
            button.addActionListener(e -> PluginManagerConfigurableNew.this.myPluginsModel.installOrUpdatePlugin(this.myPlugin, install));
            if (MyPluginModel.isInstallingOrUpdate(this.myPlugin)) {
                this.showProgress(false);
            }
        }

        public void showProgress() {
            this.showProgress(true);
        }

        private void showProgress(boolean repaint) {
            this.myIndicator = new MyProgressIndicator();
            this.myIndicator.setCancelRunnable(() -> PluginManagerConfigurableNew.this.myPluginsModel.finishInstall(this.myPlugin, false));
            this.myButtonsPanel.remove(this.myInstallButton == null ? this.myUpdateButton : this.myInstallButton);
            if (this.myEnableDisableButton != null) {
                this.myButtonsPanel.remove(this.myEnableDisableButton);
            }
            if (this.myEnableDisableUninstallButton != null) {
                this.myButtonsPanel.remove((Component)this.myEnableDisableUninstallButton);
            }
            this.myButtonsPanel.doLayout();
            this.myCenterPanel.add(this.myIndicator.getComponent());
            PluginManagerConfigurableNew.this.myPluginsModel.addProgress(this.myPlugin, this.myIndicator);
            if (repaint) {
                this.doLayout();
                this.revalidate();
                this.repaint();
            }
        }

        public void hideProgress(boolean success2) {
            this.myCenterPanel.remove(this.myIndicator.getComponent());
            this.myIndicator = null;
            if (success2) {
                this.changeInstallOrUpdateToRestart();
            } else {
                this.myButtonsPanel.add(this.myInstallButton == null ? this.myUpdateButton : this.myInstallButton);
                if (this.myEnableDisableButton != null) {
                    this.myButtonsPanel.add(this.myEnableDisableButton);
                }
                if (this.myEnableDisableUninstallButton != null) {
                    this.myButtonsPanel.add((Component)this.myEnableDisableUninstallButton);
                }
                this.doLayout();
                this.revalidate();
                this.repaint();
            }
        }

        public void close() {
            if (this.myIndicator != null) {
                PluginManagerConfigurableNew.this.myPluginsModel.removeProgress(this.myPlugin, this.myIndicator);
                this.myIndicator = null;
            }
        }

        private void createBottomPanel() {
            String size;
            String description = this.getDescriptionAndChangeNotes();
            String vendor = this.myPlugin.isBundled() ? null : this.myPlugin.getVendor();
            String string = size = this.myPlugin instanceof PluginNode ? ((PluginNode)this.myPlugin).getSize() : null;
            if (!(StringUtil.isEmptyOrSpaces((String)description) && StringUtil.isEmptyOrSpaces((String)vendor) && StringUtil.isEmptyOrSpaces((String)size))) {
                OpaquePanel bottomPanel = new OpaquePanel((LayoutManager)((Object)new VerticalLayout(PluginManagerConfigurableNew.offset5())), MAIN_BG_COLOR);
                bottomPanel.setBorder((Border)JBUI.Borders.emptyBottom((int)15));
                JBScrollPane scrollPane = new JBScrollPane((Component)bottomPanel);
                scrollPane.getVerticalScrollBar().setBackground(MAIN_BG_COLOR);
                scrollPane.setHorizontalScrollBarPolicy(31);
                scrollPane.setBorder(null);
                this.add((Component)scrollPane);
                if (!StringUtil.isEmptyOrSpaces((String)description)) {
                    JEditorPane descriptionComponent = new JEditorPane();
                    descriptionComponent.setEditorKit(UIUtil.getHTMLEditorKit());
                    descriptionComponent.setEditable(false);
                    descriptionComponent.setFocusable(false);
                    descriptionComponent.setOpaque(false);
                    descriptionComponent.setBorder(null);
                    descriptionComponent.setText(XmlStringUtil.wrapInHtml((CharSequence)description));
                    if (descriptionComponent.getCaret() != null) {
                        descriptionComponent.setCaretPosition(0);
                    }
                    bottomPanel.add(descriptionComponent, JBUI.scale((int)700), -1);
                }
                if (!StringUtil.isEmptyOrSpaces((String)vendor) || !StringUtil.isEmptyOrSpaces((String)size)) {
                    ArrayList labels = new ArrayList();
                    if (!StringUtil.isEmptyOrSpaces((String)vendor)) {
                        JPanel linePanel = PluginManagerConfigurableNew.createLabelsPanel((JPanel)bottomPanel, labels, "Vendor:", vendor, this.myPlugin.getVendorUrl());
                        linePanel.setBorder((Border)JBUI.Borders.emptyTop((int)20));
                    }
                    if (!StringUtil.isEmptyOrSpaces((String)size)) {
                        PluginManagerConfigurableNew.createLabelsPanel((JPanel)bottomPanel, labels, "Size:", PluginManagerColumnInfo.getFormattedSize(size), null);
                    }
                    if (labels.size() > 1) {
                        int width = 0;
                        for (JLabel label2 : labels) {
                            width = Math.max(width, label2.getPreferredSize().width);
                        }
                        for (JLabel label2 : labels) {
                            label2.setPreferredSize(new Dimension(width, label2.getPreferredSize().height));
                        }
                    }
                }
            }
        }

        @Nullable
        private String getDescriptionAndChangeNotes() {
            String notes;
            StringBuilder result2 = new StringBuilder();
            String description = this.myPlugin.getDescription();
            if (!StringUtil.isEmptyOrSpaces((String)description)) {
                result2.append(description);
            }
            if (!StringUtil.isEmptyOrSpaces((String)(notes = this.myPlugin.getChangeNotes()))) {
                result2.append("<h4>Change Notes</h4>").append(notes);
            }
            return result2.length() > 0 ? result2.toString() : null;
        }

        private void changeEnableDisable() {
            PluginManagerConfigurableNew.this.myPluginsModel.changeEnableDisable(this.myPlugin);
            this.updateEnabledState();
        }

        private void updateEnabledState() {
            if (!(this.myPlugin instanceof PluginNode)) {
                boolean enabled = PluginManagerConfigurableNew.this.myPluginsModel.isEnabled(this.myPlugin);
                this.myNameComponent.setForeground(enabled ? null : DisabledColor);
                this.myIconLabel.setEnabled(enabled);
            }
            String title = PluginManagerConfigurableNew.this.myPluginsModel.getEnabledTitle(this.myPlugin);
            if (this.myEnableDisableButton != null) {
                this.myEnableDisableButton.setText(title);
            }
            if (this.myEnableDisableUninstallButton != null) {
                this.myEnableDisableUninstallButton.setText(title);
            }
        }

        private void doUninstall() {
            PluginManagerConfigurableNew.this.myPluginsModel.doUninstall((Component)((Object)this), this.myPlugin, this::changeInstallOrUpdateToRestart);
        }

        private void changeInstallOrUpdateToRestart() {
            if (this.myEnableDisableUninstallButton != null) {
                this.myButtonsPanel.remove((Component)this.myEnableDisableUninstallButton);
                this.myEnableDisableUninstallButton = null;
            }
            if (this.myUpdateButton != null) {
                this.myButtonsPanel.remove(this.myUpdateButton);
                this.myUpdateButton = null;
            }
            if (this.myInstallButton != null) {
                this.myButtonsPanel.remove(this.myInstallButton);
                this.myInstallButton = null;
            }
            if (this.myRestartButton == null) {
                this.myRestartButton = new RestartButton(PluginManagerConfigurableNew.this.myPluginsModel);
                this.myButtonsPanel.add(this.myRestartButton);
            }
            this.doLayout();
            this.revalidate();
            this.repaint();
        }

        private /* synthetic */ void lambda$createErrorPanel$1(JPanel errorPanel, LinkLabel aSource, Object aLinkData) {
            PluginManagerConfigurableNew.this.myPluginsModel.enableRequiredPlugins(this.myPlugin);
            this.myCenterPanel.remove(errorPanel);
            this.createErrorPanel();
            this.myCenterPanel.doLayout();
            this.updateIcon();
            this.updateEnabledState();
            this.doLayout();
            this.revalidate();
            this.repaint();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "plugin";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/plugins/PluginManagerConfigurableNew$DetailsPagePluginComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurableNew$DetailsPagePluginComponent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createCenterPanel";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createButtons";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createHeaderPanel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static enum SelectionType {
        SELECTION,
        HOVER,
        NONE;

    }

    private static class GridCellPluginComponent
    extends CellPluginComponent {
        private final MyPluginModel myPluginModel;
        private JLabel myLastUpdated;
        private JLabel myDownloads;
        private JLabel myRating;
        private final JButton myInstallButton;
        private JComponent myLastComponent;
        private List<TagComponent> myTagComponents;
        private ProgressIndicatorEx myIndicator;

        public GridCellPluginComponent(@NotNull MyPluginModel pluginsModel, @NotNull IdeaPluginDescriptor plugin, @NotNull TagBuilder tagBuilder) {
            if (pluginsModel == null) {
                GridCellPluginComponent.$$$reportNull$$$0(0);
            }
            if (plugin == null) {
                GridCellPluginComponent.$$$reportNull$$$0(1);
            }
            if (tagBuilder == null) {
                GridCellPluginComponent.$$$reportNull$$$0(2);
            }
            super(plugin);
            this.myInstallButton = new InstallButton(false);
            this.myPluginModel = pluginsModel;
            pluginsModel.addComponent(this);
            NonOpaquePanel container = new NonOpaquePanel((LayoutManager)new BorderLayout(JBUI.scale((int)10), 0));
            this.add((Component)container);
            this.addIconComponent((JPanel)container, "West");
            NonOpaquePanel centerPanel = new NonOpaquePanel((LayoutManager)((Object)new VerticalLayout(PluginManagerConfigurableNew.offset5(), JBUI.scale((int)180))));
            container.add((Component)centerPanel);
            this.addNameComponent((JPanel)centerPanel);
            this.addTags((JPanel)centerPanel, tagBuilder);
            this.addDescriptionComponent((JPanel)centerPanel, PluginManagerConfigurableNew.getShortDescription(this.myPlugin, false), new LineFunction(3, true));
            this.createMetricsPanel((JPanel)centerPanel);
            this.addInstallButton();
            this.setOpaque(true);
            this.setBorder(JBUI.Borders.empty((int)10));
            this.setLayout((LayoutManager)new AbstractLayoutManager((JPanel)container, (JPanel)centerPanel){
                final /* synthetic */ JPanel val$container;
                final /* synthetic */ JPanel val$centerPanel;
                {
                    this.val$container = jPanel;
                    this.val$centerPanel = jPanel2;
                }

                public Dimension preferredLayoutSize(Container parent) {
                    Dimension size = this.val$container.getPreferredSize();
                    size.height += PluginManagerConfigurableNew.offset5();
                    size.height += ((GridCellPluginComponent)this).myLastComponent.getPreferredSize().height;
                    JBInsets.addTo((Dimension)size, (Insets)parent.getInsets());
                    return size;
                }

                public void layoutContainer(Container parent) {
                    Insets insets = parent.getInsets();
                    Dimension size = this.val$container.getPreferredSize();
                    Rectangle bounds = new Rectangle(insets.left, insets.top, size.width, size.height);
                    this.val$container.setBounds(bounds);
                    this.val$container.doLayout();
                    Point location = this.val$centerPanel.getLocation();
                    Dimension buttonSize = myLastComponent.getPreferredSize();
                    Border border = myLastComponent.getBorder();
                    int borderOffset = border == null ? 0 : border.getBorderInsets((Component)((GridCellPluginComponent)this).myLastComponent).left;
                    myLastComponent.setBounds(bounds.x + location.x - borderOffset, bounds.y + PluginManagerConfigurableNew.offset5() + bounds.height, Math.min(buttonSize.width, size.width), buttonSize.height);
                }
            });
            this.updateIcon(false, false);
            this.setSelection(SelectionType.NONE);
        }

        private void createMetricsPanel(@NotNull JPanel centerPanel) {
            if (centerPanel == null) {
                GridCellPluginComponent.$$$reportNull$$$0(3);
            }
            if (!(this.myPlugin instanceof PluginNode)) {
                return;
            }
            String downloads = PluginManagerConfigurableNew.getDownloads(this.myPlugin);
            String date = PluginManagerConfigurableNew.getLastUpdatedDate(this.myPlugin);
            String rating = PluginManagerConfigurableNew.getRating(this.myPlugin);
            if (downloads != null || date != null || rating != null) {
                NonOpaquePanel panel2 = new NonOpaquePanel((LayoutManager)((Object)new HorizontalLayout(JBUI.scale((int)7))));
                centerPanel.add((Component)panel2);
                if (date != null) {
                    this.myLastUpdated = new JLabel(date, AllIcons.Plugins.Updated, 0);
                    this.myLastUpdated.setOpaque(false);
                    panel2.add(PluginManagerConfigurableNew.installTiny(this.myLastUpdated));
                }
                if (downloads != null) {
                    this.myDownloads = new JLabel(downloads, AllIcons.Plugins.Downloads, 0);
                    this.myDownloads.setOpaque(false);
                    panel2.add(PluginManagerConfigurableNew.installTiny(this.myDownloads));
                }
                if (rating != null) {
                    this.myRating = new JLabel(rating, AllIcons.Plugins.Rating, 0);
                    this.myRating.setOpaque(false);
                    panel2.add(PluginManagerConfigurableNew.installTiny(this.myRating));
                }
            }
        }

        private void addInstallButton() {
            if (InstalledPluginsState.getInstance().wasInstalled(this.myPlugin.getPluginId())) {
                RestartButton restartButton = new RestartButton(this.myPluginModel);
                restartButton.setFocusable(false);
                this.myLastComponent = restartButton;
                this.add(this.myLastComponent);
                return;
            }
            this.myInstallButton.setFocusable(false);
            this.myInstallButton.addActionListener(e -> this.myPluginModel.installOrUpdatePlugin(this.myPlugin, true));
            this.myInstallButton.setEnabled(PluginManager.getPlugin(this.myPlugin.getPluginId()) == null);
            this.myLastComponent = this.myInstallButton;
            this.add(this.myLastComponent);
            if (MyPluginModel.isInstallingOrUpdate(this.myPlugin)) {
                this.showProgress(false);
            }
        }

        public void showProgress() {
            this.showProgress(true);
        }

        private void showProgress(boolean repaint) {
            MyTwoLineProgressIndicator indicator = new MyTwoLineProgressIndicator();
            indicator.setCancelRunnable(() -> this.myPluginModel.finishInstall(this.myPlugin, false));
            this.myIndicator = indicator;
            this.myInstallButton.setVisible(false);
            this.myLastComponent = indicator.getComponent();
            this.add(this.myLastComponent);
            this.doLayout();
            this.myPluginModel.addProgress(this.myPlugin, indicator);
            if (repaint) {
                this.fullRepaint();
            }
        }

        public void hideProgress(boolean success2) {
            this.myIndicator = null;
            JComponent lastComponent = this.myLastComponent;
            if (success2) {
                RestartButton restartButton = new RestartButton(this.myPluginModel);
                restartButton.setFocusable(false);
                this.myLastComponent = restartButton;
                this.add(this.myLastComponent);
            } else {
                this.myLastComponent = this.myInstallButton;
                this.myInstallButton.setVisible(true);
            }
            this.remove(lastComponent);
            this.doLayout();
            this.fullRepaint();
        }

        private void addTags(@NotNull JPanel parent, @NotNull TagBuilder tagBuilder) {
            List tags;
            if (parent == null) {
                GridCellPluginComponent.$$$reportNull$$$0(4);
            }
            if (tagBuilder == null) {
                GridCellPluginComponent.$$$reportNull$$$0(5);
            }
            if ((tags = PluginManagerConfigurableNew.getTags(this.myPlugin)).isEmpty()) {
                return;
            }
            NonOpaquePanel panel2 = new NonOpaquePanel((LayoutManager)((Object)new HorizontalLayout(JBUI.scale((int)6))));
            parent.add((Component)panel2);
            this.myTagComponents = new ArrayList<TagComponent>();
            for (String tag : tags) {
                TagComponent component = tagBuilder.createTagComponent(tag);
                panel2.add((Component)((Object)component));
                this.myTagComponents.add(component);
            }
        }

        @Override
        public void setListeners(final @NotNull LinkListener<IdeaPluginDescriptor> listener2, @NotNull LinkListener<String> searchListener, @NotNull EventHandler eventHandler) {
            if (listener2 == null) {
                GridCellPluginComponent.$$$reportNull$$$0(6);
            }
            if (searchListener == null) {
                GridCellPluginComponent.$$$reportNull$$$0(7);
            }
            if (eventHandler == null) {
                GridCellPluginComponent.$$$reportNull$$$0(8);
            }
            super.setListeners(listener2, searchListener, eventHandler);
            if (this.myDescription != null) {
                UIUtil.setCursor((Component)this.myDescription, (Cursor)Cursor.getPredefinedCursor(12));
                this.myDescription.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent event) {
                        if (SwingUtilities.isLeftMouseButton(event)) {
                            listener2.linkSelected(myName, (Object)myPlugin);
                        }
                    }
                });
                this.myDescription.addMouseListener(this.myHoverNameListener);
            }
            if (this.myTagComponents != null) {
                for (TagComponent component : this.myTagComponents) {
                    component.setListener(searchListener, "tag:" + component.getText());
                }
                this.myTagComponents = null;
            }
        }

        @Override
        protected void updateColors(@NotNull Color grayedFg, @NotNull Color background) {
            if (grayedFg == null) {
                GridCellPluginComponent.$$$reportNull$$$0(9);
            }
            if (background == null) {
                GridCellPluginComponent.$$$reportNull$$$0(10);
            }
            super.updateColors(grayedFg, background);
            if (this.myLastUpdated != null) {
                this.myLastUpdated.setForeground(grayedFg);
            }
            if (this.myDownloads != null) {
                this.myDownloads.setForeground(grayedFg);
            }
            if (this.myRating != null) {
                this.myRating.setForeground(grayedFg);
            }
        }

        @Override
        public void close() {
            if (this.myIndicator != null) {
                this.myPluginModel.removeProgress(this.myPlugin, this.myIndicator);
                this.myIndicator = null;
            }
            this.myPluginModel.removeComponent(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pluginsModel";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "plugin";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tagBuilder";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "centerPanel";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listener";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "searchListener";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "eventHandler";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grayedFg";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "background";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurableNew$GridCellPluginComponent";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createMetricsPanel";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addTags";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setListeners";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateColors";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class BaselinePanel
    extends NonOpaquePanel {
        private Component myBaseComponent;
        private final List<Component> myVersionComponents = new ArrayList<Component>();
        private final List<Component> myButtonComponents = new ArrayList<Component>();
        private Component myProgressComponent;
        private final JBValue myOffset = new JBValue.Float(8.0f);
        private final JBValue myBeforeButtonOffset = new JBValue.Float(40.0f);
        private final JBValue myButtonOffset = new JBValue.Float(6.0f);
        private JLabel myErrorComponent;
        private Component myErrorEnableComponent;
        private EventHandler myEventHandler;

        public BaselinePanel() {
            this.setBorder((Border)JBUI.Borders.empty((int)5, (int)0, (int)6, (int)0));
            this.setLayout((LayoutManager)new AbstractLayoutManager(){

                public Dimension preferredLayoutSize(Container parent) {
                    Dimension baseSize = myBaseComponent.getPreferredSize();
                    int width = baseSize.width;
                    if (myProgressComponent == null) {
                        int size;
                        Component component;
                        Iterator iterator = myVersionComponents.iterator();
                        while (iterator.hasNext() && (component = (Component)iterator.next()).isVisible()) {
                            width += myOffset.get() + component.getPreferredSize().width;
                        }
                        if (myErrorComponent != null) {
                            width += myOffset.get() + ((BaselinePanel)this).myErrorComponent.getPreferredSize().width;
                            if (myErrorEnableComponent != null) {
                                width += myOffset.get() + ((BaselinePanel)this).myErrorEnableComponent.getPreferredSize().width;
                            }
                        }
                        if ((size = myButtonComponents.size()) > 0) {
                            width += myBeforeButtonOffset.get();
                            width += (size - 1) * myButtonOffset.get();
                            for (Component component2 : myButtonComponents) {
                                width += component2.getPreferredSize().width;
                            }
                        }
                    } else {
                        width += myOffset.get() + ((BaselinePanel)this).myProgressComponent.getPreferredSize().width;
                    }
                    Insets insets = parent.getInsets();
                    return new Dimension(width, insets.top + baseSize.height + insets.bottom);
                }

                public void layoutContainer(Container parent) {
                    Dimension size;
                    Component component;
                    Dimension baseSize = myBaseComponent.getPreferredSize();
                    int top = parent.getInsets().top;
                    int y = top + myBaseComponent.getBaseline(baseSize.width, baseSize.height);
                    int x = 0;
                    myBaseComponent.setBounds(x, top, baseSize.width, baseSize.height);
                    x += baseSize.width;
                    if (myProgressComponent != null) {
                        Dimension size2 = myProgressComponent.getPreferredSize();
                        this.setBaselineBounds(parent.getWidth() - size2.width, y, myProgressComponent, size2);
                        return;
                    }
                    Iterator size2 = myVersionComponents.iterator();
                    while (size2.hasNext() && (component = (Component)size2.next()).isVisible()) {
                        size = component.getPreferredSize();
                        this.setBaselineBounds(x += myOffset.get(), y, component, size);
                        x += size.width;
                    }
                    int lastX = parent.getWidth();
                    for (int i = myButtonComponents.size() - 1; i >= 0; --i) {
                        Component component2 = (Component)myButtonComponents.get(i);
                        Dimension size3 = component2.getPreferredSize();
                        this.setBaselineBounds(lastX -= size3.width, y, component2, size3);
                        lastX -= myButtonOffset.get();
                    }
                    if (myErrorComponent != null) {
                        x += myOffset.get();
                        if (myErrorEnableComponent != null) {
                            if (!myButtonComponents.isEmpty()) {
                                lastX -= myBeforeButtonOffset.get();
                            }
                            lastX -= ((BaselinePanel)this).myErrorEnableComponent.getPreferredSize().width;
                            lastX -= myOffset.get();
                        }
                        int errorWidth = lastX - x;
                        size = myErrorComponent.getPreferredSize();
                        if (errorWidth >= size.width) {
                            this.setBaselineBounds(x, y, myErrorComponent, size);
                            myErrorComponent.setToolTipText(null);
                            x += size.width;
                        } else {
                            this.setBaselineBounds(x, y, myErrorComponent, size, errorWidth, size.height);
                            myErrorComponent.setToolTipText(myErrorComponent.getText());
                            x += errorWidth;
                        }
                        if (myErrorEnableComponent != null) {
                            this.setBaselineBounds(x += myOffset.get(), y, myErrorEnableComponent, myErrorEnableComponent.getPreferredSize());
                        }
                    }
                }

                private void setBaselineBounds(int x, int y, @NotNull Component component, @NotNull Dimension size) {
                    if (component == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (size == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    this.setBaselineBounds(x, y, component, size, size.width, size.height);
                }

                private void setBaselineBounds(int x, int y, @NotNull Component component, @NotNull Dimension prefSize, int width, int height) {
                    if (component == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if (prefSize == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    component.setBounds(x, y - component.getBaseline(prefSize.width, prefSize.height), width, height);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "component";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "size";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[0] = "prefSize";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/ide/plugins/PluginManagerConfigurableNew$BaselinePanel$1";
                    objectArray[2] = "setBaselineBounds";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }

        public void setListeners(@NotNull EventHandler eventHandler) {
            if (eventHandler == null) {
                BaselinePanel.$$$reportNull$$$0(0);
            }
            this.myEventHandler = eventHandler;
        }

        public Component add(Component component) {
            assert (this.myBaseComponent == null);
            this.myBaseComponent = component;
            return super.add(component);
        }

        public void addVersionComponent(@NotNull JComponent component) {
            if (component == null) {
                BaselinePanel.$$$reportNull$$$0(1);
            }
            this.myVersionComponents.add(component);
            this.add(component, null);
        }

        public void addErrorComponents(@NotNull String message, boolean enableAction, @NotNull Runnable enableCallback) {
            if (message == null) {
                BaselinePanel.$$$reportNull$$$0(2);
            }
            if (enableCallback == null) {
                BaselinePanel.$$$reportNull$$$0(3);
            }
            if (this.myErrorComponent == null) {
                this.myErrorComponent = new JLabel();
                this.myErrorComponent.setForeground((Color)JBColor.red);
                this.myErrorComponent.setOpaque(false);
                this.add(this.myErrorComponent, null);
                if (this.myEventHandler != null) {
                    this.myEventHandler.add(this.myErrorComponent);
                }
            }
            this.myErrorComponent.setText(message);
            if (enableAction) {
                if (this.myErrorEnableComponent == null) {
                    LinkLabel errorAction = new LinkLabel("Enable", null);
                    errorAction.setOpaque(false);
                    errorAction.setListener((aSource, aLinkData) -> {
                        if (enableCallback == null) {
                            BaselinePanel.$$$reportNull$$$0(8);
                        }
                        enableCallback.run();
                    }, null);
                    this.myErrorEnableComponent = errorAction;
                    this.add(this.myErrorEnableComponent, null);
                    if (this.myEventHandler != null) {
                        this.myEventHandler.add((Component)errorAction);
                    }
                }
            } else if (this.myErrorEnableComponent != null) {
                this.remove(this.myErrorEnableComponent);
                this.myErrorEnableComponent = null;
            }
            for (Component component : this.myVersionComponents) {
                component.setVisible(false);
            }
            this.doLayout();
        }

        public void removeErrorComponents() {
            if (this.myErrorComponent != null) {
                this.remove(this.myErrorComponent);
                this.myErrorComponent = null;
                if (this.myErrorEnableComponent != null) {
                    this.remove(this.myErrorEnableComponent);
                    this.myErrorEnableComponent = null;
                }
                for (Component component : this.myVersionComponents) {
                    component.setVisible(true);
                }
                this.doLayout();
            }
        }

        public void addButtonComponent(@NotNull JComponent component) {
            if (component == null) {
                BaselinePanel.$$$reportNull$$$0(4);
            }
            this.myButtonComponents.add(component);
            this.add(component, null);
        }

        public void removeButtonComponent(@NotNull JComponent component) {
            if (component == null) {
                BaselinePanel.$$$reportNull$$$0(5);
            }
            this.myButtonComponents.remove(component);
            this.remove(component);
        }

        public void setProgressComponent(@NotNull CellPluginComponent pluginComponent, @NotNull JComponent progressComponent) {
            if (pluginComponent == null) {
                BaselinePanel.$$$reportNull$$$0(6);
            }
            if (progressComponent == null) {
                BaselinePanel.$$$reportNull$$$0(7);
            }
            assert (this.myProgressComponent == null);
            this.myProgressComponent = progressComponent;
            this.add(progressComponent, null);
            if (this.myEventHandler != null) {
                this.myEventHandler.addAll(progressComponent);
                this.myEventHandler.updateHover(pluginComponent);
            }
            this.setVisibleOther(false);
            this.doLayout();
        }

        public void removeProgressComponent() {
            assert (this.myProgressComponent != null);
            this.remove(this.myProgressComponent);
            this.myProgressComponent = null;
            this.setVisibleOther(true);
            this.doLayout();
        }

        private void setVisibleOther(boolean value) {
            for (Component component : this.myVersionComponents) {
                component.setVisible(value);
            }
            if (this.myErrorComponent != null) {
                this.myErrorComponent.setVisible(value);
            }
            if (this.myErrorEnableComponent != null) {
                this.myErrorEnableComponent.setVisible(value);
            }
            for (Component component : this.myButtonComponents) {
                component.setVisible(value);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "eventHandler";
                    break;
                }
                case 1: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 3: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "enableCallback";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pluginComponent";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "progressComponent";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurableNew$BaselinePanel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setListeners";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addVersionComponent";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addErrorComponents";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addButtonComponent";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removeButtonComponent";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setProgressComponent";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$addErrorComponents$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class MyAnAction
    extends AnAction {
        public MyAnAction(@Nullable String text2, int keyCode) {
            super(text2);
            this.setShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(keyCode, 0)));
        }
    }

    private static class ButtonAnAction
    extends AnAction {
        private final JButton[] myButtons;

        public ButtonAnAction(JButton ... buttons) {
            if (buttons == null) {
                ButtonAnAction.$$$reportNull$$$0(0);
            }
            super(buttons[0].getText());
            this.myButtons = buttons;
            this.setShortcutSet(CommonShortcuts.ENTER);
        }

        public void actionPerformed(AnActionEvent e) {
            for (JButton button : this.myButtons) {
                button.doClick();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buttons", "com/intellij/ide/plugins/PluginManagerConfigurableNew$ButtonAnAction", "<init>"));
        }
    }

    private static class ListPluginComponent
    extends CellPluginComponent {
        private final MyPluginModel myPluginModel;
        private boolean myUninstalled;
        private JLabel myVersion;
        private JLabel myLastUpdated;
        private JButton myUpdateButton;
        private final JCheckBox myEnableDisableButton;
        private RestartButton myRestartButton;
        private final BaselinePanel myBaselinePanel;
        private ProgressIndicatorEx myIndicator;

        public ListPluginComponent(@NotNull MyPluginModel pluginModel, @NotNull IdeaPluginDescriptor plugin, boolean pluginForUpdate) {
            if (pluginModel == null) {
                ListPluginComponent.$$$reportNull$$$0(0);
            }
            if (plugin == null) {
                ListPluginComponent.$$$reportNull$$$0(1);
            }
            super(plugin);
            this.myEnableDisableButton = new JCheckBox();
            this.myBaselinePanel = new BaselinePanel();
            this.myPluginModel = pluginModel;
            pluginModel.addComponent(this);
            this.setFocusable(true);
            this.myEnableDisableButton.setFocusable(false);
            this.setOpaque(true);
            this.setLayout(new BorderLayout(JBUI.scale((int)8), 0));
            this.setBorder((Border)JBUI.Borders.empty((int)5, (int)10, (int)10, (int)10));
            this.createButtons(pluginForUpdate);
            NonOpaquePanel westPanel = new NonOpaquePanel((LayoutManager)ListPluginComponent.createCheckboxIconLayout());
            westPanel.setBorder((Border)JBUI.Borders.emptyTop((int)5));
            westPanel.add(this.myEnableDisableButton);
            this.addIconComponent((JPanel)westPanel, null);
            this.add((Component)westPanel, "West");
            NonOpaquePanel centerPanel = new NonOpaquePanel((LayoutManager)((Object)new VerticalLayout(0)));
            this.add((Component)centerPanel);
            centerPanel.add((Component)((Object)this.myBaselinePanel), "fill_h");
            this.addNameComponent((JPanel)((Object)this.myBaselinePanel));
            this.myName.setVerticalAlignment(1);
            if (pluginForUpdate) {
                this.createVersion();
            }
            this.updateErrors();
            if (pluginForUpdate) {
                this.addDescriptionComponent((JPanel)centerPanel, ListPluginComponent.getChangeNotes(plugin), new LineFunction(3, false));
            } else {
                this.addDescriptionComponent((JPanel)centerPanel, PluginManagerConfigurableNew.getShortDescription(plugin, false), new LineFunction(1, true));
            }
            if (MyPluginModel.isInstallingOrUpdate(plugin)) {
                this.showProgress(false);
            }
            this.setSelection(SelectionType.NONE);
        }

        private void createButtons(boolean update) {
            this.myEnableDisableButton.setOpaque(false);
            if (this.myPlugin instanceof IdeaPluginDescriptorImpl && ((IdeaPluginDescriptorImpl)this.myPlugin).isDeleted()) {
                this.myRestartButton = new RestartButton(this.myPluginModel);
                this.myRestartButton.setFocusable(false);
                this.myBaselinePanel.addButtonComponent(this.myRestartButton);
                this.myEnableDisableButton.setSelected(false);
                this.myEnableDisableButton.setEnabled(false);
                this.myUninstalled = true;
            } else {
                PluginId id;
                InstalledPluginsState pluginsState = InstalledPluginsState.getInstance();
                if (pluginsState.wasInstalled(id = this.myPlugin.getPluginId()) || pluginsState.wasUpdated(id)) {
                    this.myRestartButton = new RestartButton(this.myPluginModel);
                    this.myRestartButton.setFocusable(false);
                    this.myBaselinePanel.addButtonComponent(this.myRestartButton);
                } else if (update) {
                    this.myUpdateButton = new UpdateButton();
                    this.myUpdateButton.setFocusable(false);
                    this.myUpdateButton.addActionListener(e -> this.myPluginModel.installOrUpdatePlugin(this.myPlugin, false));
                    this.myBaselinePanel.addButtonComponent(this.myUpdateButton);
                }
                this.myEnableDisableButton.setSelected(this.isEnabledState());
                this.myEnableDisableButton.addActionListener(e -> this.myPluginModel.changeEnableDisable(this.myPlugin));
            }
        }

        public void showProgress() {
            this.showProgress(true);
        }

        private void showProgress(boolean repaint) {
            this.myEnableDisableButton.setSelected(false);
            this.myEnableDisableButton.setEnabled(false);
            MyProgressIndicator indicator = new MyProgressIndicator();
            indicator.setCancelRunnable(() -> this.myPluginModel.finishInstall(this.myPlugin, false));
            this.myBaselinePanel.setProgressComponent(this, indicator.createBaselineWrapper());
            this.myPluginModel.addProgress(this.myPlugin, indicator);
            this.myIndicator = indicator;
            if (repaint) {
                this.fullRepaint();
            }
        }

        public void hideProgress(boolean success2) {
            this.myIndicator = null;
            this.myEnableDisableButton.setEnabled(true);
            this.myBaselinePanel.removeProgressComponent();
            if (success2) {
                this.changeUpdateToRestart();
            }
            this.fullRepaint();
        }

        @NotNull
        private static AbstractLayoutManager createCheckboxIconLayout() {
            AbstractLayoutManager abstractLayoutManager = new AbstractLayoutManager(){
                JBValue offset = new JBValue.Float(12.0f);

                public Dimension preferredLayoutSize(Container parent) {
                    Dimension size = new Dimension();
                    if (parent.getComponentCount() == 2) {
                        Dimension iconSize = parent.getComponent(1).getPreferredSize();
                        size.width = parent.getComponent((int)0).getPreferredSize().width + this.offset.get() + iconSize.width;
                        size.height = iconSize.height;
                    }
                    JBInsets.addTo((Dimension)size, (Insets)parent.getInsets());
                    return size;
                }

                public void layoutContainer(Container parent) {
                    if (parent.getComponentCount() == 2) {
                        Component checkBox2 = parent.getComponent(0);
                        Component icon = parent.getComponent(1);
                        Dimension checkBoxSize = checkBox2.getPreferredSize();
                        Dimension iconSize = icon.getPreferredSize();
                        Insets insets = parent.getInsets();
                        int x = insets.left;
                        int y = insets.top;
                        checkBox2.setBounds(x, y + (iconSize.height - checkBoxSize.height) / 2, checkBoxSize.width, checkBoxSize.height);
                        icon.setBounds(x + checkBoxSize.width + this.offset.get(), y, iconSize.width, iconSize.height);
                    }
                }
            };
            if (abstractLayoutManager == null) {
                ListPluginComponent.$$$reportNull$$$0(2);
            }
            return abstractLayoutManager;
        }

        private void createVersion() {
            String date;
            String version = StringUtil.defaultIfEmpty((String)this.myPlugin.getVersion(), null);
            if (version != null) {
                this.myVersion = new JLabel("Version " + version);
                this.myVersion.setOpaque(false);
                this.myBaselinePanel.addVersionComponent((JComponent)PluginManagerConfigurableNew.installTiny(this.myVersion));
            }
            if (this.myPlugin instanceof PluginNode && (date = PluginManagerConfigurableNew.getLastUpdatedDate(this.myPlugin)) != null) {
                this.myLastUpdated = new JLabel(date, AllIcons.Plugins.Updated, 0);
                this.myLastUpdated.setOpaque(false);
                this.myBaselinePanel.addVersionComponent((JComponent)PluginManagerConfigurableNew.installTiny(this.myLastUpdated));
            }
        }

        public void updateErrors() {
            boolean errors = this.myPluginModel.hasErrors(this.myPlugin);
            this.updateIcon(errors, !this.myPluginModel.isEnabled(this.myPlugin));
            if (errors) {
                Ref enableAction = new Ref();
                String message = PluginManagerConfigurableNew.getErrorMessage(this.myPluginModel, (PluginDescriptor)this.myPlugin, (Ref<Boolean>)enableAction);
                this.myBaselinePanel.addErrorComponents(message, !enableAction.isNull(), () -> this.myPluginModel.enableRequiredPlugins(this.myPlugin));
            } else {
                this.myBaselinePanel.removeErrorComponents();
            }
        }

        @Nullable
        private static String getChangeNotes(@NotNull IdeaPluginDescriptor plugin) {
            String notes;
            if (plugin == null) {
                ListPluginComponent.$$$reportNull$$$0(3);
            }
            return StringUtil.isEmptyOrSpaces((String)(notes = plugin.getChangeNotes())) ? null : "<b>Change Notes</b><br>\n" + notes;
        }

        @Override
        public void setListeners(@NotNull LinkListener<IdeaPluginDescriptor> listener2, @NotNull LinkListener<String> searchListener, @NotNull EventHandler eventHandler) {
            if (listener2 == null) {
                ListPluginComponent.$$$reportNull$$$0(4);
            }
            if (searchListener == null) {
                ListPluginComponent.$$$reportNull$$$0(5);
            }
            if (eventHandler == null) {
                ListPluginComponent.$$$reportNull$$$0(6);
            }
            super.setListeners(listener2, searchListener, eventHandler);
            eventHandler.addAll(this);
            this.myBaselinePanel.setListeners(eventHandler);
        }

        @Override
        protected void updateColors(@NotNull Color grayedFg, @NotNull Color background) {
            if (grayedFg == null) {
                ListPluginComponent.$$$reportNull$$$0(7);
            }
            if (background == null) {
                ListPluginComponent.$$$reportNull$$$0(8);
            }
            super.updateColors(grayedFg, background);
            if (this.myVersion != null) {
                this.myVersion.setForeground(grayedFg);
            }
            if (this.myLastUpdated != null) {
                this.myLastUpdated.setForeground(grayedFg);
            }
            boolean enabled = MyPluginModel.isInstallingOrUpdate(this.myPlugin) || this.myPluginModel.isEnabled(this.myPlugin);
            this.myName.setForeground(enabled ? null : DisabledColor);
            if (this.myDescription != null) {
                this.myDescription.setForeground(enabled ? grayedFg : DisabledColor);
            }
        }

        public boolean isEnabledState() {
            return this.myPluginModel.isEnabled(this.myPlugin);
        }

        public void updateAfterUninstall() {
            this.myUninstalled = true;
            this.myEnableDisableButton.setSelected(false);
            this.myEnableDisableButton.setEnabled(false);
            this.changeUpdateToRestart();
        }

        public void changeUpdateToRestart() {
            boolean layout = false;
            if (this.myUpdateButton != null) {
                this.myBaselinePanel.removeButtonComponent(this.myUpdateButton);
                this.myUpdateButton = null;
                layout = true;
            }
            if (this.myRestartButton == null) {
                this.myRestartButton = new RestartButton(this.myPluginModel);
                this.myRestartButton.setFocusable(false);
                this.myBaselinePanel.addButtonComponent(this.myRestartButton);
                layout = true;
            }
            if (layout) {
                this.myBaselinePanel.doLayout();
            }
        }

        public void updateEnabledState() {
            if (!this.myUninstalled) {
                this.myEnableDisableButton.setSelected(this.isEnabledState());
            }
            this.updateErrors();
            this.setSelection(this.mySelection, false);
        }

        public void updatePlugin() {
            if (this.myUpdateButton != null) {
                this.myUpdateButton.doClick();
            }
        }

        @Override
        public void createPopupMenu(@NotNull DefaultActionGroup group, final @NotNull List<CellPluginComponent> selection) {
            if (group == null) {
                ListPluginComponent.$$$reportNull$$$0(9);
            }
            if (selection == null) {
                ListPluginComponent.$$$reportNull$$$0(10);
            }
            for (CellPluginComponent cellPluginComponent : selection) {
                if (!MyPluginModel.isInstallingOrUpdate(cellPluginComponent.myPlugin)) continue;
                return;
            }
            boolean restart = true;
            for (CellPluginComponent component : selection) {
                if (((ListPluginComponent)component).myRestartButton != null) continue;
                restart = false;
                break;
            }
            if (restart) {
                group.add((AnAction)new ButtonAnAction(((ListPluginComponent)selection.get((int)0)).myRestartButton));
            } else {
                int n = selection.size();
                JButton[] buttons = new JButton[n];
                for (int i = 0; i < n; ++i) {
                    JButton button = ((ListPluginComponent)selection.get((int)i)).myUpdateButton;
                    if (button == null) {
                        buttons = null;
                        break;
                    }
                    buttons[i] = button;
                }
                if (buttons != null) {
                    group.add((AnAction)new ButtonAnAction(buttons));
                }
            }
            final Pair<Boolean, IdeaPluginDescriptor[]> pair = ListPluginComponent.getSelectionNewState(selection);
            group.add((AnAction)new MyAnAction((Boolean)pair.first != false ? "Enable" : "Disable", 32){

                public void actionPerformed(AnActionEvent e) {
                    myPluginModel.changeEnableDisable((IdeaPluginDescriptor[])pair.second, (Boolean)pair.first);
                }
            });
            for (CellPluginComponent component : selection) {
                if (!((ListPluginComponent)component).myUninstalled && !component.myPlugin.isBundled()) continue;
                return;
            }
            group.addSeparator();
            group.add((AnAction)new MyAnAction("Uninstall", 8){

                public void actionPerformed(AnActionEvent e) {
                    for (CellPluginComponent component : selection) {
                        myPluginModel.doUninstall(component, component.myPlugin, null);
                    }
                }
            });
        }

        @Override
        public void handleKeyAction(int keyCode, @NotNull List<CellPluginComponent> selection) {
            block11: {
                block12: {
                    block10: {
                        if (selection == null) {
                            ListPluginComponent.$$$reportNull$$$0(11);
                        }
                        for (CellPluginComponent cellPluginComponent : selection) {
                            if (!MyPluginModel.isInstallingOrUpdate(cellPluginComponent.myPlugin)) continue;
                            return;
                        }
                        if (keyCode != 32) break block10;
                        if (selection.size() == 1) {
                            this.myPluginModel.changeEnableDisable(selection.get((int)0).myPlugin);
                        } else {
                            Pair<Boolean, IdeaPluginDescriptor[]> result2 = ListPluginComponent.getSelectionNewState(selection);
                            this.myPluginModel.changeEnableDisable((IdeaPluginDescriptor[])result2.second, (Boolean)result2.first);
                        }
                        break block11;
                    }
                    if (keyCode != 10) break block12;
                    boolean restart = true;
                    for (CellPluginComponent component : selection) {
                        if (((ListPluginComponent)component).myRestartButton != null) continue;
                        restart = false;
                        break;
                    }
                    if (restart) {
                        ((ListPluginComponent)selection.get((int)0)).myRestartButton.doClick();
                        return;
                    }
                    for (CellPluginComponent component : selection) {
                        if (((ListPluginComponent)component).myUpdateButton != null) continue;
                        return;
                    }
                    for (CellPluginComponent component : selection) {
                        ((ListPluginComponent)component).myUpdateButton.doClick();
                    }
                    break block11;
                }
                if (keyCode != 8) break block11;
                for (CellPluginComponent cellPluginComponent : selection) {
                    if (!((ListPluginComponent)cellPluginComponent).myUninstalled && !cellPluginComponent.myPlugin.isBundled()) continue;
                    return;
                }
                for (CellPluginComponent cellPluginComponent : selection) {
                    this.myPluginModel.doUninstall(this, cellPluginComponent.myPlugin, null);
                }
            }
        }

        @NotNull
        private static Pair<Boolean, IdeaPluginDescriptor[]> getSelectionNewState(@NotNull List<CellPluginComponent> selection) {
            if (selection == null) {
                ListPluginComponent.$$$reportNull$$$0(12);
            }
            boolean state2 = ((ListPluginComponent)selection.get(0)).isEnabledState();
            boolean setTrue = false;
            ListIterator<CellPluginComponent> I = selection.listIterator(1);
            while (I.hasNext()) {
                if (state2 == ((ListPluginComponent)I.next()).isEnabledState()) continue;
                setTrue = true;
                break;
            }
            int size = selection.size();
            IdeaPluginDescriptor[] plugins2 = new IdeaPluginDescriptor[size];
            for (int i = 0; i < size; ++i) {
                plugins2[i] = selection.get((int)i).myPlugin;
            }
            Pair pair = Pair.create((Object)(setTrue || !state2 ? 1 : 0), (Object)plugins2);
            if (pair == null) {
                ListPluginComponent.$$$reportNull$$$0(13);
            }
            return pair;
        }

        @Override
        public void close() {
            if (this.myIndicator != null) {
                this.myPluginModel.removeProgress(this.myPlugin, this.myIndicator);
                this.myIndicator = null;
            }
            this.myPluginModel.removeComponent(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 13: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 13: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pluginModel";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "plugin";
                    break;
                }
                case 2: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/plugins/PluginManagerConfigurableNew$ListPluginComponent";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listener";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "searchListener";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "eventHandler";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grayedFg";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "background";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "group";
                    break;
                }
                case 10: 
                case 11: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selection";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurableNew$ListPluginComponent";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createCheckboxIconLayout";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSelectionNewState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 13: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getChangeNotes";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "setListeners";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "updateColors";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "createPopupMenu";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "handleKeyAction";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "getSelectionNewState";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 13: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class LineFunction {
        private final int myLines;
        private final boolean myShowDots;
        private Point myLastPoint;

        public LineFunction(int lines2, boolean showDots) {
            this.myLines = lines2 + 1;
            this.myShowDots = showDots;
        }

        public void paintComponent(@NotNull JEditorPane pane, @NotNull Graphics g) {
            if (pane == null) {
                LineFunction.$$$reportNull$$$0(0);
            }
            if (g == null) {
                LineFunction.$$$reportNull$$$0(1);
            }
            if (this.myShowDots && this.myLastPoint != null) {
                if (g instanceof Graphics2D) {
                    ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                }
                g.setColor(pane.getForeground());
                g.drawString("...", this.myLastPoint.x, this.myLastPoint.y + g.getFontMetrics().getAscent());
            }
        }

        public int getHeight(@NotNull JEditorPane pane) {
            if (pane == null) {
                LineFunction.$$$reportNull$$$0(2);
            }
            this.myLastPoint = null;
            try {
                int line = 0;
                int startLineY = -1;
                int length = pane.getDocument().getLength();
                for (int i = 0; i < length; ++i) {
                    Rectangle r = pane.modelToView(i);
                    if (r == null || r.height <= 0 || startLineY >= r.y) continue;
                    startLineY = r.y;
                    if (++line != this.myLines) continue;
                    int ii = i;
                    while (ii > 0) {
                        Rectangle rr;
                        if ((rr = pane.modelToView(--ii)) == null) continue;
                        this.myLastPoint = rr.getLocation();
                        break;
                    }
                    return r.y;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            return (int)(pane.getUI().getRootView(pane).getPreferredSpan(1) + JBUI.scale((float)2.0f));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pane";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurableNew$LineFunction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "paintComponent";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getHeight";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class CellPluginComponent
    extends JPanel {
        private static final Color HOVER_COLOR = new JBColor(15331061, 4606541);
        private static final Color GRAY_COLOR = new JBColor((Color)Gray._130, (Color)Gray._120);
        protected final IdeaPluginDescriptor myPlugin;
        protected LinkLabel myIconLabel;
        protected LinkLabel myName;
        protected JEditorPane myDescription;
        protected MouseListener myHoverNameListener;
        protected SelectionType mySelection;

        protected CellPluginComponent(@NotNull IdeaPluginDescriptor plugin) {
            if (plugin == null) {
                CellPluginComponent.$$$reportNull$$$0(0);
            }
            this.mySelection = SelectionType.NONE;
            this.myPlugin = plugin;
        }

        protected void addIconComponent(@NotNull JPanel parent, @Nullable Object constraints) {
            if (parent == null) {
                CellPluginComponent.$$$reportNull$$$0(1);
            }
            this.myIconLabel = new LinkLabel(null, AllIcons.Plugins.PluginLogo_40);
            this.myIconLabel.setVerticalAlignment(1);
            this.myIconLabel.setOpaque(false);
            parent.add((Component)this.myIconLabel, constraints);
        }

        protected void addNameComponent(@NotNull JPanel parent) {
            if (parent == null) {
                CellPluginComponent.$$$reportNull$$$0(2);
            }
            this.myName = new LinkComponent();
            this.myName.setText(this.myPlugin.getName());
            parent.add(RelativeFont.BOLD.install((Component)this.myName));
        }

        protected void updateIcon(boolean errors, boolean disabled) {
            this.myIconLabel.setIcon(PluginLogoInfo.getIcon(false, PluginManagerConfigurableNew.isJBPlugin(this.myPlugin), errors, disabled));
        }

        protected void addDescriptionComponent(@NotNull JPanel parent, @Nullable String description, final @NotNull LineFunction function) {
            if (parent == null) {
                CellPluginComponent.$$$reportNull$$$0(3);
            }
            if (function == null) {
                CellPluginComponent.$$$reportNull$$$0(4);
            }
            if (StringUtil.isEmptyOrSpaces((String)description)) {
                return;
            }
            this.myDescription = new JEditorPane(){

                @Override
                public Dimension getPreferredSize() {
                    Integer property;
                    if (this.getWidth() == 0 || this.getHeight() == 0) {
                        this.setSize((Dimension)new JBDimension(180, 20));
                    }
                    int width = (property = (Integer)this.getClientProperty("parent.width")) == null ? JBUI.scale((int)180) : property;
                    View view = this.getUI().getRootView(this);
                    view.setSize(width, 2.1474836E9f);
                    return new Dimension(width, function.getHeight(this));
                }

                @Override
                protected void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    function.paintComponent(this, g);
                }
            };
            this.myDescription.setEditorKit((EditorKit)new UIUtil.JBWordWrapHtmlEditorKit());
            this.myDescription.setEditable(false);
            this.myDescription.setFocusable(false);
            this.myDescription.setOpaque(false);
            this.myDescription.setBorder(null);
            this.myDescription.setText(XmlStringUtil.wrapInHtml((CharSequence)description));
            if (this.myDescription.getCaret() != null) {
                this.myDescription.setCaretPosition(0);
            }
            parent.add(PluginManagerConfigurableNew.installTiny(this.myDescription));
        }

        @NotNull
        public SelectionType getSelection() {
            SelectionType selectionType = this.mySelection;
            if (selectionType == null) {
                CellPluginComponent.$$$reportNull$$$0(5);
            }
            return selectionType;
        }

        public void setSelection(@NotNull SelectionType type) {
            if (type == null) {
                CellPluginComponent.$$$reportNull$$$0(6);
            }
            this.setSelection(type, type == SelectionType.SELECTION);
        }

        public void setSelection(@NotNull SelectionType type, boolean scrollAndFocus) {
            JComponent parent;
            if (type == null) {
                CellPluginComponent.$$$reportNull$$$0(7);
            }
            this.mySelection = type;
            if (scrollAndFocus && (parent = (JComponent)this.getParent()) != null) {
                Rectangle bounds = this.getBounds();
                if (!parent.getVisibleRect().contains(bounds)) {
                    parent.scrollRectToVisible(bounds);
                }
                if (type == SelectionType.SELECTION) {
                    IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this, true));
                }
            }
            this.updateColors(GRAY_COLOR, type == SelectionType.NONE ? MAIN_BG_COLOR : HOVER_COLOR);
            this.repaint();
        }

        protected void updateColors(@NotNull Color grayedFg, @NotNull Color background) {
            if (grayedFg == null) {
                CellPluginComponent.$$$reportNull$$$0(8);
            }
            if (background == null) {
                CellPluginComponent.$$$reportNull$$$0(9);
            }
            this.setBackground(background);
            if (this.myDescription != null) {
                this.myDescription.setForeground(grayedFg);
            }
        }

        protected void fullRepaint() {
            Container parent = this.getParent();
            parent.doLayout();
            parent.revalidate();
            parent.repaint();
        }

        public void setListeners(@NotNull LinkListener<IdeaPluginDescriptor> listener2, @NotNull LinkListener<String> searchListener, @NotNull EventHandler eventHandler) {
            if (listener2 == null) {
                CellPluginComponent.$$$reportNull$$$0(10);
            }
            if (searchListener == null) {
                CellPluginComponent.$$$reportNull$$$0(11);
            }
            if (eventHandler == null) {
                CellPluginComponent.$$$reportNull$$$0(12);
            }
            this.myIconLabel.setListener(listener2, (Object)this.myPlugin);
            this.myName.setListener(listener2, (Object)this.myPlugin);
            this.myHoverNameListener = new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent event) {
                    myName.entered(event);
                }

                @Override
                public void mouseExited(MouseEvent event) {
                    myName.exited(event);
                }
            };
            this.myIconLabel.addMouseListener(this.myHoverNameListener);
        }

        public void createPopupMenu(@NotNull DefaultActionGroup group, @NotNull List<CellPluginComponent> selection) {
            if (group == null) {
                CellPluginComponent.$$$reportNull$$$0(13);
            }
            if (selection == null) {
                CellPluginComponent.$$$reportNull$$$0(14);
            }
        }

        public void handleKeyAction(int keyCode, @NotNull List<CellPluginComponent> selection) {
            if (selection == null) {
                CellPluginComponent.$$$reportNull$$$0(15);
            }
        }

        @NotNull
        public static CellPluginComponent get(@NotNull ComponentEvent event) {
            if (event == null) {
                CellPluginComponent.$$$reportNull$$$0(16);
            }
            CellPluginComponent cellPluginComponent = (CellPluginComponent)UIUtil.getParentOfType(CellPluginComponent.class, (Component)event.getComponent());
            if (cellPluginComponent == null) {
                CellPluginComponent.$$$reportNull$$$0(17);
            }
            return cellPluginComponent;
        }

        public void close() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 17: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 17: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "plugin";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "function";
                    break;
                }
                case 5: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/plugins/PluginManagerConfigurableNew$CellPluginComponent";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grayedFg";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "background";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listener";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "searchListener";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "eventHandler";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "group";
                    break;
                }
                case 14: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selection";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurableNew$CellPluginComponent";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSelection";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "get";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "addIconComponent";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "addNameComponent";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "addDescriptionComponent";
                    break;
                }
                case 5: 
                case 17: {
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelection";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "updateColors";
                    break;
                }
                case 10: 
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "setListeners";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "createPopupMenu";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "handleKeyAction";
                    break;
                }
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "get";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 17: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PluginsGroup {
        protected final String myTitlePrefix;
        public String title;
        public JLabel titleLabel;
        public LinkLabel<Object> rightAction;
        public final List<IdeaPluginDescriptor> descriptors;
        public UIPluginGroup ui;

        public PluginsGroup(@NotNull String title) {
            if (title == null) {
                PluginsGroup.$$$reportNull$$$0(0);
            }
            this.descriptors = new ArrayList<IdeaPluginDescriptor>();
            this.myTitlePrefix = title;
            this.title = title;
        }

        public void titleWithCount() {
            this.title = this.myTitlePrefix + " (" + this.descriptors.size() + ")";
            this.updateTitle();
        }

        public void titleWithEnabled(@NotNull MyPluginModel pluginModel) {
            if (pluginModel == null) {
                PluginsGroup.$$$reportNull$$$0(1);
            }
            int enabled = 0;
            for (IdeaPluginDescriptor descriptor2 : this.descriptors) {
                if (!pluginModel.isEnabled(descriptor2)) continue;
                ++enabled;
            }
            this.titleWithCount(enabled);
        }

        public void titleWithCount(int enabled) {
            this.title = this.myTitlePrefix + " (" + enabled + " of " + this.descriptors.size() + " enabled)";
            this.updateTitle();
        }

        protected void updateTitle() {
            if (this.titleLabel != null) {
                this.titleLabel.setText(this.title);
            }
        }

        public int addWithIndex(@NotNull IdeaPluginDescriptor descriptor2) {
            if (descriptor2 == null) {
                PluginsGroup.$$$reportNull$$$0(2);
            }
            this.descriptors.add(descriptor2);
            this.sortByName();
            return this.descriptors.indexOf(descriptor2);
        }

        public void sortByName() {
            ContainerUtil.sort(this.descriptors, Comparator.comparing(IdeaPluginDescriptor::getName));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pluginModel";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurableNew$PluginsGroup";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "titleWithEnabled";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addWithIndex";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class UIPluginGroup {
        public Component panel;
        public List<CellPluginComponent> plugins = new ArrayList<CellPluginComponent>();

        private UIPluginGroup() {
        }
    }

    private class SearchResultInfo {
        public final String key;
        public int backTabIndex;
        private String myQuery;
        private final PanelWithProgress myPanel;
        private final PluginsGroupComponent myInstalledPanel;
        private PluginsGroup myInstalledGroup;
        private final PluginsGroupComponent myRepositoryPanel;
        private PluginsGroup myRepositoryGroup;
        private AtomicBoolean myRunQuery;

        public SearchResultInfo(String query) {
            if (query == null) {
                SearchResultInfo.$$$reportNull$$$0(0);
            }
            this.myInstalledPanel = new PluginsGroupComponent((LayoutManager)((Object)new PluginsListLayout()), new MultiSelectionEventHandler(), (LinkListener<IdeaPluginDescriptor>)PluginManagerConfigurableNew.this.myNameListener, (LinkListener<String>)PluginManagerConfigurableNew.this.mySearchListener, (Function<IdeaPluginDescriptor, CellPluginComponent>)((Function)descriptor2 -> new ListPluginComponent(PluginManagerConfigurableNew.this.myPluginsModel, (IdeaPluginDescriptor)descriptor2, false)));
            this.myRepositoryPanel = new PluginsGroupComponent((LayoutManager)((Object)new PluginsGridLayout()), EventHandler.EMPTY, (LinkListener<IdeaPluginDescriptor>)PluginManagerConfigurableNew.this.myNameListener, (LinkListener<String>)PluginManagerConfigurableNew.this.mySearchListener, (Function<IdeaPluginDescriptor, CellPluginComponent>)((Function)descriptor2 -> new GridCellPluginComponent(PluginManagerConfigurableNew.this.myPluginsModel, (IdeaPluginDescriptor)descriptor2, PluginManagerConfigurableNew.this.myTagBuilder)));
            this.key = query;
            this.myPanel = new PanelWithProgress("Nothing to show");
            this.myPanel.setOpaque(true);
            this.myPanel.setBackground(MAIN_BG_COLOR);
            this.myPanel.setLayout((LayoutManager)new AbstractLayoutManager(){

                public Dimension preferredLayoutSize(Container parent) {
                    Dimension size = new Dimension();
                    if (SearchResultInfo.this.myInstalledPanel.isVisible()) {
                        size.setSize(SearchResultInfo.this.myInstalledPanel.getPreferredSize());
                    }
                    if (SearchResultInfo.this.myRepositoryPanel.isVisible()) {
                        Dimension secondSize = SearchResultInfo.this.myRepositoryPanel.getPreferredSize();
                        size.width = Math.max(size.width, secondSize.width);
                        size.height += secondSize.height;
                    }
                    return size.height > 0 ? size : new Dimension(-1, -1);
                }

                public void layoutContainer(Container parent) {
                    int childHeight;
                    int width = parent.getWidth();
                    int y = 0;
                    if (SearchResultInfo.this.myInstalledPanel.isVisible()) {
                        childHeight = ((SearchResultInfo)SearchResultInfo.this).myInstalledPanel.getPreferredSize().height;
                        SearchResultInfo.this.myInstalledPanel.setBounds(0, y, width, childHeight);
                        y = childHeight;
                    }
                    if (SearchResultInfo.this.myRepositoryPanel.isVisible()) {
                        childHeight = ((SearchResultInfo)SearchResultInfo.this).myRepositoryPanel.getPreferredSize().height;
                        SearchResultInfo.this.myRepositoryPanel.setBounds(0, y, width, childHeight);
                    }
                }
            });
            this.myPanel.add((Component)((Object)this.myInstalledPanel));
            this.myPanel.add((Component)((Object)this.myRepositoryPanel));
            this.myPanel.addProgress();
            this.myInstalledPanel.setVisible(false);
            this.myRepositoryPanel.setVisible(false);
            this.handleQuery(query);
        }

        @NotNull
        public JComponent createScrollPane() {
            JBScrollPane pane = new JBScrollPane((Component)((Object)this.myPanel));
            pane.setBorder((Border)JBUI.Borders.empty());
            JBScrollPane jBScrollPane = pane;
            if (jBScrollPane == null) {
                SearchResultInfo.$$$reportNull$$$0(1);
            }
            return jBScrollPane;
        }

        public void setQuery(@NotNull String query) {
            if (query == null) {
                SearchResultInfo.$$$reportNull$$$0(2);
            }
            if (this.myRunQuery != null) {
                this.myRunQuery.set(false);
                this.myRunQuery = null;
                this.myPanel.stopLoading();
            }
            if (this.myInstalledGroup != null) {
                this.removeGroup(this.myInstalledGroup);
                this.myInstalledGroup = null;
            }
            if (this.myRepositoryGroup != null) {
                this.removeGroup(this.myRepositoryGroup);
                this.myRepositoryGroup = null;
            }
            this.handleQuery(query);
        }

        private void handleQuery(@NotNull String query) {
            if (query == null) {
                SearchResultInfo.$$$reportNull$$$0(3);
            }
            this.myQuery = query;
            String serverQuery = PluginManagerConfigurableNew.recognizeServerSearchQuery(query);
            if (serverQuery == null) {
                Pair groups = PluginManagerConfigurableNew.this.localSearchPlugins(query);
                this.myInstalledGroup = (PluginsGroup)groups.first;
                if (this.myInstalledGroup != null) {
                    this.myInstalledPanel.addGroup(this.myInstalledGroup);
                    this.myInstalledGroup.titleWithCount();
                    this.myInstalledPanel.setVisible(true);
                    this.myInstalledPanel.initialSelection();
                }
                this.myRepositoryGroup = (PluginsGroup)groups.second;
                if (this.myRepositoryGroup != null) {
                    this.myRepositoryPanel.addGroup(this.myRepositoryGroup);
                    this.myRepositoryGroup.titleWithCount();
                    this.myRepositoryPanel.setVisible(true);
                }
                if (this.myInstalledGroup != null || this.myRepositoryGroup != null) {
                    this.myPanel.scrollToBegin();
                }
                this.myPanel.doLayout();
            } else {
                this.myPanel.startLoading();
                AtomicBoolean runQuery = this.myRunQuery = new AtomicBoolean(true);
                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    PluginsGroup group = new PluginsGroup("Search Result");
                    try {
                        for (String pluginId : PluginManagerConfigurableNew.requestToPluginRepository(PluginManagerConfigurableNew.createSearchUrl(serverQuery, 10000), PluginManagerConfigurableNew.forceHttps())) {
                            IdeaPluginDescriptor descriptor2 = (IdeaPluginDescriptor)PluginManagerConfigurableNew.this.myJBRepositoryMap.get(pluginId);
                            if (descriptor2 == null) continue;
                            group.descriptors.add(descriptor2);
                        }
                    }
                    catch (IOException e) {
                        PluginManagerMain.LOG.info((Throwable)e);
                    }
                    finally {
                        ApplicationManager.getApplication().invokeLater(() -> {
                            if (!runQuery.get()) {
                                return;
                            }
                            this.myRunQuery = null;
                            this.myPanel.stopLoading();
                            if (!group.descriptors.isEmpty()) {
                                this.myRepositoryPanel.addGroup(group);
                                group.titleWithCount();
                                this.myRepositoryGroup = group;
                                this.myRepositoryPanel.setVisible(true);
                                this.myPanel.scrollToBegin();
                            }
                            this.myPanel.doLayout();
                        }, ModalityState.any());
                    }
                });
            }
        }

        public void close() {
            if (this.myRunQuery != null) {
                this.myRunQuery.set(false);
                this.myRunQuery = null;
            }
            if (this.myInstalledGroup != null) {
                this.closeGroup(this.myInstalledGroup);
                this.myInstalledGroup = null;
            }
            if (this.myRepositoryGroup != null) {
                this.closeGroup(this.myRepositoryGroup);
                this.myRepositoryGroup = null;
            }
        }

        private void removeGroup(@NotNull PluginsGroup group) {
            if (group == null) {
                SearchResultInfo.$$$reportNull$$$0(4);
            }
            this.closeGroup(group);
            this.myRepositoryPanel.removeGroup(group);
            this.myRepositoryPanel.setVisible(false);
        }

        private void closeGroup(@NotNull PluginsGroup group) {
            if (group == null) {
                SearchResultInfo.$$$reportNull$$$0(5);
            }
            if (group.ui == null) {
                return;
            }
            for (CellPluginComponent component : group.ui.plugins) {
                component.close();
            }
        }

        public void setText() {
            PluginManagerConfigurableNew.this.setSearchTextIgnoreEvents(this.myQuery);
        }

        public void clearText() {
            PluginManagerConfigurableNew.this.setSearchTextIgnoreEvents("");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "query";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/plugins/PluginManagerConfigurableNew$SearchResultInfo";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "group";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurableNew$SearchResultInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createScrollPane";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setQuery";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "handleQuery";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "removeGroup";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "closeGroup";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PluginsGridLayout
    extends AbstractLayoutManager {
        private final int myFirstVOffset = JBUI.scale((int)10);
        private final int myMiddleVOffset = JBUI.scale((int)20);
        private final int myLastVOffset = JBUI.scale((int)30);
        private final int myMiddleHOffset = JBUI.scale((int)20);
        private final Dimension myCellSize = new Dimension();

        private PluginsGridLayout() {
        }

        public Dimension preferredLayoutSize(@NotNull Container parent) {
            if (parent == null) {
                PluginsGridLayout.$$$reportNull$$$0(0);
            }
            this.calculateCellSize(parent);
            int width = PluginManagerConfigurableNew.getParentWidth(parent);
            int cellWidth = this.myCellSize.width;
            int columns = width / (cellWidth + this.myMiddleHOffset);
            if (columns < 2) {
                columns = 2;
            }
            width = columns * (cellWidth + this.myMiddleHOffset) - this.myMiddleHOffset;
            int height = 0;
            int cellHeight = this.myCellSize.height;
            List groups = ((PluginsGroupComponent)((Object)parent)).myGroups;
            for (UIPluginGroup group : groups) {
                int rows;
                height += group.panel.getPreferredSize().height;
                int plugins2 = group.plugins.size();
                if (plugins2 <= columns) {
                    rows = 1;
                } else {
                    rows = plugins2 / columns;
                    if (plugins2 > rows * columns) {
                        ++rows;
                    }
                }
                height += this.myFirstVOffset + rows * (cellHeight + this.myMiddleVOffset) - this.myMiddleVOffset + this.myLastVOffset;
            }
            return new Dimension(width, height);
        }

        public void layoutContainer(@NotNull Container parent) {
            if (parent == null) {
                PluginsGridLayout.$$$reportNull$$$0(1);
            }
            this.calculateCellSize(parent);
            List groups = ((PluginsGroupComponent)((Object)parent)).myGroups;
            int width = parent.getWidth();
            int y = 0;
            int columns = Math.max(1, width / (this.myCellSize.width + this.myMiddleHOffset));
            for (UIPluginGroup group : groups) {
                Component component = group.panel;
                int height = component.getPreferredSize().height;
                component.setBounds(0, y, width, height);
                y += height + this.myFirstVOffset;
                y += this.layoutPlugins(group.plugins, y, columns);
            }
        }

        private void calculateCellSize(@NotNull Container parent) {
            if (parent == null) {
                PluginsGridLayout.$$$reportNull$$$0(2);
            }
            this.myCellSize.width = 0;
            this.myCellSize.height = 0;
            List groups = ((PluginsGroupComponent)((Object)parent)).myGroups;
            for (UIPluginGroup group : groups) {
                for (CellPluginComponent plugin : group.plugins) {
                    plugin.doLayout();
                    Dimension size = plugin.getPreferredSize();
                    this.myCellSize.width = Math.max(this.myCellSize.width, size.width);
                    this.myCellSize.height = Math.max(this.myCellSize.height, size.height);
                }
            }
        }

        private int layoutPlugins(@NotNull List<CellPluginComponent> plugins2, int startY, int columns) {
            if (plugins2 == null) {
                PluginsGridLayout.$$$reportNull$$$0(3);
            }
            int x = 0;
            int y = 0;
            int width = this.myCellSize.width;
            int height = this.myCellSize.height;
            int column = 0;
            int size = plugins2.size();
            int last = size - 1;
            for (int i = 0; i < size; ++i) {
                plugins2.get(i).setBounds(x, startY + y, width, height);
                x += width + this.myMiddleHOffset;
                if (++column != columns && i != last) continue;
                x = 0;
                y += height + this.myMiddleVOffset;
                column = 0;
            }
            return y += this.myLastVOffset - this.myMiddleVOffset;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "plugins";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurableNew$PluginsGridLayout";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "preferredLayoutSize";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "layoutContainer";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "calculateCellSize";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "layoutPlugins";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PluginsListLayout
    extends AbstractLayoutManager {
        private int myLineHeight;

        private PluginsListLayout() {
        }

        public Dimension preferredLayoutSize(@NotNull Container parent) {
            if (parent == null) {
                PluginsListLayout.$$$reportNull$$$0(0);
            }
            this.calculateLineHeight(parent);
            List groups = ((PluginsGroupComponent)((Object)parent)).myGroups;
            int height = 0;
            for (UIPluginGroup group : groups) {
                height += group.panel.getPreferredSize().height;
                height += group.plugins.size() * this.myLineHeight;
            }
            return new Dimension(0, height);
        }

        public void layoutContainer(@NotNull Container parent) {
            if (parent == null) {
                PluginsListLayout.$$$reportNull$$$0(1);
            }
            this.calculateLineHeight(parent);
            List groups = ((PluginsGroupComponent)((Object)parent)).myGroups;
            int width = parent.getWidth();
            int y = 0;
            for (UIPluginGroup group : groups) {
                Component component = group.panel;
                int height = component.getPreferredSize().height;
                component.setBounds(0, y, width, height);
                y += height;
                for (CellPluginComponent plugin : group.plugins) {
                    plugin.setBounds(0, y, width, this.myLineHeight);
                    y += this.myLineHeight;
                }
            }
        }

        private void calculateLineHeight(@NotNull Container parent) {
            if (parent == null) {
                PluginsListLayout.$$$reportNull$$$0(2);
            }
            List groups = ((PluginsGroupComponent)((Object)parent)).myGroups;
            int width = PluginManagerConfigurableNew.getParentWidth(parent) - parent.getInsets().right;
            this.myLineHeight = 0;
            for (UIPluginGroup group : groups) {
                for (CellPluginComponent plugin : group.plugins) {
                    JEditorPane description = plugin.myDescription;
                    if (description != null) {
                        plugin.doLayout();
                        int parentWidth = width - SwingUtilities.convertPoint((Component)description.getParent(), (Point)description.getLocation(), (Component)plugin).x;
                        if (parentWidth > 0) {
                            description.putClientProperty("parent.width", new Integer(parentWidth));
                        }
                    }
                    plugin.doLayout();
                    this.myLineHeight = Math.max(this.myLineHeight, plugin.getPreferredSize().height);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "parent";
            objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurableNew$PluginsListLayout";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "preferredLayoutSize";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "layoutContainer";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "calculateLineHeight";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MultiSelectionEventHandler
    extends EventHandler {
        private PluginsGroupComponent myContainer;
        private PluginsListLayout myLayout;
        private List<CellPluginComponent> myComponents;
        private CellPluginComponent myHoverComponent;
        private int mySelectionIndex;
        private int mySelectionLength;
        private final MouseAdapter myMouseHandler;
        private final KeyListener myKeyListener;
        private final FocusListener myFocusListener;
        private final ShortcutSet mySelectAllKeys;
        private boolean myAllSelected;
        private boolean myMixSelection;

        public MultiSelectionEventHandler() {
            this.clear();
            this.myMouseHandler = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent event) {
                    if (SwingUtilities.isLeftMouseButton(event)) {
                        CellPluginComponent component = CellPluginComponent.get(event);
                        int index = this.getIndex(component);
                        if (event.isShiftDown()) {
                            int end = mySelectionIndex + mySelectionLength + (mySelectionLength > 0 ? -1 : 1);
                            if (index != end) {
                                this.moveOrResizeSelection(index < end, false, Math.abs(end - index));
                            }
                        } else if (event.isMetaDown()) {
                            myMixSelection = true;
                            myAllSelected = false;
                            mySelectionIndex = index;
                            mySelectionLength = 1;
                            component.setSelection(component.getSelection() == SelectionType.SELECTION ? SelectionType.NONE : SelectionType.SELECTION, true);
                        } else {
                            this.clearSelectionWithout(index);
                            this.singleSelection(component, index);
                        }
                    } else if (SwingUtilities.isRightMouseButton(event)) {
                        CellPluginComponent component = CellPluginComponent.get(event);
                        if (myAllSelected || myMixSelection) {
                            int size = this.getSelection().size();
                            if (size == 0) {
                                this.singleSelection(component, this.getIndex(component));
                            } else if (size == 1) {
                                this.ensureMoveSingleSelection(component);
                            }
                        } else if (mySelectionLength == 0 || mySelectionLength == 1) {
                            this.ensureMoveSingleSelection(component);
                        }
                        DefaultActionGroup group = new DefaultActionGroup();
                        component.createPopupMenu(group, this.getSelection());
                        if (group.getChildrenCount() == 0) {
                            return;
                        }
                        ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("unknown", (ActionGroup)group);
                        popupMenu.setTargetComponent((JComponent)component);
                        popupMenu.getComponent().show(event.getComponent(), event.getX(), event.getY());
                        event.consume();
                    }
                }

                @Override
                public void mouseExited(MouseEvent event) {
                    if (myHoverComponent != null) {
                        if (myHoverComponent.getSelection() == SelectionType.HOVER) {
                            myHoverComponent.setSelection(SelectionType.NONE);
                        }
                        myHoverComponent = null;
                    }
                }

                @Override
                public void mouseMoved(MouseEvent event) {
                    CellPluginComponent component;
                    if (myHoverComponent == null && (component = CellPluginComponent.get(event)).getSelection() == SelectionType.NONE) {
                        myHoverComponent = component;
                        component.setSelection(SelectionType.HOVER);
                    }
                }
            };
            this.mySelectAllKeys = MultiSelectionEventHandler.getShortcuts("$SelectAll");
            this.myKeyListener = new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent event) {
                    int modifiers;
                    int code = event.getKeyCode();
                    KeyboardShortcut shortcut = new KeyboardShortcut(KeyStroke.getKeyStroke(code, modifiers = event.getModifiers()), null);
                    if (MultiSelectionEventHandler.check(shortcut, mySelectAllKeys)) {
                        event.consume();
                        this.selectAll();
                        return;
                    }
                    if (code == 36 || code == 35) {
                        if (myComponents.isEmpty()) {
                            return;
                        }
                        event.consume();
                        if (event.isShiftDown()) {
                            this.moveOrResizeSelection(code == 36, false, 2 * myComponents.size());
                        } else {
                            int index = code == 36 ? 0 : myComponents.size() - 1;
                            this.clearSelectionWithout(index);
                            this.singleSelection(index);
                        }
                    } else if (code == 38 || code == 40) {
                        event.consume();
                        if (modifiers == 0) {
                            this.moveOrResizeSelection(code == 38, true, 1);
                        } else if (modifiers == 1) {
                            this.moveOrResizeSelection(code == 38, false, 1);
                        }
                    } else if (code == 33 || code == 34) {
                        if (myComponents.isEmpty()) {
                            return;
                        }
                        event.consume();
                        int pageCount = ((MultiSelectionEventHandler)this).myContainer.getVisibleRect().height / myLayout.myLineHeight;
                        this.moveOrResizeSelection(code == 33, !event.isShiftDown(), pageCount);
                    } else if (code == 32 || code == 10 || code == 8) {
                        assert (mySelectionLength != 0);
                        CellPluginComponent component = (CellPluginComponent)myComponents.get(mySelectionIndex);
                        if (component.getSelection() != SelectionType.SELECTION) {
                            component.setSelection(SelectionType.SELECTION);
                        }
                        component.handleKeyAction(code, this.getSelection());
                    }
                }
            };
            this.myFocusListener = new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent event) {
                    if (mySelectionIndex >= 0 && mySelectionLength == 1 && !myMixSelection) {
                        CellPluginComponent component = CellPluginComponent.get(event);
                        int index = this.getIndex(component);
                        if (mySelectionIndex != index) {
                            this.clearSelectionWithout(index);
                            this.singleSelection(component, index);
                        }
                    }
                }
            };
        }

        @Nullable
        private static ShortcutSet getShortcuts(@NotNull String id) {
            AnAction action;
            if (id == null) {
                MultiSelectionEventHandler.$$$reportNull$$$0(0);
            }
            return (action = ActionManager.getInstance().getAction(id)) == null ? null : action.getShortcutSet();
        }

        private static boolean check(@NotNull KeyboardShortcut shortcut, @Nullable ShortcutSet set2) {
            if (shortcut == null) {
                MultiSelectionEventHandler.$$$reportNull$$$0(1);
            }
            if (set2 != null) {
                for (Shortcut test : set2.getShortcuts()) {
                    if (!test.isKeyboard() || !shortcut.startsWith(test)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public void connect(@NotNull PluginsGroupComponent container) {
            if (container == null) {
                MultiSelectionEventHandler.$$$reportNull$$$0(2);
            }
            this.myContainer = container;
            this.myLayout = (PluginsListLayout)((Object)container.getLayout());
        }

        @Override
        public void addCell(@NotNull CellPluginComponent component, int index) {
            if (component == null) {
                MultiSelectionEventHandler.$$$reportNull$$$0(3);
            }
            if (index == -1) {
                this.myComponents.add(component);
            } else {
                this.myComponents.add(index, component);
            }
        }

        @Override
        public void addCell(@NotNull CellPluginComponent component, @Nullable CellPluginComponent anchor2) {
            if (component == null) {
                MultiSelectionEventHandler.$$$reportNull$$$0(4);
            }
            if (anchor2 == null) {
                this.myComponents.add(component);
            } else {
                this.myComponents.add(this.myComponents.indexOf(anchor2), component);
            }
        }

        @Override
        public void removeCell(@NotNull CellPluginComponent component) {
            if (component == null) {
                MultiSelectionEventHandler.$$$reportNull$$$0(5);
            }
            this.myComponents.remove(component);
        }

        @Override
        public void initialSelection() {
            if (!this.myComponents.isEmpty()) {
                this.singleSelection(0);
            }
        }

        @NotNull
        private List<CellPluginComponent> getSelection() {
            ArrayList<CellPluginComponent> selection = new ArrayList<CellPluginComponent>();
            for (CellPluginComponent component : this.myComponents) {
                if (component.getSelection() != SelectionType.SELECTION) continue;
                selection.add(component);
            }
            ArrayList<CellPluginComponent> arrayList = selection;
            if (arrayList == null) {
                MultiSelectionEventHandler.$$$reportNull$$$0(6);
            }
            return arrayList;
        }

        @Override
        public void clear() {
            this.myComponents = new ArrayList<CellPluginComponent>();
            this.myHoverComponent = null;
            this.mySelectionIndex = -1;
            this.mySelectionLength = 0;
            this.myAllSelected = false;
            this.myMixSelection = false;
        }

        private void selectAll() {
            if (this.myAllSelected) {
                return;
            }
            this.myAllSelected = true;
            this.myMixSelection = false;
            this.myHoverComponent = null;
            for (CellPluginComponent component : this.myComponents) {
                if (component.getSelection() == SelectionType.SELECTION) continue;
                component.setSelection(SelectionType.SELECTION, false);
            }
        }

        private void moveOrResizeSelection(boolean up, boolean singleSelection, int count) {
            block9: {
                block12: {
                    block10: {
                        block11: {
                            block8: {
                                if (!singleSelection) break block8;
                                assert (this.mySelectionLength != 0);
                                int index = this.mySelectionLength > 0 ? (up ? Math.max(this.mySelectionIndex + this.mySelectionLength - 1 - count, 0) : Math.min(this.mySelectionIndex + this.mySelectionLength - 1 + count, this.myComponents.size() - 1)) : (up ? Math.max(this.mySelectionIndex + this.mySelectionLength + 1 - count, 0) : Math.min(this.mySelectionIndex + this.mySelectionLength + 1 + count, this.myComponents.size() - 1));
                                this.clearSelectionWithout(index);
                                this.singleSelection(index);
                                break block9;
                            }
                            if (!up) break block10;
                            if (this.mySelectionLength <= 0) break block11;
                            if (this.mySelectionIndex + this.mySelectionLength - 1 <= 0) break block9;
                            this.clearAllOrMixSelection();
                            for (int i = 0; i < count && this.mySelectionIndex + this.mySelectionLength - 1 > 0; ++i) {
                                --this.mySelectionLength;
                                if (this.mySelectionLength > 0) {
                                    this.myComponents.get(this.mySelectionIndex + this.mySelectionLength).setSelection(SelectionType.NONE, true);
                                }
                                if (this.mySelectionLength != 0) continue;
                                this.myComponents.get(this.mySelectionIndex - 1).setSelection(SelectionType.SELECTION);
                                this.mySelectionLength = -2;
                                int newCount = count - i - 1;
                                if (newCount > 0) {
                                    this.moveOrResizeSelection(true, false, newCount);
                                }
                                return;
                            }
                            break block9;
                        }
                        if (this.mySelectionIndex + this.mySelectionLength + 1 <= 0) break block9;
                        this.clearAllOrMixSelection();
                        int i = 0;
                        for (int index = this.mySelectionIndex + this.mySelectionLength + 1; i < count && index > 0; ++i, --index) {
                            --this.mySelectionLength;
                            this.myComponents.get(index - 1).setSelection(SelectionType.SELECTION);
                        }
                        break block9;
                    }
                    if (this.mySelectionLength <= 0) break block12;
                    if (this.mySelectionIndex + this.mySelectionLength >= this.myComponents.size()) break block9;
                    this.clearAllOrMixSelection();
                    int i = 0;
                    int size = this.myComponents.size();
                    for (int index = this.mySelectionIndex + this.mySelectionLength; i < count && index < size; ++i, ++index) {
                        this.myComponents.get(index).setSelection(SelectionType.SELECTION);
                        ++this.mySelectionLength;
                    }
                    break block9;
                }
                this.clearAllOrMixSelection();
                for (int i = 0; i < count; ++i) {
                    ++this.mySelectionLength;
                    this.myComponents.get(this.mySelectionIndex + this.mySelectionLength).setSelection(SelectionType.NONE, true);
                    if (this.mySelectionLength != -1) continue;
                    this.mySelectionLength = 1;
                    int newCount = count - i - 1;
                    if (newCount > 0) {
                        this.moveOrResizeSelection(false, false, newCount);
                    }
                    return;
                }
            }
        }

        private int getIndex(@NotNull CellPluginComponent component) {
            if (component == null) {
                MultiSelectionEventHandler.$$$reportNull$$$0(7);
            }
            int index = this.myComponents.indexOf(component);
            assert (index >= 0) : component;
            return index;
        }

        private void clearAllOrMixSelection() {
            int i;
            int last;
            int first;
            CellPluginComponent component;
            if (!this.myAllSelected && !this.myMixSelection) {
                return;
            }
            if (this.myMixSelection && this.mySelectionIndex != -1 && (component = this.myComponents.get(this.mySelectionIndex)).getSelection() != SelectionType.SELECTION) {
                component.setSelection(SelectionType.SELECTION);
            }
            this.myAllSelected = false;
            this.myMixSelection = false;
            if (this.mySelectionLength > 0) {
                first = this.mySelectionIndex;
                last = this.mySelectionIndex + this.mySelectionLength;
            } else {
                first = this.mySelectionIndex + this.mySelectionLength + 1;
                last = this.mySelectionIndex + 1;
            }
            for (i = 0; i < first; ++i) {
                CellPluginComponent component2 = this.myComponents.get(i);
                if (component2.getSelection() != SelectionType.SELECTION) continue;
                component2.setSelection(SelectionType.NONE);
            }
            int size = this.myComponents.size();
            for (i = last; i < size; ++i) {
                CellPluginComponent component3 = this.myComponents.get(i);
                if (component3.getSelection() != SelectionType.SELECTION) continue;
                component3.setSelection(SelectionType.NONE);
            }
        }

        private void clearSelectionWithout(int withoutIndex) {
            this.myAllSelected = false;
            this.myMixSelection = false;
            int size = this.myComponents.size();
            for (int i = 0; i < size; ++i) {
                CellPluginComponent component;
                if (i == withoutIndex || (component = this.myComponents.get(i)).getSelection() != SelectionType.SELECTION) continue;
                component.setSelection(SelectionType.NONE);
            }
        }

        private void ensureMoveSingleSelection(CellPluginComponent component) {
            int index = this.getIndex(component);
            if (this.mySelectionLength == 0 || this.mySelectionIndex != index) {
                this.clearSelectionWithout(index);
                this.singleSelection(component, index);
            }
        }

        @Override
        public void setSelection(@NotNull CellPluginComponent component) {
            if (component == null) {
                MultiSelectionEventHandler.$$$reportNull$$$0(8);
            }
            this.clearSelectionWithout(-1);
            this.singleSelection(component, this.getIndex(component));
        }

        private void singleSelection(int index) {
            this.singleSelection(this.myComponents.get(index), index);
        }

        private void singleSelection(@NotNull CellPluginComponent component, int index) {
            if (component == null) {
                MultiSelectionEventHandler.$$$reportNull$$$0(9);
            }
            this.mySelectionIndex = index;
            this.mySelectionLength = 1;
            if (this.myHoverComponent == component) {
                this.myHoverComponent = null;
            }
            if (component.getSelection() != SelectionType.SELECTION) {
                component.setSelection(SelectionType.SELECTION);
            }
        }

        @Override
        public void add(@NotNull Component component) {
            if (component == null) {
                MultiSelectionEventHandler.$$$reportNull$$$0(10);
            }
            component.addMouseListener(this.myMouseHandler);
            component.addMouseMotionListener(this.myMouseHandler);
            component.addKeyListener(this.myKeyListener);
            component.addFocusListener(this.myFocusListener);
        }

        @Override
        public void addAll(@NotNull Component component) {
            if (component == null) {
                MultiSelectionEventHandler.$$$reportNull$$$0(11);
            }
            this.add(component);
            for (Component child : UIUtil.uiChildren((Component)component)) {
                this.addAll(child);
            }
        }

        @Override
        public void updateHover(@NotNull CellPluginComponent component) {
            if (component == null) {
                MultiSelectionEventHandler.$$$reportNull$$$0(12);
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                if (component == null) {
                    MultiSelectionEventHandler.$$$reportNull$$$0(13);
                }
                this.myHoverComponent = component;
                if (component.getSelection() == SelectionType.NONE) {
                    component.setSelection(SelectionType.HOVER);
                }
            }, ModalityState.any());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "shortcut";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "container";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/plugins/PluginManagerConfigurableNew$MultiSelectionEventHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurableNew$MultiSelectionEventHandler";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSelection";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getShortcuts";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "check";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "connect";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "addCell";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "removeCell";
                    break;
                }
                case 6: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getIndex";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelection";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "singleSelection";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "add";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "addAll";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "updateHover";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$updateHover$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class EventHandler {
        public static final EventHandler EMPTY = new EventHandler();

        private EventHandler() {
        }

        public void connect(@NotNull PluginsGroupComponent container) {
            if (container == null) {
                EventHandler.$$$reportNull$$$0(0);
            }
        }

        public void addCell(@NotNull CellPluginComponent component, int index) {
            if (component == null) {
                EventHandler.$$$reportNull$$$0(1);
            }
        }

        public void addCell(@NotNull CellPluginComponent component, @Nullable CellPluginComponent anchor2) {
            if (component == null) {
                EventHandler.$$$reportNull$$$0(2);
            }
        }

        public void removeCell(@NotNull CellPluginComponent component) {
            if (component == null) {
                EventHandler.$$$reportNull$$$0(3);
            }
        }

        public void add(@NotNull Component component) {
            if (component == null) {
                EventHandler.$$$reportNull$$$0(4);
            }
        }

        public void addAll(@NotNull Component component) {
            if (component == null) {
                EventHandler.$$$reportNull$$$0(5);
            }
        }

        public void updateHover(@NotNull CellPluginComponent component) {
            if (component == null) {
                EventHandler.$$$reportNull$$$0(6);
            }
        }

        public void initialSelection() {
        }

        public void setSelection(@NotNull CellPluginComponent component) {
            if (component == null) {
                EventHandler.$$$reportNull$$$0(7);
            }
        }

        public void clear() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "container";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurableNew$EventHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "connect";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addCell";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removeCell";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "add";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addAll";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateHover";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelection";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PanelWithProgress
    extends JBPanelWithEmptyText {
        private AsyncProcessIcon myIcon;

        public PanelWithProgress(@NotNull String emptyText) {
            if (emptyText == null) {
                PanelWithProgress.$$$reportNull$$$0(0);
            }
            this.myIcon = new AsyncProcessIcon.Big("Panel.Loading"){

                @NotNull
                protected Rectangle calculateBounds(@NotNull JComponent container) {
                    if (container == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    Dimension size = container.getSize();
                    Dimension iconSize = this.getPreferredSize();
                    Rectangle rectangle = new Rectangle((size.width - iconSize.width) / 2, (size.height - iconSize.height) / 2, iconSize.width, iconSize.height);
                    if (rectangle == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return rectangle;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "container";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/ide/plugins/PluginManagerConfigurableNew$PanelWithProgress$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurableNew$PanelWithProgress$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "calculateBounds";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "calculateBounds";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
            this.getEmptyText().setText(emptyText);
        }

        public void addProgress() {
            this.myIcon.setOpaque(false);
            this.myIcon.setPaintPassiveIcon(false);
            this.add((Component)this.myIcon);
            this.stopLoading();
        }

        public void removeNotify() {
            super.removeNotify();
            if (this.myIcon != null && ScreenUtil.isStandardAddRemoveNotify((Component)((Object)this))) {
                this.remove((Component)this.myIcon);
                Disposer.dispose((Disposable)this.myIcon);
                this.myIcon = null;
            }
        }

        public void doLayout() {
            super.doLayout();
            if (this.myIcon != null) {
                this.myIcon.updateLocation((JComponent)((Object)this));
            }
        }

        public void paint(Graphics g) {
            super.paint(g);
            if (this.myIcon != null) {
                this.myIcon.updateLocation((JComponent)((Object)this));
            }
        }

        public void startLoading() {
            if (this.myIcon != null) {
                this.myIcon.setVisible(true);
                this.myIcon.resume();
                this.doLayout();
                this.revalidate();
                this.repaint();
            }
        }

        public void stopLoading() {
            if (this.myIcon != null) {
                this.myIcon.suspend();
                this.myIcon.setVisible(false);
                this.doLayout();
                this.revalidate();
                this.repaint();
            }
        }

        public void scrollToBegin() {
            SwingUtilities.invokeLater(() -> {
                if (this.getComponentCount() > 0) {
                    this.scrollRectToVisible(this.getComponent(0).getBounds());
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "emptyText", "com/intellij/ide/plugins/PluginManagerConfigurableNew$PanelWithProgress", "<init>"));
        }
    }

    private static class PluginsGroupComponentWithProgress
    extends PluginsGroupComponent {
        private AsyncProcessIcon myIcon;

        public PluginsGroupComponentWithProgress(@NotNull LayoutManager layout, @NotNull EventHandler eventHandler, @NotNull LinkListener<IdeaPluginDescriptor> listener2, @NotNull LinkListener<String> searchListener, @NotNull Function<IdeaPluginDescriptor, CellPluginComponent> function) {
            if (layout == null) {
                PluginsGroupComponentWithProgress.$$$reportNull$$$0(0);
            }
            if (eventHandler == null) {
                PluginsGroupComponentWithProgress.$$$reportNull$$$0(1);
            }
            if (listener2 == null) {
                PluginsGroupComponentWithProgress.$$$reportNull$$$0(2);
            }
            if (searchListener == null) {
                PluginsGroupComponentWithProgress.$$$reportNull$$$0(3);
            }
            if (function == null) {
                PluginsGroupComponentWithProgress.$$$reportNull$$$0(4);
            }
            super(layout, eventHandler, listener2, searchListener, function);
            this.myIcon = new AsyncProcessIcon.Big("Loading"){

                @NotNull
                protected Rectangle calculateBounds(@NotNull JComponent container) {
                    if (container == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    Dimension size = container.getSize();
                    Dimension iconSize = this.getPreferredSize();
                    Rectangle rectangle = new Rectangle((size.width - iconSize.width) / 2, (size.height - iconSize.height) / 2, iconSize.width, iconSize.height);
                    if (rectangle == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return rectangle;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "container";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/ide/plugins/PluginManagerConfigurableNew$PluginsGroupComponentWithProgress$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurableNew$PluginsGroupComponentWithProgress$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "calculateBounds";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "calculateBounds";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
            this.myIcon.setOpaque(false);
            this.myIcon.setPaintPassiveIcon(false);
            this.add((Component)this.myIcon);
            this.myIcon.resume();
        }

        public void removeNotify() {
            super.removeNotify();
            if (this.myIcon != null && ScreenUtil.isStandardAddRemoveNotify((Component)((Object)this))) {
                this.dispose();
            }
        }

        public void doLayout() {
            super.doLayout();
            if (this.myIcon != null) {
                this.myIcon.updateLocation((JComponent)((Object)this));
            }
        }

        public void paint(Graphics g) {
            super.paint(g);
            if (this.myIcon != null) {
                this.myIcon.updateLocation((JComponent)((Object)this));
            }
        }

        public void stopLoading() {
            if (this.myIcon != null) {
                this.myIcon.suspend();
                this.myIcon.setVisible(false);
                this.dispose();
                this.doLayout();
                this.revalidate();
                this.repaint();
            }
        }

        private void dispose() {
            this.remove((Component)this.myIcon);
            Disposer.dispose((Disposable)this.myIcon);
            this.myIcon = null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "layout";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "eventHandler";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "listener";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "searchListener";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "function";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ide/plugins/PluginManagerConfigurableNew$PluginsGroupComponentWithProgress";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PluginsGroupComponent
    extends JBPanelWithEmptyText {
        private final EventHandler myEventHandler;
        private final LinkListener<IdeaPluginDescriptor> myListener;
        private final LinkListener<String> mySearchListener;
        private final Function<IdeaPluginDescriptor, CellPluginComponent> myFunction;
        private final List<UIPluginGroup> myGroups;

        public PluginsGroupComponent(@NotNull LayoutManager layout, @NotNull EventHandler eventHandler, @NotNull LinkListener<IdeaPluginDescriptor> listener2, @NotNull LinkListener<String> searchListener, @NotNull Function<IdeaPluginDescriptor, CellPluginComponent> function) {
            if (layout == null) {
                PluginsGroupComponent.$$$reportNull$$$0(0);
            }
            if (eventHandler == null) {
                PluginsGroupComponent.$$$reportNull$$$0(1);
            }
            if (listener2 == null) {
                PluginsGroupComponent.$$$reportNull$$$0(2);
            }
            if (searchListener == null) {
                PluginsGroupComponent.$$$reportNull$$$0(3);
            }
            if (function == null) {
                PluginsGroupComponent.$$$reportNull$$$0(4);
            }
            super(layout);
            this.myGroups = new ArrayList<UIPluginGroup>();
            this.myEventHandler = eventHandler;
            this.myListener = listener2;
            this.mySearchListener = searchListener;
            this.myFunction = function;
            this.myEventHandler.connect(this);
            this.setOpaque(true);
            this.setBackground(MAIN_BG_COLOR);
        }

        public void clear() {
            this.myGroups.clear();
            this.myEventHandler.clear();
            this.removeAll();
        }

        public void setSelection(@NotNull CellPluginComponent component) {
            if (component == null) {
                PluginsGroupComponent.$$$reportNull$$$0(5);
            }
            this.myEventHandler.setSelection(component);
        }

        public void addGroup(@NotNull PluginsGroup group) {
            if (group == null) {
                PluginsGroupComponent.$$$reportNull$$$0(6);
            }
            this.addGroup(group, -1);
        }

        public void addGroup(@NotNull PluginsGroup group, int groupIndex) {
            int index;
            UIPluginGroup uiGroup;
            if (group == null) {
                PluginsGroupComponent.$$$reportNull$$$0(7);
            }
            group.ui = uiGroup = new UIPluginGroup();
            this.myGroups.add(groupIndex == -1 ? this.myGroups.size() : groupIndex, uiGroup);
            OpaquePanel panel2 = new OpaquePanel((LayoutManager)new BorderLayout(), (Color)new JBColor(0xF7F7F7, 4013889));
            panel2.setBorder((Border)JBUI.Borders.empty((int)4, (int)13));
            JLabel title = new JLabel(group.title);
            title.setForeground((Color)new JBColor(0x787878, 0x999999));
            panel2.add((Component)title, (Object)"West");
            group.titleLabel = title;
            if (group.rightAction != null) {
                panel2.add(group.rightAction, (Object)"East");
            }
            if (groupIndex == 0) {
                this.add((Component)panel2, 0);
                index = 1;
            } else if (groupIndex == -1) {
                this.add((Component)panel2);
                index = -1;
            } else {
                Component anchorPanel = this.myGroups.get((int)(groupIndex + 1)).panel;
                int components = this.getComponentCount();
                index = -1;
                for (int i = 0; i < components; ++i) {
                    if (this.getComponent(i) != anchorPanel) continue;
                    index = i;
                    break;
                }
                assert (index != -1);
                this.add((Component)panel2, index++);
            }
            uiGroup.panel = panel2;
            for (IdeaPluginDescriptor descriptor2 : group.descriptors) {
                CellPluginComponent pluginComponent = (CellPluginComponent)this.myFunction.fun((Object)descriptor2);
                uiGroup.plugins.add(pluginComponent);
                this.add(pluginComponent, index);
                this.myEventHandler.addCell(pluginComponent, index);
                pluginComponent.setListeners(this.myListener, this.mySearchListener, this.myEventHandler);
                if (index == -1) continue;
                ++index;
            }
        }

        public void addToGroup(@NotNull PluginsGroup group, @NotNull IdeaPluginDescriptor descriptor2) {
            if (group == null) {
                PluginsGroupComponent.$$$reportNull$$$0(8);
            }
            if (descriptor2 == null) {
                PluginsGroupComponent.$$$reportNull$$$0(9);
            }
            int index = group.addWithIndex(descriptor2);
            CellPluginComponent anchor2 = null;
            int uiIndex = -1;
            if (index == group.ui.plugins.size()) {
                int groupIndex = this.myGroups.indexOf(group.ui);
                if (groupIndex < this.myGroups.size() - 1) {
                    UIPluginGroup nextGroup = this.myGroups.get(groupIndex + 1);
                    anchor2 = nextGroup.plugins.get(0);
                    uiIndex = this.getComponentIndex(nextGroup.panel);
                }
            } else {
                anchor2 = group.ui.plugins.get(index);
                uiIndex = this.getComponentIndex(anchor2);
            }
            CellPluginComponent pluginComponent = (CellPluginComponent)this.myFunction.fun((Object)descriptor2);
            group.ui.plugins.add(index, pluginComponent);
            this.add(pluginComponent, uiIndex);
            this.myEventHandler.addCell(pluginComponent, anchor2);
            pluginComponent.setListeners(this.myListener, this.mySearchListener, this.myEventHandler);
        }

        public void removeGroup(@NotNull PluginsGroup group) {
            if (group == null) {
                PluginsGroupComponent.$$$reportNull$$$0(10);
            }
            this.myGroups.remove(group.ui);
            this.remove(group.ui.panel);
            for (CellPluginComponent plugin : group.ui.plugins) {
                this.remove(plugin);
                this.myEventHandler.removeCell(plugin);
            }
            group.ui = null;
            group.descriptors.clear();
            group.titleLabel = null;
            group.rightAction = null;
        }

        public void removeFromGroup(@NotNull PluginsGroup group, @NotNull IdeaPluginDescriptor descriptor2) {
            if (group == null) {
                PluginsGroupComponent.$$$reportNull$$$0(11);
            }
            if (descriptor2 == null) {
                PluginsGroupComponent.$$$reportNull$$$0(12);
            }
            int index = ContainerUtil.indexOf(group.ui.plugins, component -> {
                if (descriptor2 == null) {
                    PluginsGroupComponent.$$$reportNull$$$0(14);
                }
                return component.myPlugin == descriptor2;
            });
            assert (index != -1);
            CellPluginComponent component2 = group.ui.plugins.remove(index);
            this.remove(component2);
            this.myEventHandler.removeCell(component2);
            group.descriptors.remove(descriptor2);
        }

        private int getComponentIndex(@NotNull Component component) {
            if (component == null) {
                PluginsGroupComponent.$$$reportNull$$$0(13);
            }
            int components = this.getComponentCount();
            for (int i = 0; i < components; ++i) {
                if (this.getComponent(i) != component) continue;
                return i;
            }
            return -1;
        }

        public void initialSelection() {
            SwingUtilities.invokeLater(() -> {
                this.myEventHandler.initialSelection();
                if (this.getComponentCount() > 0) {
                    this.scrollRectToVisible(this.getComponent(0).getBounds());
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "layout";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "eventHandler";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listener";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "searchListener";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "function";
                    break;
                }
                case 5: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "group";
                    break;
                }
                case 9: 
                case 12: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurableNew$PluginsGroupComponent";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelection";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addGroup";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addToGroup";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removeGroup";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removeFromGroup";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getComponentIndex";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$removeFromGroup$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class SizeInfo {
        public int width;
        public Rectangle[] tabs;
        public int[] tabTitleX;
        public int toolbarX;

        private SizeInfo() {
        }
    }

    private static class CountTabName
    implements Computable<String> {
        private final TabHeaderComponent myTabComponent;
        private final String myBaseName;
        private int myCount;

        public CountTabName(@NotNull TabHeaderComponent component, @NotNull String baseName) {
            if (component == null) {
                CountTabName.$$$reportNull$$$0(0);
            }
            if (baseName == null) {
                CountTabName.$$$reportNull$$$0(1);
            }
            this.myCount = -1;
            this.myTabComponent = component;
            this.myBaseName = baseName;
        }

        public void setCount(int count) {
            if (this.myCount != count) {
                this.myCount = count;
                this.myTabComponent.update();
            }
        }

        public String compute() {
            return this.myCount == -1 ? this.myBaseName : this.myBaseName + " (" + this.myCount + ")";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "component";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "baseName";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ide/plugins/PluginManagerConfigurableNew$CountTabName";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class TabHeaderComponent
    extends JComponent {
        private final List<Computable<String>> myTabs;
        private final JComponent myToolbarComponent;
        private final TabHeaderListener myListener;
        private int mySelectionTab;
        private int myHoverTab;
        private SizeInfo mySizeInfo;
        private int myBaselineY;
        private Breadcrumbs myBreadcrumbs;

        public TabHeaderComponent(@NotNull DefaultActionGroup actions, @NotNull TabHeaderListener listener2) {
            if (actions == null) {
                TabHeaderComponent.$$$reportNull$$$0(0);
            }
            if (listener2 == null) {
                TabHeaderComponent.$$$reportNull$$$0(1);
            }
            this.myTabs = new ArrayList<Computable<String>>();
            this.mySelectionTab = -1;
            this.myHoverTab = -1;
            this.myListener = listener2;
            this.myToolbarComponent = PluginManagerConfigurableNew.createToolbar(actions);
            this.add(this.myToolbarComponent);
            this.setBackground(JBUI.CurrentTheme.ToolWindow.headerBackground());
            this.setOpaque(true);
            MouseAdapter mouseHandler = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent event) {
                    int tab;
                    if (SwingUtilities.isLeftMouseButton(event) && (tab = this.findTab(event)) != -1 && tab != mySelectionTab) {
                        mySelectionTab = tab;
                        myListener.selectionChanged(tab);
                        this.repaint();
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    if (myHoverTab != -1) {
                        myHoverTab = -1;
                        this.repaint();
                    }
                }

                @Override
                public void mouseMoved(MouseEvent event) {
                    int tab = this.findTab(event);
                    if (tab != -1 && tab != myHoverTab) {
                        myHoverTab = tab;
                        this.repaint();
                    }
                }
            };
            this.addMouseListener(mouseHandler);
            this.addMouseMotionListener(mouseHandler);
        }

        public void addTab(@NotNull String title) {
            if (title == null) {
                TabHeaderComponent.$$$reportNull$$$0(2);
            }
            this.addTab((Computable<String>)((Computable)() -> {
                if (title == null) {
                    TabHeaderComponent.$$$reportNull$$$0(5);
                }
                return title;
            }));
        }

        public void addTab(@NotNull Computable<String> titleComputable) {
            if (titleComputable == null) {
                TabHeaderComponent.$$$reportNull$$$0(3);
            }
            this.myTabs.add(titleComputable);
            this.update();
        }

        public void update() {
            this.mySizeInfo = null;
            this.revalidate();
            this.repaint();
        }

        public int getSelectionTab() {
            return this.mySelectionTab;
        }

        public void clearSelection() {
            this.setSelection(-1);
        }

        public void setSelection(int index) {
            this.mySelectionTab = index < 0 ? -1 : (index >= this.myTabs.size() ? this.myTabs.size() - 1 : index);
            this.repaint();
        }

        private int findTab(@NotNull MouseEvent event) {
            if (event == null) {
                TabHeaderComponent.$$$reportNull$$$0(4);
            }
            this.calculateSize();
            int x = this.getStartX();
            int height = this.getHeight();
            int eventX = event.getX();
            int eventY = event.getY();
            int size = this.myTabs.size();
            for (int i = 0; i < size; ++i) {
                Rectangle bounds = this.mySizeInfo.tabs[i];
                if (!new Rectangle(x + bounds.x, 0, bounds.width, height).contains(eventX, eventY)) continue;
                return i;
            }
            return -1;
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (g instanceof Graphics2D) {
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            this.calculateSize();
            FontMetrics fm = this.getFontMetrics(this.getFont());
            int x = this.getStartX();
            int height = this.getHeight();
            int tabTitleY = fm.getAscent() + (height - fm.getHeight()) / 2;
            if (this.myBreadcrumbs != null) {
                tabTitleY = this.myBaselineY + this.myBreadcrumbs.getBaseline();
            }
            int size = this.myTabs.size();
            for (int i = 0; i < size; ++i) {
                if (this.mySelectionTab == i || this.myHoverTab == i) {
                    Rectangle bounds = this.mySizeInfo.tabs[i];
                    g.setColor(this.mySelectionTab == i ? JBUI.CurrentTheme.ToolWindow.tabSelectedBackground() : JBUI.CurrentTheme.ToolWindow.tabHoveredBackground());
                    g.fillRect(x + bounds.x, 0, bounds.width, height);
                    g.setColor(this.getForeground());
                }
                g.drawString((String)this.myTabs.get(i).compute(), x + this.mySizeInfo.tabTitleX[i], tabTitleY);
            }
        }

        @Override
        public void setBounds(int x, int y, int width, int height) {
            this.myBaselineY = y;
            super.setBounds(x, 0, width, height += y);
            if (this.myBreadcrumbs == null) {
                this.myBreadcrumbs = (Breadcrumbs)UIUtil.findComponentOfType((JComponent)((JComponent)this.getParent()), Breadcrumbs.class);
            }
            this.calculateSize();
            Dimension size = this.myToolbarComponent.getPreferredSize();
            int toolbarX = this.getStartX() + this.mySizeInfo.toolbarX;
            int toolbarY = (height - size.height) / 2;
            this.myToolbarComponent.setBounds(toolbarX, toolbarY, size.width, size.height);
        }

        private int getStartX() {
            return (this.getParent().getWidth() - this.mySizeInfo.width) / 2 - this.getX();
        }

        @Override
        public Dimension getPreferredSize() {
            this.calculateSize();
            return new Dimension(this.mySizeInfo.width, JBUI.scale((int)30));
        }

        private void calculateSize() {
            if (this.mySizeInfo != null) {
                return;
            }
            this.mySizeInfo = new SizeInfo();
            int size = this.myTabs.size();
            this.mySizeInfo.tabs = new Rectangle[size];
            this.mySizeInfo.tabTitleX = new int[size];
            int offset = JBUI.scale((int)22);
            int x = 0;
            FontMetrics fm = this.getFontMetrics(this.getFont());
            for (int i = 0; i < size; ++i) {
                int tabWidth = offset + SwingUtilities2.stringWidth(null, fm, (String)this.myTabs.get(i).compute()) + offset;
                this.mySizeInfo.tabTitleX[i] = x + offset;
                this.mySizeInfo.tabs[i] = new Rectangle(x, 0, tabWidth, -1);
                x += tabWidth;
            }
            Dimension toolbarSize = this.myToolbarComponent.getPreferredSize();
            this.mySizeInfo.width = (x += JBUI.scale((int)10)) + toolbarSize.width;
            this.mySizeInfo.toolbarX = x;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actions";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listener";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "titleComputable";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurableNew$TabHeaderComponent";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addTab";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findTab";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$addTab$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static interface TabHeaderListener {
        public void selectionChanged(int var1);
    }
}

