/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.impl.common;

import com.intellij.ide.structureView.StructureViewExtension;
import com.intellij.ide.structureView.StructureViewFactoryEx;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.customRegions.CustomRegionStructureUtil;
import com.intellij.ide.util.treeView.AbstractTreeUi;
import com.intellij.ide.util.treeView.NodeDescriptorProvidingKey;
import com.intellij.ide.util.treeView.TreeAnchorizer;
import com.intellij.navigation.ItemPresentation;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiTreeElementBase<T extends PsiElement>
implements StructureViewTreeElement,
ItemPresentation,
NodeDescriptorProvidingKey {
    private final Object myValue;

    protected PsiTreeElementBase(T psiElement) {
        this.myValue = psiElement == null ? null : TreeAnchorizer.getService().createAnchor(psiElement);
    }

    @NotNull
    public ItemPresentation getPresentation() {
        PsiTreeElementBase psiTreeElementBase = this;
        if (psiTreeElementBase == null) {
            PsiTreeElementBase.$$$reportNull$$$0(0);
        }
        return psiTreeElementBase;
    }

    @NotNull
    public Object getKey() {
        String string = String.valueOf(this.getElement());
        if (string == null) {
            PsiTreeElementBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public final T getElement() {
        return (T)(this.myValue == null ? null : (PsiElement)TreeAnchorizer.getService().retrieveElement(this.myValue));
    }

    public Icon getIcon(boolean open2) {
        T element = this.getElement();
        if (element != null) {
            int flags = 2;
            if (!(element instanceof PsiFile) || !element.isWritable()) {
                flags |= 1;
            }
            return element.getIcon(flags);
        }
        return null;
    }

    public T getValue() {
        return this.getElement();
    }

    public String getLocationString() {
        return null;
    }

    public boolean isSearchInLocationString() {
        return false;
    }

    public String toString() {
        T element = this.getElement();
        return element != null ? element.toString() : "";
    }

    @NotNull
    public final StructureViewTreeElement[] getChildren() {
        StructureViewTreeElement[] structureViewTreeElementArray = (StructureViewTreeElement[])AbstractTreeUi.calculateYieldingToWriteAction(this::doGetChildren);
        if (structureViewTreeElementArray == null) {
            PsiTreeElementBase.$$$reportNull$$$0(2);
        }
        return structureViewTreeElementArray;
    }

    @NotNull
    private StructureViewTreeElement[] doGetChildren() {
        T element = this.getElement();
        if (element == null) {
            if (EMPTY_ARRAY == null) {
                PsiTreeElementBase.$$$reportNull$$$0(3);
            }
            return EMPTY_ARRAY;
        }
        StructureViewTreeElement[] structureViewTreeElementArray = PsiTreeElementBase.mergeWithExtensions(element, this.getChildrenBase());
        if (structureViewTreeElementArray == null) {
            PsiTreeElementBase.$$$reportNull$$$0(4);
        }
        return structureViewTreeElementArray;
    }

    public void navigate(boolean requestFocus) {
        T element = this.getElement();
        if (element != null) {
            ((Navigatable)element).navigate(requestFocus);
        }
    }

    public boolean canNavigate() {
        T element = this.getElement();
        return element instanceof Navigatable && ((Navigatable)element).canNavigate();
    }

    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    @NotNull
    public abstract Collection<StructureViewTreeElement> getChildrenBase();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PsiTreeElementBase that = (PsiTreeElementBase)o;
        T value = this.getValue();
        return value == null ? that.getValue() == null : value.equals(that.getValue());
    }

    public int hashCode() {
        T value = this.getValue();
        return value == null ? 0 : value.hashCode();
    }

    public boolean isValid() {
        return this.getElement() != null;
    }

    @NotNull
    public static StructureViewTreeElement[] mergeWithExtensions(@NotNull PsiElement element, @NotNull Collection<StructureViewTreeElement> baseChildren) {
        if (element == null) {
            PsiTreeElementBase.$$$reportNull$$$0(5);
        }
        if (baseChildren == null) {
            PsiTreeElementBase.$$$reportNull$$$0(6);
        }
        ArrayList<StructureViewTreeElement> result2 = new ArrayList<StructureViewTreeElement>(CustomRegionStructureUtil.groupByCustomRegions(element, baseChildren));
        StructureViewFactoryEx structureViewFactory = StructureViewFactoryEx.getInstanceEx(element.getProject());
        Class<?> aClass = element.getClass();
        for (StructureViewExtension extension : structureViewFactory.getAllExtensions(aClass)) {
            Object[] children2 = extension.getChildren(element);
            if (children2 == null) continue;
            ContainerUtil.addAll(result2, (Object[])children2);
        }
        StructureViewTreeElement[] structureViewTreeElementArray = result2.toArray(StructureViewTreeElement.EMPTY_ARRAY);
        if (structureViewTreeElementArray == null) {
            PsiTreeElementBase.$$$reportNull$$$0(7);
        }
        return structureViewTreeElementArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/structureView/impl/common/PsiTreeElementBase";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetChildren";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/structureView/impl/common/PsiTreeElementBase";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeWithExtensions";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "mergeWithExtensions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

