/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.focus;

import com.intellij.internal.focus.Util;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import java.awt.Color;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.util.ArrayList;
import javax.swing.JComponent;

public class DumpFocusableComponentHierarchyAction
extends AnAction
implements DumbAware {
    public void actionPerformed(AnActionEvent e) {
        Util.drawOnActiveFrameGraphics(g -> {
            Window activeWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
            Window focusedWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
            Component focusedComponent = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            int y = 0;
            int FONT_HEIGHT = 30;
            g.setColor(Color.BLACK);
            g.fillRect(0, 0, activeWindow.getBounds().width, activeWindow.getBounds().height);
            g.setColor(Color.WHITE);
            g.drawString("Active Window: " + activeWindow.getClass().getName(), 0, FONT_HEIGHT * y++);
            g.drawString("Focused Window: " + focusedWindow.getClass().getName(), 0, FONT_HEIGHT * y++);
            g.drawString("Focused Component: " + focusedComponent.getClass().getName(), 0, 60);
            ArrayList<Component> componentTrace = new ArrayList<Component>();
            for (Component c = focusedComponent; c != null; c = c.getParent()) {
                componentTrace.add(c);
            }
            ++y;
            for (int i = componentTrace.size() - 1; i >= 0; --i) {
                g.drawString(((Component)componentTrace.get(i)).getClass().getName(), 0, FONT_HEIGHT * y++);
                g.drawString("^", 0, FONT_HEIGHT * y + 15);
            }
            g.drawString("Children count in focused component: " + ((JComponent)focusedComponent).getComponentCount(), 0, FONT_HEIGHT * y);
        });
    }
}

