/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic;

import com.intellij.concurrency.JobScheduler;
import com.intellij.internal.statistic.AbstractProjectsUsagesCollector;
import com.intellij.internal.statistic.UsagesCollector;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.persistence.ApplicationStatisticsPersistence;
import com.intellij.internal.statistic.persistence.CollectedUsages;
import com.intellij.internal.statistic.utils.StatisticsUploadAssistant;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.BaseComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.THashSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@State(name="StatisticsApplicationUsages", storages={@Storage(value="usage.statistics.xml", roamingType=RoamingType.DISABLED), @Storage(value="statistics.application.usages.xml", roamingType=RoamingType.DISABLED, deprecated=true)})
public class ApplicationStatisticsPersistenceComponent
extends ApplicationStatisticsPersistence
implements PersistentStateComponent<Element>,
BaseComponent {
    private static final int DELAY_IN_MIN = 30;
    private static final Map<Project, Future> persistProjectStatisticsTasks = Collections.synchronizedMap(new HashMap());
    private static final String TOKENIZER = ",";
    @NonNls
    private static final String GROUP_TAG = "group";
    @NonNls
    private static final String GROUP_NAME_ATTR = "name";
    @NonNls
    private static final String PROJECT_TAG = "project";
    @NonNls
    private static final String COLLECTION_TIME_TAG = "collectionTime";
    @NonNls
    private static final String PROJECT_ID_ATTR = "id";
    @NonNls
    private static final String VALUES_ATTR = "values";

    public static ApplicationStatisticsPersistenceComponent getInstance() {
        return (ApplicationStatisticsPersistenceComponent)ApplicationManager.getApplication().getComponent(ApplicationStatisticsPersistenceComponent.class);
    }

    public void loadState(@NotNull Element element) {
        if (element == null) {
            ApplicationStatisticsPersistenceComponent.$$$reportNull$$$0(0);
        }
        for (Element groupElement : element.getChildren(GROUP_TAG)) {
            GroupDescriptor groupDescriptor = GroupDescriptor.create(groupElement.getAttributeValue(GROUP_NAME_ATTR));
            List projectsList = groupElement.getChildren(PROJECT_TAG);
            for (Element projectElement : projectsList) {
                long collectionTime;
                String projectId = projectElement.getAttributeValue(PROJECT_ID_ATTR);
                String frameworks = projectElement.getAttributeValue(VALUES_ATTR);
                if (StringUtil.isEmptyOrSpaces((String)projectId) || StringUtil.isEmptyOrSpaces((String)frameworks)) continue;
                THashSet frameworkDescriptors = new THashSet();
                for (String key : StringUtil.split((String)frameworks, (String)TOKENIZER)) {
                    UsageDescriptor descriptor2 = ApplicationStatisticsPersistenceComponent.getUsageDescriptor(key);
                    if (descriptor2 == null) continue;
                    frameworkDescriptors.add(descriptor2);
                }
                try {
                    collectionTime = Long.valueOf(projectElement.getAttributeValue(COLLECTION_TIME_TAG));
                }
                catch (NumberFormatException ignored) {
                    collectionTime = 0L;
                }
                this.getApplicationData(groupDescriptor).put(projectId, new CollectedUsages((Set<UsageDescriptor>)frameworkDescriptors, collectionTime));
            }
        }
    }

    public Element getState() {
        Element element = new Element("state");
        for (Map.Entry<GroupDescriptor, Map<String, CollectedUsages>> appData : this.getApplicationData().entrySet()) {
            Element groupElement = new Element(GROUP_TAG);
            groupElement.setAttribute(GROUP_NAME_ATTR, appData.getKey().getId());
            boolean isEmptyGroup = true;
            for (Map.Entry<String, CollectedUsages> projectData : appData.getValue().entrySet()) {
                Element projectElement = new Element(PROJECT_TAG);
                projectElement.setAttribute(PROJECT_ID_ATTR, projectData.getKey());
                CollectedUsages projectDataValue = projectData.getValue();
                if (projectDataValue.usages.isEmpty()) continue;
                projectElement.setAttribute(VALUES_ATTR, ApplicationStatisticsPersistenceComponent.joinUsages(projectDataValue.usages));
                projectElement.setAttribute(COLLECTION_TIME_TAG, String.valueOf(projectDataValue.collectionTime));
                groupElement.addContent(projectElement);
                isEmptyGroup = false;
            }
            if (isEmptyGroup) continue;
            element.addContent(groupElement);
        }
        return element;
    }

    private static UsageDescriptor getUsageDescriptor(String usage) {
        try {
            int i = usage.indexOf(61);
            if (i > 0 && i < usage.length() - 1) {
                String key = usage.substring(0, i).trim();
                String value = usage.substring(i + 1).trim();
                if (!StringUtil.isEmptyOrSpaces((String)key) && !StringUtil.isEmptyOrSpaces((String)value)) {
                    try {
                        int count = Integer.parseInt(value);
                        if (count > 0) {
                            return new UsageDescriptor(key, count);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            return new UsageDescriptor(usage, 1);
        }
        catch (AssertionError assertionError) {
            return null;
        }
    }

    private static String joinUsages(@NotNull Set<UsageDescriptor> usages) {
        if (usages == null) {
            ApplicationStatisticsPersistenceComponent.$$$reportNull$$$0(1);
        }
        return StringUtil.join(usages, usageDescriptor -> {
            String key = usageDescriptor.getKey();
            int value = usageDescriptor.getValue();
            return value != 1 ? key + "=" + value : key;
        }, (String)TOKENIZER);
    }

    public void initComponent() {
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect();
        connection.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectOpened(Project project) {
                ScheduledFuture<?> future2 = JobScheduler.getScheduler().schedule(() -> ApplicationStatisticsPersistenceComponent.doPersistProjectUsages(project), 30L, TimeUnit.MINUTES);
                persistProjectStatisticsTasks.put(project, future2);
            }

            public void projectClosed(Project project) {
                Future future2 = (Future)persistProjectStatisticsTasks.remove(project);
                if (future2 != null) {
                    future2.cancel(true);
                }
            }
        });
        ApplicationStatisticsPersistenceComponent.persistPeriodically();
    }

    private static void persistPeriodically() {
        JobScheduler.getScheduler().scheduleWithFixedDelay(ApplicationStatisticsPersistenceComponent::persistOpenedProjects, 1L, 1L, TimeUnit.DAYS);
    }

    public static void persistOpenedProjects() {
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            ApplicationStatisticsPersistenceComponent.doPersistProjectUsages(project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doPersistProjectUsages(@NotNull Project project) {
        if (project == null) {
            ApplicationStatisticsPersistenceComponent.$$$reportNull$$$0(2);
        }
        if (StatisticsUploadAssistant.isSendAllowed()) {
            Object object = StatisticsUploadAssistant.LOCK;
            synchronized (object) {
                if (!project.isInitialized() || DumbService.isDumb((Project)project)) {
                    return;
                }
                for (UsagesCollector usagesCollector : (UsagesCollector[])UsagesCollector.EP_NAME.getExtensions()) {
                    if (!(usagesCollector instanceof AbstractProjectsUsagesCollector)) continue;
                    ((AbstractProjectsUsagesCollector)usagesCollector).persistProjectUsages(project);
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = PROJECT_TAG;
                break;
            }
        }
        objectArray2[1] = "com/intellij/internal/statistic/ApplicationStatisticsPersistenceComponent";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "joinUsages";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "doPersistProjectUsages";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

