/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.actions.persistence;

import com.intellij.internal.statistic.beans.ConvertUsagesUtil;
import com.intellij.internal.statistic.eventLog.FeatureUsageLogger;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="ToolWindowCollector", storages={@Storage(value="usage.statistics.xml", roamingType=RoamingType.DISABLED)})
public class ToolWindowCollector
implements PersistentStateComponent<State> {
    private State myState = new State();

    public static ToolWindowCollector getInstance() {
        return (ToolWindowCollector)ServiceManager.getService(ToolWindowCollector.class);
    }

    public void recordActivation(String toolWindowId) {
        this.record(toolWindowId + " by Activation");
    }

    public void recordClick(String toolWindowId) {
        this.record(toolWindowId + " by Click");
    }

    private void record(String toolWindowId) {
        if (toolWindowId == null) {
            return;
        }
        State state2 = this.getState();
        if (state2 == null) {
            return;
        }
        String key = ConvertUsagesUtil.escapeDescriptorName(toolWindowId);
        FeatureUsageLogger.INSTANCE.log("toolwindow", key);
        Integer count = state2.myValues.get(key);
        int value = count == null ? 1 : count + 1;
        state2.myValues.put(key, value);
    }

    @Nullable
    public State getState() {
        return this.myState;
    }

    public void loadState(@NotNull State state2) {
        if (state2 == null) {
            ToolWindowCollector.$$$reportNull$$$0(0);
        }
        this.myState = state2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/internal/statistic/collectors/fus/actions/persistence/ToolWindowCollector", "loadState"));
    }

    public static final class State {
        @Tag(value="counts")
        @MapAnnotation(surroundWithTag=false, keyAttributeName="toolWindow", valueAttributeName="count")
        public Map<String, Integer> myValues = new HashMap<String, Integer>();
    }
}

