/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.service.fus.collectors;

import com.intellij.internal.statistic.service.fus.collectors.FUSession;
import com.intellij.internal.statistic.service.fus.collectors.FeatureUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.UsagesCollectorConsumer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractUsageTrigger<T extends FeatureUsagesCollector>
implements UsagesCollectorConsumer {
    private static final Logger LOG = Logger.getInstance((String)("#" + AbstractUsageTrigger.class.getPackage().getName()));
    private State myState = new State();

    public void trigger(@NotNull Class<? extends T> fusClass, @NotNull @NonNls String feature) {
        FeatureUsagesCollector collector;
        if (fusClass == null) {
            AbstractUsageTrigger.$$$reportNull$$$0(0);
        }
        if (feature == null) {
            AbstractUsageTrigger.$$$reportNull$$$0(1);
        }
        if ((collector = this.findCollector(fusClass)) != null) {
            this.doTrigger(collector.getGroupId(), feature);
        } else {
            LOG.warn("Cannot find collector `" + fusClass + "`. Make sure it's registered");
        }
    }

    protected abstract FeatureUsagesCollector findCollector(@NotNull Class<? extends T> var1);

    protected void doTrigger(@NotNull String usageCollectorId, @NotNull String feature) {
        if (usageCollectorId == null) {
            AbstractUsageTrigger.$$$reportNull$$$0(2);
        }
        if (feature == null) {
            AbstractUsageTrigger.$$$reportNull$$$0(3);
        }
        SessionInfo sessionInfo = this.getOrCreateSessionInfo();
        UsagesCollectorInfo collectorInfo = sessionInfo.getUsageCollectorInfo(usageCollectorId);
        Integer count = collectorInfo.counts.get(feature);
        if (count == null) {
            collectorInfo.counts.put(feature, 1);
        } else {
            collectorInfo.counts.put(feature, count + 1);
        }
    }

    @NotNull
    public Map<String, Integer> getData(@NotNull String usageCollectorId) {
        SessionInfo info;
        if (usageCollectorId == null) {
            AbstractUsageTrigger.$$$reportNull$$$0(4);
        }
        if ((info = this.geExistingSessionInfo()) != null) {
            Map<String, Integer> map2 = info.getUsageCollectorInfo((String)usageCollectorId).counts;
            if (map2 == null) {
                AbstractUsageTrigger.$$$reportNull$$$0(5);
            }
            return map2;
        }
        Map<String, Integer> map3 = Collections.emptyMap();
        if (map3 == null) {
            AbstractUsageTrigger.$$$reportNull$$$0(6);
        }
        return map3;
    }

    @NotNull
    private SessionInfo getOrCreateSessionInfo() {
        SessionInfo info = this.geExistingSessionInfo();
        if (info != null) {
            SessionInfo sessionInfo = info;
            if (sessionInfo == null) {
                AbstractUsageTrigger.$$$reportNull$$$0(7);
            }
            return sessionInfo;
        }
        SessionInfo sessionInfo = SessionInfo.create(this.getFUSession().getId());
        this.myState.sessions.add(sessionInfo);
        SessionInfo sessionInfo2 = sessionInfo;
        if (sessionInfo2 == null) {
            AbstractUsageTrigger.$$$reportNull$$$0(8);
        }
        return sessionInfo2;
    }

    protected abstract FUSession getFUSession();

    @Nullable
    private SessionInfo geExistingSessionInfo() {
        FUSession session2 = this.getFUSession();
        for (SessionInfo info : this.myState.sessions) {
            if (info.id != session2.getId()) continue;
            return info;
        }
        return null;
    }

    public State getState() {
        return this.myState;
    }

    public void loadState(@NotNull State state2) {
        if (state2 == null) {
            AbstractUsageTrigger.$$$reportNull$$$0(9);
        }
        this.myState = state2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fusClass";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "feature";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageCollectorId";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/service/fus/collectors/AbstractUsageTrigger";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/service/fus/collectors/AbstractUsageTrigger";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getData";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateSessionInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "trigger";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doTrigger";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @Tag(value="usages-collector")
    public static class UsagesCollectorInfo {
        @Attribute(value="id")
        public String id;
        @Tag(value="counts")
        @MapAnnotation(surroundWithTag=false)
        public Map<String, Integer> counts = new HashMap<String, Integer>();
    }

    @Tag(value="session")
    public static class SessionInfo {
        @Attribute(value="id")
        public int id;
        @Property(surroundWithTag=false)
        @XCollection
        List<UsagesCollectorInfo> collectors = ContainerUtil.newSmartList();

        @NotNull
        public UsagesCollectorInfo getUsageCollectorInfo(String id) {
            UsagesCollectorInfo collector = this.findUsageCollectorInfo(id);
            if (collector != null) {
                UsagesCollectorInfo usagesCollectorInfo = collector;
                if (usagesCollectorInfo == null) {
                    SessionInfo.$$$reportNull$$$0(0);
                }
                return usagesCollectorInfo;
            }
            UsagesCollectorInfo info = new UsagesCollectorInfo();
            info.id = id;
            this.collectors.add(info);
            UsagesCollectorInfo usagesCollectorInfo = info;
            if (usagesCollectorInfo == null) {
                SessionInfo.$$$reportNull$$$0(1);
            }
            return usagesCollectorInfo;
        }

        @Nullable
        public UsagesCollectorInfo findUsageCollectorInfo(String id) {
            for (UsagesCollectorInfo collector : this.collectors) {
                if (!id.equals(collector.id)) continue;
                return collector;
            }
            return null;
        }

        public static SessionInfo create(int id) {
            SessionInfo info = new SessionInfo();
            info.id = id;
            return info;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/service/fus/collectors/AbstractUsageTrigger$SessionInfo", "getUsageCollectorInfo"));
        }
    }

    static final class State {
        @Property(surroundWithTag=false)
        @XCollection
        List<SessionInfo> sessions = ContainerUtil.newSmartList();

        State() {
        }
    }
}

