/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.ide.cloudConfig.CloudConfigProvider;
import com.intellij.internal.statistic.collectors.legacy.ideSettings.IdeInitialConfigButtonUsages;
import com.intellij.openapi.MnemonicHelper;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.util.ResourceBundle;
import java.util.function.Function;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.Nullable;

class ImportOldConfigsPanel
extends JDialog {
    private JPanel myRootPanel;
    private JLabel mySuggestLabel;
    private JRadioButton myRbImportAuto;
    private JRadioButton myRbImport;
    private TextFieldWithBrowseButton myPrevInstallation;
    private JRadioButton myCustomButton;
    private JRadioButton myRbDoNotImport;
    private JButton myOkButton;
    private final File myGuessedOldConfig;
    private final Function<File, Pair<File, File>> myValidator;
    private final String myProductName;
    private File myLastSelection = null;
    private Pair<File, File> myResult;

    ImportOldConfigsPanel(@Nullable File guessedOldConfig, Function<File, Pair<File, File>> validator) {
        super((Dialog)null, true);
        this.myGuessedOldConfig = guessedOldConfig;
        this.myValidator = validator;
        this.$$$setupUI$$$();
        this.myProductName = ApplicationNamesInfo.getInstance().getFullProductName();
        this.setTitle(ApplicationBundle.message((String)"title.complete.installation", (Object[])new Object[0]));
        this.init();
    }

    private void init() {
        File jetBrainsHome;
        String programFiles;
        MnemonicHelper.init((Component)this.getContentPane());
        ButtonGroup group = new ButtonGroup();
        group.add(this.myRbImportAuto);
        group.add(this.myRbImport);
        group.add(this.myRbDoNotImport);
        this.myRbDoNotImport.setSelected(true);
        this.mySuggestLabel.setText(ApplicationBundle.message((String)"label.you.can.import", (Object[])new Object[]{this.myProductName}));
        this.myRbDoNotImport.setText(ApplicationBundle.message((String)"radio.do.not.import", (Object[])new Object[0]));
        if (this.myGuessedOldConfig != null) {
            String path = FileUtil.getLocationRelativeToUserHome((String)this.myGuessedOldConfig.getAbsolutePath());
            this.myRbImportAuto.setText(ApplicationBundle.message((String)"radio.import.auto", (Object[])new Object[]{path}));
            this.myRbImportAuto.setSelected(true);
        } else {
            this.myRbImportAuto.setVisible(false);
        }
        this.myRbImport.addChangeListener(e -> this.update());
        if (SystemInfo.isMac) {
            this.myLastSelection = new File("/Applications");
        } else if (SystemInfo.isWindows && (programFiles = System.getenv("ProgramFiles")) != null && (jetBrainsHome = new File(programFiles, "JetBrains")).isDirectory()) {
            this.myLastSelection = jetBrainsHome;
        }
        this.myPrevInstallation.addActionListener(e -> {
            File file2;
            JFileChooser fc = new JFileChooser(this.myLastSelection != null ? this.myLastSelection.getParentFile() : null);
            fc.setSelectedFile(this.myLastSelection);
            fc.setFileSelectionMode(SystemInfo.isMac ? 2 : 1);
            fc.setFileHidingEnabled(SystemInfo.isWindows || SystemInfo.isMac);
            int returnVal = fc.showOpenDialog(this);
            if (returnVal == 0 && (file2 = fc.getSelectedFile()) != null) {
                this.myLastSelection = file2;
                this.myPrevInstallation.setText(file2.getAbsolutePath());
            }
        });
        this.myOkButton.addActionListener(e -> this.close());
        CloudConfigProvider configProvider = CloudConfigProvider.getProvider();
        if (configProvider != null) {
            configProvider.initConfigsPanel(group, this.myCustomButton);
        }
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(this.myRootPanel);
        this.getRootPane().setDefaultButton(this.myOkButton);
        this.update();
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private void update() {
        this.myPrevInstallation.setEnabled(this.myRbImport.isSelected());
    }

    private void close() {
        IdeInitialConfigButtonUsages.setConfigImport(this.myRbDoNotImport, this.myRbImport, this.myRbImportAuto, this.myCustomButton);
        if (this.myRbImport.isSelected()) {
            String text2 = this.myPrevInstallation.getText();
            if (StringUtil.isEmptyOrSpaces((String)text2)) {
                this.showError(ApplicationBundle.message((String)"error.please.select.previous.installation.home", (Object[])new Object[]{this.myProductName}));
                return;
            }
            File selectedDir = new File(FileUtil.toCanonicalPath((String)text2.trim()));
            if (FileUtil.pathsEqual((String)selectedDir.getPath(), (String)PathManager.getHomePath()) || FileUtil.pathsEqual((String)selectedDir.getPath(), (String)PathManager.getConfigPath())) {
                this.showError(ApplicationBundle.message((String)"error.selected.current.installation.home", (Object[])new Object[]{this.myProductName}));
                return;
            }
            Pair<File, File> result2 = this.myValidator.apply(selectedDir);
            if (result2 == null) {
                this.showError(ApplicationBundle.message((String)"error.does.not.appear.to.be.installation.home", (Object[])new Object[]{selectedDir, this.myProductName}));
                return;
            }
            if (!((File)result2.first).canRead()) {
                this.showError(ApplicationBundle.message((String)"error.no.read.permissions", (Object[])new Object[]{result2}));
                return;
            }
            this.myResult = result2;
        }
        this.dispose();
    }

    private void showError(String message) {
        String title = ApplicationBundle.message((String)"title.installation.home.required", (Object[])new Object[0]);
        JOptionPane.showMessageDialog(this, message, title, 0);
    }

    @Nullable
    Pair<File, File> getSelectedFile() {
        if (this.myRbImportAuto.isSelected()) {
            return Pair.pair((Object)this.myGuessedOldConfig, null);
        }
        if (this.myRbImport.isSelected()) {
            return this.myResult;
        }
        return null;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JRadioButton jRadioButton3;
        JRadioButton jRadioButton4;
        JLabel jLabel;
        JPanel jPanel;
        this.myRootPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(10, 10, 10, 10), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(6, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.mySuggestLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/ApplicationBundle").getString("label.you.can.import"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myRbImportAuto = jRadioButton4 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton4, ResourceBundle.getBundle("messages/ApplicationBundle").getString("radio.import.auto"));
        jPanel2.add((Component)jRadioButton4, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myRbImport = jRadioButton3 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton3, ResourceBundle.getBundle("messages/ApplicationBundle").getString("radio.import"));
        jPanel2.add((Component)jRadioButton3, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myPrevInstallation = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton, new GridConstraints(3, 0, 1, 1, 0, 1, 3, 0, null, null, null, 2));
        this.myCustomButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("");
        ((Component)jRadioButton2).setVisible(false);
        jPanel2.add((Component)jRadioButton2, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myRbDoNotImport = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("messages/ApplicationBundle").getString("radio.do.not.import"));
        jPanel2.add((Component)jRadioButton, new GridConstraints(5, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myOkButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("messages/ApplicationBundle").getString("button.ok"));
        jPanel3.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, new Dimension(80, -1), null, null, 5));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

