/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diff.impl.DiffUtil;
import com.intellij.openapi.diff.impl.util.FocusDiffSide;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.DumbAware;
import java.awt.event.KeyEvent;

public abstract class DiffWalkerAction
extends AnAction
implements DumbAware {
    protected DiffWalkerAction() {
        this.setEnabledInModalContext(true);
    }

    public void actionPerformed(AnActionEvent event) {
        FocusDiffSide side = DiffUtil.getFocusDiffSide(event.getDataContext());
        if (side == null) {
            return;
        }
        int line = this.getLineNumberToGo(side);
        Editor editor = side.getEditor();
        if (line >= 0 && editor != null) {
            LogicalPosition pos = new LogicalPosition(line, 0);
            editor.getCaretModel().removeSecondaryCarets();
            editor.getCaretModel().moveToLogicalPosition(pos);
            editor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
        }
    }

    public void update(AnActionEvent event) {
        FocusDiffSide side = DiffUtil.getFocusDiffSide(event.getDataContext());
        Presentation presentation = event.getPresentation();
        if (side == null) {
            presentation.setEnabled(false);
        } else {
            presentation.setEnabled(this.getLineNumberToGo(side) >= 0 || event.getInputEvent() instanceof KeyEvent);
        }
    }

    protected abstract int getLineNumberToGo(FocusDiffSide var1);
}

