/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.ex;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.DiffPanelImpl;
import com.intellij.openapi.diff.impl.DiffSideView;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapperDialog;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFocusManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Window;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffPanelOptions {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.diff.ex.DiffPanelOptions");
    private final DiffPanelImpl myDiffPanel;
    private boolean myRequestFocusOnNewContent = true;
    private ShowSourcePolicy myShowSourcePolicy = ShowSourcePolicy.DEFAULT;

    public DiffPanelOptions(DiffPanelImpl diffPanel) {
        this.myDiffPanel = diffPanel;
    }

    public void onNewContent(DiffSideView currentSide) {
        if (this.myRequestFocusOnNewContent) {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)currentSide.getFocusableComponent(), true));
        }
    }

    public void setRequestFocusOnNewContent(boolean requestFocusOnNewContent) {
        this.myRequestFocusOnNewContent = requestFocusOnNewContent;
    }

    public void setShowSourcePolicy(ShowSourcePolicy showSourcePolicy) {
        if (showSourcePolicy == null) {
            LOG.error("");
            return;
        }
        this.myShowSourcePolicy = showSourcePolicy;
    }

    public void showSource(@Nullable OpenFileDescriptor descriptor2) {
        if (descriptor2 == null || this.myDiffPanel.getProject() == null || this.myDiffPanel.getProject().isDefault()) {
            return;
        }
        this.myShowSourcePolicy.showSource(descriptor2, this.myDiffPanel);
    }

    public static interface ShowSourcePolicy {
        public static final ShowSourcePolicy DONT_SHOW = new ShowSourcePolicy(){

            @Override
            public void showSource(@NotNull OpenFileDescriptor descriptor2, @NotNull DiffPanelImpl diffPanel) {
                if (descriptor2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (diffPanel == null) {
                    1.$$$reportNull$$$0(1);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "descriptor";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "diffPanel";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/diff/ex/DiffPanelOptions$ShowSourcePolicy$1";
                objectArray[2] = "showSource";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        public static final ShowSourcePolicy OPEN_EDITOR = new ShowSourcePolicy(){

            @Override
            public void showSource(@NotNull OpenFileDescriptor descriptor2, @NotNull DiffPanelImpl diffPanel) {
                if (descriptor2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (diffPanel == null) {
                    2.$$$reportNull$$$0(1);
                }
                FileEditorManager.getInstance((Project)diffPanel.getProject()).openTextEditor(descriptor2, true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "descriptor";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "diffPanel";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/diff/ex/DiffPanelOptions$ShowSourcePolicy$2";
                objectArray[2] = "showSource";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        public static final ShowSourcePolicy OPEN_EDITOR_AND_CLOSE_DIFF = new ShowSourcePolicy(){

            @Override
            public void showSource(@NotNull OpenFileDescriptor descriptor2, @NotNull DiffPanelImpl diffPanel) {
                if (descriptor2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (diffPanel == null) {
                    3.$$$reportNull$$$0(1);
                }
                OPEN_EDITOR.showSource(descriptor2, diffPanel);
                if (diffPanel.getOwnerWindow() == null) {
                    return;
                }
                Disposer.dispose((Disposable)diffPanel);
                if (!this.dialogWrapperClose(diffPanel.getOwnerWindow())) {
                    diffPanel.getOwnerWindow().setVisible(false);
                    diffPanel.getOwnerWindow().dispose();
                }
            }

            private boolean dialogWrapperClose(Container window) {
                if (!(window instanceof DialogWrapperDialog)) {
                    return false;
                }
                while (window instanceof DialogWrapperDialog) {
                    DialogWrapperDialog dlg = (DialogWrapperDialog)window;
                    window = window.getParent();
                    dlg.getDialogWrapper().doCancelAction();
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "descriptor";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "diffPanel";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/diff/ex/DiffPanelOptions$ShowSourcePolicy$3";
                objectArray[2] = "showSource";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        public static final ShowSourcePolicy DEFAULT = new ShowSourcePolicy(){

            @Override
            public void showSource(@NotNull OpenFileDescriptor descriptor2, @NotNull DiffPanelImpl diffPanel) {
                Window window;
                if (descriptor2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (diffPanel == null) {
                    4.$$$reportNull$$$0(1);
                }
                if ((window = diffPanel.getOwnerWindow()) == null || window instanceof Frame) {
                    OPEN_EDITOR.showSource(descriptor2, diffPanel);
                } else {
                    OPEN_EDITOR_AND_CLOSE_DIFF.showSource(descriptor2, diffPanel);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "descriptor";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "diffPanel";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/diff/ex/DiffPanelOptions$ShowSourcePolicy$4";
                objectArray[2] = "showSource";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };

        public void showSource(@NotNull OpenFileDescriptor var1, @NotNull DiffPanelImpl var2);
    }
}

