/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.editor.impl.view.TextFragment;
import java.awt.Font;
import java.awt.Graphics2D;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

class SimpleTextFragment
extends TextFragment {
    @NotNull
    private final char[] myText;
    @NotNull
    private final Font myFont;

    SimpleTextFragment(@NotNull char[] lineChars, int start, int end, @NotNull FontInfo fontInfo) {
        if (lineChars == null) {
            SimpleTextFragment.$$$reportNull$$$0(0);
        }
        if (fontInfo == null) {
            SimpleTextFragment.$$$reportNull$$$0(1);
        }
        super(end - start);
        this.myText = Arrays.copyOfRange(lineChars, start, end);
        this.myFont = fontInfo.getFont();
        float x = 0.0f;
        for (int i = 0; i < this.myText.length; ++i) {
            this.myCharPositions[i] = x += fontInfo.charWidth2D(this.myText[i]);
        }
    }

    @Override
    boolean isRtl() {
        return false;
    }

    @Override
    int offsetToLogicalColumn(int offset) {
        return offset;
    }

    @Override
    public void draw(Graphics2D g, float x, float y, int startColumn, int endColumn) {
        g.setFont(this.myFont);
        int xAsInt = (int)x;
        int yAsInt = (int)y;
        if (x == (float)xAsInt && y == (float)yAsInt) {
            g.drawChars(this.myText, startColumn, endColumn - startColumn, xAsInt, yAsInt);
        } else {
            g.drawString(new String(this.myText, startColumn, endColumn - startColumn), x, y);
        }
    }

    @Override
    public int getLogicalColumnCount(int startColumn) {
        return this.myCharPositions.length;
    }

    @Override
    public int getVisualColumnCount(float startX) {
        return this.myCharPositions.length;
    }

    @Override
    public int visualColumnToOffset(float startX, int column) {
        return column;
    }

    @Override
    public int[] xToVisualColumn(float startX, float x) {
        float relX = x - startX;
        float prevPos = 0.0f;
        for (int i = 0; i < this.myCharPositions.length; ++i) {
            float newPos = this.myCharPositions[i];
            if (relX < (newPos + prevPos) / 2.0f) {
                return new int[]{i, relX <= prevPos ? 0 : 1};
            }
            prevPos = newPos;
        }
        return new int[]{this.myCharPositions.length, relX <= this.myCharPositions[this.myCharPositions.length - 1] ? 0 : 1};
    }

    @Override
    public float visualColumnToX(float startX, int column) {
        return startX + this.getX(column);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "lineChars";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "fontInfo";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/editor/impl/view/SimpleTextFragment";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

