/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.UniqueVFilePathBuilder;
import com.intellij.openapi.fileEditor.impl.EditorTabColorProvider;
import com.intellij.openapi.fileEditor.impl.EditorTabTitleProvider;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Color;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorTabPresentationUtil {
    @NotNull
    public static String getEditorTabTitle(@NotNull Project project, @NotNull VirtualFile file2, @Nullable EditorWindow editorWindow) {
        if (project == null) {
            EditorTabPresentationUtil.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            EditorTabPresentationUtil.$$$reportNull$$$0(1);
        }
        List providers = DumbService.getInstance((Project)project).filterByDumbAwareness(Extensions.getExtensions(EditorTabTitleProvider.EP_NAME));
        for (EditorTabTitleProvider provider : providers) {
            String result2 = provider.getEditorTabTitle(project, file2, editorWindow);
            if (!StringUtil.isNotEmpty((String)result2)) continue;
            String string = result2;
            if (string == null) {
                EditorTabPresentationUtil.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = file2.getPresentableName();
        if (string == null) {
            EditorTabPresentationUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public static String getUniqueEditorTabTitle(@NotNull Project project, @NotNull VirtualFile file2, @Nullable EditorWindow editorWindow) {
        String name;
        if (project == null) {
            EditorTabPresentationUtil.$$$reportNull$$$0(4);
        }
        if (file2 == null) {
            EditorTabPresentationUtil.$$$reportNull$$$0(5);
        }
        if ((name = EditorTabPresentationUtil.getEditorTabTitle(project, file2, editorWindow)).equals(file2.getPresentableName())) {
            String string = UniqueVFilePathBuilder.getInstance().getUniqueVirtualFilePath(project, file2);
            if (string == null) {
                EditorTabPresentationUtil.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = name;
        if (string == null) {
            EditorTabPresentationUtil.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    public static Color getEditorTabBackgroundColor(@NotNull Project project, @NotNull VirtualFile file2, @Nullable EditorWindow editorWindow) {
        if (project == null) {
            EditorTabPresentationUtil.$$$reportNull$$$0(8);
        }
        if (file2 == null) {
            EditorTabPresentationUtil.$$$reportNull$$$0(9);
        }
        List providers = DumbService.getInstance((Project)project).filterByDumbAwareness(Extensions.getExtensions(EditorTabColorProvider.EP_NAME));
        for (EditorTabColorProvider provider : providers) {
            Color result2 = provider.getEditorTabColor(project, file2, editorWindow);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    @Nullable
    public static Color getFileBackgroundColor(@NotNull Project project, @NotNull VirtualFile file2) {
        if (project == null) {
            EditorTabPresentationUtil.$$$reportNull$$$0(10);
        }
        if (file2 == null) {
            EditorTabPresentationUtil.$$$reportNull$$$0(11);
        }
        List providers = DumbService.getInstance((Project)project).filterByDumbAwareness(Extensions.getExtensions(EditorTabColorProvider.EP_NAME));
        for (EditorTabColorProvider provider : providers) {
            Color result2 = provider.getProjectViewColor(project, file2);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/impl/EditorTabPresentationUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/EditorTabPresentationUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorTabTitle";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getUniqueEditorTabTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getEditorTabTitle";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getUniqueEditorTabTitle";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getEditorTabBackgroundColor";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getFileBackgroundColor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

