/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.readOnlyHandler.FileListRenderer;
import com.intellij.openapi.vcs.readOnlyHandler.ReadOnlyStatusDialog;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NonProjectFileWritingAccessDialog
extends DialogWrapper {
    private JPanel myPanel;
    private JLabel myListTitle;
    private JList<VirtualFile> myFileList;
    private JRadioButton myUnlockOneButton;
    private JRadioButton myUnlockDirButton;
    private JRadioButton myUnlockAllButton;

    public NonProjectFileWritingAccessDialog(@NotNull Project project, @NotNull List<VirtualFile> nonProjectFiles) {
        if (project == null) {
            NonProjectFileWritingAccessDialog.$$$reportNull$$$0(0);
        }
        if (nonProjectFiles == null) {
            NonProjectFileWritingAccessDialog.$$$reportNull$$$0(1);
        }
        this(project, nonProjectFiles, "Non-Project Files");
    }

    public NonProjectFileWritingAccessDialog(@NotNull Project project, @NotNull List<VirtualFile> nonProjectFiles, @NotNull String filesType) {
        if (project == null) {
            NonProjectFileWritingAccessDialog.$$$reportNull$$$0(2);
        }
        if (nonProjectFiles == null) {
            NonProjectFileWritingAccessDialog.$$$reportNull$$$0(3);
        }
        if (filesType == null) {
            NonProjectFileWritingAccessDialog.$$$reportNull$$$0(4);
        }
        super(project);
        this.$$$setupUI$$$();
        this.setTitle(filesType + " Protection");
        this.myFileList.setPreferredSize(ReadOnlyStatusDialog.getDialogPreferredSize());
        this.myFileList.setCellRenderer((ListCellRenderer<VirtualFile>)((Object)new FileListRenderer()));
        this.myFileList.setModel((ListModel<VirtualFile>)new CollectionListModel(nonProjectFiles));
        String theseFilesMessage = ReadOnlyStatusDialog.getTheseFilesMessage(nonProjectFiles);
        this.myListTitle.setText(StringUtil.capitalize((String)theseFilesMessage) + " " + (nonProjectFiles.size() > 1 ? "do" : "does") + " not belong to the project:");
        this.myUnlockOneButton.setSelected(true);
        this.setTextAndMnemonicAndListeners(this.myUnlockOneButton, "I want to edit " + theseFilesMessage + " anyway", "edit");
        int dirs = ContainerUtil.map2Set(nonProjectFiles, VirtualFile::getParent).size();
        this.setTextAndMnemonicAndListeners(this.myUnlockDirButton, "I want to edit all files in " + StringUtil.pluralize((String)"this", (int)dirs) + " " + StringUtil.pluralize((String)"directory", (int)dirs), "dir");
        this.setTextAndMnemonicAndListeners(this.myUnlockAllButton, "I want to edit any non-project file in the current session", "any");
        this.getOKAction().putValue("DefaultAction", null);
        this.getCancelAction().putValue("DefaultAction", null);
        this.getRootPane().registerKeyboardAction(e -> this.doOKAction(), KeyStroke.getKeyStroke(10, 128), 1);
        this.getRootPane().registerKeyboardAction(e -> this.doOKAction(), KeyStroke.getKeyStroke(10, 256), 1);
        this.init();
    }

    private void setTextAndMnemonicAndListeners(JRadioButton button, String text2, String mnemonic) {
        button.setText(text2);
        button.setMnemonic(mnemonic.charAt(0));
        button.setDisplayedMnemonicIndex(button.getText().indexOf(mnemonic));
        Runnable setDefaultButton = () -> {
            JRootPane rootPane = button.getRootPane();
            if (rootPane != null) {
                rootPane.setDefaultButton(this.getButton(this.getOKAction()));
            }
        };
        button.addActionListener(e -> setDefaultButton.run());
        button.addItemListener(e -> setDefaultButton.run());
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myUnlockOneButton;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    @NotNull
    public NonProjectFileWritingAccessProvider.UnlockOption getUnlockOption() {
        if (this.myUnlockAllButton.isSelected()) {
            NonProjectFileWritingAccessProvider.UnlockOption unlockOption = NonProjectFileWritingAccessProvider.UnlockOption.UNLOCK_ALL;
            if (unlockOption == null) {
                NonProjectFileWritingAccessDialog.$$$reportNull$$$0(5);
            }
            return unlockOption;
        }
        if (this.myUnlockDirButton.isSelected()) {
            NonProjectFileWritingAccessProvider.UnlockOption unlockOption = NonProjectFileWritingAccessProvider.UnlockOption.UNLOCK_DIR;
            if (unlockOption == null) {
                NonProjectFileWritingAccessDialog.$$$reportNull$$$0(6);
            }
            return unlockOption;
        }
        NonProjectFileWritingAccessProvider.UnlockOption unlockOption = NonProjectFileWritingAccessProvider.UnlockOption.UNLOCK;
        if (unlockOption == null) {
            NonProjectFileWritingAccessDialog.$$$reportNull$$$0(7);
        }
        return unlockOption;
    }

    protected String getHelpId() {
        return "Non-Project_Files_Access_Dialog";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nonProjectFiles";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesType";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/impl/NonProjectFileWritingAccessDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/NonProjectFileWritingAccessDialog";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnlockOption";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBList jBList;
        JLabel jLabel;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(2, 0, 1, 1, 2, 1, 3, 1, null, null, null));
        this.myUnlockOneButton = jRadioButton3 = new JRadioButton();
        jRadioButton3.setSelected(false);
        jRadioButton3.setText("unlock one");
        jPanel2.add((Component)jRadioButton3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myUnlockAllButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("unlock all");
        jPanel2.add((Component)jRadioButton2, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myUnlockDirButton = jRadioButton = new JRadioButton();
        jRadioButton.setSelected(false);
        jRadioButton.setText("unlock dir");
        jPanel2.add((Component)jRadioButton, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myListTitle = jLabel = new JLabel();
        jLabel.setText("title");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.myFileList = jBList = new JBList();
        jBScrollPane.setViewportView((Component)jBList);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(jRadioButton2);
        buttonGroup2.add(jRadioButton3);
        buttonGroup2.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

