/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl.ui;

import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.impl.ui.KeyboardShortcutPanel;
import com.intellij.openapi.keymap.impl.ui.ShortcutDialog;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;

final class KeyboardShortcutDialog
extends ShortcutDialog<KeyboardShortcut> {
    private final JComponent myPreferredFocusedComponent;

    KeyboardShortcutDialog(Component parent, boolean allowSecondStroke) {
        super(parent, "keyboard.shortcut.dialog.title", new KeyboardShortcutPanel(new BorderLayout()));
        KeyboardShortcutPanel panel2 = (KeyboardShortcutPanel)this.myShortcutPanel;
        this.myPreferredFocusedComponent = panel2.myFirstStroke;
        JPanel inner = new JPanel(new BorderLayout());
        inner.add("Center", panel2.mySecondStroke);
        inner.add("West", panel2.mySecondStrokeEnable);
        inner.setBorder((Border)JBUI.Borders.empty((int)5, (int)0, (int)0, (int)0));
        inner.setVisible(allowSecondStroke);
        panel2.add("North", panel2.myFirstStroke);
        panel2.add("South", inner);
        panel2.setBorder((Border)JBUI.Borders.empty((int)0, (int)10));
        panel2.mySecondStrokeEnable.setText(KeyMapBundle.message((String)"dialog.enable.second.stroke.checkbox", (Object[])new Object[0]));
        this.init();
    }

    protected String getHelpId() {
        return "preferences.keymap.shortcut";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myPreferredFocusedComponent;
    }

    @Override
    KeyboardShortcut toShortcut(Object value) {
        return value instanceof KeyboardShortcut ? (KeyboardShortcut)value : null;
    }

    @Override
    Collection<String> getConflicts(KeyboardShortcut shortcut, String actionId, Keymap keymap) {
        return keymap.getConflicts(actionId, shortcut).keySet();
    }
}

