/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project.impl;

import com.intellij.configurationStore.StorageUtilKt;
import com.intellij.conversion.ConversionResult;
import com.intellij.conversion.ConversionService;
import com.intellij.featureStatistics.fusCollectors.ProjectLifecycleUsageTriggerCollector;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.ide.startup.impl.StartupManagerImpl;
import com.intellij.internal.statistic.eventLog.FeatureUsageLogger;
import com.intellij.internal.statistic.service.fus.collectors.FUSProjectUsageTrigger;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.components.impl.stores.StoreUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.project.ProjectReloadState;
import com.intellij.openapi.project.VetoableProjectManagerListener;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.project.impl.DefaultProject;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.project.impl.ProjectLifecycleListener;
import com.intellij.openapi.project.impl.TooManyProjectLeakedException;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.ZipHandler;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.ui.GuiUtils;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.UnsafeWeakList;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.ref.GCUtil;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectManagerImpl
extends ProjectManagerEx
implements Disposable {
    private static final Logger LOG = Logger.getInstance(ProjectManagerImpl.class);
    private static final Key<List<ProjectManagerListener>> LISTENERS_IN_PROJECT_KEY = Key.create((String)"LISTENERS_IN_PROJECT_KEY");
    private ProjectImpl myDefaultProject;
    private Project[] myOpenProjects = new Project[0];
    private final Map<String, Project> myOpenProjectByHash = ContainerUtil.newConcurrentMap();
    private final Object lock = new Object();
    private final List<ProjectManagerListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final ProgressManager myProgressManager;
    private volatile boolean myDefaultProjectWasDisposed;
    private final ProjectManagerListener myBusPublisher;
    public static int TEST_PROJECTS_CREATED;
    private static final boolean LOG_PROJECT_LEAKAGE_IN_TESTS;
    private static final int MAX_LEAKY_PROJECTS = 5;
    private static final long LEAK_CHECK_INTERVAL;
    private static long CHECK_START;
    private final Map<Project, String> myProjects = new WeakHashMap<Project, String>();

    @NotNull
    private static List<ProjectManagerListener> getListeners(@NotNull Project project) {
        List array;
        if (project == null) {
            ProjectManagerImpl.$$$reportNull$$$0(0);
        }
        if ((array = (List)project.getUserData(LISTENERS_IN_PROJECT_KEY)) == null) {
            List<ProjectManagerListener> list2 = Collections.emptyList();
            if (list2 == null) {
                ProjectManagerImpl.$$$reportNull$$$0(1);
            }
            return list2;
        }
        List list3 = array;
        if (list3 == null) {
            ProjectManagerImpl.$$$reportNull$$$0(2);
        }
        return list3;
    }

    public ProjectManagerImpl(ProgressManager progressManager) {
        this.myProgressManager = progressManager;
        MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
        this.myBusPublisher = (ProjectManagerListener)messageBus.syncPublisher(TOPIC);
        messageBus.connect().subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectOpened(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                for (ProjectManagerListener listener2 : ProjectManagerImpl.this.getAllListeners(project)) {
                    try {
                        listener2.projectOpened(project);
                    }
                    catch (Exception e) {
                        ProjectManagerImpl.handleListenerError(e, listener2);
                    }
                }
            }

            public void projectClosed(Project project) {
                for (ProjectManagerListener listener2 : ProjectManagerImpl.this.getAllListeners(project)) {
                    try {
                        listener2.projectClosed(project);
                    }
                    catch (Exception e) {
                        ProjectManagerImpl.handleListenerError(e, listener2);
                    }
                }
                ZipHandler.clearFileAccessorCache();
                LaterInvocator.purgeExpiredItems();
            }

            public void projectClosing(Project project) {
                for (ProjectManagerListener listener2 : ProjectManagerImpl.this.getAllListeners(project)) {
                    try {
                        listener2.projectClosing(project);
                    }
                    catch (Exception e) {
                        ProjectManagerImpl.handleListenerError(e, listener2);
                    }
                }
            }

            public void projectClosingBeforeSave(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(1);
                }
                for (ProjectManagerListener listener2 : ProjectManagerImpl.this.getAllListeners(project)) {
                    try {
                        listener2.projectClosingBeforeSave(project);
                    }
                    catch (Exception e) {
                        ProjectManagerImpl.handleListenerError(e, listener2);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "project";
                objectArray2[1] = "com/intellij/openapi/project/impl/ProjectManagerImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "projectOpened";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "projectClosingBeforeSave";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static void handleListenerError(@NotNull Throwable e, @NotNull ProjectManagerListener listener2) {
        if (e == null) {
            ProjectManagerImpl.$$$reportNull$$$0(3);
        }
        if (listener2 == null) {
            ProjectManagerImpl.$$$reportNull$$$0(4);
        }
        if (e instanceof ProcessCanceledException) {
            throw (ProcessCanceledException)e;
        }
        LOG.error("From listener " + listener2 + " (" + listener2.getClass() + ")", e);
    }

    public void dispose() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (this.myDefaultProject != null) {
            Disposer.dispose((Disposable)this.myDefaultProject);
            this.myDefaultProject = null;
            this.myDefaultProjectWasDisposed = true;
        }
    }

    @Override
    @Nullable
    public Project newProject(@Nullable String projectName, @NotNull String filePath, boolean useDefaultProjectSettings, boolean isDummy) {
        File projectFile;
        if (filePath == null) {
            ProjectManagerImpl.$$$reportNull$$$0(5);
        }
        filePath = ProjectManagerImpl.toCanonicalName(filePath);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ++TEST_PROJECTS_CREATED;
            this.checkProjectLeaksInTests();
        }
        if ((projectFile = new File(filePath)).isFile()) {
            FileUtil.delete((File)projectFile);
        } else {
            File[] files2 = new File(projectFile, ".idea").listFiles();
            if (files2 != null) {
                for (File file2 : files2) {
                    FileUtil.delete((File)file2);
                }
            }
        }
        ProjectImpl project = ProjectManagerImpl.createProject(projectName, filePath, false);
        try {
            this.initProject(project, useDefaultProjectSettings ? this.getDefaultProject() : null);
            if (LOG_PROJECT_LEAKAGE_IN_TESTS) {
                this.myProjects.put(project, null);
            }
            return project;
        }
        catch (Throwable t) {
            LOG.info(t);
            Messages.showErrorDialog((String)ProjectManagerImpl.message(t), (String)ProjectBundle.message((String)"project.load.default.error", (Object[])new Object[0]));
            return null;
        }
    }

    @NonNls
    @NotNull
    private static String message(@NotNull Throwable e) {
        String message;
        if (e == null) {
            ProjectManagerImpl.$$$reportNull$$$0(6);
        }
        if ((message = e.getMessage()) != null) {
            String string = message;
            if (string == null) {
                ProjectManagerImpl.$$$reportNull$$$0(7);
            }
            return string;
        }
        message = e.getLocalizedMessage();
        if (message != null) {
            String string = message;
            if (string == null) {
                ProjectManagerImpl.$$$reportNull$$$0(8);
            }
            return string;
        }
        message = e.toString();
        Throwable cause = e.getCause();
        if (cause != null) {
            String causeMessage = ProjectManagerImpl.message(cause);
            String string = message + " (cause: " + causeMessage + ")";
            if (string == null) {
                ProjectManagerImpl.$$$reportNull$$$0(9);
            }
            return string;
        }
        String string = message;
        if (string == null) {
            ProjectManagerImpl.$$$reportNull$$$0(10);
        }
        return string;
    }

    private void checkProjectLeaksInTests() {
        if (!LOG_PROJECT_LEAKAGE_IN_TESTS || this.getLeakedProjectsCount() < 5) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - CHECK_START < LEAK_CHECK_INTERVAL) {
            return;
        }
        for (int i = 0; i < 3 && this.getLeakedProjectsCount() >= 5; ++i) {
            GCUtil.tryGcSoftlyReachableObjects();
        }
        CHECK_START = currentTime;
        if (this.getLeakedProjectsCount() >= 5) {
            System.gc();
            Collection<Project> copy = this.getLeakedProjects();
            this.myProjects.clear();
            if (ContainerUtil.collect(copy.iterator()).size() >= 5) {
                throw new TooManyProjectLeakedException(copy);
            }
        }
    }

    private Collection<Project> getLeakedProjects() {
        this.myProjects.remove(this.getDefaultProject());
        return (Collection)this.myProjects.keySet().stream().filter(project -> project.isDisposed() && !((ProjectImpl)project).isTemporarilyDisposed()).collect(Collectors.toCollection(UnsafeWeakList::new));
    }

    private int getLeakedProjectsCount() {
        this.myProjects.remove(this.getDefaultProject());
        return (int)this.myProjects.keySet().stream().filter(project -> project.isDisposed() && !((ProjectImpl)project).isTemporarilyDisposed()).count();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initProject(@NotNull ProjectImpl project, @Nullable Project template) {
        ProgressIndicator indicator;
        if (project == null) {
            ProjectManagerImpl.$$$reportNull$$$0(11);
        }
        if ((indicator = this.myProgressManager.getProgressIndicator()) != null && !project.isDefault()) {
            indicator.setIndeterminate(false);
            indicator.setText(ProjectBundle.message((String)"loading.components.for", (Object[])new Object[]{project.getName()}));
        }
        ((ProjectLifecycleListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(ProjectLifecycleListener.TOPIC)).beforeProjectLoaded((Project)project);
        boolean succeed = false;
        try {
            if (template != null) {
                project.getStateStore().loadProjectFromTemplate(template);
            }
            project.init();
            succeed = true;
        }
        finally {
            if (!succeed && !project.isDefault()) {
                TransactionGuard.submitTransaction((Disposable)project, () -> {
                    if (project == null) {
                        ProjectManagerImpl.$$$reportNull$$$0(67);
                    }
                    WriteAction.run(() -> {
                        if (project == null) {
                            ProjectManagerImpl.$$$reportNull$$$0(68);
                        }
                        Disposer.dispose((Disposable)project);
                    });
                });
            }
        }
    }

    @NotNull
    private static ProjectImpl createProject(@Nullable String projectName, @NotNull String filePath, boolean isDefault) {
        if (filePath == null) {
            ProjectManagerImpl.$$$reportNull$$$0(12);
        }
        if (isDefault) {
            DefaultProject defaultProject = new DefaultProject("");
            if (defaultProject == null) {
                ProjectManagerImpl.$$$reportNull$$$0(13);
            }
            return defaultProject;
        }
        ProjectImpl projectImpl = new ProjectImpl(FileUtilRt.toSystemIndependentName((String)filePath), projectName);
        if (projectImpl == null) {
            ProjectManagerImpl.$$$reportNull$$$0(14);
        }
        return projectImpl;
    }

    @Override
    @Nullable
    public Project loadProject(@NotNull String filePath) throws IOException {
        if (filePath == null) {
            ProjectManagerImpl.$$$reportNull$$$0(15);
        }
        return this.loadProject(filePath, null);
    }

    @Override
    @Nullable
    public Project loadProject(@NotNull String filePath, @Nullable String projectName) throws IOException {
        if (filePath == null) {
            ProjectManagerImpl.$$$reportNull$$$0(16);
        }
        try {
            ProjectImpl project = ProjectManagerImpl.createProject(projectName, new File(filePath).getAbsolutePath(), false);
            this.initProject(project, null);
            return project;
        }
        catch (Throwable t) {
            LOG.info(t);
            throw new IOException(t);
        }
    }

    @NotNull
    private static String toCanonicalName(@NotNull String filePath) {
        String string;
        if (filePath == null) {
            ProjectManagerImpl.$$$reportNull$$$0(17);
        }
        try {
            string = FileUtil.resolveShortWindowsName((String)filePath);
        }
        catch (IOException iOException) {
            String string2 = filePath;
            if (string2 == null) {
                ProjectManagerImpl.$$$reportNull$$$0(19);
            }
            return string2;
        }
        if (string == null) {
            ProjectManagerImpl.$$$reportNull$$$0(18);
        }
        return string;
    }

    public synchronized boolean isDefaultProjectInitialized() {
        return this.myDefaultProject != null;
    }

    @NotNull
    public synchronized Project getDefaultProject() {
        LOG.assertTrue(!this.myDefaultProjectWasDisposed, (Object)"Default project has been already disposed!");
        if (this.myDefaultProject == null) {
            LOG.assertTrue(!ApplicationManager.getApplication().isDisposeInProgress(), (Object)"Application being disposed!");
            ProgressManager.getInstance().executeNonCancelableSection(() -> {
                try {
                    this.myDefaultProject = ProjectManagerImpl.createProject(null, "", true);
                    this.initProject(this.myDefaultProject, null);
                }
                catch (Throwable t) {
                    PluginManager.processException(t);
                }
            });
        }
        ProjectImpl projectImpl = this.myDefaultProject;
        if (projectImpl == null) {
            ProjectManagerImpl.$$$reportNull$$$0(20);
        }
        return projectImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Project[] getOpenProjects() {
        Object object = this.lock;
        // MONITORENTER : object
        // MONITOREXIT : object
        if (this.myOpenProjects != null) return this.myOpenProjects;
        ProjectManagerImpl.$$$reportNull$$$0(21);
        return this.myOpenProjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isProjectOpened(Project project) {
        Object object = this.lock;
        synchronized (object) {
            return ArrayUtil.contains((Object)project, (Object[])this.myOpenProjects);
        }
    }

    @Override
    public boolean openProject(@NotNull Project project) {
        if (project == null) {
            ProjectManagerImpl.$$$reportNull$$$0(22);
        }
        if (ProjectManagerImpl.isLight(project)) {
            ((ProjectImpl)project).setTemporarilyDisposed(false);
            boolean isInitialized = StartupManagerEx.getInstanceEx(project).startupActivityPassed();
            if (isInitialized) {
                this.addToOpened(project);
                return true;
            }
        }
        for (Project p : this.getOpenProjects()) {
            if (!ProjectUtil.isSameProject(project.getProjectFilePath(), p)) continue;
            GuiUtils.invokeLaterIfNeeded(() -> ProjectUtil.focusProjectWindow(p, false), (ModalityState)ModalityState.NON_MODAL);
            return false;
        }
        if (!this.addToOpened(project)) {
            return false;
        }
        Runnable process2 = () -> {
            if (project == null) {
                ProjectManagerImpl.$$$reportNull$$$0(64);
            }
            TransactionGuard.getInstance().submitTransactionAndWait(() -> {
                if (project == null) {
                    ProjectManagerImpl.$$$reportNull$$$0(66);
                }
                this.fireProjectOpened(project);
            });
            StartupManagerImpl startupManager = (StartupManagerImpl)StartupManager.getInstance((Project)project);
            startupManager.runStartupActivities();
            TransactionGuard.getInstance().submitTransactionAndWait(startupManager::startCacheUpdate);
            startupManager.runPostStartupActivitiesFromExtensions();
            GuiUtils.invokeLaterIfNeeded(() -> {
                if (project == null) {
                    ProjectManagerImpl.$$$reportNull$$$0(65);
                }
                if (!project.isDisposed()) {
                    startupManager.runPostStartupActivities();
                    Application application = ApplicationManager.getApplication();
                    if (!application.isHeadlessEnvironment() && !application.isUnitTestMode()) {
                        StorageUtilKt.checkUnknownMacros(project, true);
                    }
                }
            }, (ModalityState)ModalityState.NON_MODAL);
        };
        if (!this.loadProjectUnderProgress(project, process2)) {
            GuiUtils.invokeLaterIfNeeded(() -> {
                if (project == null) {
                    ProjectManagerImpl.$$$reportNull$$$0(62);
                }
                this.closeProject(project, false, false, false, true);
                WriteAction.run(() -> {
                    if (project == null) {
                        ProjectManagerImpl.$$$reportNull$$$0(63);
                    }
                    Disposer.dispose((Disposable)project);
                });
                ProjectManagerImpl.notifyProjectOpenFailed();
            }, (ModalityState)ModalityState.defaultModalityState());
            return false;
        }
        return true;
    }

    private boolean loadProjectUnderProgress(@NotNull Project project, @NotNull Runnable performLoading) {
        ProgressIndicator indicator;
        if (project == null) {
            ProjectManagerImpl.$$$reportNull$$$0(23);
        }
        if (performLoading == null) {
            ProjectManagerImpl.$$$reportNull$$$0(24);
        }
        if ((indicator = this.myProgressManager.getProgressIndicator()) != null) {
            indicator.setText("Preparing workspace...");
            try {
                performLoading.run();
                return true;
            }
            catch (ProcessCanceledException e) {
                return false;
            }
        }
        return this.myProgressManager.runProcessWithProgressSynchronously(performLoading, ProjectBundle.message((String)"project.load.progress", (Object[])new Object[0]), ProjectManagerImpl.canCancelProjectLoading(), project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addToOpened(@NotNull Project project) {
        if (project == null) {
            ProjectManagerImpl.$$$reportNull$$$0(25);
        }
        assert (!project.isDisposed()) : "Must not open already disposed project";
        Object object = this.lock;
        synchronized (object) {
            if (this.isProjectOpened(project)) {
                return false;
            }
            this.myOpenProjects = (Project[])ArrayUtil.append((Object[])this.myOpenProjects, (Object)project);
            ProjectCoreUtil.theProject = this.myOpenProjects.length == 1 ? project : null;
            this.myOpenProjectByHash.put(project.getLocationHash(), project);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromOpened(@NotNull Project project) {
        if (project == null) {
            ProjectManagerImpl.$$$reportNull$$$0(26);
        }
        Object object = this.lock;
        synchronized (object) {
            this.myOpenProjects = (Project[])ArrayUtil.remove((Object[])this.myOpenProjects, (Object)project);
            ProjectCoreUtil.theProject = this.myOpenProjects.length == 1 ? this.myOpenProjects[0] : null;
            this.myOpenProjectByHash.values().remove(project);
        }
    }

    @Nullable
    public Project findOpenProjectByHash(@Nullable String locationHash) {
        return this.myOpenProjectByHash.get(locationHash);
    }

    private static boolean canCancelProjectLoading() {
        return !ProgressManager.getInstance().isInNonCancelableSection();
    }

    public Project loadAndOpenProject(@NotNull String originalFilePath) throws IOException {
        ProjectImpl project;
        if (originalFilePath == null) {
            ProjectManagerImpl.$$$reportNull$$$0(27);
        }
        String filePath = ProjectManagerImpl.toCanonicalName(originalFilePath);
        final ConversionResult conversionResult = ConversionService.getInstance().convert(filePath);
        if (conversionResult.openingIsCanceled()) {
            project = null;
        } else {
            project = ProjectManagerImpl.createProject(null, filePath, false);
            this.myProgressManager.run((Task.WithResult)new Task.WithResult<Project, IOException>((Project)project, ProjectBundle.message((String)"project.load.progress", (Object[])new Object[0]), true){

                protected Project compute(@NotNull ProgressIndicator indicator) throws IOException {
                    if (indicator == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (!ProjectManagerImpl.this.loadProjectWithProgress(project)) {
                        return null;
                    }
                    if (!conversionResult.conversionNotNeeded()) {
                        StartupManager.getInstance((Project)project).registerPostStartupActivity(() -> conversionResult.postStartupActivity(project));
                    }
                    ProjectManagerImpl.this.openProject(project);
                    return project;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/project/impl/ProjectManagerImpl$2", "compute"));
                }
            });
        }
        if (project == null) {
            WelcomeFrame.showIfNoProjectOpened();
            return null;
        }
        if (!project.isOpen()) {
            WelcomeFrame.showIfNoProjectOpened();
            ApplicationManager.getApplication().runWriteAction(() -> {
                if (!project.isDisposed()) {
                    Disposer.dispose((Disposable)project);
                }
            });
        }
        return project;
    }

    @Override
    @Nullable
    public Project convertAndLoadProject(@NotNull String filePath) throws IOException {
        if (filePath == null) {
            ProjectManagerImpl.$$$reportNull$$$0(28);
        }
        String canonicalFilePath = ProjectManagerImpl.toCanonicalName(filePath);
        ConversionResult conversionResult = ConversionService.getInstance().convert(canonicalFilePath);
        if (conversionResult.openingIsCanceled()) {
            return null;
        }
        ProjectImpl project = ProjectManagerImpl.createProject(null, canonicalFilePath, false);
        if (!this.loadProjectWithProgress(project)) {
            return null;
        }
        if (!conversionResult.conversionNotNeeded()) {
            StartupManager.getInstance((Project)project).registerPostStartupActivity(() -> conversionResult.postStartupActivity(project));
        }
        return project;
    }

    private boolean loadProjectWithProgress(ProjectImpl project) throws IOException {
        try {
            if (!ApplicationManager.getApplication().isDispatchThread() && this.myProgressManager.getProgressIndicator() != null) {
                this.initProject(project, null);
                return true;
            }
            this.myProgressManager.runProcessWithProgressSynchronously(() -> {
                this.initProject(project, null);
                return project;
            }, ProjectBundle.message((String)"project.load.progress", (Object[])new Object[0]), ProjectManagerImpl.canCancelProjectLoading(), (Project)project);
            return true;
        }
        catch (ProcessCanceledException e) {
            return false;
        }
        catch (Throwable t) {
            LOG.info(t);
            throw new IOException(t);
        }
    }

    private static void notifyProjectOpenFailed() {
        Application application = ApplicationManager.getApplication();
        ((AppLifecycleListener)application.getMessageBus().syncPublisher(AppLifecycleListener.TOPIC)).projectOpenFailed();
        if (application.isUnitTestMode()) {
            return;
        }
        WelcomeFrame.showIfNoProjectOpened();
    }

    @Override
    public void openTestProject(@NotNull Project project) {
        if (project == null) {
            ProjectManagerImpl.$$$reportNull$$$0(29);
        }
        assert (ApplicationManager.getApplication().isUnitTestMode());
        this.openProject(project);
        UIUtil.dispatchAllInvocationEvents();
    }

    @Override
    @NotNull
    public Collection<Project> closeTestProject(@NotNull Project project) {
        if (project == null) {
            ProjectManagerImpl.$$$reportNull$$$0(30);
        }
        assert (ApplicationManager.getApplication().isUnitTestMode());
        this.forceCloseProject(project, false);
        Project[] projects = this.getOpenProjects();
        List<Object> list2 = projects.length == 0 ? Collections.emptyList() : Arrays.asList(projects);
        if (list2 == null) {
            ProjectManagerImpl.$$$reportNull$$$0(31);
        }
        return list2;
    }

    public void reloadProject(@NotNull Project project) {
        if (project == null) {
            ProjectManagerImpl.$$$reportNull$$$0(32);
        }
        ProjectManagerImpl.doReloadProject(project);
    }

    public static void doReloadProject(@NotNull Project project) {
        if (project == null) {
            ProjectManagerImpl.$$$reportNull$$$0(33);
        }
        Ref projectRef = Ref.create((Object)project);
        ProjectReloadState.getInstance((Project)project).onBeforeAutomaticProjectReload();
        ApplicationManager.getApplication().invokeLater(() -> {
            LOG.debug("Reloading project.");
            Project project1 = (Project)projectRef.get();
            projectRef.set(null);
            if (project1.isDisposed()) {
                return;
            }
            String presentableUrl = project1.getPresentableUrl();
            if (!ProjectUtil.closeAndDispose(project1)) {
                return;
            }
            ProjectUtil.openProject(presentableUrl, null, true);
        }, ModalityState.NON_MODAL);
    }

    public boolean closeProject(@NotNull Project project) {
        if (project == null) {
            ProjectManagerImpl.$$$reportNull$$$0(34);
        }
        return this.closeProject(project, true, true, false, true);
    }

    public boolean forceCloseProject(@NotNull Project project, boolean dispose2) {
        if (project == null) {
            ProjectManagerImpl.$$$reportNull$$$0(35);
        }
        return this.closeProject(project, false, false, dispose2, false);
    }

    public boolean closeAndDisposeAllProjects(boolean checkCanClose) {
        for (Project project : this.getOpenProjects()) {
            if (this.closeProject(project, true, false, true, checkCanClose)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean closeProject(@NotNull Project project, boolean saveProject, boolean saveApp, boolean dispose2, boolean checkCanClose) {
        Application app;
        if (project == null) {
            ProjectManagerImpl.$$$reportNull$$$0(36);
        }
        if ((app = ApplicationManager.getApplication()).isWriteAccessAllowed()) {
            throw new IllegalStateException("Must not call closeProject() from under write action because fireProjectClosing() listeners must have a chance to do something useful");
        }
        app.assertIsDispatchThread();
        if (ProjectManagerImpl.isLight(project)) {
            if (!((ProjectImpl)project).isTemporarilyDisposed()) {
                ((ProjectImpl)project).setTemporarilyDisposed(true);
                this.removeFromOpened(project);
                return true;
            }
            ((ProjectImpl)project).setTemporarilyDisposed(false);
        } else if (!this.isProjectOpened(project)) {
            return true;
        }
        if (checkCanClose && !this.canClose(project)) {
            return false;
        }
        FUSProjectUsageTrigger.getInstance(project).trigger(ProjectLifecycleUsageTriggerCollector.class, "project.closed");
        ShutDownTracker shutDownTracker = ShutDownTracker.getInstance();
        shutDownTracker.registerStopperThread(Thread.currentThread());
        try {
            this.myBusPublisher.projectClosingBeforeSave(project);
            if (saveProject) {
                FileDocumentManager.getInstance().saveAllDocuments();
                StoreUtil.saveProject(project, true);
                if (saveApp) {
                    app.saveSettings(true);
                }
            }
            if (checkCanClose && !ProjectManagerImpl.ensureCouldCloseIfUnableToSave(project)) {
                boolean bl = false;
                return bl;
            }
            this.fireProjectClosing(project);
            app.runWriteAction(() -> {
                if (project == null) {
                    ProjectManagerImpl.$$$reportNull$$$0(61);
                }
                this.removeFromOpened(project);
                this.fireProjectClosed(project);
                if (dispose2) {
                    Disposer.dispose((Disposable)project);
                }
            });
        }
        finally {
            shutDownTracker.unregisterStopperThread(Thread.currentThread());
        }
        return true;
    }

    public static boolean isLight(@NotNull Project project) {
        if (project == null) {
            ProjectManagerImpl.$$$reportNull$$$0(37);
        }
        return project instanceof ProjectImpl && ((ProjectImpl)project).isLight();
    }

    @Override
    public boolean closeAndDispose(@NotNull Project project) {
        if (project == null) {
            ProjectManagerImpl.$$$reportNull$$$0(38);
        }
        return this.closeProject(project, true, true, true, true);
    }

    private void fireProjectClosing(@NotNull Project project) {
        if (project == null) {
            ProjectManagerImpl.$$$reportNull$$$0(39);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: fireProjectClosing()");
        }
        this.myBusPublisher.projectClosing(project);
    }

    public void addProjectManagerListener(@NotNull ProjectManagerListener listener2) {
        if (listener2 == null) {
            ProjectManagerImpl.$$$reportNull$$$0(40);
        }
        this.myListeners.add(listener2);
    }

    public void addProjectManagerListener(@NotNull VetoableProjectManagerListener listener2) {
        if (listener2 == null) {
            ProjectManagerImpl.$$$reportNull$$$0(41);
        }
        this.myListeners.add((ProjectManagerListener)listener2);
    }

    public void addProjectManagerListener(@NotNull ProjectManagerListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            ProjectManagerImpl.$$$reportNull$$$0(42);
        }
        if (parentDisposable == null) {
            ProjectManagerImpl.$$$reportNull$$$0(43);
        }
        this.addProjectManagerListener(listener2);
        Disposer.register((Disposable)parentDisposable, () -> {
            if (listener2 == null) {
                ProjectManagerImpl.$$$reportNull$$$0(60);
            }
            this.removeProjectManagerListener(listener2);
        });
    }

    public void removeProjectManagerListener(@NotNull ProjectManagerListener listener2) {
        if (listener2 == null) {
            ProjectManagerImpl.$$$reportNull$$$0(44);
        }
        boolean removed = this.myListeners.remove(listener2);
        LOG.assertTrue(removed);
    }

    public void removeProjectManagerListener(@NotNull VetoableProjectManagerListener listener2) {
        if (listener2 == null) {
            ProjectManagerImpl.$$$reportNull$$$0(45);
        }
        boolean removed = this.myListeners.remove(listener2);
        LOG.assertTrue(removed);
    }

    public void addProjectManagerListener(@NotNull Project project, @NotNull ProjectManagerListener listener2) {
        List listeners;
        if (project == null) {
            ProjectManagerImpl.$$$reportNull$$$0(46);
        }
        if (listener2 == null) {
            ProjectManagerImpl.$$$reportNull$$$0(47);
        }
        if ((listeners = (List)project.getUserData(LISTENERS_IN_PROJECT_KEY)) == null) {
            listeners = (List)((UserDataHolderEx)project).putUserDataIfAbsent(LISTENERS_IN_PROJECT_KEY, (Object)ContainerUtil.createLockFreeCopyOnWriteList());
        }
        listeners.add(listener2);
    }

    public void removeProjectManagerListener(@NotNull Project project, @NotNull ProjectManagerListener listener2) {
        List listeners;
        if (project == null) {
            ProjectManagerImpl.$$$reportNull$$$0(48);
        }
        if (listener2 == null) {
            ProjectManagerImpl.$$$reportNull$$$0(49);
        }
        LOG.assertTrue((listeners = (List)project.getUserData(LISTENERS_IN_PROJECT_KEY)) != null);
        boolean removed = listeners.remove(listener2);
        LOG.assertTrue(removed);
    }

    private void fireProjectOpened(@NotNull Project project) {
        if (project == null) {
            ProjectManagerImpl.$$$reportNull$$$0(50);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("projectOpened");
        }
        FUSProjectUsageTrigger.getInstance(project).trigger(ProjectLifecycleUsageTriggerCollector.class, "project.opened");
        FeatureUsageLogger.INSTANCE.log("lifecycle", "project.opened");
        this.myBusPublisher.projectOpened(project);
        if (project instanceof ProjectImpl) {
            for (ProjectComponent component : ((ProjectImpl)project).getComponentInstancesOfType(ProjectComponent.class)) {
                try {
                    component.projectOpened();
                }
                catch (Throwable e) {
                    LOG.error(component.toString(), e);
                }
            }
        }
    }

    private void fireProjectClosed(@NotNull Project project) {
        if (project == null) {
            ProjectManagerImpl.$$$reportNull$$$0(51);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("projectClosed");
        }
        FeatureUsageLogger.INSTANCE.log("lifecycle", "project.closed");
        this.myBusPublisher.projectClosed(project);
        if (project instanceof ProjectImpl) {
            List<ProjectComponent> components = ((ProjectImpl)project).getComponentInstancesOfType(ProjectComponent.class);
            for (int i = components.size() - 1; i >= 0; --i) {
                ProjectComponent component = components.get(i);
                try {
                    component.projectClosed();
                    continue;
                }
                catch (Throwable e) {
                    LOG.error(component.toString(), e);
                }
            }
        }
    }

    @Override
    public boolean canClose(@NotNull Project project) {
        if (project == null) {
            ProjectManagerImpl.$$$reportNull$$$0(52);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: canClose()");
        }
        for (ProjectManagerListener listener2 : this.getAllListeners(project)) {
            try {
                boolean canClose = listener2 instanceof VetoableProjectManagerListener ? ((VetoableProjectManagerListener)listener2).canClose(project) : listener2.canCloseProject(project);
                if (canClose) continue;
                LOG.debug("close canceled by " + listener2);
                return false;
            }
            catch (Throwable e) {
                ProjectManagerImpl.handleListenerError(e, listener2);
            }
        }
        return true;
    }

    @NotNull
    private List<ProjectManagerListener> getAllListeners(@NotNull Project project) {
        List<ProjectManagerListener> projectLevelListeners;
        if (project == null) {
            ProjectManagerImpl.$$$reportNull$$$0(53);
        }
        if ((projectLevelListeners = ProjectManagerImpl.getListeners(project)).isEmpty()) {
            List<ProjectManagerListener> list2 = this.myListeners;
            if (list2 == null) {
                ProjectManagerImpl.$$$reportNull$$$0(54);
            }
            return list2;
        }
        if (this.myListeners.isEmpty()) {
            List<ProjectManagerListener> list3 = projectLevelListeners;
            if (list3 == null) {
                ProjectManagerImpl.$$$reportNull$$$0(55);
            }
            return list3;
        }
        ArrayList<ProjectManagerListener> result2 = new ArrayList<ProjectManagerListener>(projectLevelListeners.size() + this.myListeners.size());
        result2.addAll(projectLevelListeners);
        result2.addAll(this.myListeners);
        ArrayList<ProjectManagerListener> arrayList = result2;
        if (arrayList == null) {
            ProjectManagerImpl.$$$reportNull$$$0(56);
        }
        return arrayList;
    }

    private static boolean ensureCouldCloseIfUnableToSave(@NotNull Project project) {
        VirtualFile[] files2;
        UnableToSaveProjectNotification[] notifications;
        if (project == null) {
            ProjectManagerImpl.$$$reportNull$$$0(57);
        }
        if ((notifications = (UnableToSaveProjectNotification[])NotificationsManager.getNotificationsManager().getNotificationsOfType(UnableToSaveProjectNotification.class, project)).length == 0) {
            return true;
        }
        StringBuilder message = new StringBuilder();
        message.append(String.format("%s was unable to save some project files,\nare you sure you want to close this project anyway?", ApplicationNamesInfo.getInstance().getProductName()));
        message.append("\n\nRead-only files:\n");
        int count = 0;
        for (VirtualFile file2 : files2 = notifications[0].myFiles) {
            if (count == 10) {
                message.append('\n').append("and ").append(files2.length - count).append(" more").append('\n');
                continue;
            }
            message.append(file2.getPath()).append('\n');
            ++count;
        }
        return Messages.showYesNoDialog((Project)project, (String)message.toString(), (String)"Unsaved Project", (Icon)Messages.getWarningIcon()) == 0;
    }

    @Override
    public void saveChangedProjectFile(@NotNull VirtualFile file2, @NotNull Project project) {
        if (file2 == null) {
            ProjectManagerImpl.$$$reportNull$$$0(58);
        }
        if (project == null) {
            ProjectManagerImpl.$$$reportNull$$$0(59);
        }
    }

    @Override
    public void blockReloadingProjectOnExternalChanges() {
    }

    @Override
    public void unblockReloadingProjectOnExternalChanges() {
    }

    static {
        LOG_PROJECT_LEAKAGE_IN_TESTS = Boolean.parseBoolean(System.getProperty("idea.log.leaked.projects.in.tests", "true"));
        LEAK_CHECK_INTERVAL = TimeUnit.MINUTES.toMillis(30L);
        CHECK_START = System.currentTimeMillis();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 31: 
            case 54: 
            case 55: 
            case 56: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 31: 
            case 54: 
            case 55: 
            case 56: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 31: 
            case 54: 
            case 55: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/project/impl/ProjectManagerImpl";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 47: 
            case 49: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 5: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "performLoading";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalFilePath";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/project/impl/ProjectManagerImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getListeners";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "message";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createProject";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "toCanonicalName";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultProject";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getOpenProjects";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "closeTestProject";
                break;
            }
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllListeners";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getListeners";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 31: 
            case 54: 
            case 55: 
            case 56: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "handleListenerError";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "newProject";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "message";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "initProject";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createProject";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "loadProject";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "toCanonicalName";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "openProject";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "loadProjectUnderProgress";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addToOpened";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "removeFromOpened";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "loadAndOpenProject";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "convertAndLoadProject";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "openTestProject";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "closeTestProject";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "reloadProject";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "doReloadProject";
                break;
            }
            case 34: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "closeProject";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "forceCloseProject";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "isLight";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "closeAndDispose";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "fireProjectClosing";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "addProjectManagerListener";
                break;
            }
            case 44: 
            case 45: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "removeProjectManagerListener";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "fireProjectOpened";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "fireProjectClosed";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "canClose";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getAllListeners";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "ensureCouldCloseIfUnableToSave";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "saveChangedProjectFile";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addProjectManagerListener$16";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "lambda$closeProject$15";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "lambda$openProject$10";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$9";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "lambda$openProject$8";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$7";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$6";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "lambda$initProject$3";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 31: 
            case 54: 
            case 55: 
            case 56: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class UnableToSaveProjectNotification
    extends Notification {
        private Project myProject;
        public VirtualFile[] myFiles;

        public UnableToSaveProjectNotification(@NotNull Project project, @NotNull VirtualFile[] readOnlyFiles) {
            if (project == null) {
                UnableToSaveProjectNotification.$$$reportNull$$$0(0);
            }
            if (readOnlyFiles == null) {
                UnableToSaveProjectNotification.$$$reportNull$$$0(1);
            }
            super("Project Settings", "Could not save project", "Unable to save project files. Please ensure project files are writable and you have permissions to modify them. <a href=\"\">Try to save project again</a>.", NotificationType.ERROR, (notification2, event) -> {
                UnableToSaveProjectNotification unableToSaveProjectNotification = (UnableToSaveProjectNotification)notification2;
                Project _project = unableToSaveProjectNotification.myProject;
                notification2.expire();
                if (_project != null && !_project.isDisposed()) {
                    _project.save();
                }
            });
            this.myProject = project;
            this.myFiles = readOnlyFiles;
        }

        public void expire() {
            this.myProject = null;
            super.expire();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "readOnlyFiles";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/project/impl/ProjectManagerImpl$UnableToSaveProjectNotification";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

