/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerContainer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class OrderRootsCache {
    private final AtomicReference<Map<CacheKey, VirtualFilePointerContainer>> myRoots;
    private final Disposable myParentDisposable;
    private Disposable myRootsDisposable;

    OrderRootsCache(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            OrderRootsCache.$$$reportNull$$$0(0);
        }
        this.myRoots = new AtomicReference();
        this.myParentDisposable = parentDisposable;
        this.disposePointers();
    }

    private void disposePointers() {
        if (this.myRootsDisposable != null) {
            Disposer.dispose((Disposable)this.myRootsDisposable);
        }
        if (!Disposer.isDisposing((Disposable)this.myParentDisposable)) {
            this.myRootsDisposable = Disposer.newDisposable();
            Disposer.register((Disposable)this.myParentDisposable, (Disposable)this.myRootsDisposable);
        }
    }

    VirtualFilePointerContainer setCachedRoots(@NotNull OrderRootType rootType, int flags, @NotNull Collection<String> urls) {
        if (rootType == null) {
            OrderRootsCache.$$$reportNull$$$0(1);
        }
        if (urls == null) {
            OrderRootsCache.$$$reportNull$$$0(2);
        }
        VirtualFilePointerContainer container = VirtualFilePointerManager.getInstance().createContainer(this.myRootsDisposable);
        for (String url : urls) {
            container.add(url);
        }
        Map map2 = this.myRoots.get();
        if (map2 == null) {
            map2 = (Map)ConcurrencyUtil.cacheOrGet(this.myRoots, (Object)ContainerUtil.newConcurrentMap());
        }
        map2.put(new CacheKey(rootType, flags), container);
        return container;
    }

    @Nullable
    public VirtualFile[] getCachedRoots(@NotNull OrderRootType rootType, int flags) {
        Map<CacheKey, VirtualFilePointerContainer> map2;
        if (rootType == null) {
            OrderRootsCache.$$$reportNull$$$0(3);
        }
        VirtualFilePointerContainer cached = (map2 = this.myRoots.get()) == null ? null : map2.get(new CacheKey(rootType, flags));
        return cached == null ? null : cached.getFiles();
    }

    @Nullable
    public String[] getCachedUrls(@NotNull OrderRootType rootType, int flags) {
        Map<CacheKey, VirtualFilePointerContainer> map2;
        if (rootType == null) {
            OrderRootsCache.$$$reportNull$$$0(4);
        }
        VirtualFilePointerContainer cached = (map2 = this.myRoots.get()) == null ? null : map2.get(new CacheKey(rootType, flags));
        return cached != null ? cached.getUrls() : null;
    }

    public void clearCache() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.disposePointers();
        this.myRoots.set(null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/roots/impl/OrderRootsCache";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setCachedRoots";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getCachedRoots";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getCachedUrls";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class CacheKey {
        private final OrderRootType myRootType;
        private final int myFlags;

        private CacheKey(@NotNull OrderRootType rootType, int flags) {
            if (rootType == null) {
                CacheKey.$$$reportNull$$$0(0);
            }
            this.myRootType = rootType;
            this.myFlags = flags;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.myFlags == cacheKey.myFlags && this.myRootType.equals((Object)cacheKey.myRootType);
        }

        public int hashCode() {
            return 31 * this.myRootType.hashCode() + this.myFlags;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "com/intellij/openapi/roots/impl/OrderRootsCache$CacheKey", "<init>"));
        }
    }
}

