/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.ProjectTopics;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.vcs.changes.ChangesViewManager;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.problems.ProblemListener;
import com.intellij.util.messages.MessageBusConnection;
import org.jetbrains.annotations.NotNull;

public class VcsEventWatcher
implements ProjectComponent {
    private final Project myProject;

    public VcsEventWatcher(Project project) {
        this.myProject = project;
    }

    public void projectOpened() {
        MessageBusConnection connection = this.myProject.getMessageBus().connect();
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(ModuleRootEvent event) {
                ApplicationManager.getApplication().invokeLater(() -> VcsDirtyScopeManager.getInstance((Project)VcsEventWatcher.this.myProject).markEverythingDirty(), ModalityState.NON_MODAL, VcsEventWatcher.this.myProject.getDisposed());
            }
        });
        connection.subscribe(ProblemListener.TOPIC, (Object)new ProblemListener(){

            public void problemsAppeared(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                ChangesViewManager.getInstance(VcsEventWatcher.this.myProject).refreshChangesViewNodeAsync(file2);
            }

            public void problemsDisappeared(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                ChangesViewManager.getInstance(VcsEventWatcher.this.myProject).refreshChangesViewNodeAsync(file2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "file";
                objectArray2[1] = "com/intellij/openapi/vcs/changes/VcsEventWatcher$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "problemsAppeared";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "problemsDisappeared";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }
}

