/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.EditChangelistDialog;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.Nullable;

public class RenameChangeListAction
extends AnAction
implements DumbAware {
    public void update(AnActionEvent e) {
        LocalChangeList target2 = RenameChangeListAction.getTargetChangeList(e);
        boolean visible = target2 != null && !target2.isReadOnly();
        e.getPresentation().setEnabled(visible);
        if (e.getPlace().equals("ChangesViewPopup")) {
            e.getPresentation().setVisible(visible);
        }
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        LocalChangeList target2 = RenameChangeListAction.getTargetChangeList(e);
        if (target2 != null) {
            new EditChangelistDialog(project, target2).show();
        }
    }

    @Nullable
    private static LocalChangeList getTargetChangeList(AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return null;
        }
        Object[] lists = (ChangeList[])e.getData(VcsDataKeys.CHANGE_LISTS);
        if (!ArrayUtil.isEmpty((Object[])lists)) {
            if (lists.length == 1) {
                return ChangeListManager.getInstance((Project)project).findChangeList(lists[0].getName());
            }
            return null;
        }
        Change[] changes = (Change[])e.getData(VcsDataKeys.CHANGES);
        if (changes == null) {
            return null;
        }
        LocalChangeList result2 = null;
        for (Change change : changes) {
            LocalChangeList cl = ChangeListManager.getInstance((Project)project).getChangeList(change);
            if (result2 == null) {
                result2 = cl;
                continue;
            }
            if (cl == null || cl.equals(result2)) continue;
            return null;
        }
        return result2;
    }
}

