/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManager;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.requests.UnknownFileTypeDiffRequest;
import com.intellij.diff.tools.util.DiffNotifications;
import com.intellij.diff.tools.util.SoftHardCacheMap;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionExtensionProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diff.impl.patch.ApplyPatchContext;
import com.intellij.openapi.diff.impl.patch.BaseRevisionTextPatchEP;
import com.intellij.openapi.diff.impl.patch.PatchEP;
import com.intellij.openapi.diff.impl.patch.PatchSyntaxException;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.ApplyFilePatchBase;
import com.intellij.openapi.diff.impl.patch.apply.GenericPatchApplier;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.FilePathsHelper;
import com.intellij.openapi.vcs.changes.patch.AppliedTextPatch;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchForBaseRevisionTexts;
import com.intellij.openapi.vcs.changes.patch.PatchDiffRequestFactory;
import com.intellij.openapi.vcs.changes.patch.tool.PatchDiffRequest;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFile;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChange;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangesViewManager;
import com.intellij.openapi.vcs.changes.ui.ChangeDiffRequestChain;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffShelvedChangesActionProvider
implements AnActionExtensionProvider {
    private static final String DIFF_WITH_BASE_ERROR = "Base content not found or not applicable.";
    public static final String SHELVED_VERSION = "Shelved Version";
    public static final String BASE_VERSION = "Base Version";
    public static final String CURRENT_VERSION = "Current Version";

    @Override
    public boolean isActive(@NotNull AnActionEvent e) {
        if (e == null) {
            DiffShelvedChangesActionProvider.$$$reportNull$$$0(0);
        }
        return e.getData(ShelvedChangesViewManager.SHELVED_CHANGELIST_KEY) != null || e.getData(ShelvedChangesViewManager.SHELVED_RECYCLED_CHANGELIST_KEY) != null;
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            DiffShelvedChangesActionProvider.$$$reportNull$$$0(1);
        }
        e.getPresentation().setEnabled(DiffShelvedChangesActionProvider.isEnabled(e.getDataContext()));
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            DiffShelvedChangesActionProvider.$$$reportNull$$$0(2);
        }
        DiffShelvedChangesActionProvider.showShelvedChangesDiff(e.getDataContext());
    }

    public static boolean isEnabled(DataContext dc) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dc);
        if (project == null) {
            return false;
        }
        List<ShelvedChangeList> changeLists = ShelvedChangesViewManager.getShelvedLists(dc);
        return changeLists.size() == 1;
    }

    public static void showShelvedChangesDiff(DataContext dc) {
        DiffShelvedChangesActionProvider.showShelvedChangesDiff(dc, false);
    }

    public static void showShelvedChangesDiff(DataContext dc, boolean withLocal) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dc);
        if (project == null) {
            return;
        }
        if (ChangeListManager.getInstance((Project)project).isFreezedWithNotification(null)) {
            return;
        }
        List<ShelvedChangeList> changeLists = ShelvedChangesViewManager.getShelvedLists(dc);
        ShelvedChangeList changeList = (ShelvedChangeList)ObjectUtils.assertNotNull((Object)ContainerUtil.getFirstItem(changeLists));
        List<ShelvedChange> textChanges = changeList.getChanges(project);
        List<ShelvedBinaryFile> binaryChanges = changeList.getBinaryFiles();
        ArrayList<ShelveDiffRequestProducer> diffRequestProducers = new ArrayList<ShelveDiffRequestProducer>();
        DiffShelvedChangesActionProvider.processTextChanges(project, textChanges, diffRequestProducers, withLocal);
        DiffShelvedChangesActionProvider.processBinaryFiles(project, binaryChanges, diffRequestProducers);
        Collections.sort(diffRequestProducers, ChangeDiffRequestComparator.getInstance());
        HashSet<Object> selectedChanges = new HashSet<Object>();
        selectedChanges.addAll(ShelvedChangesViewManager.getShelveChanges(dc));
        selectedChanges.addAll(ShelvedChangesViewManager.getBinaryShelveChanges(dc));
        int index = 0;
        for (int i = 0; i < diffRequestProducers.size(); ++i) {
            ShelveDiffRequestProducer producer = (ShelveDiffRequestProducer)diffRequestProducers.get(i);
            if (!selectedChanges.contains(producer.getBinaryChange()) && !selectedChanges.contains(producer.getTextChange())) continue;
            index = i;
            break;
        }
        ChangeDiffRequestChain chain = new ChangeDiffRequestChain(diffRequestProducers, index);
        DiffManager.getInstance().showDiff(project, (DiffRequestChain)chain, DiffDialogHints.FRAME);
    }

    private static void processBinaryFiles(@NotNull Project project, @NotNull List<ShelvedBinaryFile> files2, @NotNull List<ShelveDiffRequestProducer> diffRequestProducers) {
        if (project == null) {
            DiffShelvedChangesActionProvider.$$$reportNull$$$0(3);
        }
        if (files2 == null) {
            DiffShelvedChangesActionProvider.$$$reportNull$$$0(4);
        }
        if (diffRequestProducers == null) {
            DiffShelvedChangesActionProvider.$$$reportNull$$$0(5);
        }
        String base = project.getBasePath();
        for (ShelvedBinaryFile shelvedChange : files2) {
            File file2 = new File(base, shelvedChange.AFTER_PATH == null ? shelvedChange.BEFORE_PATH : shelvedChange.AFTER_PATH);
            FilePath filePath = VcsUtil.getFilePath((File)file2);
            diffRequestProducers.add(new BinaryShelveDiffRequestProducer(project, shelvedChange, filePath));
        }
    }

    private static void processTextChanges(@NotNull Project project, @NotNull List<ShelvedChange> changesFromFirstList, @NotNull List<ShelveDiffRequestProducer> diffRequestProducers, boolean withLocal) {
        if (project == null) {
            DiffShelvedChangesActionProvider.$$$reportNull$$$0(6);
        }
        if (changesFromFirstList == null) {
            DiffShelvedChangesActionProvider.$$$reportNull$$$0(7);
        }
        if (diffRequestProducers == null) {
            DiffShelvedChangesActionProvider.$$$reportNull$$$0(8);
        }
        String base = project.getBasePath();
        ApplyPatchContext patchContext = new ApplyPatchContext(project.getBaseDir(), 0, false, false);
        PatchesPreloader preloader = new PatchesPreloader(project);
        CommitContext commitContext = new CommitContext();
        for (ShelvedChange shelvedChange : changesFromFirstList) {
            String beforePath = shelvedChange.getBeforePath();
            String afterPath = shelvedChange.getAfterPath();
            FilePath filePath = VcsUtil.getFilePath((File)new File(base, afterPath == null ? beforePath : afterPath));
            boolean isNewFile = FileStatus.ADDED.equals(shelvedChange.getFileStatus());
            try {
                if (isNewFile) {
                    diffRequestProducers.add(new NewFileTextShelveDiffRequestProducer(project, shelvedChange, filePath, preloader, commitContext, withLocal));
                    continue;
                }
                VirtualFile file2 = ApplyFilePatchBase.findPatchTarget(patchContext, beforePath, afterPath, isNewFile);
                if (file2 == null || !file2.exists()) {
                    throw new FileNotFoundException(beforePath);
                }
                diffRequestProducers.add(new TextShelveDiffRequestProducer(project, shelvedChange, filePath, file2, patchContext, preloader, commitContext, withLocal));
            }
            catch (IOException e) {
                diffRequestProducers.add(new PatchShelveDiffRequestProducer(project, shelvedChange, filePath, preloader, commitContext));
            }
        }
    }

    @NotNull
    static AppliedTextPatch createAppliedTextPatch(@NotNull TextFilePatch patch) {
        if (patch == null) {
            DiffShelvedChangesActionProvider.$$$reportNull$$$0(9);
        }
        GenericPatchApplier applier = new GenericPatchApplier("", patch.getHunks());
        applier.execute();
        AppliedTextPatch appliedTextPatch = AppliedTextPatch.create(applier.getAppliedInfo());
        if (appliedTextPatch == null) {
            DiffShelvedChangesActionProvider.$$$reportNull$$$0(10);
        }
        return appliedTextPatch;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diffRequestProducers";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changesFromFirstList";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patch";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createAppliedTextPatch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isActive";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processBinaryFiles";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processTextChanges";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createAppliedTextPatch";
                break;
            }
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static abstract class BaseTextShelveDiffRequestProducer
    extends ShelveDiffRequestProducer {
        @NotNull
        protected final Project myProject;
        @NotNull
        protected final ShelvedChange myChange;

        public BaseTextShelveDiffRequestProducer(@NotNull Project project, @NotNull ShelvedChange change, @NotNull FilePath filePath) {
            if (project == null) {
                BaseTextShelveDiffRequestProducer.$$$reportNull$$$0(0);
            }
            if (change == null) {
                BaseTextShelveDiffRequestProducer.$$$reportNull$$$0(1);
            }
            if (filePath == null) {
                BaseTextShelveDiffRequestProducer.$$$reportNull$$$0(2);
            }
            super(filePath);
            this.myChange = change;
            this.myProject = project;
        }

        @Override
        @NotNull
        public FileStatus getFileStatus() {
            FileStatus fileStatus = this.myChange.getFileStatus();
            if (fileStatus == null) {
                BaseTextShelveDiffRequestProducer.$$$reportNull$$$0(3);
            }
            return fileStatus;
        }

        @Override
        @NotNull
        public ShelvedChange getTextChange() {
            ShelvedChange shelvedChange = this.myChange;
            if (shelvedChange == null) {
                BaseTextShelveDiffRequestProducer.$$$reportNull$$$0(4);
            }
            return shelvedChange;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$BaseTextShelveDiffRequestProducer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$BaseTextShelveDiffRequestProducer";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileStatus";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextChange";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class TextShelveDiffRequestProducer
    extends BaseTextShelveDiffRequestProducer {
        @NotNull
        private final VirtualFile myFile;
        @NotNull
        private final ApplyPatchContext myPatchContext;
        @NotNull
        private final PatchesPreloader myPreloader;
        @NotNull
        private final CommitContext myCommitContext;
        private final boolean myWithLocal;

        public TextShelveDiffRequestProducer(@NotNull Project project, @NotNull ShelvedChange change, @NotNull FilePath filePath, @NotNull VirtualFile file2, @NotNull ApplyPatchContext patchContext, @NotNull PatchesPreloader preloader, @NotNull CommitContext commitContext, boolean withLocal) {
            if (project == null) {
                TextShelveDiffRequestProducer.$$$reportNull$$$0(0);
            }
            if (change == null) {
                TextShelveDiffRequestProducer.$$$reportNull$$$0(1);
            }
            if (filePath == null) {
                TextShelveDiffRequestProducer.$$$reportNull$$$0(2);
            }
            if (file2 == null) {
                TextShelveDiffRequestProducer.$$$reportNull$$$0(3);
            }
            if (patchContext == null) {
                TextShelveDiffRequestProducer.$$$reportNull$$$0(4);
            }
            if (preloader == null) {
                TextShelveDiffRequestProducer.$$$reportNull$$$0(5);
            }
            if (commitContext == null) {
                TextShelveDiffRequestProducer.$$$reportNull$$$0(6);
            }
            super(project, change, filePath);
            this.myFile = file2;
            this.myPatchContext = patchContext;
            this.myPreloader = preloader;
            this.myCommitContext = commitContext;
            this.myWithLocal = withLocal;
        }

        @NotNull
        public DiffRequest process(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException, ProcessCanceledException {
            ApplyPatchForBaseRevisionTexts texts;
            TextFilePatch patch;
            block13: {
                block12: {
                    DiffRequest diffRequest;
                    if (context == null) {
                        TextShelveDiffRequestProducer.$$$reportNull$$$0(7);
                    }
                    if (indicator == null) {
                        TextShelveDiffRequestProducer.$$$reportNull$$$0(8);
                    }
                    if (this.myFile.getFileType() == UnknownFileType.INSTANCE) {
                        UnknownFileTypeDiffRequest unknownFileTypeDiffRequest = new UnknownFileTypeDiffRequest(this.myFile, this.getName());
                        if (unknownFileTypeDiffRequest == null) {
                            TextShelveDiffRequestProducer.$$$reportNull$$$0(9);
                        }
                        return unknownFileTypeDiffRequest;
                    }
                    try {
                        patch = this.myPreloader.getPatch(this.myChange, this.myCommitContext);
                        if (!patch.isDeletedFile()) break block12;
                        diffRequest = this.createDiffRequestForDeleted(patch);
                    }
                    catch (VcsException e) {
                        throw new DiffRequestProducerException("Can't show diff for '" + this.getFilePath() + "'", (Throwable)e);
                    }
                    if (diffRequest == null) {
                        TextShelveDiffRequestProducer.$$$reportNull$$$0(10);
                    }
                    return diffRequest;
                }
                String path = (String)ObjectUtils.chooseNotNull((Object)patch.getAfterName(), (Object)patch.getBeforeName());
                CharSequence baseContents = ((BaseRevisionTextPatchEP)Extensions.findExtension((ExtensionPointName)PatchEP.EP_NAME, (AreaInstance)this.myProject, BaseRevisionTextPatchEP.class)).provideContent(path, this.myCommitContext);
                texts = ApplyPatchForBaseRevisionTexts.create(this.myProject, this.myFile, this.myPatchContext.getPathBeforeRename(this.myFile), patch, baseContents);
                if (!texts.isBaseRevisionLoaded()) break block13;
                assert (!texts.isAppliedSomehow());
                DiffRequest diffRequest = this.createDiffRequestUsingBase(texts);
                if (diffRequest == null) {
                    TextShelveDiffRequestProducer.$$$reportNull$$$0(11);
                }
                return diffRequest;
            }
            DiffRequest diffRequest = this.createDiffRequestUsingLocal(texts, patch, context, indicator);
            if (diffRequest == null) {
                TextShelveDiffRequestProducer.$$$reportNull$$$0(12);
            }
            return diffRequest;
        }

        @NotNull
        private DiffRequest createDiffRequestForDeleted(@NotNull TextFilePatch patch) {
            String leftTitle;
            DiffContent leftContent;
            if (patch == null) {
                TextShelveDiffRequestProducer.$$$reportNull$$$0(13);
            }
            DiffContentFactory contentFactory = DiffContentFactory.getInstance();
            if (this.myWithLocal) {
                leftContent = contentFactory.create(this.myProject, this.myFile);
                leftTitle = DiffShelvedChangesActionProvider.CURRENT_VERSION;
            } else {
                leftContent = contentFactory.create(this.myProject, patch.getSingleHunkPatchText(), this.myFile);
                leftTitle = DiffShelvedChangesActionProvider.SHELVED_VERSION;
            }
            EmptyContent rightContent = contentFactory.createEmpty();
            String rightTitle = null;
            SimpleDiffRequest simpleDiffRequest = new SimpleDiffRequest(this.getName(), leftContent, (DiffContent)rightContent, leftTitle, rightTitle);
            if (simpleDiffRequest == null) {
                TextShelveDiffRequestProducer.$$$reportNull$$$0(14);
            }
            return simpleDiffRequest;
        }

        @NotNull
        private DiffRequest createDiffRequestUsingBase(@NotNull ApplyPatchForBaseRevisionTexts texts) {
            String leftTitle;
            DiffContent leftContent;
            if (texts == null) {
                TextShelveDiffRequestProducer.$$$reportNull$$$0(15);
            }
            DiffContentFactory contentFactory = DiffContentFactory.getInstance();
            if (this.myWithLocal) {
                leftContent = contentFactory.create(this.myProject, this.myFile);
                leftTitle = DiffShelvedChangesActionProvider.CURRENT_VERSION;
            } else {
                leftContent = contentFactory.create(this.myProject, (String)ObjectUtils.assertNotNull((Object)texts.getBase()), this.myFile);
                leftTitle = DiffShelvedChangesActionProvider.BASE_VERSION;
            }
            DocumentContent rightContent = contentFactory.create(this.myProject, texts.getPatched(), this.myFile);
            String rightTitle = DiffShelvedChangesActionProvider.SHELVED_VERSION;
            SimpleDiffRequest simpleDiffRequest = new SimpleDiffRequest(this.getName(), leftContent, (DiffContent)rightContent, leftTitle, rightTitle);
            if (simpleDiffRequest == null) {
                TextShelveDiffRequestProducer.$$$reportNull$$$0(16);
            }
            return simpleDiffRequest;
        }

        private DiffRequest createDiffRequestUsingLocal(@NotNull ApplyPatchForBaseRevisionTexts texts, @NotNull TextFilePatch patch, @NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException {
            DiffRequest diffRequest;
            if (texts == null) {
                TextShelveDiffRequestProducer.$$$reportNull$$$0(17);
            }
            if (patch == null) {
                TextShelveDiffRequestProducer.$$$reportNull$$$0(18);
            }
            if (context == null) {
                TextShelveDiffRequestProducer.$$$reportNull$$$0(19);
            }
            if (indicator == null) {
                TextShelveDiffRequestProducer.$$$reportNull$$$0(20);
            }
            DiffRequest diffRequest2 = diffRequest = this.myChange.isConflictingChange(this.myProject) ? PatchDiffRequestFactory.createConflictDiffRequest(this.myProject, this.myFile, patch, DiffShelvedChangesActionProvider.SHELVED_VERSION, texts, this.getName()) : PatchDiffRequestFactory.createDiffRequest(this.myProject, this.myChange.getChange(this.myProject), this.getName(), context, indicator);
            if (!this.myWithLocal) {
                DiffUtil.addNotification(DiffNotifications.createNotification("Base content not found or not applicable. Showing difference with local version"), (UserDataHolder)diffRequest);
            }
            return diffRequest;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 14: 
                case 16: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 14: 
                case 16: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "patchContext";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "preloader";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commitContext";
                    break;
                }
                case 7: 
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 8: 
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 14: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$TextShelveDiffRequestProducer";
                    break;
                }
                case 13: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "patch";
                    break;
                }
                case 15: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "texts";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$TextShelveDiffRequestProducer";
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "process";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createDiffRequestForDeleted";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createDiffRequestUsingBase";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "process";
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 14: 
                case 16: {
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "createDiffRequestForDeleted";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "createDiffRequestUsingBase";
                    break;
                }
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "createDiffRequestUsingLocal";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 14: 
                case 16: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class NewFileTextShelveDiffRequestProducer
    extends BaseTextShelveDiffRequestProducer {
        @NotNull
        private final PatchesPreloader myPreloader;
        @NotNull
        private final CommitContext myCommitContext;
        private final boolean myWithLocal;

        public NewFileTextShelveDiffRequestProducer(@NotNull Project project, @NotNull ShelvedChange change, @NotNull FilePath filePath, @NotNull PatchesPreloader preloader, @NotNull CommitContext commitContext, boolean withLocal) {
            if (project == null) {
                NewFileTextShelveDiffRequestProducer.$$$reportNull$$$0(0);
            }
            if (change == null) {
                NewFileTextShelveDiffRequestProducer.$$$reportNull$$$0(1);
            }
            if (filePath == null) {
                NewFileTextShelveDiffRequestProducer.$$$reportNull$$$0(2);
            }
            if (preloader == null) {
                NewFileTextShelveDiffRequestProducer.$$$reportNull$$$0(3);
            }
            if (commitContext == null) {
                NewFileTextShelveDiffRequestProducer.$$$reportNull$$$0(4);
            }
            super(project, change, filePath);
            this.myPreloader = preloader;
            this.myCommitContext = commitContext;
            this.myWithLocal = withLocal;
        }

        @NotNull
        public DiffRequest process(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException, ProcessCanceledException {
            if (context == null) {
                NewFileTextShelveDiffRequestProducer.$$$reportNull$$$0(5);
            }
            if (indicator == null) {
                NewFileTextShelveDiffRequestProducer.$$$reportNull$$$0(6);
            }
            VirtualFile file2 = this.myFilePath.getVirtualFile();
            if (this.myWithLocal && file2 != null) {
                SimpleDiffRequest simpleDiffRequest;
                block6: {
                    try {
                        TextFilePatch patch = this.myPreloader.getPatch(this.myChange, this.myCommitContext);
                        DiffContentFactory contentFactory = DiffContentFactory.getInstance();
                        DiffContent leftContent = contentFactory.create(this.myProject, file2);
                        DocumentContent rightContent = contentFactory.create(this.myProject, patch.getSingleHunkPatchText(), file2);
                        simpleDiffRequest = new SimpleDiffRequest(this.getName(), leftContent, (DiffContent)rightContent, DiffShelvedChangesActionProvider.CURRENT_VERSION, DiffShelvedChangesActionProvider.SHELVED_VERSION);
                        if (simpleDiffRequest != null) break block6;
                    }
                    catch (VcsException e) {
                        throw new DiffRequestProducerException("Can't show diff for '" + this.getFilePath() + "'", (Throwable)e);
                    }
                    NewFileTextShelveDiffRequestProducer.$$$reportNull$$$0(7);
                }
                return simpleDiffRequest;
            }
            DiffRequest diffRequest = PatchDiffRequestFactory.createDiffRequest(this.myProject, this.myChange.getChange(this.myProject), this.getName(), context, indicator);
            if (diffRequest == null) {
                NewFileTextShelveDiffRequestProducer.$$$reportNull$$$0(8);
            }
            return diffRequest;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 7: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 7: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "preloader";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commitContext";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$NewFileTextShelveDiffRequestProducer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$NewFileTextShelveDiffRequestProducer";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "process";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "process";
                    break;
                }
                case 7: 
                case 8: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 7: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PatchShelveDiffRequestProducer
    extends BaseTextShelveDiffRequestProducer {
        private final PatchesPreloader myPreloader;
        private final CommitContext myCommitContext;

        public PatchShelveDiffRequestProducer(@NotNull Project project, @NotNull ShelvedChange change, @NotNull FilePath filePath, @NotNull PatchesPreloader preloader, @NotNull CommitContext commitContext) {
            if (project == null) {
                PatchShelveDiffRequestProducer.$$$reportNull$$$0(0);
            }
            if (change == null) {
                PatchShelveDiffRequestProducer.$$$reportNull$$$0(1);
            }
            if (filePath == null) {
                PatchShelveDiffRequestProducer.$$$reportNull$$$0(2);
            }
            if (preloader == null) {
                PatchShelveDiffRequestProducer.$$$reportNull$$$0(3);
            }
            if (commitContext == null) {
                PatchShelveDiffRequestProducer.$$$reportNull$$$0(4);
            }
            super(project, change, filePath);
            this.myPreloader = preloader;
            this.myCommitContext = commitContext;
        }

        @NotNull
        public DiffRequest process(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException {
            PatchDiffRequest patchDiffRequest;
            if (context == null) {
                PatchShelveDiffRequestProducer.$$$reportNull$$$0(5);
            }
            if (indicator == null) {
                PatchShelveDiffRequestProducer.$$$reportNull$$$0(6);
            }
            try {
                TextFilePatch patch = this.myPreloader.getPatch(this.myChange, this.myCommitContext);
                AppliedTextPatch appliedTextPatch = DiffShelvedChangesActionProvider.createAppliedTextPatch(patch);
                PatchDiffRequest request = new PatchDiffRequest(appliedTextPatch, this.getName(), VcsBundle.message((String)"patch.apply.conflict.patch", (Object[])new Object[0]));
                DiffUtil.addNotification(DiffNotifications.createNotification("Cannot find local file for '" + this.getFilePath() + "'"), (UserDataHolder)request);
                patchDiffRequest = request;
            }
            catch (VcsException e) {
                throw new DiffRequestProducerException("Can't show diff for '" + this.getFilePath() + "'", (Throwable)e);
            }
            if (patchDiffRequest == null) {
                PatchShelveDiffRequestProducer.$$$reportNull$$$0(7);
            }
            return patchDiffRequest;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "preloader";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commitContext";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$PatchShelveDiffRequestProducer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$PatchShelveDiffRequestProducer";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "process";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "process";
                    break;
                }
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class BinaryShelveDiffRequestProducer
    extends ShelveDiffRequestProducer {
        @NotNull
        private final Project myProject;
        @NotNull
        private final ShelvedBinaryFile myBinaryChange;

        public BinaryShelveDiffRequestProducer(@NotNull Project project, @NotNull ShelvedBinaryFile change, @NotNull FilePath filePath) {
            if (project == null) {
                BinaryShelveDiffRequestProducer.$$$reportNull$$$0(0);
            }
            if (change == null) {
                BinaryShelveDiffRequestProducer.$$$reportNull$$$0(1);
            }
            if (filePath == null) {
                BinaryShelveDiffRequestProducer.$$$reportNull$$$0(2);
            }
            super(filePath);
            this.myBinaryChange = change;
            this.myProject = project;
        }

        @NotNull
        public DiffRequest process(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException, ProcessCanceledException {
            if (context == null) {
                BinaryShelveDiffRequestProducer.$$$reportNull$$$0(3);
            }
            if (indicator == null) {
                BinaryShelveDiffRequestProducer.$$$reportNull$$$0(4);
            }
            Change change = this.myBinaryChange.createChange(this.myProject);
            DiffRequest diffRequest = PatchDiffRequestFactory.createDiffRequest(this.myProject, change, this.getName(), context, indicator);
            if (diffRequest == null) {
                BinaryShelveDiffRequestProducer.$$$reportNull$$$0(5);
            }
            return diffRequest;
        }

        @Override
        @NotNull
        public FileStatus getFileStatus() {
            FileStatus fileStatus = this.myBinaryChange.getFileStatus();
            if (fileStatus == null) {
                BinaryShelveDiffRequestProducer.$$$reportNull$$$0(6);
            }
            return fileStatus;
        }

        @Override
        @NotNull
        public ShelvedBinaryFile getBinaryChange() {
            ShelvedBinaryFile shelvedBinaryFile = this.myBinaryChange;
            if (shelvedBinaryFile == null) {
                BinaryShelveDiffRequestProducer.$$$reportNull$$$0(7);
            }
            return shelvedBinaryFile;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$BinaryShelveDiffRequestProducer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$BinaryShelveDiffRequestProducer";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "process";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileStatus";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBinaryChange";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "process";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static abstract class ShelveDiffRequestProducer
    implements ChangeDiffRequestChain.Producer {
        @NotNull
        protected final FilePath myFilePath;

        public ShelveDiffRequestProducer(@NotNull FilePath filePath) {
            if (filePath == null) {
                ShelveDiffRequestProducer.$$$reportNull$$$0(0);
            }
            this.myFilePath = filePath;
        }

        @Nullable
        public ShelvedChange getTextChange() {
            return null;
        }

        @Nullable
        public ShelvedBinaryFile getBinaryChange() {
            return null;
        }

        @NotNull
        public String getName() {
            String string = FileUtil.toSystemDependentName((String)this.getFilePath().getPath());
            if (string == null) {
                ShelveDiffRequestProducer.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @NotNull
        public FilePath getFilePath() {
            FilePath filePath = this.myFilePath;
            if (filePath == null) {
                ShelveDiffRequestProducer.$$$reportNull$$$0(2);
            }
            return filePath;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$ShelveDiffRequestProducer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$ShelveDiffRequestProducer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilePath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class PatchesPreloader {
        private final Project myProject;
        private final SoftHardCacheMap<String, PatchInfo> myFilePatchesMap = new SoftHardCacheMap(5, 5);
        private final ReadWriteLock myLock = new ReentrantReadWriteLock(true);

        PatchesPreloader(Project project) {
            this.myProject = project;
        }

        @NotNull
        public TextFilePatch getPatch(ShelvedChange shelvedChange, @Nullable CommitContext commitContext) throws VcsException {
            PatchInfo patchInfo;
            String patchPath = shelvedChange.getPatchPath();
            if (this.getInfoFromCache(patchPath) == null || this.isPatchFileChanged(patchPath)) {
                this.readFilePatchAndUpdateCaches(patchPath, commitContext);
            }
            if ((patchInfo = this.getInfoFromCache(patchPath)) != null) {
                for (TextFilePatch textFilePatch : patchInfo.myTextFilePatches) {
                    if (!shelvedChange.getBeforePath().equals(textFilePatch.getBeforeName())) continue;
                    TextFilePatch textFilePatch2 = textFilePatch;
                    if (textFilePatch2 == null) {
                        PatchesPreloader.$$$reportNull$$$0(0);
                    }
                    return textFilePatch2;
                }
            }
            throw new VcsException("Can not find patch for " + shelvedChange.getBeforePath() + " in patch file.");
        }

        private PatchInfo getInfoFromCache(@NotNull String patchPath) {
            if (patchPath == null) {
                PatchesPreloader.$$$reportNull$$$0(1);
            }
            try {
                this.myLock.readLock().lock();
                PatchInfo patchInfo = this.myFilePatchesMap.get(patchPath);
                return patchInfo;
            }
            finally {
                this.myLock.readLock().unlock();
            }
        }

        private void readFilePatchAndUpdateCaches(@NotNull String patchPath, @Nullable CommitContext commitContext) throws VcsException {
            if (patchPath == null) {
                PatchesPreloader.$$$reportNull$$$0(2);
            }
            try {
                this.myLock.writeLock().lock();
                this.myFilePatchesMap.put(patchPath, new PatchInfo(ShelveChangesManager.loadPatches(this.myProject, patchPath, commitContext), new File(patchPath).lastModified()));
            }
            catch (PatchSyntaxException | IOException e) {
                throw new VcsException((Throwable)e);
            }
            finally {
                this.myLock.writeLock().unlock();
            }
        }

        public boolean isPatchFileChanged(@NotNull String patchPath) {
            if (patchPath == null) {
                PatchesPreloader.$$$reportNull$$$0(3);
            }
            PatchInfo patchInfo = this.getInfoFromCache(patchPath);
            long lastModified = new File(patchPath).lastModified();
            return patchInfo != null && lastModified != patchInfo.myLoadedTimeStamp;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$PatchesPreloader";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "patchPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPatch";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$PatchesPreloader";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getInfoFromCache";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "readFilePatchAndUpdateCaches";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isPatchFileChanged";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class PatchInfo {
            private final long myLoadedTimeStamp;
            @NotNull
            private final List<TextFilePatch> myTextFilePatches;

            public PatchInfo(@NotNull List<TextFilePatch> patches, long loadedTimeStamp) {
                if (patches == null) {
                    PatchInfo.$$$reportNull$$$0(0);
                }
                this.myTextFilePatches = patches;
                this.myLoadedTimeStamp = loadedTimeStamp;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patches", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$PatchesPreloader$PatchInfo", "<init>"));
            }
        }
    }

    private static class ChangeDiffRequestComparator
    implements Comparator<DiffRequestProducer> {
        private static final ChangeDiffRequestComparator ourInstance = new ChangeDiffRequestComparator();

        private ChangeDiffRequestComparator() {
        }

        public static ChangeDiffRequestComparator getInstance() {
            return ourInstance;
        }

        @Override
        public int compare(DiffRequestProducer o1, DiffRequestProducer o2) {
            return FilePathsHelper.convertPath((String)o1.getName()).compareTo(FilePathsHelper.convertPath((String)o2.getName()));
        }
    }
}

