/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history;

import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.history.FileHistoryRefresherI;
import com.intellij.openapi.vcs.history.FileHistorySessionPartner;
import com.intellij.openapi.vcs.history.VcsCachingHistory;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.vcs.history.VcsHistoryProviderEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileHistoryRefresher
implements FileHistoryRefresherI {
    private final FileHistorySessionPartner mySessionPartner;
    private final VcsHistoryProvider myVcsHistoryProvider;
    private final FilePath myPath;
    private final AbstractVcs myVcs;
    @Nullable
    private final VcsRevisionNumber myStartingRevisionNumber;
    private boolean myCanUseCache;
    private boolean myIsRefresh;

    public FileHistoryRefresher(VcsHistoryProvider vcsHistoryProvider, FilePath path, AbstractVcs vcs) {
        this(vcsHistoryProvider, path, null, vcs);
    }

    public FileHistoryRefresher(VcsHistoryProviderEx vcsHistoryProvider, FilePath path, @Nullable VcsRevisionNumber startingRevisionNumber, AbstractVcs vcs) {
        this((VcsHistoryProvider)vcsHistoryProvider, path, startingRevisionNumber, vcs);
    }

    private FileHistoryRefresher(VcsHistoryProvider vcsHistoryProvider, FilePath path, @Nullable VcsRevisionNumber startingRevisionNumber, AbstractVcs vcs) {
        this.myVcsHistoryProvider = vcsHistoryProvider;
        this.myPath = path;
        this.myVcs = vcs;
        this.myStartingRevisionNumber = startingRevisionNumber;
        this.mySessionPartner = new FileHistorySessionPartner(vcsHistoryProvider, path, startingRevisionNumber, vcs, this);
        this.myCanUseCache = true;
    }

    @NotNull
    public static FileHistoryRefresherI findOrCreate(@NotNull VcsHistoryProvider vcsHistoryProvider, @NotNull FilePath path, @NotNull AbstractVcs vcs) {
        FileHistoryRefresherI refresher;
        if (vcsHistoryProvider == null) {
            FileHistoryRefresher.$$$reportNull$$$0(0);
        }
        if (path == null) {
            FileHistoryRefresher.$$$reportNull$$$0(1);
        }
        if (vcs == null) {
            FileHistoryRefresher.$$$reportNull$$$0(2);
        }
        FileHistoryRefresherI fileHistoryRefresherI = (refresher = FileHistorySessionPartner.findExistingHistoryRefresher(vcs.getProject(), path, null)) == null ? new FileHistoryRefresher(vcsHistoryProvider, path, vcs) : refresher;
        if (fileHistoryRefresherI == null) {
            FileHistoryRefresher.$$$reportNull$$$0(3);
        }
        return fileHistoryRefresherI;
    }

    @NotNull
    public static FileHistoryRefresherI findOrCreate(@NotNull VcsHistoryProviderEx vcsHistoryProvider, @NotNull FilePath path, @NotNull AbstractVcs vcs, @Nullable VcsRevisionNumber startingRevisionNumber) {
        FileHistoryRefresherI refresher;
        if (vcsHistoryProvider == null) {
            FileHistoryRefresher.$$$reportNull$$$0(4);
        }
        if (path == null) {
            FileHistoryRefresher.$$$reportNull$$$0(5);
        }
        if (vcs == null) {
            FileHistoryRefresher.$$$reportNull$$$0(6);
        }
        FileHistoryRefresherI fileHistoryRefresherI = (refresher = FileHistorySessionPartner.findExistingHistoryRefresher(vcs.getProject(), path, startingRevisionNumber)) == null ? new FileHistoryRefresher(vcsHistoryProvider, path, startingRevisionNumber, vcs) : refresher;
        if (fileHistoryRefresherI == null) {
            FileHistoryRefresher.$$$reportNull$$$0(7);
        }
        return fileHistoryRefresherI;
    }

    @Override
    public void run(boolean isRefresh, boolean canUseLastRevision) {
        this.myIsRefresh = isRefresh;
        this.mySessionPartner.beforeRefresh();
        if (this.myVcsHistoryProvider instanceof VcsHistoryProviderEx && this.myStartingRevisionNumber != null) {
            VcsCachingHistory.collectInBackground(this.myVcs, this.myPath, this.myStartingRevisionNumber, this.mySessionPartner);
        } else {
            VcsCachingHistory.collectInBackground(this.myVcs, this.myPath, this.mySessionPartner, this.myCanUseCache, canUseLastRevision);
        }
        this.myCanUseCache = false;
    }

    @Override
    public boolean isFirstTime() {
        return !this.myIsRefresh;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsHistoryProvider";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/history/FileHistoryRefresher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/history/FileHistoryRefresher";
                break;
            }
            case 3: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findOrCreate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreate";
                break;
            }
            case 3: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

