/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.impl.AnchoredButton;
import com.intellij.ui.Gray;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.metal.MetalToggleButtonUI;

public final class StripeButtonUI
extends MetalToggleButtonUI {
    private static final StripeButtonUI ourInstance = new StripeButtonUI();
    private static final Rectangle ourIconRect = new Rectangle();
    private static final Rectangle ourTextRect = new Rectangle();
    private static final Rectangle ourViewRect = new Rectangle();
    private static Insets ourViewInsets = JBUI.emptyInsets();

    private StripeButtonUI() {
    }

    public static ComponentUI createUI(JComponent c) {
        return ourInstance;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        AnchoredButton button = (AnchoredButton)c;
        Dimension dim = super.getPreferredSize(button);
        dim.width = (int)((float)JBUI.scale((int)4) + (float)dim.width * 1.1f);
        dim.height += JBUI.scale((int)2);
        ToolWindowAnchor anchor2 = button.getAnchor();
        if (ToolWindowAnchor.LEFT == anchor2 || ToolWindowAnchor.RIGHT == anchor2) {
            return new Dimension(dim.height, dim.width);
        }
        return dim;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Icon icon;
        AnchoredButton button = (AnchoredButton)c;
        String text2 = button.getText();
        Icon icon2 = icon = button.isEnabled() ? button.getIcon() : button.getDisabledIcon();
        if (icon == null && text2 == null) {
            return;
        }
        FontMetrics fm = button.getFontMetrics(button.getFont());
        ourViewInsets = c.getInsets(ourViewInsets);
        StripeButtonUI.ourViewRect.x = StripeButtonUI.ourViewInsets.left;
        StripeButtonUI.ourViewRect.y = StripeButtonUI.ourViewInsets.top;
        ToolWindowAnchor anchor2 = button.getAnchor();
        if (ToolWindowAnchor.RIGHT == anchor2 || ToolWindowAnchor.LEFT == anchor2) {
            StripeButtonUI.ourViewRect.height = c.getWidth() - (StripeButtonUI.ourViewInsets.left + StripeButtonUI.ourViewInsets.right);
            StripeButtonUI.ourViewRect.width = c.getHeight() - (StripeButtonUI.ourViewInsets.top + StripeButtonUI.ourViewInsets.bottom);
        } else {
            StripeButtonUI.ourViewRect.height = c.getHeight() - (StripeButtonUI.ourViewInsets.left + StripeButtonUI.ourViewInsets.right);
            StripeButtonUI.ourViewRect.width = c.getWidth() - (StripeButtonUI.ourViewInsets.top + StripeButtonUI.ourViewInsets.bottom);
        }
        StripeButtonUI.ourIconRect.height = 0;
        StripeButtonUI.ourIconRect.width = 0;
        StripeButtonUI.ourIconRect.y = 0;
        StripeButtonUI.ourIconRect.x = 0;
        StripeButtonUI.ourTextRect.height = 0;
        StripeButtonUI.ourTextRect.width = 0;
        StripeButtonUI.ourTextRect.y = 0;
        StripeButtonUI.ourTextRect.x = 0;
        String clippedText = SwingUtilities.layoutCompoundLabel(c, fm, text2, icon, button.getVerticalAlignment(), button.getHorizontalAlignment(), button.getVerticalTextPosition(), button.getHorizontalTextPosition(), ourViewRect, ourIconRect, ourTextRect, button.getText() == null ? 0 : button.getIconTextGap());
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        ButtonModel model = button.getModel();
        Color background = button.getBackground();
        StripeButtonUI.ourIconRect.x -= JBUI.scale((int)2);
        StripeButtonUI.ourTextRect.x -= JBUI.scale((int)2);
        boolean off = true;
        if (model.isArmed() && model.isPressed() || model.isSelected() || model.isRollover()) {
            boolean dark;
            if (anchor2 == ToolWindowAnchor.LEFT) {
                g2.translate(-1, 0);
            }
            if (anchor2.isHorizontal()) {
                g2.translate(0, -1);
            }
            g2.setColor((dark = UIUtil.isUnderDarcula()) ? Gray._15.withAlpha(model.isSelected() ? 85 : 40) : Gray._85.withAlpha(model.isSelected() ? 85 : 40));
            g2.fillRect(0, 0, button.getWidth(), button.getHeight());
            if (anchor2 == ToolWindowAnchor.LEFT) {
                g2.translate(1, 0);
            }
            if (anchor2.isHorizontal()) {
                g2.translate(0, 1);
            }
        }
        AffineTransform tr = null;
        if (ToolWindowAnchor.RIGHT == anchor2 || ToolWindowAnchor.LEFT == anchor2) {
            tr = g2.getTransform();
            if (ToolWindowAnchor.RIGHT == anchor2) {
                if (icon != null) {
                    icon.paintIcon(c, g2, StripeButtonUI.ourIconRect.y, StripeButtonUI.ourIconRect.x);
                }
                g2.rotate(1.5707963267948966);
                g2.translate(0, -c.getWidth());
            } else {
                if (icon != null) {
                    icon.paintIcon(c, g2, StripeButtonUI.ourIconRect.y, c.getHeight() - StripeButtonUI.ourIconRect.x - icon.getIconHeight());
                }
                g2.rotate(-1.5707963267948966);
                g2.translate(-c.getHeight(), 0);
            }
        } else if (icon != null) {
            icon.paintIcon(c, g2, StripeButtonUI.ourIconRect.x, StripeButtonUI.ourIconRect.y);
        }
        UISettings.setupAntialiasing((Graphics)g2);
        if (text2 != null) {
            if (model.isEnabled()) {
                if (model.isArmed() && model.isPressed() || model.isSelected()) {
                    g2.setColor(background);
                } else {
                    g2.setColor(button.getForeground());
                }
            } else {
                g2.setColor(background.darker());
            }
            if (model.isEnabled()) {
                g2.setColor(UIUtil.isUnderDarcula() && model.isSelected() ? button.getForeground().brighter() : button.getForeground());
                BasicGraphicsUtils.drawString(g2, clippedText, button.getMnemonic2(), StripeButtonUI.ourTextRect.x, StripeButtonUI.ourTextRect.y + fm.getAscent());
            } else {
                if (model.isSelected()) {
                    g2.setColor(c.getBackground());
                } else {
                    g2.setColor(this.getDisabledTextColor());
                }
                BasicGraphicsUtils.drawString(g2, clippedText, button.getMnemonic2(), StripeButtonUI.ourTextRect.x, StripeButtonUI.ourTextRect.y + fm.getAscent());
            }
        }
        if (ToolWindowAnchor.RIGHT == anchor2 || ToolWindowAnchor.LEFT == anchor2) {
            g2.setTransform(tr);
        }
        g2.dispose();
    }
}

