/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies.ui;

import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.ui.DependencyNodeComparator;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.Gray;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Color;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageDependenciesNode
extends DefaultMutableTreeNode
implements Navigatable {
    private static final EmptyIcon EMPTY_ICON = EmptyIcon.create((int)0, (int)IconUtil.getEmptyIcon((boolean)false).getIconHeight());
    private Set<VirtualFile> myRegisteredFiles;
    private boolean myHasUnmarked;
    private boolean myHasMarked;
    private boolean myEquals;
    protected Color myColor;
    protected static final Color NOT_CHANGED = Gray._0;
    protected Project myProject;
    private boolean mySorted;

    public PackageDependenciesNode(@NotNull Project project) {
        if (project == null) {
            PackageDependenciesNode.$$$reportNull$$$0(0);
        }
        this.myRegisteredFiles = null;
        this.myHasUnmarked = false;
        this.myHasMarked = false;
        this.myColor = null;
        this.myProject = project;
    }

    public void setEquals(boolean equals) {
        this.myEquals = equals;
    }

    public boolean isEquals() {
        return this.myEquals;
    }

    public void fillFiles(Set<PsiFile> set2, boolean recursively) {
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        for (VirtualFile vFile : this.getRegisteredFiles()) {
            PsiFile psiFile = psiManager.findFile(vFile);
            if (psiFile == null || !psiFile.isValid()) continue;
            set2.add(psiFile);
        }
    }

    public void addFile(VirtualFile file2, boolean isMarked) {
        this.getRegisteredFiles().add(file2);
        this.updateMarked(!isMarked, isMarked);
    }

    public Icon getIcon() {
        return EMPTY_ICON;
    }

    public int getWeight() {
        return 0;
    }

    public boolean hasUnmarked() {
        return this.myHasUnmarked;
    }

    public boolean hasMarked() {
        return this.myHasMarked;
    }

    @Nullable
    public PsiElement getPsiElement() {
        return null;
    }

    @Nullable
    public Color getColor() {
        return this.myColor;
    }

    public void updateColor() {
        this.myColor = null;
    }

    public int getContainingFiles() {
        int result2 = 0;
        for (int i = 0; i < this.getChildCount(); ++i) {
            result2 += ((PackageDependenciesNode)this.getChildAt(i)).getContainingFiles();
        }
        return result2;
    }

    public String getPresentableFilesCount() {
        int filesCount = this.getContainingFiles();
        return filesCount > 0 ? " (" + AnalysisScopeBundle.message((String)"package.dependencies.node.items.count", (Object[])new Object[]{filesCount}) + ")" : "";
    }

    @Override
    public void add(MutableTreeNode newChild) {
        super.add(newChild);
        boolean hasUnmarked = ((PackageDependenciesNode)newChild).hasUnmarked();
        boolean hasMarked = ((PackageDependenciesNode)newChild).hasMarked();
        this.updateMarked(hasUnmarked, hasMarked);
    }

    private void updateMarked(boolean hasUnmarked, boolean hasMarked) {
        if (hasUnmarked && !this.myHasUnmarked || hasMarked && !this.myHasMarked) {
            this.myHasUnmarked |= hasUnmarked;
            this.myHasMarked |= hasMarked;
            PackageDependenciesNode parent = (PackageDependenciesNode)this.getParent();
            if (parent != null) {
                parent.updateMarked(this.myHasUnmarked, this.myHasMarked);
            }
        }
    }

    public void navigate(boolean focus) {
        PsiElement psiElement;
        if (this.canNavigate() && (psiElement = this.getPsiElement()) != null) {
            NavigationUtil.openFileWithPsiElement(psiElement, focus, focus);
        }
    }

    public boolean canNavigate() {
        PsiElement psiElement = this.getPsiElement();
        if (psiElement == null) {
            return false;
        }
        PsiFile containingFile = psiElement.getContainingFile();
        if (containingFile == null) {
            return false;
        }
        VirtualFile virtualFile = containingFile.getVirtualFile();
        return virtualFile != null && virtualFile.isValid();
    }

    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    @Override
    public Object getUserObject() {
        return this.toString();
    }

    public boolean isValid() {
        return true;
    }

    public Set<VirtualFile> getRegisteredFiles() {
        if (this.myRegisteredFiles == null) {
            this.myRegisteredFiles = new HashSet<VirtualFile>();
        }
        return this.myRegisteredFiles;
    }

    @Nullable
    public String getComment() {
        return null;
    }

    public boolean canSelectInLeftTree(Map<PsiFile, Set<PsiFile>> deps) {
        return false;
    }

    public boolean isSorted() {
        return this.mySorted;
    }

    public void setSorted(boolean sorted) {
        this.mySorted = sorted;
    }

    public void sortChildren() {
        if (this.isSorted()) {
            return;
        }
        TreeUtil.sortChildren((MutableTreeNode)this, (Comparator)new DependencyNodeComparator());
        this.setSorted(true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/packageDependencies/ui/PackageDependenciesNode", "<init>"));
    }
}

