/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.AbstractFileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.SharedPsiElementImplUtil;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MultiplePsiFilesPerDocumentFileViewProvider
extends AbstractFileViewProvider {
    private final ConcurrentMap<Language, PsiFileImpl> myRoots;
    private MultiplePsiFilesPerDocumentFileViewProvider myOriginal;

    public MultiplePsiFilesPerDocumentFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile virtualFile, boolean eventSystemEnabled) {
        if (manager == null) {
            MultiplePsiFilesPerDocumentFileViewProvider.$$$reportNull$$$0(0);
        }
        if (virtualFile == null) {
            MultiplePsiFilesPerDocumentFileViewProvider.$$$reportNull$$$0(1);
        }
        super(manager, virtualFile, eventSystemEnabled, virtualFile.getFileType());
        this.myRoots = ContainerUtil.newConcurrentMap((int)1, (float)0.75f, (int)1);
    }

    @NotNull
    public abstract Language getBaseLanguage();

    @NotNull
    public List<PsiFile> getAllFiles() {
        ArrayList<PsiFile> roots = new ArrayList<PsiFile>();
        for (Language language : this.getLanguages()) {
            PsiFile psi = this.getPsi(language);
            if (psi == null) continue;
            roots.add(psi);
        }
        PsiFile base = this.getPsi(this.getBaseLanguage());
        if (!roots.isEmpty() && roots.get(0) != base) {
            roots.remove(base);
            roots.add(0, base);
        }
        ArrayList<PsiFile> arrayList = roots;
        if (arrayList == null) {
            MultiplePsiFilesPerDocumentFileViewProvider.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    protected final void removeFile(@NotNull Language language) {
        PsiFileImpl file2;
        if (language == null) {
            MultiplePsiFilesPerDocumentFileViewProvider.$$$reportNull$$$0(3);
        }
        if ((file2 = (PsiFileImpl)this.myRoots.remove(language)) != null) {
            file2.markInvalidated();
        }
    }

    @Override
    protected PsiFile getPsiInner(@NotNull Language target2) {
        PsiFileImpl file2;
        if (target2 == null) {
            MultiplePsiFilesPerDocumentFileViewProvider.$$$reportNull$$$0(4);
        }
        if ((file2 = (PsiFileImpl)this.myRoots.get(target2)) == null) {
            PsiFile originalFile;
            if (!this.shouldCreatePsi()) {
                return null;
            }
            if (target2 != this.getBaseLanguage() && !this.getLanguages().contains(target2)) {
                return null;
            }
            file2 = (PsiFileImpl)this.createFile(target2);
            if (file2 == null) {
                return null;
            }
            if (this.myOriginal != null && (originalFile = this.myOriginal.getPsi(target2)) != null) {
                file2.setOriginalFile(originalFile);
            }
            file2 = (PsiFileImpl)ConcurrencyUtil.cacheOrGet(this.myRoots, (Object)target2, (Object)file2);
        }
        return file2;
    }

    @Override
    public final PsiFile getCachedPsi(@NotNull Language target2) {
        if (target2 == null) {
            MultiplePsiFilesPerDocumentFileViewProvider.$$$reportNull$$$0(5);
        }
        return (PsiFile)this.myRoots.get(target2);
    }

    @Override
    @NotNull
    public final List<PsiFile> getCachedPsiFiles() {
        List list2 = ContainerUtil.mapNotNull(this.myRoots.keySet(), this::getCachedPsi);
        if (list2 == null) {
            MultiplePsiFilesPerDocumentFileViewProvider.$$$reportNull$$$0(6);
        }
        return list2;
    }

    @Override
    @NotNull
    public final List<FileElement> getKnownTreeRoots() {
        ArrayList<FileElement> files2 = new ArrayList<FileElement>(this.myRoots.size());
        for (PsiFile file2 : this.myRoots.values()) {
            FileElement treeElement = ((PsiFileImpl)file2).getTreeElement();
            if (treeElement == null) continue;
            files2.add(treeElement);
        }
        ArrayList<FileElement> arrayList = files2;
        if (arrayList == null) {
            MultiplePsiFilesPerDocumentFileViewProvider.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    public void checkAllTreesEqual() {
        Collection roots = this.myRoots.values();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.getManager().getProject());
        documentManager.commitAllDocuments();
        for (PsiFile root : roots) {
            Document document = documentManager.getDocument(root);
            assert (document != null);
            PsiDocumentManagerBase.checkConsistency(root, document);
            assert (root.getText().equals(document.getText()));
        }
    }

    @NotNull
    public final MultiplePsiFilesPerDocumentFileViewProvider createCopy(@NotNull VirtualFile fileCopy) {
        if (fileCopy == null) {
            MultiplePsiFilesPerDocumentFileViewProvider.$$$reportNull$$$0(8);
        }
        MultiplePsiFilesPerDocumentFileViewProvider copy = this.cloneInner(fileCopy);
        copy.myOriginal = this.myOriginal == null ? this : this.myOriginal;
        MultiplePsiFilesPerDocumentFileViewProvider multiplePsiFilesPerDocumentFileViewProvider = copy;
        if (multiplePsiFilesPerDocumentFileViewProvider == null) {
            MultiplePsiFilesPerDocumentFileViewProvider.$$$reportNull$$$0(9);
        }
        return multiplePsiFilesPerDocumentFileViewProvider;
    }

    @NotNull
    protected abstract MultiplePsiFilesPerDocumentFileViewProvider cloneInner(@NotNull VirtualFile var1);

    @Nullable
    public PsiElement findElementAt(int offset, @NotNull Class<? extends Language> lang) {
        if (lang == null) {
            MultiplePsiFilesPerDocumentFileViewProvider.$$$reportNull$$$0(10);
        }
        PsiFile mainRoot = this.getPsi(this.getBaseLanguage());
        PsiElement ret = null;
        for (Language language : this.getLanguages()) {
            PsiFile psiRoot;
            PsiElement psiElement;
            if (!ReflectionUtil.isAssignable(lang, language.getClass()) || lang.equals(Language.class) && !this.getLanguages().contains(language) || (psiElement = MultiplePsiFilesPerDocumentFileViewProvider.findElementAt((PsiElement)(psiRoot = this.getPsi(language)), offset)) == null || psiElement instanceof OuterLanguageElement || ret != null && psiRoot == mainRoot) continue;
            ret = psiElement;
        }
        return ret;
    }

    @Nullable
    public PsiElement findElementAt(int offset) {
        return this.findElementAt(offset, Language.class);
    }

    @Nullable
    public PsiReference findReferenceAt(int offset) {
        TextRange minRange = new TextRange(0, this.getContents().length());
        PsiReference ret = null;
        for (Language language : this.getLanguages()) {
            TextRange textRange;
            PsiFile psiRoot = this.getPsi(language);
            PsiReference reference = SharedPsiElementImplUtil.findReferenceAt((PsiElement)psiRoot, offset, language);
            if (reference == null || !minRange.contains(textRange = reference.getRangeInElement().shiftRight(reference.getElement().getTextRange().getStartOffset())) || textRange.contains(minRange)) continue;
            minRange = textRange;
            ret = reference;
        }
        return ret;
    }

    @Override
    public void contentsSynchronized() {
        Set languages = this.getLanguages();
        Iterator iterator = this.myRoots.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (languages.contains(entry.getKey())) continue;
            PsiFileImpl file2 = (PsiFileImpl)entry.getValue();
            iterator.remove();
            file2.markInvalidated();
        }
        super.contentsSynchronized();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/MultiplePsiFilesPerDocumentFileViewProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileCopy";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lang";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/MultiplePsiFilesPerDocumentFileViewProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFiles";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedPsiFiles";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getKnownTreeRoots";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createCopy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPsiInner";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCachedPsi";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createCopy";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findElementAt";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

