/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.tree.injected.InjectedFileViewProvider;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageManagerImpl;
import com.intellij.psi.impl.source.tree.injected.InjectionRegistrarImpl;
import com.intellij.psi.impl.source.tree.injected.InjectionResult;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class InjectedPsiCachedValueProvider
implements ParameterizedCachedValueProvider<InjectionResult, PsiElement> {
    InjectedPsiCachedValueProvider() {
    }

    public CachedValueProvider.Result<InjectionResult> compute(PsiElement element) {
        PsiFile hostPsiFile = element.getContainingFile();
        if (hostPsiFile == null) {
            return null;
        }
        FileViewProvider viewProvider = hostPsiFile.getViewProvider();
        if (viewProvider instanceof InjectedFileViewProvider) {
            return null;
        }
        DocumentEx hostDocument = (DocumentEx)viewProvider.getDocument();
        if (hostDocument == null) {
            return null;
        }
        PsiManager psiManager = viewProvider.getManager();
        Project project = psiManager.getProject();
        InjectedLanguageManagerImpl injectedManager = InjectedLanguageManagerImpl.getInstanceImpl(project);
        InjectionResult result2 = InjectedPsiCachedValueProvider.doCompute(element, injectedManager, project, hostPsiFile);
        return CachedValueProvider.Result.create((Object)result2, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, hostDocument});
    }

    @Nullable
    static InjectionResult doCompute(@NotNull PsiElement element, @NotNull InjectedLanguageManagerImpl injectedManager, @NotNull Project project, @NotNull PsiFile hostPsiFile) {
        if (element == null) {
            InjectedPsiCachedValueProvider.$$$reportNull$$$0(0);
        }
        if (injectedManager == null) {
            InjectedPsiCachedValueProvider.$$$reportNull$$$0(1);
        }
        if (project == null) {
            InjectedPsiCachedValueProvider.$$$reportNull$$$0(2);
        }
        if (hostPsiFile == null) {
            InjectedPsiCachedValueProvider.$$$reportNull$$$0(3);
        }
        MyInjProcessor processor2 = new MyInjProcessor(project, hostPsiFile);
        injectedManager.processInPlaceInjectorsFor(element, processor2);
        InjectionRegistrarImpl registrar = processor2.hostRegistrar;
        return registrar == null ? null : registrar.getInjectedResult();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "injectedManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "hostPsiFile";
                break;
            }
        }
        objectArray[1] = "com/intellij/psi/impl/source/tree/injected/InjectedPsiCachedValueProvider";
        objectArray[2] = "doCompute";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyInjProcessor
    implements InjectedLanguageManagerImpl.InjProcessor {
        private InjectionRegistrarImpl hostRegistrar;
        private final Project myProject;
        private final PsiFile myHostPsiFile;

        private MyInjProcessor(@NotNull Project project, @NotNull PsiFile hostPsiFile) {
            if (project == null) {
                MyInjProcessor.$$$reportNull$$$0(0);
            }
            if (hostPsiFile == null) {
                MyInjProcessor.$$$reportNull$$$0(1);
            }
            this.myProject = project;
            this.myHostPsiFile = hostPsiFile;
        }

        @Override
        public boolean process(@NotNull PsiElement element, @NotNull MultiHostInjector injector) {
            if (element == null) {
                MyInjProcessor.$$$reportNull$$$0(2);
            }
            if (injector == null) {
                MyInjProcessor.$$$reportNull$$$0(3);
            }
            if (this.hostRegistrar == null) {
                this.hostRegistrar = new InjectionRegistrarImpl(this.myProject, this.myHostPsiFile, element);
            }
            injector.getLanguagesToInject((MultiHostRegistrar)this.hostRegistrar, element);
            return this.hostRegistrar.getInjectedResult() == null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hostPsiFile";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "injector";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/impl/source/tree/injected/InjectedPsiCachedValueProvider$MyInjProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "process";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

