/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.javaee.ExternalResourceManager;
import com.intellij.javaee.ExternalResourceManagerEx;
import com.intellij.javaee.ImplicitNamespaceDescriptorProvider;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.PomManager;
import com.intellij.pom.PomModel;
import com.intellij.pom.PomModelAspect;
import com.intellij.pom.PomTransaction;
import com.intellij.pom.event.PomModelEvent;
import com.intellij.pom.impl.PomTransactionBase;
import com.intellij.pom.tree.events.TreeChangeEvent;
import com.intellij.pom.xml.XmlAspect;
import com.intellij.pom.xml.impl.events.XmlAttributeSetImpl;
import com.intellij.pom.xml.impl.events.XmlTagNameChangedImpl;
import com.intellij.psi.HintedReferenceHost;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.impl.meta.MetaRegistry;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.impl.source.tree.ChangeUtil;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.impl.source.xml.SchemaPrefixReference;
import com.intellij.psi.impl.source.xml.TagNameReference;
import com.intellij.psi.impl.source.xml.XmlElementDescriptorProvider;
import com.intellij.psi.impl.source.xml.XmlElementImpl;
import com.intellij.psi.impl.source.xml.XmlTagValueImpl;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlEntityRef;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.psi.xml.XmlTagValue;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CharTable;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import com.intellij.util.SmartList;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import com.intellij.xml.impl.schema.MultiFileNsDescriptor;
import com.intellij.xml.impl.schema.XmlNSDescriptorImpl;
import com.intellij.xml.index.XmlNamespaceIndex;
import com.intellij.xml.util.XmlTagUtil;
import com.intellij.xml.util.XmlUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlTagImpl
extends XmlElementImpl
implements XmlTag,
HintedReferenceHost {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.xml.XmlTagImpl");
    @NonNls
    private static final String XML_NS_PREFIX = "xml";
    private static final RecursionGuard ourGuard = RecursionManager.createGuard((String)"xmlTag");
    private static final Key<ParameterizedCachedValue<XmlTag[], XmlTagImpl>> SUBTAGS_KEY = Key.create((String)"subtags");
    private static final ParameterizedCachedValueProvider<XmlTag[], XmlTagImpl> CACHED_VALUE_PROVIDER = new ParameterizedCachedValueProvider<XmlTag[], XmlTagImpl>(){

        public CachedValueProvider.Result<XmlTag[]> compute(XmlTagImpl tag) {
            ArrayList<XmlTag> result2 = new ArrayList<XmlTag>();
            tag.fillSubTags(result2);
            int s = result2.size();
            XmlTag[] tags = s > 0 ? (XmlTag[])ContainerUtil.toArray(result2, (Object[])new XmlTag[s]) : XmlTag.EMPTY;
            return CachedValueProvider.Result.create((Object)tags, (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT, tag});
        }
    };
    private static final Comparator<TextRange> RANGE_COMPARATOR = Comparator.comparingInt(TextRange::getStartOffset);
    private final int myHC = ourHC++;
    private volatile String myName;
    private volatile String myLocalName;
    private volatile XmlAttribute[] myAttributes;
    private volatile TextRange[] myTextElements;
    private volatile Map<String, String> myAttributeValueMap;
    private volatile XmlTagValue myValue;
    private volatile boolean myHasNamespaceDeclarations;

    public XmlTagImpl() {
        this(XmlElementType.XML_TAG);
    }

    protected XmlTagImpl(IElementType type) {
        super(type);
    }

    @Nullable
    private static XmlNSDescriptor getDtdDescriptor(@NotNull XmlFile containingFile) {
        XmlDocument document;
        if (containingFile == null) {
            XmlTagImpl.$$$reportNull$$$0(0);
        }
        if ((document = containingFile.getDocument()) == null) {
            return null;
        }
        String url = XmlUtil.getDtdUri(document);
        if (url == null) {
            return null;
        }
        return document.getDefaultNSDescriptor(url, true);
    }

    @Nullable
    private static String getNSVersion(String ns, XmlTagImpl xmlTag) {
        String versionValue = xmlTag.getAttributeValue("version");
        if (versionValue != null && xmlTag.getNamespace().equals(ns)) {
            return versionValue;
        }
        return null;
    }

    public final int hashCode() {
        return this.myHC;
    }

    @Override
    public void clearCaches() {
        this.myName = null;
        this.myLocalName = null;
        this.myAttributes = null;
        this.myTextElements = null;
        this.myAttributeValueMap = null;
        this.myHasNamespaceDeclarations = false;
        this.myValue = null;
        super.clearCaches();
    }

    @Override
    @Deprecated
    @NotNull
    public final PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = this.getReferences(PsiReferenceService.Hints.NO_HINTS);
        if (psiReferenceArray == null) {
            XmlTagImpl.$$$reportNull$$$0(1);
        }
        return psiReferenceArray;
    }

    public boolean shouldAskParentForReferences(@NotNull PsiReferenceService.Hints hints) {
        if (hints == null) {
            XmlTagImpl.$$$reportNull$$$0(2);
        }
        return false;
    }

    @NotNull
    public PsiReference[] getReferences(@NotNull PsiReferenceService.Hints hints) {
        if (hints == null) {
            XmlTagImpl.$$$reportNull$$$0(3);
        }
        ProgressManager.checkCanceled();
        if (hints == PsiReferenceService.Hints.NO_HINTS) {
            PsiReference[] psiReferenceArray = (PsiReference[])CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create((Object)this.getReferencesImpl(PsiReferenceService.Hints.NO_HINTS), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, this.externalResourceModificationTracker()}));
            if (psiReferenceArray == null) {
                XmlTagImpl.$$$reportNull$$$0(4);
            }
            return psiReferenceArray;
        }
        PsiReference[] psiReferenceArray = this.getReferencesImpl(hints);
        if (psiReferenceArray == null) {
            XmlTagImpl.$$$reportNull$$$0(5);
        }
        return psiReferenceArray;
    }

    @NotNull
    private PsiReference[] getReferencesImpl(@NotNull PsiReferenceService.Hints hints) {
        boolean inEndTag;
        boolean inStartTag;
        ASTNode startTagName;
        if (hints == null) {
            XmlTagImpl.$$$reportNull$$$0(6);
        }
        if ((startTagName = XmlChildRole.START_TAG_NAME_FINDER.findChild(this)) == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                XmlTagImpl.$$$reportNull$$$0(7);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        ASTNode endTagName = XmlChildRole.CLOSING_TAG_NAME_FINDER.findChild(this);
        SmartList refs = new SmartList();
        String prefix = this.getNamespacePrefix();
        boolean bl = inStartTag = hints.offsetInElement == null || XmlTagImpl.childContainsOffset(startTagName.getPsi(), hints.offsetInElement);
        if (inStartTag) {
            TagNameReference startTagRef = TagNameReference.createTagNameReference(this, startTagName, true);
            if (startTagRef != null) {
                refs.add(startTagRef);
            }
            if (!prefix.isEmpty()) {
                refs.addAll(this.createPrefixReferences(startTagName, prefix, startTagRef));
            }
        }
        boolean bl2 = inEndTag = endTagName != null && (hints.offsetInElement == null || XmlTagImpl.childContainsOffset(endTagName.getPsi(), hints.offsetInElement));
        if (inEndTag) {
            TagNameReference endTagRef = TagNameReference.createTagNameReference(this, endTagName, false);
            if (endTagRef != null) {
                refs.add(endTagRef);
            }
            if (StringUtil.isNotEmpty((String)(prefix = this.getNamespacePrefix(endTagName.getText())))) {
                refs.addAll(this.createPrefixReferences(endTagName, prefix, endTagRef));
            }
        }
        if (hints.offsetInElement == null || inStartTag || inEndTag || this.isInsideXmlText(hints.offsetInElement)) {
            Collections.addAll(refs, ReferenceProvidersRegistry.getReferencesFromProviders(this, hints));
        }
        PsiReference[] psiReferenceArray = (PsiReference[])ContainerUtil.toArray((List)refs, (Object[])new PsiReference[refs.size()]);
        if (psiReferenceArray == null) {
            XmlTagImpl.$$$reportNull$$$0(8);
        }
        return psiReferenceArray;
    }

    private static boolean childContainsOffset(PsiElement child, int offsetInTag) {
        return child.getStartOffsetInParent() <= offsetInTag && offsetInTag <= child.getStartOffsetInParent() + child.getTextLength();
    }

    private boolean isInsideXmlText(int offsetInTag) {
        TextRange[] ranges = this.getValueTextRanges();
        if (ranges.length == 0) {
            return false;
        }
        if (offsetInTag < ranges[0].getStartOffset() || offsetInTag > ranges[ranges.length - 1].getEndOffset()) {
            return false;
        }
        int i = Arrays.binarySearch(ranges, TextRange.from((int)offsetInTag, (int)0), RANGE_COMPARATOR);
        return i >= 0 || ranges[-i - 2].containsOffset(offsetInTag);
    }

    @NotNull
    private TextRange[] getValueTextRanges() {
        TextRange[] elements = this.myTextElements;
        if (elements == null) {
            List list2 = ContainerUtil.newSmartList();
            for (TreeElement child = this.getFirstChildNode(); child != null; child = child.getTreeNext()) {
                PsiElement psi = child.getPsi();
                if (!(psi instanceof XmlText)) continue;
                list2.add(TextRange.from((int)psi.getStartOffsetInParent(), (int)psi.getTextLength()));
            }
            this.myTextElements = elements = list2.toArray(new TextRange[0]);
        }
        if (elements == null) {
            XmlTagImpl.$$$reportNull$$$0(9);
        }
        return elements;
    }

    @NotNull
    protected Collection<PsiReference> createPrefixReferences(@NotNull ASTNode startTagName, @NotNull String prefix, @NotNull TagNameReference tagRef) {
        if (startTagName == null) {
            XmlTagImpl.$$$reportNull$$$0(10);
        }
        if (prefix == null) {
            XmlTagImpl.$$$reportNull$$$0(11);
        }
        if (tagRef == null) {
            XmlTagImpl.$$$reportNull$$$0(12);
        }
        Set<PsiReference> set2 = Collections.singleton(new SchemaPrefixReference(this, TextRange.from((int)(startTagName.getStartOffset() - this.getStartOffset()), (int)prefix.length()), prefix, tagRef));
        if (set2 == null) {
            XmlTagImpl.$$$reportNull$$$0(13);
        }
        return set2;
    }

    public XmlNSDescriptor getNSDescriptor(String namespace, boolean strict) {
        XmlNSDescriptor value;
        XmlNSDescriptor descriptor2;
        XmlTag parentTag = this.getParentTag();
        if (parentTag == null && namespace.equals("http://www.w3.org/1999/xhtml") && (descriptor2 = XmlTagImpl.getDtdDescriptor(XmlUtil.getContainingFile(this))) != null) {
            return descriptor2;
        }
        Map<String, CachedValue<XmlNSDescriptor>> map2 = this.getNSDescriptorsMap();
        CachedValue<XmlNSDescriptor> descriptor3 = map2.get(namespace);
        if (descriptor3 != null && (value = (XmlNSDescriptor)descriptor3.getValue()) != null) {
            return value;
        }
        if (parentTag == null) {
            XmlDocument parentOfType = (XmlDocument)PsiTreeUtil.getParentOfType((PsiElement)this, XmlDocument.class);
            if (parentOfType == null) {
                return null;
            }
            return parentOfType.getDefaultNSDescriptor(namespace, strict);
        }
        return parentTag.getNSDescriptor(namespace, strict);
    }

    public boolean isEmpty() {
        return XmlChildRole.CLOSING_TAG_START_FINDER.findChild(this) == null;
    }

    public void collapseIfEmpty() {
        XmlTag[] tags = this.getSubTags();
        if (tags.length > 0) {
            return;
        }
        final ASTNode closingName = XmlChildRole.CLOSING_TAG_NAME_FINDER.findChild(this);
        final ASTNode startTagEnd = XmlChildRole.START_TAG_END_FINDER.findChild(this);
        if (closingName == null || startTagEnd == null) {
            return;
        }
        PomModel pomModel = PomManager.getModel((Project)this.getProject());
        PomTransactionBase transaction = new PomTransactionBase(this, pomModel.getModelAspect(XmlAspect.class)){

            @Nullable
            public PomModelEvent runInner() {
                ASTNode closingBracket = closingName.getTreeNext();
                XmlTagImpl.this.removeRange(startTagEnd, closingBracket);
                LeafElement emptyTagEnd = Factory.createSingleLeafElement(XmlTokenType.XML_EMPTY_ELEMENT_END, "/>", 0, 2, null, XmlTagImpl.this.getManager());
                XmlTagImpl.this.replaceChild(closingBracket, emptyTagEnd);
                return null;
            }
        };
        try {
            pomModel.runTransaction((PomTransaction)transaction);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    @Nullable
    @NonNls
    public String getSubTagText(@NonNls String qname) {
        XmlTag tag = this.findFirstSubTag(qname);
        if (tag == null) {
            return null;
        }
        return tag.getValue().getText();
    }

    protected final Map<String, CachedValue<XmlNSDescriptor>> getNSDescriptorsMap() {
        return (Map)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create(this.computeNsDescriptorMap(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, this.externalResourceModificationTracker()}));
    }

    @NotNull
    private Map<String, CachedValue<XmlNSDescriptor>> computeNsDescriptorMap() {
        Map<String, CachedValue<XmlNSDescriptor>> map2 = null;
        String noNamespaceDeclaration = this.getAttributeValue("noNamespaceSchemaLocation", "http://www.w3.org/2001/XMLSchema-instance");
        String schemaLocationDeclaration = this.getAttributeValue("schemaLocation", "http://www.w3.org/2001/XMLSchema-instance");
        if (noNamespaceDeclaration != null) {
            map2 = this.initializeSchema("", null, Collections.singleton(noNamespaceDeclaration), null, this.myHasNamespaceDeclarations);
        }
        if (schemaLocationDeclaration != null) {
            StringTokenizer tokenizer = new StringTokenizer(schemaLocationDeclaration);
            while (tokenizer.hasMoreTokens()) {
                String uri = tokenizer.nextToken();
                if (!tokenizer.hasMoreTokens()) continue;
                map2 = this.initializeSchema(uri, XmlTagImpl.getNSVersion(uri, this), Collections.singleton(tokenizer.nextToken()), map2, this.myHasNamespaceDeclarations);
            }
        }
        if (this.hasNamespaceDeclarations()) {
            for (XmlAttribute attribute : this.getAttributes()) {
                if (!attribute.isNamespaceDeclaration()) continue;
                String ns = attribute.getValue();
                if (ns == null) {
                    ns = "";
                }
                ns = this.getRealNs(ns);
                if (map2 != null && map2.containsKey(ns)) continue;
                Set<String> locations = this.getNsLocations(ns);
                map2 = this.initializeSchema(ns, XmlTagImpl.getNSVersion(ns, this), locations, map2, true);
            }
        }
        Map<String, CachedValue<XmlNSDescriptor>> map3 = map2 == null ? Collections.emptyMap() : map2;
        if (map3 == null) {
            XmlTagImpl.$$$reportNull$$$0(14);
        }
        return map3;
    }

    private Map<String, CachedValue<XmlNSDescriptor>> initializeSchema(@NotNull String namespace, @Nullable String version, Set<String> fileLocations, Map<String, CachedValue<XmlNSDescriptor>> map2, boolean nsDecl) {
        if (namespace == null) {
            XmlTagImpl.$$$reportNull$$$0(15);
        }
        if (map2 == null) {
            map2 = new THashMap();
        }
        map2.put(namespace, CachedValuesManager.getManager((Project)this.getManager().getProject()).createCachedValue(() -> {
            if (namespace == null) {
                XmlTagImpl.$$$reportNull$$$0(40);
            }
            XmlFile[] file2 = new XmlFile[1];
            List descriptors = fileLocations.stream().map(s -> {
                if (namespace == null) {
                    XmlTagImpl.$$$reportNull$$$0(41);
                }
                file2[0] = this.retrieveFile((String)s, version, namespace, nsDecl);
                return this.getDescriptor(file2[0], (String)s, namespace);
            }).filter(Objects::nonNull).collect(Collectors.toList());
            XmlNSDescriptor descriptor2 = null;
            if (descriptors.size() == 1) {
                descriptor2 = (XmlNSDescriptor)descriptors.get(0);
            } else if (descriptors.size() > 1) {
                descriptor2 = new MultiFileNsDescriptor(descriptors.stream().map(descriptor1 -> (XmlNSDescriptorImpl)descriptor1).collect(Collectors.toList()));
            }
            if (descriptor2 == null) {
                return new CachedValueProvider.Result(null, new Object[]{this, file2[0] == null ? this : file2[0], ExternalResourceManager.getInstance()});
            }
            return new CachedValueProvider.Result((Object)descriptor2, new Object[]{descriptor2.getDependences(), this});
        }, false));
        return map2;
    }

    private XmlNSDescriptor getDescriptor(@Nullable XmlFile currentFile, String fileLocation, String namespace) {
        PsiMetaOwner currentOwner;
        XmlDocument document;
        XmlNSDescriptor descriptor2 = this.getImplicitNamespaceDescriptor(fileLocation);
        if (descriptor2 != null) {
            return descriptor2;
        }
        if (currentFile == null && (document = XmlUtil.getContainingFile(this).getDocument()) != null) {
            String defaultValue;
            XmlAttributeDescriptor attributeDescriptor;
            XmlElementDescriptor elementDescriptor;
            String uri = XmlUtil.getDtdUri(document);
            if (uri != null) {
                XmlFile containingFile = XmlUtil.getContainingFile((PsiElement)document);
                XmlFile xmlFile = XmlUtil.findNamespace((PsiFile)containingFile, uri);
                XmlNSDescriptor xmlNSDescriptor = descriptor2 = xmlFile == null ? null : (XmlNSDescriptor)xmlFile.getDocument().getMetaData();
            }
            if (descriptor2 instanceof com.intellij.xml.impl.dtd.XmlNSDescriptorImpl && (elementDescriptor = descriptor2.getElementDescriptor((XmlTag)this)) != null && (attributeDescriptor = elementDescriptor.getAttributeDescriptor("xmlns", (XmlTag)this)) != null && attributeDescriptor.isFixed() && (defaultValue = attributeDescriptor.getDefaultValue()) != null && defaultValue.equals(namespace)) {
                return descriptor2;
            }
        }
        if ((currentOwner = this.retrieveOwner(currentFile, namespace)) != null) {
            return (XmlNSDescriptor)currentOwner.getMetaData();
        }
        return null;
    }

    @Nullable
    private XmlNSDescriptor getImplicitNamespaceDescriptor(String ns) {
        PsiFile file2 = this.getContainingFile();
        if (file2 == null) {
            return null;
        }
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)file2);
        if (module2 != null) {
            for (ImplicitNamespaceDescriptorProvider provider : (ImplicitNamespaceDescriptorProvider[])Extensions.getExtensions(ImplicitNamespaceDescriptorProvider.EP_NAME)) {
                XmlNSDescriptor nsDescriptor = provider.getNamespaceDescriptor(module2, ns, file2);
                if (nsDescriptor == null) continue;
                return nsDescriptor;
            }
        }
        return null;
    }

    @Nullable
    private XmlFile retrieveFile(String fileLocation, String version, String namespace, boolean nsDecl) {
        String targetNs = XmlUtil.getTargetSchemaNsFromTag(this);
        if (fileLocation.equals(targetNs)) {
            return null;
        }
        XmlFile file2 = XmlUtil.getContainingFile(this);
        if (file2 == null) {
            return null;
        }
        PsiFile psiFile = ExternalResourceManager.getInstance().getResourceLocation(fileLocation, (PsiFile)file2, version);
        if (psiFile instanceof XmlFile) {
            return (XmlFile)psiFile;
        }
        return XmlNamespaceIndex.guessSchema(namespace, nsDecl ? null : this.getLocalName(), version, fileLocation, (PsiFile)file2);
    }

    @Nullable
    private PsiMetaOwner retrieveOwner(XmlFile file2, @NotNull String namespace) {
        if (namespace == null) {
            XmlTagImpl.$$$reportNull$$$0(16);
        }
        if (file2 == null) {
            return namespace.equals(XmlUtil.getTargetSchemaNsFromTag(this)) ? this : null;
        }
        return file2.getDocument();
    }

    @Override
    public PsiReference getReference() {
        return (PsiReference)ArrayUtil.getFirstElement((Object[])this.getReferences(PsiReferenceService.Hints.NO_HINTS));
    }

    public XmlElementDescriptor getDescriptor() {
        return (XmlElementDescriptor)CachedValuesManager.getCachedValue((PsiElement)this, () -> {
            RecursionGuard.StackStamp stamp = ourGuard.markStack();
            XmlElementDescriptor descriptor2 = (XmlElementDescriptor)ourGuard.doPreventingRecursion((Object)this, true, this::computeElementDescriptor);
            if (stamp.mayCacheNow()) {
                return CachedValueProvider.Result.create((Object)descriptor2, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, this.externalResourceModificationTracker()});
            }
            return CachedValueProvider.Result.create((Object)descriptor2, (Object[])new Object[]{ModificationTracker.EVER_CHANGED});
        });
    }

    private ModificationTracker externalResourceModificationTracker() {
        Project project = this.getProject();
        ExternalResourceManagerEx manager = ExternalResourceManagerEx.getInstanceEx();
        return () -> manager.getModificationCount(project);
    }

    @Nullable
    protected XmlElementDescriptor computeElementDescriptor() {
        XmlElementDescriptor fromParent;
        XmlElementDescriptor descriptor2;
        XmlTag parent;
        for (XmlElementDescriptorProvider provider : (XmlElementDescriptorProvider[])Extensions.getExtensions(XmlElementDescriptorProvider.EP_NAME)) {
            XmlElementDescriptor elementDescriptor = provider.getDescriptor(this);
            if (elementDescriptor == null) continue;
            return elementDescriptor;
        }
        String namespace = this.getNamespace();
        if ("".equals(namespace) && (parent = this.getParentTag()) != null && (descriptor2 = parent.getDescriptor()) != null && (fromParent = descriptor2.getElementDescriptor((XmlTag)this, parent)) != null && !(fromParent instanceof AnyXmlElementDescriptor)) {
            return fromParent;
        }
        XmlElementDescriptor elementDescriptor = null;
        XmlNSDescriptor nsDescriptor = this.getNSDescriptor(namespace, false);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Descriptor for namespace " + namespace + " is " + (nsDescriptor != null ? nsDescriptor.getClass().getCanonicalName() : "NULL"));
        }
        if (nsDescriptor != null && (!DumbService.getInstance((Project)this.getProject()).isDumb() || DumbService.isDumbAware((Object)nsDescriptor))) {
            elementDescriptor = nsDescriptor.getElementDescriptor((XmlTag)this);
        }
        if (elementDescriptor == null) {
            return XmlUtil.findXmlDescriptorByType(this);
        }
        return elementDescriptor;
    }

    @Override
    public int getChildRole(@NotNull ASTNode child) {
        if (child == null) {
            XmlTagImpl.$$$reportNull$$$0(17);
        }
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == XmlTokenType.XML_NAME || i == XmlTokenType.XML_TAG_NAME) {
            return 224;
        }
        if (i == XmlElementType.XML_ATTRIBUTE) {
            return 240;
        }
        return 0;
    }

    @Override
    @NotNull
    public String getName() {
        String name = this.myName;
        if (name == null) {
            ASTNode nameElement = XmlChildRole.START_TAG_NAME_FINDER.findChild(this);
            name = nameElement != null ? nameElement.getText() : "";
            this.myName = name;
        }
        String string = name;
        if (string == null) {
            XmlTagImpl.$$$reportNull$$$0(18);
        }
        return string;
    }

    public PsiElement setName(final @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            XmlTagImpl.$$$reportNull$$$0(19);
        }
        final PomModel model = PomManager.getModel((Project)this.getProject());
        XmlAspect aspect = (XmlAspect)model.getModelAspect(XmlAspect.class);
        model.runTransaction((PomTransaction)new PomTransactionBase(this, (PomModelAspect)aspect){

            public PomModelEvent runInner() throws IncorrectOperationException {
                TreeElement treeElement;
                String oldName = XmlTagImpl.this.getName();
                XmlTagImpl dummyTag = (XmlTagImpl)XmlElementFactory.getInstance((Project)XmlTagImpl.this.getProject()).createTagFromText(XmlTagUtil.composeTagText((String)name, (String)"aa"));
                XmlTagImpl tag = XmlTagImpl.this;
                CharTable charTableByTree = SharedImplUtil.findCharTableByTree(tag);
                ASTNode child = XmlChildRole.START_TAG_NAME_FINDER.findChild(tag);
                LOG.assertTrue(child != null, (Object)("It seems '" + name + "' is not a valid tag name"));
                TreeElement tagElement = (TreeElement)XmlChildRole.START_TAG_NAME_FINDER.findChild(dummyTag);
                LOG.assertTrue(tagElement != null, (Object)("What's wrong with it? '" + name + "'"));
                tag.replaceChild(child, ChangeUtil.copyElement(tagElement, charTableByTree));
                ASTNode childByRole = XmlChildRole.CLOSING_TAG_NAME_FINDER.findChild(tag);
                if (childByRole != null && (treeElement = (TreeElement)XmlChildRole.CLOSING_TAG_NAME_FINDER.findChild(dummyTag)) != null) {
                    tag.replaceChild(childByRole, ChangeUtil.copyElement(treeElement, charTableByTree));
                }
                return XmlTagNameChangedImpl.createXmlTagNameChanged(model, tag, oldName);
            }
        });
        return this;
    }

    @NotNull
    public XmlAttribute[] getAttributes() {
        XmlAttribute[] attributes = this.myAttributes;
        if (attributes == null) {
            this.myAttributes = attributes = this.calculateAttributes();
        }
        if (attributes == null) {
            XmlTagImpl.$$$reportNull$$$0(20);
        }
        return attributes;
    }

    @NotNull
    private XmlAttribute[] calculateAttributes() {
        final ArrayList result2 = new ArrayList(10);
        this.processChildren(new PsiElementProcessor(){

            public boolean execute(@NotNull PsiElement element) {
                if (element == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (element instanceof XmlAttribute) {
                    XmlAttribute attribute = (XmlAttribute)element;
                    result2.add(attribute);
                    if (!XmlTagImpl.this.myHasNamespaceDeclarations && attribute.isNamespaceDeclaration()) {
                        XmlTagImpl.this.myHasNamespaceDeclarations = true;
                    }
                } else if (element instanceof XmlToken && ((XmlToken)element).getTokenType() == XmlTokenType.XML_TAG_END) {
                    return false;
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/xml/XmlTagImpl$4", "execute"));
            }
        });
        if (result2.isEmpty()) {
            if (XmlAttribute.EMPTY_ARRAY == null) {
                XmlTagImpl.$$$reportNull$$$0(21);
            }
            return XmlAttribute.EMPTY_ARRAY;
        }
        XmlAttribute[] xmlAttributeArray = (XmlAttribute[])ContainerUtil.toArray(result2, (Object[])new XmlAttribute[result2.size()]);
        if (xmlAttributeArray == null) {
            XmlTagImpl.$$$reportNull$$$0(22);
        }
        return xmlAttributeArray;
    }

    protected void cacheOneAttributeValue(String name, String value, Map<String, String> attributesValueMap) {
        attributesValueMap.put(name, value);
    }

    public String getAttributeValue(String qname) {
        THashMap map2 = this.myAttributeValueMap;
        if (map2 == null) {
            map2 = new THashMap();
            for (XmlAttribute attribute : this.getAttributes()) {
                this.cacheOneAttributeValue(attribute.getName(), attribute.getValue(), (Map<String, String>)map2);
            }
            this.myAttributeValueMap = map2;
        }
        return map2.get(qname);
    }

    public String getAttributeValue(String _name, String namespace) {
        if (namespace == null) {
            return this.getAttributeValue(_name);
        }
        XmlTagImpl current = this;
        while (true) {
            PsiElement parent;
            List keysByValue;
            BidirectionalMap<String, String> map2;
            if ((map2 = current.getNamespaceMap()) != null && (keysByValue = map2.getKeysByValue((Object)namespace)) != null && !keysByValue.isEmpty()) {
                for (String prefix : keysByValue) {
                    String value;
                    if (prefix == null || prefix.isEmpty() || (value = this.getAttributeValue(prefix + ":" + _name)) == null) continue;
                    return value;
                }
            }
            if (!((parent = current.getParent()) instanceof XmlTag)) break;
            current = (XmlTagImpl)parent;
        }
        if (namespace.isEmpty() || this.getNamespace().equals(namespace)) {
            return this.getAttributeValue(_name);
        }
        return null;
    }

    @NotNull
    public XmlTag[] getSubTags() {
        XmlTag[] xmlTagArray = (XmlTag[])CachedValuesManager.getManager((Project)this.getProject()).getParameterizedCachedValue((UserDataHolder)this, SUBTAGS_KEY, CACHED_VALUE_PROVIDER, false, (Object)this);
        if (xmlTagArray == null) {
            XmlTagImpl.$$$reportNull$$$0(23);
        }
        return xmlTagArray;
    }

    protected void fillSubTags(final List<XmlTag> result2) {
        this.processElements(new PsiElementProcessor(){

            public boolean execute(@NotNull PsiElement element) {
                if (element == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (element instanceof XmlTag) {
                    PsiUtilCore.ensureValid((PsiElement)element);
                    result2.add((XmlTag)element);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/xml/XmlTagImpl$5", "execute"));
            }
        }, this);
    }

    @NotNull
    public XmlTag[] findSubTags(String name) {
        XmlTag[] xmlTagArray = this.findSubTags(name, null);
        if (xmlTagArray == null) {
            XmlTagImpl.$$$reportNull$$$0(24);
        }
        return xmlTagArray;
    }

    @NotNull
    public XmlTag[] findSubTags(String name, @Nullable String namespace) {
        XmlTag[] subTags = this.getSubTags();
        ArrayList<XmlTag> result2 = new ArrayList<XmlTag>();
        for (XmlTag subTag : subTags) {
            if (namespace == null) {
                if (!name.equals(subTag.getName())) continue;
                result2.add(subTag);
                continue;
            }
            if (!name.equals(subTag.getLocalName()) || !namespace.equals(subTag.getNamespace())) continue;
            result2.add(subTag);
        }
        XmlTag[] xmlTagArray = (XmlTag[])ContainerUtil.toArray(result2, (Object[])new XmlTag[result2.size()]);
        if (xmlTagArray == null) {
            XmlTagImpl.$$$reportNull$$$0(25);
        }
        return xmlTagArray;
    }

    public XmlTag findFirstSubTag(String name) {
        XmlTag[] subTags = this.findSubTags(name);
        if (subTags.length > 0) {
            return subTags[0];
        }
        return null;
    }

    public XmlAttribute getAttribute(String name, String namespace) {
        if (name != null && name.indexOf(58) != -1 || namespace == null || "".equals(namespace)) {
            return this.getAttribute(name);
        }
        String prefix = this.getPrefixByNamespace(namespace);
        if (prefix == null || prefix.isEmpty()) {
            return null;
        }
        return this.getAttribute(prefix + ":" + name);
    }

    @Nullable
    public XmlAttribute getAttribute(String qname) {
        if (qname == null) {
            return null;
        }
        XmlAttribute[] attributes = this.getAttributes();
        boolean caseSensitive = this.isCaseSensitive();
        for (XmlAttribute attribute : attributes) {
            ASTNode child = XmlChildRole.ATTRIBUTE_NAME_FINDER.findChild(attribute.getNode());
            if (!(child instanceof LeafElement)) continue;
            LeafElement attrNameElement = (LeafElement)child;
            if ((!caseSensitive || !Comparing.equal((CharSequence)attrNameElement.getChars(), (CharSequence)qname)) && (caseSensitive || !Comparing.equal((CharSequence)attrNameElement.getChars(), (CharSequence)qname, (boolean)false))) continue;
            return attribute;
        }
        return null;
    }

    public boolean isCaseSensitive() {
        return true;
    }

    @NotNull
    public String getNamespace() {
        String string = (String)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create((Object)this.getNamespaceByPrefix(this.getNamespacePrefix()), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        if (string == null) {
            XmlTagImpl.$$$reportNull$$$0(26);
        }
        return string;
    }

    @NotNull
    public String getNamespacePrefix() {
        String string = this.getNamespacePrefix(this.getName());
        if (string == null) {
            XmlTagImpl.$$$reportNull$$$0(27);
        }
        return string;
    }

    @NotNull
    protected String getNamespacePrefix(@NotNull String name) {
        if (name == null) {
            XmlTagImpl.$$$reportNull$$$0(28);
        }
        String string = XmlUtil.findPrefixByQualifiedName(name);
        if (string == null) {
            XmlTagImpl.$$$reportNull$$$0(29);
        }
        return string;
    }

    @NotNull
    public String getNamespaceByPrefix(String prefix) {
        String result2;
        String ns;
        BidirectionalMap<String, String> map2 = this.getNamespaceMap();
        if (map2 != null && (ns = (String)map2.get((Object)prefix)) != null) {
            String string = ns;
            if (string == null) {
                XmlTagImpl.$$$reportNull$$$0(30);
            }
            return string;
        }
        XmlTag parentTag = this.getParentTag();
        if (parentTag != null) {
            String string = parentTag.getNamespaceByPrefix(prefix);
            if (string == null) {
                XmlTagImpl.$$$reportNull$$$0(31);
            }
            return string;
        }
        if (XML_NS_PREFIX.equals(prefix)) {
            if ("http://www.w3.org/XML/1998/namespace" == null) {
                XmlTagImpl.$$$reportNull$$$0(32);
            }
            return "http://www.w3.org/XML/1998/namespace";
        }
        if (!prefix.isEmpty() && !this.hasNamespaceDeclarations() && this.getNamespacePrefix().equals(prefix) && (result2 = (String)ourGuard.doPreventingRecursion((Object)"getNsByPrefix", true, () -> {
            String nameFromRealDescriptor;
            String nsFromEmptyPrefix = this.getNamespaceByPrefix("");
            XmlNSDescriptor nsDescriptor = this.getNSDescriptor(nsFromEmptyPrefix, false);
            XmlElementDescriptor descriptor2 = nsDescriptor != null ? nsDescriptor.getElementDescriptor((XmlTag)this) : null;
            String string = nameFromRealDescriptor = descriptor2 != null && descriptor2.getDeclaration() != null && descriptor2.getDeclaration().isPhysical() ? descriptor2.getName() : "";
            if (nameFromRealDescriptor.equals(this.getName())) {
                return nsFromEmptyPrefix;
            }
            return "";
        })) != null) {
            String string = result2;
            if (string == null) {
                XmlTagImpl.$$$reportNull$$$0(33);
            }
            return string;
        }
        if ("" == null) {
            XmlTagImpl.$$$reportNull$$$0(34);
        }
        return "";
    }

    public String getPrefixByNamespace(String namespace) {
        XmlTag parentTag;
        BidirectionalMap<String, String> map2 = this.getNamespaceMap();
        if (map2 != null) {
            String ns;
            List keysByValue = map2.getKeysByValue((Object)namespace);
            String string = ns = keysByValue == null || keysByValue.isEmpty() ? null : (String)keysByValue.get(0);
            if (ns != null) {
                return ns;
            }
        }
        if ((parentTag = this.getParentTag()) != null) {
            return parentTag.getPrefixByNamespace(namespace);
        }
        if ("http://www.w3.org/XML/1998/namespace".equals(namespace)) {
            return XML_NS_PREFIX;
        }
        return null;
    }

    public String[] knownNamespaces() {
        PsiElement parentElement = this.getParent();
        BidirectionalMap<String, String> map2 = this.getNamespaceMap();
        Set known = Collections.emptySet();
        if (map2 != null) {
            known = new HashSet(map2.values());
        }
        if (parentElement instanceof XmlTag) {
            if (known.isEmpty()) {
                return ((XmlTag)parentElement).knownNamespaces();
            }
            ContainerUtil.addAll(known, (Object[])((XmlTag)parentElement).knownNamespaces());
        } else {
            XmlTag rootTag;
            XmlFile xmlFile;
            XmlExtension xmlExtension = XmlExtension.getExtensionByElement(this);
            if (xmlExtension != null && (xmlFile = xmlExtension.getContainingFile(this)) != null && (rootTag = xmlFile.getRootTag()) != null && rootTag != this) {
                if (known.isEmpty()) {
                    return rootTag.knownNamespaces();
                }
                ContainerUtil.addAll(known, (Object[])rootTag.knownNamespaces());
            }
        }
        return ArrayUtil.toStringArray(known);
    }

    @Nullable
    private BidirectionalMap<String, String> getNamespaceMap() {
        return (BidirectionalMap)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create(this.computeNamespaceMap(this.getParent()), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    @Nullable
    private BidirectionalMap<String, String> computeNamespaceMap(PsiElement parent) {
        String[][] namespacesFromDocument;
        XmlExtension extension;
        BidirectionalMap map2 = null;
        boolean hasNamespaceDeclarations = this.hasNamespaceDeclarations();
        if (hasNamespaceDeclarations) {
            XmlAttribute[] attributes;
            map2 = new BidirectionalMap();
            for (XmlAttribute attribute : attributes = this.getAttributes()) {
                if (!attribute.isNamespaceDeclaration()) continue;
                String name = attribute.getName();
                int splitIndex = name.indexOf(58);
                String value = this.getRealNs(attribute.getValue());
                if (value == null) continue;
                if (splitIndex < 0) {
                    map2.put((Object)"", (Object)value);
                    continue;
                }
                map2.put((Object)XmlUtil.findLocalNameByQualifiedName(name), (Object)value);
            }
        }
        if (parent instanceof XmlDocument && (extension = XmlExtension.getExtensionByElement(parent)) != null && (namespacesFromDocument = extension.getNamespacesFromDocument((XmlDocument)parent, hasNamespaceDeclarations)) != null) {
            if (map2 == null) {
                map2 = new BidirectionalMap();
            }
            for (String[] prefix2ns : namespacesFromDocument) {
                if (map2.containsKey((Object)prefix2ns[0])) continue;
                map2.put((Object)prefix2ns[0], (Object)this.getRealNs(prefix2ns[1]));
            }
        }
        return map2;
    }

    private Set<String> getNsLocations(String ns) {
        if ("http://www.w3.org/1999/xhtml".equals(ns)) {
            return Collections.singleton(XmlUtil.getDefaultXhtmlNamespace(this.getProject()));
        }
        HashSet<String> locations = new HashSet<String>();
        if (XmlNSDescriptorImpl.equalsToSchemaName(this, "schema")) {
            for (XmlTag subTag : this.getSubTags()) {
                if (!XmlNSDescriptorImpl.equalsToSchemaName(subTag, "import") || !ns.equals(subTag.getAttributeValue("namespace"))) continue;
                String location = subTag.getAttributeValue("schemaLocation");
                ContainerUtil.addIfNotNull(locations, (Object)location);
            }
        }
        if (locations.isEmpty()) {
            locations.add(XmlUtil.getSchemaLocation(this, ns));
        }
        return locations;
    }

    protected String getRealNs(String value) {
        return value;
    }

    @NotNull
    public String getLocalName() {
        String localName = this.myLocalName;
        if (localName == null) {
            String name = this.getName();
            this.myLocalName = localName = name.substring(name.indexOf(58) + 1);
        }
        String string = localName;
        if (string == null) {
            XmlTagImpl.$$$reportNull$$$0(35);
        }
        return string;
    }

    public boolean hasNamespaceDeclarations() {
        this.getAttributes();
        return this.myHasNamespaceDeclarations;
    }

    @NotNull
    public Map<String, String> getLocalNamespaceDeclarations() {
        THashMap namespaces = new THashMap();
        for (XmlAttribute attribute : this.getAttributes()) {
            if (!attribute.isNamespaceDeclaration() || attribute.getValue() == null) continue;
            String localName = attribute.getLocalName();
            namespaces.put(localName.equals(attribute.getName()) ? "" : localName, attribute.getValue());
        }
        THashMap tHashMap = namespaces;
        if (tHashMap == null) {
            XmlTagImpl.$$$reportNull$$$0(36);
        }
        return tHashMap;
    }

    public XmlAttribute setAttribute(String qname, String value) throws IncorrectOperationException {
        XmlAttribute attribute = this.getAttribute(qname);
        if (attribute != null) {
            if (value == null) {
                this.deleteChildInternal(attribute.getNode());
                return null;
            }
            attribute.setValue(value);
            return attribute;
        }
        if (value == null) {
            return null;
        }
        PsiElement xmlAttribute = this.add((PsiElement)XmlElementFactory.getInstance((Project)this.getProject()).createAttribute(qname, value, (PsiElement)this));
        while (!(xmlAttribute instanceof XmlAttribute)) {
            xmlAttribute = xmlAttribute.getNextSibling();
        }
        return (XmlAttribute)xmlAttribute;
    }

    public XmlAttribute setAttribute(String name, String namespace, String value) throws IncorrectOperationException {
        String prefix;
        if (!Comparing.equal((String)namespace, (String)"") && (prefix = this.getPrefixByNamespace(namespace)) != null && !prefix.isEmpty()) {
            name = prefix + ":" + name;
        }
        return this.setAttribute(name, value);
    }

    public XmlTag createChildTag(String localName, String namespace, String bodyText, boolean enforceNamespacesDeep) {
        return XmlUtil.createChildTag(this, localName, namespace, bodyText, enforceNamespacesDeep);
    }

    public XmlTag addSubTag(XmlTag subTag, boolean first) {
        Object[] children2 = this.getSubTags();
        if (children2.length == 0) {
            children2 = this.getValue().getChildren();
        }
        if (children2.length == 0) {
            return (XmlTag)this.add((PsiElement)subTag);
        }
        if (first) {
            return (XmlTag)this.addBefore((PsiElement)subTag, (PsiElement)children2[0]);
        }
        return (XmlTag)this.addAfter((PsiElement)subTag, (PsiElement)ArrayUtil.getLastElement((Object[])children2));
    }

    @NotNull
    public XmlTagValue getValue() {
        XmlTagValue tagValue = this.myValue;
        if (tagValue == null) {
            this.myValue = tagValue = XmlTagValueImpl.createXmlTagValue(this);
        }
        XmlTagValue xmlTagValue = tagValue;
        if (xmlTagValue == null) {
            XmlTagImpl.$$$reportNull$$$0(37);
        }
        return xmlTagValue;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            XmlTagImpl.$$$reportNull$$$0(38);
        }
        if (visitor2 instanceof XmlElementVisitor) {
            ((XmlElementVisitor)visitor2).visitXmlTag((XmlTag)this);
        } else {
            visitor2.visitElement((PsiElement)this);
        }
    }

    @Override
    public String toString() {
        return "XmlTag:" + this.getName();
    }

    public PsiMetaData getMetaData() {
        return MetaRegistry.getMeta(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TreeElement addInternal(TreeElement first, ASTNode last, ASTNode anchor2, Boolean beforeB) {
        TreeElement firstAppended = null;
        boolean before = beforeB == null || beforeB != false;
        try {
            TreeElement next;
            do {
                next = first.getTreeNext();
                if (firstAppended == null) {
                    firstAppended = this.addInternal(first, anchor2, before);
                    anchor2 = firstAppended;
                    continue;
                }
                anchor2 = this.addInternal(first, anchor2, false);
            } while (first != last && (first = next) != null);
        }
        catch (IncorrectOperationException incorrectOperationException) {
        }
        finally {
            this.clearCaches();
        }
        return firstAppended;
    }

    private TreeElement addInternal(TreeElement child, ASTNode anchor2, boolean before) throws IncorrectOperationException {
        PomModel model = PomManager.getModel((Project)this.getProject());
        if (anchor2 != null && child.getElementType() == XmlElementType.XML_TEXT) {
            XmlText psi = null;
            if (anchor2.getPsi() instanceof XmlText) {
                psi = (XmlText)anchor2.getPsi();
            } else {
                ASTNode other;
                ASTNode aSTNode = other = before ? anchor2.getTreePrev() : anchor2.getTreeNext();
                if (other != null && other.getPsi() instanceof XmlText) {
                    before = !before;
                    psi = (XmlText)other.getPsi();
                }
            }
            if (psi != null) {
                if (before) {
                    psi.insertText(((XmlText)child.getPsi()).getValue(), 0);
                } else {
                    psi.insertText(((XmlText)child.getPsi()).getValue(), psi.getValue().length());
                }
                return (TreeElement)psi.getNode();
            }
        }
        LOG.assertTrue(child.getPsi() instanceof XmlAttribute || child.getPsi() instanceof XmlTagChild);
        InsertTransaction transaction = child.getElementType() == XmlElementType.XML_ATTRIBUTE ? new InsertAttributeTransaction(child, anchor2, before, model) : (anchor2 == null ? this.getBodyInsertTransaction(child) : new GenericInsertTransaction(child, anchor2, before));
        model.runTransaction((PomTransaction)transaction);
        return transaction.getFirstInserted();
    }

    protected InsertTransaction getBodyInsertTransaction(TreeElement child) {
        return new BodyInsertTransaction(child);
    }

    @Override
    public void deleteChildInternal(final @NotNull ASTNode child) {
        if (child == null) {
            XmlTagImpl.$$$reportNull$$$0(39);
        }
        final PomModel model = PomManager.getModel((Project)this.getProject());
        XmlAspect aspect = (XmlAspect)model.getModelAspect(XmlAspect.class);
        if (child.getElementType() == XmlElementType.XML_ATTRIBUTE) {
            try {
                model.runTransaction((PomTransaction)new PomTransactionBase(this, (PomModelAspect)aspect){

                    public PomModelEvent runInner() {
                        String name = ((XmlAttribute)child).getName();
                        XmlTagImpl.super.deleteChildInternal(child);
                        return XmlAttributeSetImpl.createXmlAttributeSet(model, XmlTagImpl.this, name, null);
                    }
                });
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        } else {
            ASTNode treePrev = child.getTreePrev();
            ASTNode treeNext = child.getTreeNext();
            super.deleteChildInternal(child);
            if (treePrev != null && treeNext != null && treePrev.getElementType() == XmlElementType.XML_TEXT && treeNext.getElementType() == XmlElementType.XML_TEXT && !TreeUtil.containsOuterLanguageElements(treePrev) && !TreeUtil.containsOuterLanguageElements(treeNext)) {
                final XmlText prevText = (XmlText)treePrev.getPsi();
                final XmlText nextText = (XmlText)treeNext.getPsi();
                final String newValue = prevText.getValue() + nextText.getValue();
                ChangeUtil.prepareAndRunChangeAction(new ChangeUtil.ChangeAction(){

                    @Override
                    public void makeChange(TreeChangeEvent destinationTreeChange) {
                        PsiElement anchor2 = prevText.getPrevSibling();
                        prevText.delete();
                        nextText.delete();
                        XmlText text2 = (XmlText)XmlTagImpl.this.addAfter((PsiElement)XmlElementFactory.getInstance((Project)XmlTagImpl.this.getProject()).createDisplayText("x"), anchor2);
                        text2.setValue(newValue);
                    }
                }, this);
            }
        }
    }

    private ASTNode expandTag() throws IncorrectOperationException {
        ASTNode endTagStart = XmlChildRole.CLOSING_TAG_START_FINDER.findChild(this);
        if (endTagStart == null) {
            XmlTagImpl tagFromText = (XmlTagImpl)XmlElementFactory.getInstance((Project)this.getProject()).createTagFromText((CharSequence)("<" + this.getName() + "></" + this.getName() + ">"));
            ASTNode startTagStart = XmlChildRole.START_TAG_END_FINDER.findChild(tagFromText);
            endTagStart = XmlChildRole.CLOSING_TAG_START_FINDER.findChild(tagFromText);
            LeafElement emptyTagEnd = (LeafElement)XmlChildRole.EMPTY_TAG_END_FINDER.findChild(this);
            if (emptyTagEnd != null) {
                this.removeChild(emptyTagEnd);
            }
            this.addChildren(startTagStart, null, null);
        }
        return endTagStart;
    }

    public XmlTag getParentTag() {
        PsiElement parent = this.getParent();
        if (parent instanceof XmlTag) {
            return (XmlTag)parent;
        }
        return null;
    }

    public XmlTagChild getNextSiblingInTag() {
        PsiElement nextSibling = this.getNextSibling();
        if (nextSibling instanceof XmlTagChild) {
            return (XmlTagChild)nextSibling;
        }
        return null;
    }

    public XmlTagChild getPrevSiblingInTag() {
        PsiElement prevSibling = this.getPrevSibling();
        if (prevSibling instanceof XmlTagChild) {
            return (XmlTagChild)prevSibling;
        }
        return null;
    }

    public Icon getElementIcon(int flags) {
        return PlatformIcons.XML_TAG_ICON;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/xml/XmlTagImpl";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hints";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startTagName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagRef";
                break;
            }
            case 15: 
            case 16: 
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 17: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 19: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/xml/XmlTagImpl";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesImpl";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueTextRanges";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createPrefixReferences";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "computeNsDescriptorMap";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributes";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateAttributes";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubTags";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "findSubTags";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespace";
                break;
            }
            case 27: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespacePrefix";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespaceByPrefix";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalName";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalNamespaceDeclarations";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDtdDescriptor";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "shouldAskParentForReferences";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getReferences";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesImpl";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createPrefixReferences";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "initializeSchema";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "retrieveOwner";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getChildRole";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getNamespacePrefix";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "deleteChildInternal";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "lambda$initializeSchema$4";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected abstract class InsertTransaction
    extends PomTransactionBase {
        public InsertTransaction(PsiElement scope) {
            super(scope, PomManager.getModel((Project)XmlTagImpl.this.getProject()).getModelAspect(XmlAspect.class));
        }

        public abstract TreeElement getFirstInserted();
    }

    protected class GenericInsertTransaction
    extends InsertTransaction {
        private final TreeElement myChild;
        private final ASTNode myAnchor;
        private final boolean myBefore;
        private TreeElement myRetHolder;

        public GenericInsertTransaction(TreeElement child, ASTNode anchor2, boolean before) {
            super(XmlTagImpl.this);
            this.myChild = child;
            this.myAnchor = anchor2;
            this.myBefore = before;
        }

        public PomModelEvent runInner() {
            this.myRetHolder = XmlTagImpl.super.addInternal(this.myChild, this.myChild, this.myAnchor, this.myBefore);
            return null;
        }

        @Override
        public TreeElement getFirstInserted() {
            return this.myRetHolder;
        }
    }

    protected class InsertAttributeTransaction
    extends InsertTransaction {
        private final TreeElement myChild;
        private final ASTNode myAnchor;
        private final boolean myBefore;
        private final PomModel myModel;
        private TreeElement myFirstInserted;

        public InsertAttributeTransaction(TreeElement child, ASTNode anchor2, boolean before, PomModel model) {
            super(XmlTagImpl.this);
            this.myChild = child;
            this.myAnchor = anchor2;
            this.myBefore = before;
            this.myModel = model;
        }

        public PomModelEvent runInner() {
            String value = ((XmlAttribute)this.myChild).getValue();
            String name = ((XmlAttribute)this.myChild).getName();
            if (this.myAnchor == null) {
                TreeElement anchor2;
                ASTNode startTagEnd = XmlChildRole.START_TAG_END_FINDER.findChild(XmlTagImpl.this);
                if (startTagEnd == null) {
                    startTagEnd = XmlChildRole.EMPTY_TAG_END_FINDER.findChild(XmlTagImpl.this);
                }
                if (startTagEnd == null) {
                    anchor2 = XmlTagImpl.this.getLastChildNode();
                    while (anchor2 instanceof PsiWhiteSpace) {
                        anchor2 = anchor2.getTreePrev();
                    }
                    if (anchor2 instanceof PsiErrorElement) {
                        LeafElement token = Factory.createSingleLeafElement(XmlTokenType.XML_EMPTY_ELEMENT_END, "/>", 0, 2, SharedImplUtil.findCharTableByTree(anchor2), XmlTagImpl.this.getManager());
                        XmlTagImpl.this.replaceChild(anchor2, token);
                        startTagEnd = token;
                    }
                }
                if (startTagEnd == null) {
                    anchor2 = XmlChildRole.START_TAG_NAME_FINDER.findChild(XmlTagImpl.this);
                    this.myFirstInserted = XmlTagImpl.super.addInternal(this.myChild, this.myChild, anchor2, Boolean.FALSE);
                } else {
                    this.myFirstInserted = XmlTagImpl.super.addInternal(this.myChild, this.myChild, startTagEnd, Boolean.TRUE);
                }
            } else {
                this.myFirstInserted = XmlTagImpl.super.addInternal(this.myChild, this.myChild, this.myAnchor, this.myBefore);
            }
            return XmlAttributeSetImpl.createXmlAttributeSet(this.myModel, XmlTagImpl.this, name, value);
        }

        @Override
        public TreeElement getFirstInserted() {
            return this.myFirstInserted;
        }
    }

    protected class BodyInsertTransaction
    extends InsertTransaction {
        private final TreeElement myChild;
        private ASTNode myNewElement;
        private final XmlElementDescriptor myParentDescriptor;

        public BodyInsertTransaction(TreeElement child) {
            super(XmlTagImpl.this);
            this.myChild = child;
            this.myParentDescriptor = this.myChild.getElementType() == XmlElementType.XML_TAG ? XmlTagImpl.this.getDescriptor() : null;
        }

        public PomModelEvent runInner() throws IncorrectOperationException {
            ASTNode anchor2 = XmlTagImpl.this.expandTag();
            if (this.myChild.getElementType() == XmlElementType.XML_TAG) {
                PsiElement declaration;
                XmlTag[] subTags = XmlTagImpl.this.getSubTags();
                PsiElement psiElement = declaration = this.myParentDescriptor != null ? this.myParentDescriptor.getDeclaration() : null;
                if (declaration != null && declaration.getContainingFile() != null && declaration.getContainingFile().isPhysical() && subTags.length > 0) {
                    XmlElementDescriptor[] childElementDescriptors = this.myParentDescriptor.getElementsDescriptors((XmlTag)XmlTagImpl.this);
                    int subTagNum = -1;
                    for (XmlElementDescriptor childElementDescriptor : childElementDescriptors) {
                        String childElementName = childElementDescriptor.getName();
                        while (subTagNum < subTags.length - 1 && subTags[subTagNum + 1].getName().equals(childElementName)) {
                            ++subTagNum;
                        }
                        if (!childElementName.equals(XmlChildRole.START_TAG_NAME_FINDER.findChild(this.myChild).getText())) continue;
                        if (subTagNum >= 0) {
                            ASTNode subTag = (ASTNode)subTags[subTagNum];
                            if (subTag.getTreeParent() != XmlTagImpl.this) {
                                XmlEntityRef entityRef = (XmlEntityRef)PsiTreeUtil.getParentOfType((PsiElement)subTags[subTagNum], XmlEntityRef.class);
                                throw new IncorrectOperationException("Can't insert subtag to the entity. Entity reference text: " + (entityRef == null ? "" : entityRef.getText()));
                            }
                            this.myNewElement = XmlTagImpl.super.addInternal(this.myChild, this.myChild, subTag, Boolean.FALSE);
                        } else {
                            ASTNode child = XmlChildRole.START_TAG_END_FINDER.findChild(XmlTagImpl.this);
                            this.myNewElement = XmlTagImpl.super.addInternal(this.myChild, this.myChild, child, Boolean.FALSE);
                        }
                        return null;
                    }
                } else {
                    ASTNode child = XmlChildRole.CLOSING_TAG_START_FINDER.findChild(XmlTagImpl.this);
                    this.myNewElement = XmlTagImpl.super.addInternal(this.myChild, this.myChild, child, Boolean.TRUE);
                    return null;
                }
            }
            this.myNewElement = XmlTagImpl.super.addInternal(this.myChild, this.myChild, anchor2, Boolean.TRUE);
            return null;
        }

        @Override
        public TreeElement getFirstInserted() {
            return (TreeElement)this.myNewElement;
        }
    }
}

