/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.LogUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.ObjectStubSerializer;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.SerializerNotFoundException;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.stubs.StubSerializationUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.RecentStringInterner;
import com.intellij.util.io.AbstractStringEnumerator;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.IOUtil;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectIntHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StubSerializationHelper {
    private final AbstractStringEnumerator myNameStorage;
    protected final TIntObjectHashMap<ObjectStubSerializer> myIdToSerializer;
    protected final TObjectIntHashMap<ObjectStubSerializer> mySerializerToId;
    private final RecentStringInterner myStringInterner;
    private static final ThreadLocal<ObjectStubSerializer> ourRootStubSerializer = new ThreadLocal();

    public StubSerializationHelper(@NotNull AbstractStringEnumerator nameStorage, @NotNull Disposable parentDisposable) {
        if (nameStorage == null) {
            StubSerializationHelper.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            StubSerializationHelper.$$$reportNull$$$0(1);
        }
        this.myIdToSerializer = new TIntObjectHashMap();
        this.mySerializerToId = new TObjectIntHashMap();
        this.myNameStorage = nameStorage;
        this.myStringInterner = new RecentStringInterner(parentDisposable);
    }

    public void assignId(@NotNull ObjectStubSerializer serializer) throws IOException {
        if (serializer == null) {
            StubSerializationHelper.$$$reportNull$$$0(2);
        }
        int id = this.persistentId(serializer);
        ObjectStubSerializer old = (ObjectStubSerializer)this.myIdToSerializer.put(id, (Object)serializer);
        assert (old == null) : "ID: " + serializer.getExternalId() + " is not unique; Already registered serializer with this ID: " + old.getClass().getName();
        int oldId = this.mySerializerToId.put((Object)serializer, id);
        assert (oldId == 0) : "Serializer " + serializer + " is already registered; Old ID:" + oldId;
    }

    private int persistentId(@NotNull ObjectStubSerializer serializer) throws IOException {
        if (serializer == null) {
            StubSerializationHelper.$$$reportNull$$$0(3);
        }
        return this.myNameStorage.enumerate((Object)serializer.getExternalId());
    }

    private void doSerialize(@NotNull Stub rootStub, @NotNull StubOutputStream stream) throws IOException {
        if (rootStub == null) {
            StubSerializationHelper.$$$reportNull$$$0(4);
        }
        if (stream == null) {
            StubSerializationHelper.$$$reportNull$$$0(5);
        }
        ObjectStubSerializer serializer = StubSerializationUtil.getSerializer((Stub)rootStub);
        if (((ObjectStubBase)rootStub).isDangling()) {
            stream.writeByte(0);
        }
        DataInputOutputUtil.writeINT((DataOutput)stream, (int)this.getClassId(serializer));
        serializer.serialize(rootStub, stream);
        List children2 = rootStub.getChildrenStubs();
        int childrenSize = children2.size();
        DataInputOutputUtil.writeINT((DataOutput)stream, (int)childrenSize);
        for (int i = 0; i < childrenSize; ++i) {
            this.doSerialize((Stub)children2.get(i), stream);
        }
    }

    public void serialize(@NotNull Stub rootStub, @NotNull OutputStream stream) throws IOException {
        if (rootStub == null) {
            StubSerializationHelper.$$$reportNull$$$0(6);
        }
        if (stream == null) {
            StubSerializationHelper.$$$reportNull$$$0(7);
        }
        BufferExposingByteArrayOutputStream out = new BufferExposingByteArrayOutputStream();
        FileLocalStringEnumerator storage2 = new FileLocalStringEnumerator(true);
        StubOutputStream stubOutputStream = new StubOutputStream((OutputStream)out, (AbstractStringEnumerator)storage2);
        boolean doDefaultSerialization = true;
        if (rootStub instanceof PsiFileStubImpl) {
            PsiFileStub[] roots = ((PsiFileStubImpl)rootStub).getStubRoots();
            if (roots.length == 0) {
                Logger.getInstance(this.getClass()).error("Incorrect stub files count during serialization:" + rootStub + "," + rootStub.getStubType());
            } else {
                doDefaultSerialization = false;
                DataInputOutputUtil.writeINT((DataOutput)stubOutputStream, (int)roots.length);
                for (PsiFileStub root : roots) {
                    this.doSerialize((Stub)root, stubOutputStream);
                }
            }
        }
        if (doDefaultSerialization) {
            DataInputOutputUtil.writeINT((DataOutput)stubOutputStream, (int)1);
            this.doSerialize(rootStub, stubOutputStream);
        }
        DataOutputStream resultStream = new DataOutputStream(stream);
        DataInputOutputUtil.writeINT((DataOutput)resultStream, (int)storage2.myStrings.size());
        byte[] buffer = IOUtil.allocReadWriteUTFBuffer();
        for (String s : storage2.myStrings) {
            IOUtil.writeUTFFast((byte[])buffer, (DataOutput)resultStream, (String)s);
        }
        resultStream.write(out.getInternalBuffer(), 0, out.size());
    }

    private int getClassId(ObjectStubSerializer serializer) {
        int idValue = this.mySerializerToId.get((Object)serializer);
        if (idValue <= 0) assert (false) : "No ID found for serializer " + LogUtil.objectAndClass((Object)serializer) + ", external id:" + serializer.getExternalId() + (serializer instanceof IElementType ? ", language:" + ((IElementType)serializer).getLanguage() + ", " + serializer : "");
        return idValue;
    }

    @NotNull
    public Stub deserialize(@NotNull InputStream stream) throws IOException, SerializerNotFoundException {
        PsiFileStub[] stubsArray;
        if (stream == null) {
            StubSerializationHelper.$$$reportNull$$$0(8);
        }
        FileLocalStringEnumerator storage2 = new FileLocalStringEnumerator(false);
        StubInputStream inputStream = new StubInputStream(stream, (AbstractStringEnumerator)storage2);
        int numberOfStrings = DataInputOutputUtil.readINT((DataInput)inputStream);
        byte[] buffer = IOUtil.allocReadWriteUTFBuffer();
        storage2.myStrings.ensureCapacity(numberOfStrings);
        for (int i = 0; i < numberOfStrings; ++i) {
            String s = this.myStringInterner.get(IOUtil.readUTFFast((byte[])buffer, (DataInput)inputStream));
            storage2.myStrings.add(s);
        }
        int stubFilesCount = DataInputOutputUtil.readINT((DataInput)inputStream);
        if (stubFilesCount <= 0) {
            Logger.getInstance(this.getClass()).error("Incorrect stub files count during deserialization:" + stubFilesCount);
        }
        Stub baseStub = this.deserialize(inputStream, null);
        ArrayList stubs = ContainerUtil.newArrayListWithCapacity((int)stubFilesCount);
        if (baseStub instanceof PsiFileStub) {
            stubs.add((PsiFileStub)baseStub);
        }
        for (int j = 1; j < stubFilesCount; ++j) {
            Stub deserialize2 = this.deserialize(inputStream, null);
            if (deserialize2 instanceof PsiFileStub) {
                PsiFileStub fileStub = (PsiFileStub)deserialize2;
                stubs.add(fileStub);
                continue;
            }
            Logger.getInstance(this.getClass()).error("Stub root must be PsiFileStub for files with several stub roots");
        }
        for (PsiFileStub stub : stubsArray = stubs.toArray(PsiFileStub.EMPTY_ARRAY)) {
            if (!(stub instanceof PsiFileStubImpl)) continue;
            ((PsiFileStubImpl)stub).setStubRoots(stubsArray);
        }
        Stub stub = baseStub;
        if (stub == null) {
            StubSerializationHelper.$$$reportNull$$$0(9);
        }
        return stub;
    }

    String intern(String str) {
        return this.myStringInterner.get(str);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private Stub deserialize(@NotNull StubInputStream stream, @Nullable Stub parentStub) throws IOException, SerializerNotFoundException {
        ObjectStubSerializer serializer;
        if (stream == null) {
            StubSerializationHelper.$$$reportNull$$$0(10);
        }
        boolean dangling = false;
        int id = DataInputOutputUtil.readINT((DataInput)stream);
        if (id == 0) {
            dangling = true;
            id = DataInputOutputUtil.readINT((DataInput)stream);
        }
        if ((serializer = this.getClassById(id)) == null) {
            String externalId = null;
            try {
                externalId = (String)this.myNameStorage.valueOf(id);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new SerializerNotFoundException("Broken stub format, most likely version of " + ourRootStubSerializer.get() + " was not updated after serialization changes\nInternal details, no serializer registered for stub: ID=" + id + ", externalId:" + externalId + "; parent stub class=" + (parentStub != null ? parentStub.getClass().getName() + ", parent stub type:" + parentStub.getStubType() : "null"));
        }
        Stub stub = serializer.deserialize(stream, parentStub);
        if (dangling) {
            ((ObjectStubBase)stub).markDangling();
        }
        boolean rootStubSerializerWasSet = false;
        if (parentStub == null && ourRootStubSerializer.get() == null) {
            ourRootStubSerializer.set((ObjectStubSerializer)(stub instanceof PsiFileStub ? ((PsiFileStub)stub).getType() : null));
            rootStubSerializerWasSet = true;
        }
        try {
            int childCount = DataInputOutputUtil.readINT((DataInput)stream);
            if (stub instanceof StubBase) {
                ((StubBase)stub).myStubList.prepareForChildren((StubBase)stub, childCount);
            }
            for (int i = 0; i < childCount; ++i) {
                this.deserialize(stream, stub);
            }
        }
        finally {
            if (rootStubSerializerWasSet) {
                ourRootStubSerializer.set(null);
            }
        }
        if (parentStub == null && stub instanceof StubBase) assert (((StubBase)stub).myStubList.isChildrenLayoutOptimal());
        Stub stub2 = stub;
        if (stub2 == null) {
            StubSerializationHelper.$$$reportNull$$$0(11);
        }
        return stub2;
    }

    private ObjectStubSerializer getClassById(int id) {
        return (ObjectStubSerializer)this.myIdToSerializer.get(id);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameStorage";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializer";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootStub";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/stubs/StubSerializationHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/stubs/StubSerializationHelper";
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "assignId";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "persistentId";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doSerialize";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 9: 
            case 11: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FileLocalStringEnumerator
    implements AbstractStringEnumerator {
        private final TObjectIntHashMap<String> myEnumerates;
        private final ArrayList<String> myStrings = new ArrayList();

        FileLocalStringEnumerator(boolean forSavingStub) {
            this.myEnumerates = forSavingStub ? new TObjectIntHashMap() : null;
        }

        public int enumerate(@Nullable String value) {
            if (value == null) {
                return 0;
            }
            assert (this.myEnumerates != null);
            int i = this.myEnumerates.get((Object)value);
            if (i == 0) {
                i = this.myStrings.size() + 1;
                this.myEnumerates.put((Object)value, i);
                this.myStrings.add(value);
            }
            return i;
        }

        public String valueOf(int idx) {
            if (idx == 0) {
                return null;
            }
            return this.myStrings.get(idx - 1);
        }

        public void markCorrupted() {
        }

        public void close() throws IOException {
        }

        public boolean isDirty() {
            return false;
        }

        public void force() {
        }
    }
}

