/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inline;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.lang.Language;
import com.intellij.lang.refactoring.InlineHandler;
import com.intellij.lang.refactoring.InlineHandlers;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.NonCodeUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenericInlineHandler {
    private static final Logger LOG = Logger.getInstance(GenericInlineHandler.class);

    public static boolean invoke(PsiElement element, @Nullable Editor editor, InlineHandler languageSpecific) {
        Collection<Object> allReferences;
        PsiReference invocationReference = editor != null ? TargetElementUtil.findReference(editor) : null;
        InlineHandler.Settings settings = languageSpecific.prepareInlineElement(element, editor, invocationReference != null);
        if (settings == null || settings == InlineHandler.Settings.CANNOT_INLINE_SETTINGS) {
            return settings != null;
        }
        if (settings.isOnlyOneReferenceToInline()) {
            allReferences = Collections.singleton(invocationReference);
        } else {
            Ref usagesRef = new Ref();
            ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> usagesRef.set((Object)ReferencesSearch.search((PsiElement)element).findAll()), "Find Usages", false, element.getProject());
            allReferences = (Collection)usagesRef.get();
        }
        MultiMap conflicts = new MultiMap();
        Map<Language, InlineHandler.Inliner> inliners = GenericInlineHandler.initializeInliners(element, settings, allReferences);
        for (PsiReference psiReference : allReferences) {
            GenericInlineHandler.collectConflicts(psiReference, element, inliners, (MultiMap<PsiElement, String>)conflicts);
        }
        Project project = element.getProject();
        if (!conflicts.isEmpty()) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw new BaseRefactoringProcessor.ConflictsInTestsException(conflicts.values());
            }
            ConflictsDialog conflictsDialog = new ConflictsDialog(project, (MultiMap<PsiElement, String>)conflicts);
            if (!conflictsDialog.showAndGet()) {
                return true;
            }
        }
        HashSet<PsiElement> hashSet = new HashSet<PsiElement>();
        for (PsiReference psiReference : allReferences) {
            PsiElement refElement = psiReference.getElement();
            if (refElement == null) continue;
            hashSet.add(refElement);
        }
        if (!settings.isOnlyOneReferenceToInline()) {
            hashSet.add(element);
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatusRecursively((Project)project, hashSet, (boolean)true)) {
            return true;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            String subj = element instanceof PsiNamedElement ? ((PsiNamedElement)element).getName() : "element";
            CommandProcessor.getInstance().executeCommand(project, () -> {
                PsiReference[] references = GenericInlineHandler.sortDepthFirstRightLeftOrder(allReferences);
                UsageInfo[] usages = new UsageInfo[references.length];
                for (int i = 0; i < references.length; ++i) {
                    usages[i] = new UsageInfo(references[i]);
                }
                for (UsageInfo usage : usages) {
                    GenericInlineHandler.inlineReference(usage, element, inliners);
                }
                if (!settings.isOnlyOneReferenceToInline()) {
                    languageSpecific.removeDefinition(element, settings);
                }
            }, RefactoringBundle.message((String)"inline.command", (Object[])new Object[]{StringUtil.notNullize((String)subj, (String)"<nameless>")}), null);
        });
        return true;
    }

    public static Map<Language, InlineHandler.Inliner> initializeInliners(PsiElement element, InlineHandler.Settings settings, Collection<? extends PsiReference> allReferences) {
        HashMap<Language, InlineHandler.Inliner> inliners = new HashMap<Language, InlineHandler.Inliner>();
        block0: for (PsiReference psiReference : allReferences) {
            if (psiReference == null) {
                LOG.error("element: " + element.getClass() + ", allReferences contains null!");
                continue;
            }
            PsiElement refElement = psiReference.getElement();
            LOG.assertTrue(refElement != null, (Object)psiReference.getClass().getName());
            Language language = refElement.getLanguage();
            if (inliners.containsKey(language)) continue;
            List handlers = InlineHandlers.getInlineHandlers((Language)language);
            for (InlineHandler handler2 : handlers) {
                InlineHandler.Inliner inliner = handler2.createInliner(element, settings);
                if (inliner == null) continue;
                inliners.put(language, inliner);
                continue block0;
            }
        }
        return inliners;
    }

    public static Map<Language, InlineHandler.Inliner> initInliners(PsiElement elementToInline, UsageInfo[] usagesIn, InlineHandler.Settings settings, MultiMap<PsiElement, String> conflicts, Language ... emptyInliners) {
        ArrayList<PsiReference> refs = new ArrayList<PsiReference>();
        for (UsageInfo info : usagesIn) {
            PsiReference[] references;
            PsiElement element;
            if (info instanceof NonCodeUsageInfo || (element = info.getElement()) == null || (references = element.getReferences()).length <= 0) continue;
            refs.add(references[0]);
        }
        Map<Language, InlineHandler.Inliner> inliners = GenericInlineHandler.initializeInliners(elementToInline, settings, refs);
        for (Language language : emptyInliners) {
            inliners.put(language, new InlineHandler.Inliner(){

                @Nullable
                public MultiMap<PsiElement, String> getConflicts(@NotNull PsiReference reference, @NotNull PsiElement referenced) {
                    if (reference == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (referenced == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return null;
                }

                public void inlineUsage(@NotNull UsageInfo usage, @NotNull PsiElement referenced) {
                    if (usage == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if (referenced == null) {
                        1.$$$reportNull$$$0(3);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "reference";
                            break;
                        }
                        case 1: 
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "referenced";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "usage";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/refactoring/inline/GenericInlineHandler$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "getConflicts";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "inlineUsage";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        for (PsiReference ref : refs) {
            GenericInlineHandler.collectConflicts(ref, elementToInline, inliners, conflicts);
        }
        return inliners;
    }

    public static void collectConflicts(PsiReference reference, PsiElement element, Map<Language, InlineHandler.Inliner> inliners, MultiMap<PsiElement, String> conflicts) {
        PsiElement referenceElement = reference.getElement();
        if (referenceElement == null) {
            return;
        }
        Language language = referenceElement.getLanguage();
        InlineHandler.Inliner inliner = inliners.get(language);
        if (inliner != null) {
            MultiMap refConflicts = inliner.getConflicts(reference, element);
            if (refConflicts != null) {
                for (PsiElement psiElement : refConflicts.keySet()) {
                    conflicts.putValues((Object)psiElement, refConflicts.get((Object)psiElement));
                }
            }
        } else {
            conflicts.putValue((Object)referenceElement, (Object)("Cannot inline reference from " + language.getDisplayName()));
        }
    }

    public static void inlineReference(UsageInfo usage, PsiElement element, Map<Language, InlineHandler.Inliner> inliners) {
        PsiElement usageElement = usage.getElement();
        if (usageElement == null) {
            return;
        }
        Language language = usageElement.getLanguage();
        InlineHandler.Inliner inliner = inliners.get(language);
        if (inliner != null) {
            inliner.inlineUsage(usage, element);
        }
    }

    public static PsiReference[] sortDepthFirstRightLeftOrder(Collection<? extends PsiReference> allReferences) {
        PsiReference[] usages = allReferences.toArray(PsiReference.EMPTY_ARRAY);
        Arrays.sort(usages, (usage1, usage2) -> {
            PsiElement element1 = usage1.getElement();
            PsiElement element2 = usage2.getElement();
            if (element1 == null || element2 == null) {
                return 0;
            }
            return element2.getTextRange().getStartOffset() - element1.getTextRange().getStartOffset();
        });
        return usages;
    }
}

