/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.Pair;
import com.intellij.ui.AbstractExpandableItemsHandler;
import com.intellij.ui.AppUIUtil;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ListExpandableItemsHandler
extends AbstractExpandableItemsHandler<Integer, JList> {
    protected ListExpandableItemsHandler(final JList list2) {
        super(list2);
        final ListSelectionListener selectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListExpandableItemsHandler.this.updateSelection(list2);
            }
        };
        list2.getSelectionModel().addListSelectionListener(selectionListener);
        list2.addPropertyChangeListener("selectionModel", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ListExpandableItemsHandler.this.updateSelection(list2);
                if (evt.getOldValue() != null) {
                    ((ListSelectionModel)evt.getOldValue()).removeListSelectionListener(selectionListener);
                }
                if (evt.getNewValue() != null) {
                    ((ListSelectionModel)evt.getNewValue()).addListSelectionListener(selectionListener);
                }
            }
        });
        final ListDataListener modelListener = new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                ListExpandableItemsHandler.this.updateSelection(list2);
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                ListExpandableItemsHandler.this.updateSelection(list2);
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                ListExpandableItemsHandler.this.updateSelection(list2);
            }
        };
        if (list2.getModel() != null) {
            list2.getModel().addListDataListener(modelListener);
        }
        list2.addPropertyChangeListener("model", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ListExpandableItemsHandler.this.updateSelection(list2);
                if (evt.getOldValue() != null) {
                    ((ListModel)evt.getOldValue()).removeListDataListener(modelListener);
                }
                if (evt.getNewValue() != null) {
                    ((ListModel)evt.getNewValue()).addListDataListener(modelListener);
                }
            }
        });
    }

    private void updateSelection(JList list2) {
        int selection = list2.getSelectedIndices().length == 1 ? list2.getSelectedIndex() : -1;
        this.handleSelectionChange(selection == -1 ? null : new Integer(selection));
    }

    @Override
    protected Integer getCellKeyForPoint(Point point) {
        int rowIndex = ((JList)this.myComponent).locationToIndex(point);
        return rowIndex != -1 ? new Integer(rowIndex) : null;
    }

    @Override
    protected Pair<Component, Rectangle> getCellRendererAndBounds(Integer key) {
        int rowIndex = key;
        Rectangle bounds = ((JList)this.myComponent).getCellBounds(rowIndex, rowIndex);
        if (bounds == null) {
            return null;
        }
        ListCellRenderer renderer = ((JList)this.myComponent).getCellRenderer();
        if (renderer == null) {
            return null;
        }
        ListModel model = ((JList)this.myComponent).getModel();
        if (rowIndex >= model.getSize()) {
            return null;
        }
        Component rendererComponent = renderer.getListCellRendererComponent((JList)this.myComponent, model.getElementAt(rowIndex), rowIndex, ((JList)this.myComponent).isSelectedIndex(rowIndex), ((JList)this.myComponent).hasFocus());
        AppUIUtil.targetToDevice(rendererComponent, this.myComponent);
        bounds.width = rendererComponent.getPreferredSize().width;
        return Pair.create((Object)rendererComponent, (Object)bounds);
    }
}

