/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.content.tabs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.ShadowAction;
import com.intellij.ui.UIBundle;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import org.jetbrains.annotations.NotNull;

public abstract class TabbedContentAction
extends AnAction
implements DumbAware {
    protected final ContentManager myManager;
    protected final ShadowAction myShadow;

    protected TabbedContentAction(@NotNull ContentManager manager, @NotNull AnAction shortcutTemplate, @NotNull String text2, @NotNull Disposable parentDisposable) {
        if (manager == null) {
            TabbedContentAction.$$$reportNull$$$0(0);
        }
        if (shortcutTemplate == null) {
            TabbedContentAction.$$$reportNull$$$0(1);
        }
        if (text2 == null) {
            TabbedContentAction.$$$reportNull$$$0(2);
        }
        if (parentDisposable == null) {
            TabbedContentAction.$$$reportNull$$$0(3);
        }
        super(text2);
        this.myManager = manager;
        this.myShadow = new ShadowAction((AnAction)this, shortcutTemplate, manager.getComponent(), new Presentation(text2), parentDisposable);
    }

    protected TabbedContentAction(@NotNull ContentManager manager, @NotNull AnAction template, @NotNull Disposable parentDisposable) {
        if (manager == null) {
            TabbedContentAction.$$$reportNull$$$0(4);
        }
        if (template == null) {
            TabbedContentAction.$$$reportNull$$$0(5);
        }
        if (parentDisposable == null) {
            TabbedContentAction.$$$reportNull$$$0(6);
        }
        this.myManager = manager;
        this.myShadow = new ShadowAction((AnAction)this, template, manager.getComponent(), parentDisposable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "shortcutTemplate";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "text";
                break;
            }
            case 3: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[0] = "parentDisposable";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[0] = "template";
                break;
            }
        }
        objectArray[1] = "com/intellij/ui/content/tabs/TabbedContentAction";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class MyPreviousTabAction
    extends TabbedContentAction {
        public MyPreviousTabAction(ContentManager manager) {
            super(manager, ActionManager.getInstance().getAction("PreviousTab"), (Disposable)manager);
        }

        public void actionPerformed(AnActionEvent e) {
            this.myManager.selectPreviousContent();
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabledAndVisible(this.myManager.getContentCount() > 1);
            e.getPresentation().setText(this.myManager.getPreviousContentActionName());
        }
    }

    public static class MyNextTabAction
    extends TabbedContentAction {
        public MyNextTabAction(ContentManager manager) {
            super(manager, ActionManager.getInstance().getAction("NextTab"), (Disposable)manager);
        }

        public void actionPerformed(AnActionEvent e) {
            this.myManager.selectNextContent();
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabledAndVisible(this.myManager.getContentCount() > 1);
            e.getPresentation().setText(this.myManager.getNextContentActionName());
        }
    }

    public static class CloseAllAction
    extends TabbedContentAction {
        public CloseAllAction(ContentManager manager) {
            super(manager, ActionManager.getInstance().getAction("CloseAllEditors"), UIBundle.message((String)"tabbed.pane.close.all.action.name", (Object[])new Object[0]), (Disposable)manager);
        }

        public void actionPerformed(AnActionEvent e) {
            Content[] contents;
            for (Content content : contents = this.myManager.getContents()) {
                if (!content.isCloseable()) continue;
                this.myManager.removeContent(content, true);
            }
        }

        public void update(AnActionEvent e) {
            Presentation presentation = e.getPresentation();
            presentation.setEnabledAndVisible(this.myManager.getContentCount() > 1 && this.myManager.canCloseAllContents());
        }
    }

    public static class CloseAllButThisAction
    extends ForContent {
        public CloseAllButThisAction(@NotNull Content content) {
            if (content == null) {
                CloseAllButThisAction.$$$reportNull$$$0(0);
            }
            super(content, ActionManager.getInstance().getAction("CloseAllEditorsButActive"), UIBundle.message((String)"tabbed.pane.close.all.but.this.action.name", (Object[])new Object[0]));
        }

        public void actionPerformed(AnActionEvent e) {
            Content[] contents;
            for (Content content : contents = this.myManager.getContents()) {
                if (this.myContent == content || !content.isCloseable()) continue;
                this.myManager.removeContent(content, true);
            }
            this.myManager.setSelectedContent(this.myContent);
        }

        @Override
        public void update(AnActionEvent e) {
            Presentation presentation = e.getPresentation();
            presentation.setText(this.myManager.getCloseAllButThisActionName());
            presentation.setEnabledAndVisible(this.myManager.canCloseContents() && this.hasOtherCloseableContents());
        }

        private boolean hasOtherCloseableContents() {
            Content[] contents;
            for (Content content : contents = this.myManager.getContents()) {
                if (this.myContent == content || !content.isCloseable()) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ui/content/tabs/TabbedContentAction$CloseAllButThisAction", "<init>"));
        }
    }

    public static class CloseAction
    extends ForContent {
        public CloseAction(@NotNull Content content) {
            if (content == null) {
                CloseAction.$$$reportNull$$$0(0);
            }
            super(content, ActionManager.getInstance().getAction("CloseActiveTab"));
        }

        public void actionPerformed(AnActionEvent e) {
            this.myManager.removeContent(this.myContent, true);
        }

        @Override
        public void update(AnActionEvent e) {
            Presentation presentation = e.getPresentation();
            presentation.setEnabledAndVisible(this.myManager.canCloseContents() && this.myContent.isCloseable());
            presentation.setText(this.myManager.getCloseActionName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ui/content/tabs/TabbedContentAction$CloseAction", "<init>"));
        }
    }

    public static abstract class ForContent
    extends TabbedContentAction {
        protected final Content myContent;

        public ForContent(@NotNull Content content, @NotNull AnAction shortcutTemplate, String text2) {
            if (content == null) {
                ForContent.$$$reportNull$$$0(0);
            }
            if (shortcutTemplate == null) {
                ForContent.$$$reportNull$$$0(1);
            }
            super(content.getManager(), shortcutTemplate, text2, (Disposable)content);
            this.myContent = content;
        }

        public ForContent(@NotNull Content content, AnAction template) {
            if (content == null) {
                ForContent.$$$reportNull$$$0(2);
            }
            super(content.getManager(), template, (Disposable)content);
            this.myContent = content;
        }

        public void update(AnActionEvent e) {
            super.update(e);
            e.getPresentation().setEnabled(this.myManager.getIndexOfContent(this.myContent) >= 0);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "content";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "shortcutTemplate";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ui/content/tabs/TabbedContentAction$ForContent";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

