/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.highlighting;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.NotNull;

public class DefineAttributeQuickFix
implements LocalQuickFix {
    private final String myAttrName;
    private final String myNamespace;

    public DefineAttributeQuickFix(String attrName) {
        this(attrName, "");
    }

    public DefineAttributeQuickFix(@NotNull String attrName, @NotNull String namespace) {
        if (attrName == null) {
            DefineAttributeQuickFix.$$$reportNull$$$0(0);
        }
        if (namespace == null) {
            DefineAttributeQuickFix.$$$reportNull$$$0(1);
        }
        this.myAttrName = attrName;
        this.myNamespace = namespace;
    }

    @NotNull
    public String getName() {
        String string = "Define " + this.myAttrName + " attribute";
        if (string == null) {
            DefineAttributeQuickFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("Define attribute" == null) {
            DefineAttributeQuickFix.$$$reportNull$$$0(3);
        }
        return "Define attribute";
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        if (project == null) {
            DefineAttributeQuickFix.$$$reportNull$$$0(4);
        }
        if (descriptor2 == null) {
            DefineAttributeQuickFix.$$$reportNull$$$0(5);
        }
        XmlTag tag = (XmlTag)descriptor2.getPsiElement();
        XmlAttribute attribute = tag.setAttribute(this.myAttrName, this.myNamespace, "");
        new OpenFileDescriptor(project, tag.getContainingFile().getVirtualFile(), attribute.getValueElement().getTextRange().getStartOffset() + 1).navigate(true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/highlighting/DefineAttributeQuickFix";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/highlighting/DefineAttributeQuickFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

