/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.LightColors;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.extension.SchemaType;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonSchemaServiceImpl;
import com.jetbrains.jsonSchema.settings.mappings.JsonSchemaMappingsConfigurable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaConflictNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"json.schema.conflict.notification.panel");
    @NotNull
    private final Project myProject;
    @NotNull
    private final JsonSchemaService myJsonSchemaService;

    public JsonSchemaConflictNotificationProvider(@NotNull Project project, @NotNull JsonSchemaService jsonSchemaService) {
        if (project == null) {
            JsonSchemaConflictNotificationProvider.$$$reportNull$$$0(0);
        }
        if (jsonSchemaService == null) {
            JsonSchemaConflictNotificationProvider.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myJsonSchemaService = jsonSchemaService;
    }

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key<EditorNotificationPanel> key = KEY;
        if (key == null) {
            JsonSchemaConflictNotificationProvider.$$$reportNull$$$0(2);
        }
        return key;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file2, @NotNull FileEditor fileEditor) {
        if (file2 == null) {
            JsonSchemaConflictNotificationProvider.$$$reportNull$$$0(3);
        }
        if (fileEditor == null) {
            JsonSchemaConflictNotificationProvider.$$$reportNull$$$0(4);
        }
        if (!this.myJsonSchemaService.isApplicableToFile(file2)) {
            return null;
        }
        ArrayList schemaFiles = ContainerUtil.newArrayList();
        if (!this.hasConflicts(schemaFiles, file2)) {
            return null;
        }
        String message = JsonSchemaConflictNotificationProvider.createMessage(schemaFiles, this.myJsonSchemaService, "; ", "<html>There are several JSON Schemas mapped to this file: ", "</html>");
        if (message == null) {
            return null;
        }
        EditorNotificationPanel panel2 = new EditorNotificationPanel(LightColors.RED);
        panel2.setText(message);
        panel2.createActionLabel("Edit JSON Schema Mappings", () -> {
            if (file2 == null) {
                JsonSchemaConflictNotificationProvider.$$$reportNull$$$0(13);
            }
            ShowSettingsUtil.getInstance().editConfigurable(this.myProject, (Configurable)new JsonSchemaMappingsConfigurable(this.myProject));
            EditorNotifications.getInstance((Project)this.myProject).updateNotifications(file2);
        });
        return panel2;
    }

    private boolean hasConflicts(@NotNull Collection<VirtualFile> files2, @NotNull VirtualFile file2) {
        if (files2 == null) {
            JsonSchemaConflictNotificationProvider.$$$reportNull$$$0(5);
        }
        if (file2 == null) {
            JsonSchemaConflictNotificationProvider.$$$reportNull$$$0(6);
        }
        List<JsonSchemaFileProvider> providers = ((JsonSchemaServiceImpl)this.myJsonSchemaService).getProvidersForFile(file2);
        for (JsonSchemaFileProvider provider : providers) {
            VirtualFile schemaFile;
            if (provider.getSchemaType() != SchemaType.userSchema || (schemaFile = provider.getSchemaFile()) == null) continue;
            files2.add(schemaFile);
        }
        return files2.size() > 1;
    }

    public static String createMessage(@NotNull Collection<VirtualFile> schemaFiles, @NotNull JsonSchemaService jsonSchemaService, @NotNull String separator, @NotNull String prefix, @NotNull String suffix) {
        if (schemaFiles == null) {
            JsonSchemaConflictNotificationProvider.$$$reportNull$$$0(7);
        }
        if (jsonSchemaService == null) {
            JsonSchemaConflictNotificationProvider.$$$reportNull$$$0(8);
        }
        if (separator == null) {
            JsonSchemaConflictNotificationProvider.$$$reportNull$$$0(9);
        }
        if (prefix == null) {
            JsonSchemaConflictNotificationProvider.$$$reportNull$$$0(10);
        }
        if (suffix == null) {
            JsonSchemaConflictNotificationProvider.$$$reportNull$$$0(11);
        }
        List pairList = schemaFiles.stream().map(file2 -> {
            if (jsonSchemaService == null) {
                JsonSchemaConflictNotificationProvider.$$$reportNull$$$0(12);
            }
            return jsonSchemaService.getSchemaProvider((VirtualFile)file2);
        }).filter(Objects::nonNull).map(provider -> Pair.create((Object)SchemaType.userSchema.equals((Object)provider.getSchemaType()), (Object)provider.getName())).collect(Collectors.toList());
        long numOfSystemSchemas = pairList.stream().filter(pair -> (Boolean)pair.getFirst() == false).count();
        if (pairList.size() == 2 && numOfSystemSchemas == 1L) {
            return null;
        }
        boolean withTypes = numOfSystemSchemas > 0L;
        return pairList.stream().map(pair -> {
            if (withTypes) {
                return String.format("%s schema '%s'", Boolean.TRUE.equals(pair.getFirst()) ? "user" : "system", pair.getSecond());
            }
            return (String)pair.getSecond();
        }).collect(Collectors.joining(separator, prefix, suffix));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsonSchemaService";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/impl/JsonSchemaConflictNotificationProvider";
                break;
            }
            case 3: 
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemaFiles";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaConflictNotificationProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createNotificationPanel";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "hasConflicts";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createMessage";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createMessage$1";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createNotificationPanel$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

