/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaResolver;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import com.jetbrains.jsonSchema.impl.JsonSchemaVariantsTreeBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaDocumentationProvider
implements DocumentationProvider {
    @Nullable
    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        return JsonSchemaDocumentationProvider.findSchemaAndGenerateDoc(element, originalElement, true);
    }

    @Nullable
    public List<String> getUrlFor(PsiElement element, PsiElement originalElement) {
        return null;
    }

    @Nullable
    public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        return JsonSchemaDocumentationProvider.findSchemaAndGenerateDoc(element, originalElement, false);
    }

    @Nullable
    public static String findSchemaAndGenerateDoc(PsiElement element, @Nullable PsiElement originalElement, boolean preferShort) {
        VirtualFile virtualFile;
        PsiFile containingFile = (element = (PsiElement)ObjectUtils.coalesce((Object)originalElement, (Object)element)).getContainingFile();
        if (containingFile == null) {
            return null;
        }
        JsonSchemaService service2 = JsonSchemaService.Impl.get(element.getProject());
        if (!service2.isApplicableToFile(virtualFile = containingFile.getViewProvider().getVirtualFile())) {
            return null;
        }
        JsonSchemaObject rootSchema = service2.getSchemaObject(virtualFile);
        if (rootSchema == null) {
            return null;
        }
        return JsonSchemaDocumentationProvider.generateDoc(element, rootSchema, preferShort);
    }

    @Nullable
    public static String generateDoc(@NotNull PsiElement element, @NotNull JsonSchemaObject rootSchema, boolean preferShort) {
        JsonLikePsiWalker walker;
        if (element == null) {
            JsonSchemaDocumentationProvider.$$$reportNull$$$0(0);
        }
        if (rootSchema == null) {
            JsonSchemaDocumentationProvider.$$$reportNull$$$0(1);
        }
        if ((walker = JsonLikePsiWalker.getWalker(element, rootSchema)) == null) {
            return null;
        }
        PsiElement checkable = walker.goUpToCheckable(element);
        if (checkable == null) {
            return null;
        }
        List<JsonSchemaVariantsTreeBuilder.Step> position = walker.findPosition(checkable, true);
        if (position == null) {
            return null;
        }
        Collection<JsonSchemaObject> schemas = new JsonSchemaResolver(rootSchema, true, position).resolve();
        String htmlDescription = null;
        ArrayList possibleTypes = ContainerUtil.newArrayList();
        for (JsonSchemaObject schema : schemas) {
            if (htmlDescription == null) {
                htmlDescription = JsonSchemaDocumentationProvider.getBestDocumentation(preferShort, schema);
            }
            if (schema.getType() != null && schema.getType() != JsonSchemaType._any) {
                possibleTypes.add(schema.getType());
                continue;
            }
            if (schema.getTypeVariants() == null) continue;
            possibleTypes.addAll(schema.getTypeVariants());
        }
        return htmlDescription == null ? null : JsonSchemaDocumentationProvider.appendNameTypeAndApi(position, JsonSchemaDocumentationProvider.getThirdPartyApiInfo(element, rootSchema), possibleTypes, htmlDescription);
    }

    @NotNull
    private static String appendNameTypeAndApi(@NotNull List<JsonSchemaVariantsTreeBuilder.Step> position, @NotNull String apiInfo, @NotNull List<JsonSchemaType> possibleTypes, @NotNull String htmlDescription) {
        if (position == null) {
            JsonSchemaDocumentationProvider.$$$reportNull$$$0(2);
        }
        if (apiInfo == null) {
            JsonSchemaDocumentationProvider.$$$reportNull$$$0(3);
        }
        if (possibleTypes == null) {
            JsonSchemaDocumentationProvider.$$$reportNull$$$0(4);
        }
        if (htmlDescription == null) {
            JsonSchemaDocumentationProvider.$$$reportNull$$$0(5);
        }
        if (position.size() == 0) {
            String string = htmlDescription;
            if (string == null) {
                JsonSchemaDocumentationProvider.$$$reportNull$$$0(6);
            }
            return string;
        }
        JsonSchemaVariantsTreeBuilder.Step lastStep = position.get(position.size() - 1);
        String name = lastStep.getName();
        if (name == null) {
            String string = htmlDescription;
            if (string == null) {
                JsonSchemaDocumentationProvider.$$$reportNull$$$0(7);
            }
            return string;
        }
        String type = "";
        String schemaType = JsonSchemaObject.getTypesDescription(false, possibleTypes);
        if (schemaType != null) {
            type = ": " + schemaType;
        }
        String string = htmlDescription = "<b>" + name + "</b>" + type + apiInfo + "<br/><br/>" + htmlDescription;
        if (string == null) {
            JsonSchemaDocumentationProvider.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    private static String getThirdPartyApiInfo(@NotNull PsiElement element, @NotNull JsonSchemaObject rootSchema) {
        String information;
        if (element == null) {
            JsonSchemaDocumentationProvider.$$$reportNull$$$0(9);
        }
        if (rootSchema == null) {
            JsonSchemaDocumentationProvider.$$$reportNull$$$0(10);
        }
        JsonSchemaService service2 = JsonSchemaService.Impl.get(element.getProject());
        String apiInfo = "";
        JsonSchemaFileProvider provider = service2.getSchemaProvider(rootSchema.getSchemaFile());
        if (provider != null && (information = provider.getThirdPartyApiInformation()) != null) {
            apiInfo = "&nbsp;&nbsp;<i>(" + information + ")</i>";
        }
        String string = apiInfo;
        if (string == null) {
            JsonSchemaDocumentationProvider.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Nullable
    public static String getBestDocumentation(boolean preferShort, @NotNull JsonSchemaObject schema) {
        if (schema == null) {
            JsonSchemaDocumentationProvider.$$$reportNull$$$0(12);
        }
        String htmlDescription = schema.getHtmlDescription();
        String description = schema.getDescription();
        String title = schema.getTitle();
        if (preferShort && !StringUtil.isEmptyOrSpaces((String)title)) {
            return JsonSchemaDocumentationProvider.plainTextPostProcess(title);
        }
        if (!StringUtil.isEmptyOrSpaces((String)htmlDescription)) {
            return htmlDescription;
        }
        if (!StringUtil.isEmptyOrSpaces((String)description)) {
            return JsonSchemaDocumentationProvider.plainTextPostProcess(description);
        }
        return null;
    }

    @NotNull
    private static String plainTextPostProcess(String text2) {
        String string = StringUtil.escapeXml((String)text2).replace("\\n", "<br/>");
        if (string == null) {
            JsonSchemaDocumentationProvider.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Nullable
    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element) {
        return null;
    }

    @Nullable
    public PsiElement getDocumentationElementForLink(PsiManager psiManager, String link, PsiElement context) {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootSchema";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "apiInfo";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibleTypes";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "htmlDescription";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/impl/JsonSchemaDocumentationProvider";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaDocumentationProvider";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "appendNameTypeAndApi";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getThirdPartyApiInfo";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "plainTextPostProcess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "generateDoc";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "appendNameTypeAndApi";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 13: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getThirdPartyApiInfo";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getBestDocumentation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

