/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.actions.SendFeedbackAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.ui.LicensingFacade;
import org.jetbrains.annotations.Nullable;

public class ReportProblemAction
extends AnAction
implements DumbAware {
    public void actionPerformed(AnActionEvent e) {
        ReportProblemAction.launchBrowser(e.getProject());
    }

    public static void launchBrowser(@Nullable Project project) {
        ApplicationInfoEx appInfo = ApplicationInfoEx.getInstanceEx();
        boolean eap = appInfo.isEAP();
        String urlTemplate = appInfo.getEAPFeedbackUrl();
        urlTemplate = urlTemplate.replace("$BUILD", eap ? appInfo.getBuild().asStringWithoutProductCode() : appInfo.getBuild().asString()).replace("$TIMEZONE", System.getProperty("user.timezone")).replace("$EVAL", ReportProblemAction.isEvaluationLicense() ? "true" : "false").replace("$DESCR", SendFeedbackAction.getDescription());
        BrowserUtil.browse((String)urlTemplate, (Project)project);
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setEnabled(ApplicationInfoEx.getInstanceEx() != null);
    }

    private static boolean isEvaluationLicense() {
        LicensingFacade la = LicensingFacade.getInstance();
        return la != null && la.isEvaluationLicense();
    }
}

