/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.controlflow;

import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.codeInsight.controlflow.InstructionTypeCallback;
import com.jetbrains.python.codeInsight.typing.PyTypingTypeProvider;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyConditionalExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyIfPart;
import com.jetbrains.python.psi.PyNoneLiteralExpression;
import com.jetbrains.python.psi.PyPrefixExpression;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.impl.PyEvaluator;
import com.jetbrains.python.psi.types.PyInstantiableType;
import com.jetbrains.python.psi.types.PyNoneType;
import com.jetbrains.python.psi.types.PyStructuralType;
import com.jetbrains.python.psi.types.PyTupleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Stack;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyTypeAssertionEvaluator
extends PyRecursiveElementVisitor {
    private final Stack<Assertion> myStack = new Stack();
    private boolean myPositive;

    public PyTypeAssertionEvaluator() {
        this(true);
    }

    public PyTypeAssertionEvaluator(boolean positive) {
        this.myPositive = positive;
    }

    public List<Assertion> getDefinitions() {
        return this.myStack;
    }

    @Override
    public void visitPyPrefixExpression(PyPrefixExpression node) {
        if (node.getOperator() == PyTokenTypes.NOT_KEYWORD) {
            this.myPositive = !this.myPositive;
            super.visitPyPrefixExpression(node);
            this.myPositive = !this.myPositive;
        } else {
            super.visitPyPrefixExpression(node);
        }
    }

    @Override
    public void visitPyCallExpression(PyCallExpression node) {
        PyExpression[] args;
        if (node.isCalleeText("isinstance", "assertIsInstance")) {
            PyExpression[] args2 = node.getArguments();
            if (args2.length == 2 && args2[0] instanceof PyReferenceExpression) {
                PyReferenceExpression target2 = (PyReferenceExpression)args2[0];
                PyExpression typeElement = args2[1];
                this.pushAssertion(target2, this.myPositive, false, context -> context.getType(typeElement));
            }
        } else if (node.isCalleeText("callable")) {
            PyExpression[] args3 = node.getArguments();
            if (args3.length == 1 && args3[0] instanceof PyReferenceExpression) {
                PyReferenceExpression target3 = (PyReferenceExpression)args3[0];
                this.pushAssertion(target3, this.myPositive, false, context -> PyTypingTypeProvider.createTypingCallableType((PsiElement)node));
            }
        } else if (node.isCalleeText("issubclass") && (args = node.getArguments()).length == 2 && args[0] instanceof PyReferenceExpression) {
            PyReferenceExpression target4 = (PyReferenceExpression)args[0];
            PyExpression typeElement = args[1];
            this.pushAssertion(target4, this.myPositive, true, context -> context.getType(typeElement));
        }
    }

    @Override
    public void visitPyReferenceExpression(PyReferenceExpression node) {
        if (this.myPositive && (PyTypeAssertionEvaluator.isIfReferenceStatement(node) || PyTypeAssertionEvaluator.isIfReferenceConditionalStatement(node) || PyTypeAssertionEvaluator.isIfNotReferenceStatement(node))) {
            this.pushAssertion(node, !this.myPositive, false, context -> PyNoneType.INSTANCE);
            return;
        }
        super.visitPyReferenceExpression(node);
    }

    @Override
    public void visitPyBinaryExpression(PyBinaryExpression node) {
        PyExpression lhs = node.getLeftExpression();
        PyExpression rhs = node.getRightExpression();
        if (lhs instanceof PyReferenceExpression && rhs instanceof PyReferenceExpression || lhs instanceof PyReferenceExpression && rhs instanceof PyNoneLiteralExpression || lhs instanceof PyNoneLiteralExpression && rhs instanceof PyReferenceExpression) {
            boolean rightIsNone;
            boolean leftIsNone = lhs instanceof PyNoneLiteralExpression || "None".equals(lhs.getName());
            boolean bl = rightIsNone = rhs instanceof PyNoneLiteralExpression || "None".equals(rhs.getName());
            if (leftIsNone ^ rightIsNone) {
                PyReferenceExpression target2 = (PyReferenceExpression)(rightIsNone ? lhs : rhs);
                if (node.isOperator("is")) {
                    this.pushAssertion(target2, this.myPositive, false, context -> PyNoneType.INSTANCE);
                    return;
                }
                if (node.isOperator("isnot")) {
                    this.pushAssertion(target2, !this.myPositive, false, context -> PyNoneType.INSTANCE);
                    return;
                }
            }
        }
        Object leftValue = PyEvaluator.evaluateNoResolve(lhs, Object.class);
        Object rightValue = PyEvaluator.evaluateNoResolve(rhs, Object.class);
        if (leftValue instanceof Boolean && rightValue instanceof Boolean) {
            return;
        }
        if (node.isOperator("is") && (leftValue == Boolean.FALSE || rightValue == Boolean.FALSE) || node.isOperator("isnot") && (leftValue == Boolean.TRUE || rightValue == Boolean.TRUE)) {
            this.myPositive = !this.myPositive;
            super.visitPyBinaryExpression(node);
            this.myPositive = !this.myPositive;
            return;
        }
        super.visitPyBinaryExpression(node);
    }

    @Nullable
    private static Ref<PyType> createAssertionType(@Nullable PyType initial, @Nullable PyType suggested, boolean positive, boolean transformToDefinition, @NotNull TypeEvalContext context) {
        if (context == null) {
            PyTypeAssertionEvaluator.$$$reportNull$$$0(0);
        }
        PyType transformedType = PyTypeAssertionEvaluator.transformTypeFromAssertion(suggested, transformToDefinition);
        if (positive) {
            if (!(initial instanceof PyUnionType) && !(initial instanceof PyStructuralType) && !PyTypeChecker.isUnknown(initial, context) && PyTypeChecker.match(transformedType, initial, context)) {
                return Ref.create((Object)initial);
            }
            return Ref.create((Object)transformedType);
        }
        if (initial instanceof PyUnionType) {
            return Ref.create((Object)((PyUnionType)initial).exclude(transformedType, context));
        }
        if (!(initial instanceof PyStructuralType) && !PyTypeChecker.isUnknown(initial, context) && PyTypeChecker.match(transformedType, initial, context)) {
            return null;
        }
        return Ref.create((Object)initial);
    }

    @Nullable
    private static PyType transformTypeFromAssertion(@Nullable PyType type, boolean transformToDefinition) {
        if (type instanceof PyTupleType) {
            ArrayList<PyType> members = new ArrayList<PyType>();
            PyTupleType tupleType = (PyTupleType)type;
            int count = tupleType.getElementCount();
            for (int i = 0; i < count; ++i) {
                members.add(PyTypeAssertionEvaluator.transformTypeFromAssertion(tupleType.getElementType(i), transformToDefinition));
            }
            return PyUnionType.union(members);
        }
        if (type instanceof PyUnionType) {
            Collection<PyType> members = ((PyUnionType)type).getMembers();
            return PyUnionType.union(ContainerUtil.map(members, member -> PyTypeAssertionEvaluator.transformTypeFromAssertion(member, transformToDefinition)));
        }
        if (type instanceof PyInstantiableType) {
            PyInstantiableType instantiableType = (PyInstantiableType)type;
            return transformToDefinition ? instantiableType.toClass() : instantiableType.toInstance();
        }
        return type;
    }

    private void pushAssertion(final @NotNull PyReferenceExpression target2, final boolean positive, final boolean transformToDefinition, final @NotNull Function<TypeEvalContext, PyType> suggestedType) {
        if (target2 == null) {
            PyTypeAssertionEvaluator.$$$reportNull$$$0(1);
        }
        if (suggestedType == null) {
            PyTypeAssertionEvaluator.$$$reportNull$$$0(2);
        }
        InstructionTypeCallback typeCallback = new InstructionTypeCallback(){

            @Override
            public Ref<PyType> getType(TypeEvalContext context, @Nullable PsiElement anchor2) {
                return PyTypeAssertionEvaluator.createAssertionType(context.getType(target2), (PyType)suggestedType.apply(context), positive, transformToDefinition, context);
            }
        };
        this.myStack.push(new Assertion(target2, typeCallback));
    }

    private static boolean isIfReferenceStatement(@NotNull PyReferenceExpression node) {
        if (node == null) {
            PyTypeAssertionEvaluator.$$$reportNull$$$0(3);
        }
        return node.getParent() instanceof PyIfPart;
    }

    private static boolean isIfReferenceConditionalStatement(@NotNull PyReferenceExpression node) {
        PsiElement parent;
        if (node == null) {
            PyTypeAssertionEvaluator.$$$reportNull$$$0(4);
        }
        return (parent = node.getParent()) instanceof PyConditionalExpression && node == ((PyConditionalExpression)parent).getCondition();
    }

    private static boolean isIfNotReferenceStatement(@NotNull PyReferenceExpression node) {
        PsiElement parent;
        if (node == null) {
            PyTypeAssertionEvaluator.$$$reportNull$$$0(5);
        }
        return (parent = node.getParent()) instanceof PyPrefixExpression && ((PyPrefixExpression)parent).getOperator() == PyTokenTypes.NOT_KEYWORD && parent.getParent() instanceof PyIfPart;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suggestedType";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/codeInsight/controlflow/PyTypeAssertionEvaluator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createAssertionType";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "pushAssertion";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isIfReferenceStatement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isIfReferenceConditionalStatement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isIfNotReferenceStatement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class Assertion {
        private final PyReferenceExpression element;
        private final InstructionTypeCallback myFunction;

        Assertion(PyReferenceExpression element, InstructionTypeCallback getType) {
            this.element = element;
            this.myFunction = getType;
        }

        public PyReferenceExpression getElement() {
            return this.element;
        }

        public InstructionTypeCallback getTypeEvalFunction() {
            return this.myFunction;
        }
    }
}

