/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.typing;

import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.codeInsight.PyInjectionUtil;
import com.jetbrains.python.codeInsight.PyInjectorBase;
import com.jetbrains.python.codeInsight.functionTypeComments.PyFunctionTypeAnnotationDialect;
import com.jetbrains.python.codeInsight.typing.PyTypingTypeProvider;
import com.jetbrains.python.documentation.doctest.PyDocstringLanguageDialect;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyTypingAnnotationInjector
extends PyInjectorBase {
    public static final Pattern RE_TYPING_ANNOTATION = Pattern.compile("\\s*\\S+(\\[.*\\])?\\s*");

    @Override
    protected PyInjectionUtil.InjectionResult registerInjection(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement context) {
        PyInjectionUtil.InjectionResult result2;
        if (registrar == null) {
            PyTypingAnnotationInjector.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PyTypingAnnotationInjector.$$$reportNull$$$0(1);
        }
        if ((result2 = super.registerInjection(registrar, context)) == PyInjectionUtil.InjectionResult.EMPTY && context.getContainingFile() instanceof PyFile && context instanceof PsiComment && context instanceof PsiLanguageInjectionHost) {
            return PyTypingAnnotationInjector.registerCommentInjection(registrar, (PsiLanguageInjectionHost)context);
        }
        return result2;
    }

    @Override
    @Nullable
    public Language getInjectedLanguage(@NotNull PsiElement context) {
        if (context == null) {
            PyTypingAnnotationInjector.$$$reportNull$$$0(2);
        }
        if (context instanceof PyStringLiteralExpression) {
            PyStringLiteralExpression expr = (PyStringLiteralExpression)context;
            if (PsiTreeUtil.getParentOfType((PsiElement)context, PyAnnotation.class, (boolean)true) != null && PyTypingAnnotationInjector.isTypingAnnotation(expr.getStringValue())) {
                return PyDocstringLanguageDialect.getInstance();
            }
        }
        return null;
    }

    @NotNull
    private static PyInjectionUtil.InjectionResult registerCommentInjection(@NotNull MultiHostRegistrar registrar, @NotNull PsiLanguageInjectionHost host) {
        Language language;
        String text2;
        String annotationText;
        if (registrar == null) {
            PyTypingAnnotationInjector.$$$reportNull$$$0(3);
        }
        if (host == null) {
            PyTypingAnnotationInjector.$$$reportNull$$$0(4);
        }
        if ((annotationText = PyTypingTypeProvider.getTypeCommentValue(text2 = host.getText())) != null && (language = "ignore".equals(annotationText) ? null : (PyTypingAnnotationInjector.isFunctionTypeComment((PsiElement)host) ? PyFunctionTypeAnnotationDialect.INSTANCE : PyDocstringLanguageDialect.getInstance())) != null) {
            registrar.startInjecting(language);
            registrar.addPlace("", "", host, PyTypingTypeProvider.getTypeCommentValueRange(text2));
            registrar.doneInjecting();
            PyInjectionUtil.InjectionResult injectionResult = new PyInjectionUtil.InjectionResult(true, true);
            if (injectionResult == null) {
                PyTypingAnnotationInjector.$$$reportNull$$$0(5);
            }
            return injectionResult;
        }
        PyInjectionUtil.InjectionResult injectionResult = PyInjectionUtil.InjectionResult.EMPTY;
        if (injectionResult == null) {
            PyTypingAnnotationInjector.$$$reportNull$$$0(6);
        }
        return injectionResult;
    }

    private static boolean isFunctionTypeComment(@NotNull PsiElement comment) {
        PyFunction function;
        if (comment == null) {
            PyTypingAnnotationInjector.$$$reportNull$$$0(7);
        }
        return (function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)comment, PyFunction.class)) != null && function.getTypeComment() == comment;
    }

    private static boolean isTypingAnnotation(@NotNull String s) {
        if (s == null) {
            PyTypingAnnotationInjector.$$$reportNull$$$0(8);
        }
        return RE_TYPING_ANNOTATION.matcher(s).matches();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/typing/PyTypingAnnotationInjector";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/typing/PyTypingAnnotationInjector";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "registerCommentInjection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerInjection";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getInjectedLanguage";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "registerCommentInjection";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isFunctionTypeComment";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isTypingAnnotation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

