/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.attach;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.python.debugger.PyDebugRunner;
import com.jetbrains.python.debugger.PyLocalPositionConverter;
import com.jetbrains.python.debugger.PyRemoteDebugProcess;
import com.jetbrains.python.debugger.attach.PyAttachToProcessCommandLineState;
import java.io.IOException;
import java.net.ServerSocket;
import org.jetbrains.annotations.NotNull;

public class PyAttachToProcessDebugRunner
extends PyDebugRunner {
    private final Project myProject;
    private final int myPid;
    private final String mySdkPath;
    private static final int CONNECTION_TIMEOUT = 20000;

    public PyAttachToProcessDebugRunner(@NotNull Project project, int pid, String sdkPath) {
        if (project == null) {
            PyAttachToProcessDebugRunner.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myPid = pid;
        this.mySdkPath = sdkPath;
    }

    public XDebugSession launch() throws ExecutionException {
        FileDocumentManager.getInstance().saveAllDocuments();
        return this.launchRemoteDebugServer();
    }

    private XDebugSession launchRemoteDebugServer() throws ExecutionException {
        ServerSocket serverSocket;
        try {
            serverSocket = new ServerSocket(0);
        }
        catch (IOException e) {
            throw new ExecutionException("Failed to find free socket port", (Throwable)e);
        }
        PyAttachToProcessCommandLineState state2 = PyAttachToProcessCommandLineState.create(this.myProject, this.mySdkPath, serverSocket.getLocalPort(), this.myPid);
        final ExecutionResult result2 = state2.execute(state2.getEnvironment().getExecutor(), (ProgramRunner)this);
        return XDebuggerManager.getInstance((Project)this.myProject).startSessionAndShowTab(String.valueOf(this.myPid), null, new XDebugProcessStarter(){

            @NotNull
            public XDebugProcess start(@NotNull XDebugSession session2) {
                if (session2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                PyRemoteDebugProcess pyDebugProcess = new PyRemoteDebugProcess(session2, serverSocket, result2.getExecutionConsole(), result2.getProcessHandler(), ""){

                    @Override
                    protected void printConsoleInfo() {
                    }

                    @Override
                    public int getConnectTimeout() {
                        return 20000;
                    }

                    @Override
                    protected void detachDebuggedProcess() {
                        this.handleStop();
                    }

                    @Override
                    protected String getConnectionMessage() {
                        return "Attaching to a process with PID=" + PyAttachToProcessDebugRunner.this.myPid;
                    }

                    @Override
                    protected String getConnectionTitle() {
                        return "Attaching Debugger";
                    }
                };
                pyDebugProcess.setPositionConverter(new PyLocalPositionConverter());
                PyDebugRunner.createConsoleCommunicationAndSetupActions(PyAttachToProcessDebugRunner.this.myProject, result2, pyDebugProcess, session2);
                PyRemoteDebugProcess pyRemoteDebugProcess = pyDebugProcess;
                if (pyRemoteDebugProcess == null) {
                    1.$$$reportNull$$$0(1);
                }
                return pyRemoteDebugProcess;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "session";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/python/debugger/attach/PyAttachToProcessDebugRunner$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/python/debugger/attach/PyAttachToProcessDebugRunner$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "start";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "start";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/debugger/attach/PyAttachToProcessDebugRunner", "<init>"));
    }
}

