/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.findUsages;

import com.intellij.lang.cacheBuilder.WordsScanner;
import com.intellij.lang.findUsages.FindUsagesProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.findUsages.PyWordsScanner;
import com.jetbrains.python.magicLiteral.PyMagicLiteralExtensionPoint;
import com.jetbrains.python.magicLiteral.PyMagicLiteralTools;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.StringLiteralExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonFindUsagesProvider
implements FindUsagesProvider {
    public boolean canFindUsagesFor(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            PythonFindUsagesProvider.$$$reportNull$$$0(0);
        }
        if (PyMagicLiteralTools.couldBeMagicLiteral(psiElement)) {
            return true;
        }
        return psiElement instanceof PsiNamedElement || psiElement instanceof PyReferenceExpression;
    }

    public String getHelpId(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            PythonFindUsagesProvider.$$$reportNull$$$0(1);
        }
        if (psiElement instanceof PyClass) {
            return "reference.dialogs.findUsages.class";
        }
        if (psiElement instanceof PyFunction) {
            return "reference.dialogs.findUsages.method";
        }
        if (psiElement instanceof PyReferenceExpression || psiElement instanceof PyTargetExpression || psiElement instanceof PyParameter) {
            return "reference.dialogs.findUsages.variable";
        }
        return null;
    }

    @NotNull
    public String getType(@NotNull PsiElement element) {
        String literalString;
        if (element == null) {
            PythonFindUsagesProvider.$$$reportNull$$$0(2);
        }
        if ((literalString = PythonFindUsagesProvider.tryFindMagicLiteralString(element, false)) != null) {
            String string = literalString;
            if (string == null) {
                PythonFindUsagesProvider.$$$reportNull$$$0(3);
            }
            return string;
        }
        if (element instanceof PyNamedParameter) {
            if ("parameter" == null) {
                PythonFindUsagesProvider.$$$reportNull$$$0(4);
            }
            return "parameter";
        }
        if (element instanceof PyFunction) {
            if (((PyFunction)element).getContainingClass() != null) {
                if ("method" == null) {
                    PythonFindUsagesProvider.$$$reportNull$$$0(5);
                }
                return "method";
            }
            if ("function" == null) {
                PythonFindUsagesProvider.$$$reportNull$$$0(6);
            }
            return "function";
        }
        if (element instanceof PyClass) {
            if ("class" == null) {
                PythonFindUsagesProvider.$$$reportNull$$$0(7);
            }
            return "class";
        }
        if (element instanceof PyReferenceExpression) {
            if ("variable" == null) {
                PythonFindUsagesProvider.$$$reportNull$$$0(8);
            }
            return "variable";
        }
        if (element instanceof PyTargetExpression) {
            PyImportElement importElement = (PyImportElement)PsiTreeUtil.getParentOfType((PsiElement)element, PyImportElement.class);
            if (importElement != null && importElement.getAsNameElement() == element) {
                if ("imported module alias" == null) {
                    PythonFindUsagesProvider.$$$reportNull$$$0(9);
                }
                return "imported module alias";
            }
            if ("variable" == null) {
                PythonFindUsagesProvider.$$$reportNull$$$0(10);
            }
            return "variable";
        }
        if (element instanceof PyKeywordArgument) {
            if ("keyword argument" == null) {
                PythonFindUsagesProvider.$$$reportNull$$$0(11);
            }
            return "keyword argument";
        }
        if ("" == null) {
            PythonFindUsagesProvider.$$$reportNull$$$0(12);
        }
        return "";
    }

    @NotNull
    public String getDescriptiveName(@NotNull PsiElement element) {
        String literalString;
        if (element == null) {
            PythonFindUsagesProvider.$$$reportNull$$$0(13);
        }
        if ((literalString = PythonFindUsagesProvider.tryFindMagicLiteralString(element, true)) != null) {
            String string = literalString;
            if (string == null) {
                PythonFindUsagesProvider.$$$reportNull$$$0(14);
            }
            return string;
        }
        if (element instanceof PsiNamedElement) {
            String name = ((PsiNamedElement)element).getName();
            String string = name == null ? "<unnamed>" : name;
            if (string == null) {
                PythonFindUsagesProvider.$$$reportNull$$$0(15);
            }
            return string;
        }
        if (element instanceof PyReferenceExpression) {
            String referencedName = ((PyReferenceExpression)element).getReferencedName();
            if (referencedName == null) {
                if ("<unnamed>" == null) {
                    PythonFindUsagesProvider.$$$reportNull$$$0(16);
                }
                return "<unnamed>";
            }
            String string = referencedName;
            if (string == null) {
                PythonFindUsagesProvider.$$$reportNull$$$0(17);
            }
            return string;
        }
        if ("" == null) {
            PythonFindUsagesProvider.$$$reportNull$$$0(18);
        }
        return "";
    }

    @NotNull
    public String getNodeText(@NotNull PsiElement element, boolean useFullName) {
        if (element == null) {
            PythonFindUsagesProvider.$$$reportNull$$$0(19);
        }
        if (element instanceof PyNamedParameter) {
            StringBuilder result2 = new StringBuilder(((PyNamedParameter)element).getName());
            PyFunction function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)element, PyFunction.class);
            if (function != null) {
                result2.append(" of ");
                PythonFindUsagesProvider.appendFunctionDescription(result2, function);
            }
            String string = result2.toString();
            if (string == null) {
                PythonFindUsagesProvider.$$$reportNull$$$0(20);
            }
            return string;
        }
        if (element instanceof PyFunction) {
            StringBuilder result3 = new StringBuilder();
            PythonFindUsagesProvider.appendFunctionDescription(result3, (PyFunction)element);
            String string = result3.toString();
            if (string == null) {
                PythonFindUsagesProvider.$$$reportNull$$$0(21);
            }
            return string;
        }
        String string = this.getDescriptiveName(element);
        if (string == null) {
            PythonFindUsagesProvider.$$$reportNull$$$0(22);
        }
        return string;
    }

    private static void appendFunctionDescription(StringBuilder result2, PyFunction function) {
        result2.append(function.getName()).append("()");
        PyClass containingClass = function.getContainingClass();
        if (containingClass != null) {
            result2.append(" of class ").append(containingClass.getName());
        }
    }

    public WordsScanner getWordsScanner() {
        return new PyWordsScanner();
    }

    @Nullable
    private static String tryFindMagicLiteralString(@NotNull PsiElement element, boolean obtainValue) {
        PyMagicLiteralExtensionPoint point;
        if (element == null) {
            PythonFindUsagesProvider.$$$reportNull$$$0(23);
        }
        if (element instanceof PyStringLiteralExpression && (point = PyMagicLiteralTools.getPoint((PyStringLiteralExpression)element)) != null) {
            if (obtainValue) {
                return ((StringLiteralExpression)element).getStringValue();
            }
            return point.getLiteralType();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 2: 
            case 13: 
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/findUsages/PythonFindUsagesProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/findUsages/PythonFindUsagesProvider";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptiveName";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canFindUsagesFor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getHelpId";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptiveName";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getNodeText";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "tryFindMagicLiteralString";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

