/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import org.jetbrains.annotations.NotNull;

public class PyCreatePropertyQuickFix
implements LocalQuickFix {
    private final AccessDirection myAccessDirection;

    public PyCreatePropertyQuickFix(AccessDirection dir) {
        this.myAccessDirection = dir;
    }

    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("QFIX.create.property", new Object[0]);
        if (string == null) {
            PyCreatePropertyQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        PyType type;
        PyExpression qualifier;
        PsiElement element;
        if (project == null) {
            PyCreatePropertyQuickFix.$$$reportNull$$$0(1);
        }
        if (descriptor2 == null) {
            PyCreatePropertyQuickFix.$$$reportNull$$$0(2);
        }
        if ((element = descriptor2.getPsiElement()) instanceof PyQualifiedExpression && (qualifier = ((PyQualifiedExpression)element).getQualifier()) != null && (type = TypeEvalContext.codeAnalysis(element.getProject(), element.getContainingFile()).getType(qualifier)) instanceof PyClassType) {
            PyClass cls = ((PyClassType)type).getPyClass();
            String propertyName = ((PyQualifiedExpression)element).getName();
            if (propertyName == null) {
                return;
            }
            String fieldName = "_" + propertyName;
            PyElementGenerator generator = PyElementGenerator.getInstance(project);
            PyFunction property = generator.createProperty(LanguageLevel.forElement((PsiElement)cls), propertyName, fieldName, this.myAccessDirection);
            PyUtil.addElementToStatementList(property, cls.getStatementList(), this.myAccessDirection == AccessDirection.READ);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/quickfix/PyCreatePropertyQuickFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/quickfix/PyCreatePropertyQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

