/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.rename;

import com.intellij.psi.PsiElement;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import com.intellij.refactoring.rename.naming.AutomaticRenamerFactory;
import com.intellij.usageView.UsageInfo;
import com.jetbrains.python.codeInsight.PyCodeInsightSettings;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.search.PyClassInheritorsSearch;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class PyInheritorRenameFactory
implements AutomaticRenamerFactory {
    @Override
    public boolean isApplicable(@NotNull PsiElement element) {
        if (element == null) {
            PyInheritorRenameFactory.$$$reportNull$$$0(0);
        }
        return element instanceof PyClass;
    }

    @Override
    public String getOptionName() {
        return "Rename inheritors";
    }

    @Override
    public boolean isEnabled() {
        return PyCodeInsightSettings.getInstance().RENAME_CLASS_INHERITORS;
    }

    @Override
    public void setEnabled(boolean enabled) {
        PyCodeInsightSettings.getInstance().RENAME_CLASS_INHERITORS = enabled;
    }

    @Override
    @NotNull
    public AutomaticRenamer createRenamer(PsiElement element, String newName, Collection<UsageInfo> usages) {
        PyInheritorRenamer pyInheritorRenamer = new PyInheritorRenamer((PyClass)element, newName);
        if (pyInheritorRenamer == null) {
            PyInheritorRenameFactory.$$$reportNull$$$0(1);
        }
        return pyInheritorRenamer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/refactoring/rename/PyInheritorRenameFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/refactoring/rename/PyInheritorRenameFactory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createRenamer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class PyInheritorRenamer
    extends AutomaticRenamer {
        public PyInheritorRenamer(PyClass element, String newName) {
            this.myElements.addAll(PyClassInheritorsSearch.search(element, false).findAll());
            this.suggestAllNames(element.getName(), newName);
        }

        @Override
        public String getDialogTitle() {
            return "Rename Inheritors";
        }

        @Override
        public String getDialogDescription() {
            return "Rename inheritor classes with the following names to:";
        }

        @Override
        public String entityName() {
            return "Inheritor Class";
        }
    }
}

