/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.rename;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.codeInsight.PyCodeInsightSettings;
import com.jetbrains.python.psi.Property;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.search.PyOverridingMethodsSearch;
import com.jetbrains.python.psi.search.PySuperMethodsSearch;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.pyi.PyiUtil;
import com.jetbrains.python.refactoring.rename.RenamePyElementProcessor;
import com.jetbrains.python.toolbox.Maybe;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenamePyFunctionProcessor
extends RenamePyElementProcessor {
    @Override
    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            RenamePyFunctionProcessor.$$$reportNull$$$0(0);
        }
        return element instanceof PyFunction;
    }

    @Override
    public boolean forcesShowPreview() {
        return true;
    }

    @Override
    public boolean isToSearchInComments(@NotNull PsiElement element) {
        if (element == null) {
            RenamePyFunctionProcessor.$$$reportNull$$$0(1);
        }
        return PyCodeInsightSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_FUNCTION;
    }

    @Override
    public void setToSearchInComments(@NotNull PsiElement element, boolean enabled) {
        if (element == null) {
            RenamePyFunctionProcessor.$$$reportNull$$$0(2);
        }
        PyCodeInsightSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_FUNCTION = enabled;
    }

    @Override
    public boolean isToSearchForTextOccurrences(@NotNull PsiElement element) {
        if (element == null) {
            RenamePyFunctionProcessor.$$$reportNull$$$0(3);
        }
        return PyCodeInsightSettings.getInstance().RENAME_SEARCH_NON_CODE_FOR_FUNCTION;
    }

    @Override
    public void setToSearchForTextOccurrences(@NotNull PsiElement element, boolean enabled) {
        if (element == null) {
            RenamePyFunctionProcessor.$$$reportNull$$$0(4);
        }
        PyCodeInsightSettings.getInstance().RENAME_SEARCH_NON_CODE_FOR_FUNCTION = enabled;
    }

    @Override
    public PsiElement substituteElementToRename(@NotNull PsiElement element, @Nullable Editor editor) {
        PyTargetExpression site;
        PyFunction function;
        PyClass containingClass;
        if (element == null) {
            RenamePyFunctionProcessor.$$$reportNull$$$0(5);
        }
        if ((containingClass = (function = RenamePyFunctionProcessor.toImplementationOtherwiseAsIs((PyFunction)element)).getContainingClass()) == null) {
            return function;
        }
        if ("__init__".equals(function.getName())) {
            return containingClass;
        }
        PyFunction deepestSuperMethod = PySuperMethodsSearch.findDeepestSuperMethod(function);
        if (!deepestSuperMethod.equals(function)) {
            String message = "Method " + function.getName() + " of class " + containingClass.getQualifiedName() + "\noverrides method of class " + deepestSuperMethod.getContainingClass().getQualifiedName() + ".\nDo you want to rename the base method?";
            int rc = Messages.showYesNoCancelDialog((Project)element.getProject(), (String)message, (String)"Rename", (Icon)Messages.getQuestionIcon());
            switch (rc) {
                case 0: {
                    return deepestSuperMethod;
                }
                case 1: {
                    return function;
                }
            }
            return null;
        }
        Property property = containingClass.findPropertyByCallable(function);
        if (property != null && (site = property.getDefinitionSite()) != null) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return site;
            }
            String message = String.format("Do you want to rename the property '%s' instead of its accessor function '%s'?", property.getName(), function.getName());
            int rc = Messages.showYesNoCancelDialog((Project)element.getProject(), (String)message, (String)"Rename", (Icon)Messages.getQuestionIcon());
            switch (rc) {
                case 0: {
                    return site;
                }
                case 1: {
                    return function;
                }
            }
            return null;
        }
        return function;
    }

    @Override
    public void prepareRenaming(@NotNull PsiElement element, @NotNull String newName, @NotNull Map<PsiElement, String> allRenames) {
        Property property;
        if (element == null) {
            RenamePyFunctionProcessor.$$$reportNull$$$0(6);
        }
        if (newName == null) {
            RenamePyFunctionProcessor.$$$reportNull$$$0(7);
        }
        if (allRenames == null) {
            RenamePyFunctionProcessor.$$$reportNull$$$0(8);
        }
        PyFunction function = (PyFunction)element;
        PyOverridingMethodsSearch.search(function, true).forEach(f -> {
            if (allRenames == null) {
                RenamePyFunctionProcessor.$$$reportNull$$$0(16);
            }
            if (newName == null) {
                RenamePyFunctionProcessor.$$$reportNull$$$0(17);
            }
            allRenames.put((PsiElement)f, newName);
            return true;
        });
        PyiUtil.getOverloads(function, TypeEvalContext.codeInsightFallback(element.getProject())).forEach(overload -> {
            if (allRenames == null) {
                RenamePyFunctionProcessor.$$$reportNull$$$0(14);
            }
            if (newName == null) {
                RenamePyFunctionProcessor.$$$reportNull$$$0(15);
            }
            allRenames.put((PsiElement)overload, newName);
        });
        PyClass containingClass = function.getContainingClass();
        if (containingClass != null && (property = containingClass.findPropertyByCallable(function)) != null) {
            RenamePyFunctionProcessor.addRename(allRenames, newName, property.getGetter());
            RenamePyFunctionProcessor.addRename(allRenames, newName, property.getSetter());
            RenamePyFunctionProcessor.addRename(allRenames, newName, property.getDeleter());
        }
    }

    @NotNull
    private static PyFunction toImplementationOtherwiseAsIs(@NotNull PyFunction function) {
        PyFunction implementation;
        if (function == null) {
            RenamePyFunctionProcessor.$$$reportNull$$$0(9);
        }
        PyFunction pyFunction = (implementation = PyiUtil.getImplementation(function)) != null ? implementation : function;
        if (pyFunction == null) {
            RenamePyFunctionProcessor.$$$reportNull$$$0(10);
        }
        return pyFunction;
    }

    private static void addRename(@NotNull Map<PsiElement, String> renames, @NotNull String newName, @NotNull Maybe<PyCallable> accessor) {
        PyCallable callable;
        if (renames == null) {
            RenamePyFunctionProcessor.$$$reportNull$$$0(11);
        }
        if (newName == null) {
            RenamePyFunctionProcessor.$$$reportNull$$$0(12);
        }
        if (accessor == null) {
            RenamePyFunctionProcessor.$$$reportNull$$$0(13);
        }
        if ((callable = accessor.valueOrNull()) instanceof PyFunction) {
            renames.put((PsiElement)callable, newName);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: 
            case 12: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 8: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRenames";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/refactoring/rename/RenamePyFunctionProcessor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renames";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/refactoring/rename/RenamePyFunctionProcessor";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "toImplementationOtherwiseAsIs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canProcessElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isToSearchInComments";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setToSearchInComments";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isToSearchForTextOccurrences";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setToSearchForTextOccurrences";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "substituteElementToRename";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "prepareRenaming";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "toImplementationOtherwiseAsIs";
                break;
            }
            case 10: {
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addRename";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$prepareRenaming$1";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$prepareRenaming$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

