/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.run;

import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.LightVirtualFile;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.run.PythonConfigurationType;
import com.jetbrains.python.run.PythonRunConfiguration;
import com.jetbrains.python.run.RunnableScriptFilter;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonRunConfigurationProducer
extends RunConfigurationProducer<PythonRunConfiguration> {
    public PythonRunConfigurationProducer() {
        super((ConfigurationFactory)PythonConfigurationType.getInstance().getFactory());
    }

    protected boolean setupConfigurationFromContext(PythonRunConfiguration configuration, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        Module module2;
        Location location = context.getLocation();
        if (location == null) {
            return false;
        }
        PsiFile script = location.getPsiElement().getContainingFile();
        if (!PythonRunConfigurationProducer.isAvailable(location, script)) {
            return false;
        }
        VirtualFile vFile = script.getVirtualFile();
        if (vFile == null) {
            return false;
        }
        configuration.setScriptName(vFile.getPath());
        VirtualFile parent = vFile.getParent();
        if (parent != null && StringUtil.isEmpty((String)configuration.getWorkingDirectory())) {
            configuration.setWorkingDirectory(parent.getPath());
        }
        if ((module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)script)) != null) {
            configuration.setUseModuleSdk(true);
            configuration.setModule(module2);
        }
        configuration.setName(configuration.suggestedName());
        return true;
    }

    public boolean isConfigurationFromContext(PythonRunConfiguration configuration, ConfigurationContext context) {
        String path;
        Location location = context.getLocation();
        if (location == null) {
            return false;
        }
        PsiFile script = location.getPsiElement().getContainingFile();
        if (!PythonRunConfigurationProducer.isAvailable(location, script)) {
            return false;
        }
        VirtualFile virtualFile = script.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        if (virtualFile instanceof LightVirtualFile) {
            return false;
        }
        String workingDirectory = configuration.getWorkingDirectory();
        String scriptName = configuration.getScriptName();
        return scriptName.equals(path = virtualFile.getPath()) || path.equals(new File(workingDirectory, scriptName).getAbsolutePath());
    }

    private static boolean isAvailable(@NotNull Location location, @Nullable PsiFile script) {
        if (location == null) {
            PythonRunConfigurationProducer.$$$reportNull$$$0(0);
        }
        if (script == null || script.getFileType() != PythonFileType.INSTANCE) {
            return false;
        }
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)script);
        if (module2 != null) {
            for (RunnableScriptFilter f : (RunnableScriptFilter[])Extensions.getExtensions(RunnableScriptFilter.EP_NAME)) {
                if (!f.isRunnableScript(script, module2, location, TypeEvalContext.userInitiated(location.getProject(), null))) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isPreferredConfiguration(ConfigurationFromContext self, ConfigurationFromContext other) {
        return other.isProducedBy(PythonRunConfigurationProducer.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/jetbrains/python/run/PythonRunConfigurationProducer", "isAvailable"));
    }
}

