/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.flavors;

import com.google.common.collect.Lists;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PatternUtil;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.run.CommandLinePatcher;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonEnvUtil;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import com.jetbrains.python.sdk.flavors.CondaEnvSdkFlavor;
import com.jetbrains.python.sdk.flavors.IronPythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.JythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.MacPythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.PyPySdkFlavor;
import com.jetbrains.python.sdk.flavors.PyRemoteSdkFlavor;
import com.jetbrains.python.sdk.flavors.PythonFlavorProvider;
import com.jetbrains.python.sdk.flavors.UnixPythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.VirtualEnvSdkFlavor;
import com.jetbrains.python.sdk.flavors.WinPythonSdkFlavor;
import icons.PythonIcons;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PythonSdkFlavor {
    private static final Pattern VERSION_RE = Pattern.compile("(Python \\S+).*");
    private static final Logger LOG = Logger.getInstance(PythonSdkFlavor.class);

    public static Collection<String> appendSystemPythonPath(@NotNull Collection<String> pythonPath) {
        if (pythonPath == null) {
            PythonSdkFlavor.$$$reportNull$$$0(0);
        }
        return PythonSdkFlavor.appendSystemEnvPaths(pythonPath, "PYTHONPATH");
    }

    protected static Collection<String> appendSystemEnvPaths(@NotNull Collection<String> pythonPath, String envname) {
        String syspath;
        if (pythonPath == null) {
            PythonSdkFlavor.$$$reportNull$$$0(1);
        }
        if ((syspath = System.getenv(envname)) != null) {
            pythonPath.addAll(Lists.newArrayList((Object[])syspath.split(File.pathSeparator)));
        }
        return pythonPath;
    }

    public static void initPythonPath(@NotNull Map<String, String> envs, boolean passParentEnvs, @NotNull Collection<String> pythonPathList) {
        if (envs == null) {
            PythonSdkFlavor.$$$reportNull$$$0(2);
        }
        if (pythonPathList == null) {
            PythonSdkFlavor.$$$reportNull$$$0(3);
        }
        if (passParentEnvs && !envs.containsKey("PYTHONPATH")) {
            pythonPathList = PythonSdkFlavor.appendSystemPythonPath(pythonPathList);
        }
        PythonEnvUtil.addToPythonPath(envs, pythonPathList);
    }

    @Deprecated
    public Collection<String> suggestHomePaths() {
        return this.suggestHomePaths(null);
    }

    public Collection<String> suggestHomePaths(@Nullable Module module2) {
        return Collections.emptyList();
    }

    public static List<PythonSdkFlavor> getApplicableFlavors() {
        return PythonSdkFlavor.getApplicableFlavors(true);
    }

    public static List<PythonSdkFlavor> getApplicableFlavors(boolean addPlatformIndependent) {
        ArrayList<PythonSdkFlavor> result2 = new ArrayList<PythonSdkFlavor>();
        if (SystemInfo.isWindows) {
            result2.add((PythonSdkFlavor)ServiceManager.getService(WinPythonSdkFlavor.class));
        } else if (SystemInfo.isMac) {
            result2.add(MacPythonSdkFlavor.INSTANCE);
        } else if (SystemInfo.isUnix) {
            result2.add(UnixPythonSdkFlavor.INSTANCE);
        }
        if (addPlatformIndependent) {
            result2.addAll(PythonSdkFlavor.getPlatformIndependentFlavors());
        }
        result2.addAll(PythonSdkFlavor.getPlatformFlavorsFromExtensions(addPlatformIndependent));
        return result2;
    }

    public static List<PythonSdkFlavor> getPlatformFlavorsFromExtensions(boolean isInpedendent) {
        ArrayList<PythonSdkFlavor> result2 = new ArrayList<PythonSdkFlavor>();
        for (PythonFlavorProvider provider : (PythonFlavorProvider[])Extensions.getExtensions(PythonFlavorProvider.EP_NAME)) {
            PythonSdkFlavor flavor = provider.getFlavor(isInpedendent);
            if (flavor == null) continue;
            result2.add(flavor);
        }
        return result2;
    }

    public static List<PythonSdkFlavor> getPlatformIndependentFlavors() {
        ArrayList result2 = Lists.newArrayList();
        result2.add(JythonSdkFlavor.INSTANCE);
        result2.add(IronPythonSdkFlavor.INSTANCE);
        result2.add(PyPySdkFlavor.INSTANCE);
        result2.add(VirtualEnvSdkFlavor.INSTANCE);
        result2.add(CondaEnvSdkFlavor.INSTANCE);
        result2.add(PyRemoteSdkFlavor.INSTANCE);
        return result2;
    }

    @Nullable
    public static PythonSdkFlavor getFlavor(@NotNull Sdk sdk) {
        PythonSdkFlavor flavor;
        SdkAdditionalData data;
        if (sdk == null) {
            PythonSdkFlavor.$$$reportNull$$$0(4);
        }
        if ((data = sdk.getSdkAdditionalData()) instanceof PythonSdkAdditionalData && (flavor = ((PythonSdkAdditionalData)data).getFlavor()) != null) {
            return flavor;
        }
        return PythonSdkFlavor.getFlavor(sdk.getHomePath());
    }

    @Nullable
    public static PythonSdkFlavor getFlavor(@Nullable String sdkPath) {
        if (sdkPath == null) {
            return null;
        }
        for (PythonSdkFlavor flavor : PythonSdkFlavor.getApplicableFlavors()) {
            if (!flavor.isValidSdkHome(sdkPath)) continue;
            return flavor;
        }
        return null;
    }

    @Nullable
    public static PythonSdkFlavor getPlatformIndependentFlavor(@Nullable String sdkPath) {
        if (sdkPath == null) {
            return null;
        }
        for (PythonSdkFlavor flavor : PythonSdkFlavor.getPlatformIndependentFlavors()) {
            if (!flavor.isValidSdkHome(sdkPath)) continue;
            return flavor;
        }
        for (PythonSdkFlavor flavor : PythonSdkFlavor.getPlatformFlavorsFromExtensions(true)) {
            if (!flavor.isValidSdkHome(sdkPath)) continue;
            return flavor;
        }
        return null;
    }

    public boolean isValidSdkHome(String path) {
        File file2 = new File(path);
        return file2.isFile() && this.isValidSdkPath(file2);
    }

    public boolean isValidSdkPath(@NotNull File file2) {
        if (file2 == null) {
            PythonSdkFlavor.$$$reportNull$$$0(5);
        }
        return FileUtil.getNameWithoutExtension((File)file2).toLowerCase().startsWith("python");
    }

    @Nullable
    public String getVersionString(@Nullable String sdkHome) {
        if (sdkHome == null) {
            return null;
        }
        String runDirectory = new File(sdkHome).getParent();
        ProcessOutput processOutput = PySdkUtil.getProcessOutput(runDirectory, new String[]{sdkHome, this.getVersionOption()}, 10000);
        return this.getVersionStringFromOutput(processOutput);
    }

    @Nullable
    public String getVersionStringFromOutput(@NotNull ProcessOutput processOutput) {
        if (processOutput == null) {
            PythonSdkFlavor.$$$reportNull$$$0(6);
        }
        if (processOutput.getExitCode() != 0) {
            String errors = processOutput.getStderr();
            if (StringUtil.isEmpty((String)errors)) {
                errors = processOutput.getStdout();
            }
            LOG.warn("Couldn't get interpreter version: process exited with code " + processOutput.getExitCode() + "\n" + errors);
            return null;
        }
        String result2 = this.getVersionStringFromOutput(processOutput.getStderr());
        if (result2 != null) {
            return result2;
        }
        return this.getVersionStringFromOutput(processOutput.getStdout());
    }

    @Nullable
    public String getVersionStringFromOutput(@NotNull String output) {
        if (output == null) {
            PythonSdkFlavor.$$$reportNull$$$0(7);
        }
        return PatternUtil.getFirstMatch(Arrays.asList(StringUtil.splitByLines((String)output)), (Pattern)VERSION_RE);
    }

    public String getVersionOption() {
        return "-V";
    }

    public Collection<String> getExtraDebugOptions() {
        return Collections.emptyList();
    }

    public void initPythonPath(GeneralCommandLine cmd, boolean passParentEnvs, Collection<String> path) {
        this.initPythonPath(path, passParentEnvs, cmd.getEnvironment());
    }

    public static void addToEnv(String key, String value, Map<String, String> envs) {
        PythonEnvUtil.addPathToEnv(envs, key, value);
    }

    public static void setupEncodingEnvs(Map<String, String> envs, @NotNull Charset charset) {
        if (charset == null) {
            PythonSdkFlavor.$$$reportNull$$$0(8);
        }
        String encoding = charset.name();
        PythonEnvUtil.setPythonIOEncoding(envs, encoding);
    }

    @NotNull
    public abstract String getName();

    @NotNull
    public LanguageLevel getLanguageLevel(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkFlavor.$$$reportNull$$$0(9);
        }
        LanguageLevel languageLevel = this.getLanguageLevelFromVersionString(sdk.getVersionString());
        if (languageLevel == null) {
            PythonSdkFlavor.$$$reportNull$$$0(10);
        }
        return languageLevel;
    }

    @NotNull
    public LanguageLevel getLanguageLevel(@NotNull String sdkHome) {
        if (sdkHome == null) {
            PythonSdkFlavor.$$$reportNull$$$0(11);
        }
        LanguageLevel languageLevel = this.getLanguageLevelFromVersionString(this.getVersionString(sdkHome));
        if (languageLevel == null) {
            PythonSdkFlavor.$$$reportNull$$$0(12);
        }
        return languageLevel;
    }

    @NotNull
    private LanguageLevel getLanguageLevelFromVersionString(@Nullable String version) {
        String prefix = this.getName() + " ";
        if (version != null && version.startsWith(prefix)) {
            LanguageLevel languageLevel = LanguageLevel.fromPythonVersion(version.substring(prefix.length()));
            if (languageLevel == null) {
                PythonSdkFlavor.$$$reportNull$$$0(13);
            }
            return languageLevel;
        }
        LanguageLevel languageLevel = LanguageLevel.getDefault();
        if (languageLevel == null) {
            PythonSdkFlavor.$$$reportNull$$$0(14);
        }
        return languageLevel;
    }

    public Icon getIcon() {
        return PythonIcons.Python.Python;
    }

    public void initPythonPath(Collection<String> path, boolean passParentEnvs, Map<String, String> env) {
        PythonSdkFlavor.initPythonPath(env, passParentEnvs, path);
    }

    public VirtualFile getSdkPath(VirtualFile path) {
        return path;
    }

    @Nullable
    public CommandLinePatcher commandLinePatcher() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pythonPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envs";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pythonPathList";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processOutput";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/sdk/flavors/PythonSdkFlavor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkHome";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/sdk/flavors/PythonSdkFlavor";
                break;
            }
            case 10: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevel";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevelFromVersionString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "appendSystemPythonPath";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "appendSystemEnvPaths";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "initPythonPath";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFlavor";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isValidSdkPath";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getVersionStringFromOutput";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setupEncodingEnvs";
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageLevel";
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

