/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SVGLoader;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import org.intellij.images.fileTypes.impl.SvgFileType;

public class ConvertSvgToPngAction
extends DumbAwareAction {
    public void actionPerformed(AnActionEvent e) {
        VirtualFile svgFile = (VirtualFile)e.getRequiredData(CommonDataKeys.VIRTUAL_FILE);
        try {
            Image image = SVGLoader.load((URL)new File(svgFile.getPath()).toURI().toURL(), (float)1.0f);
            String path = svgFile.getPath();
            ImageIO.write((RenderedImage)((BufferedImage)image), "png", new File(path + ".png"));
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public void update(AnActionEvent e) {
        VirtualFile file2 = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        boolean enabled = file2 != null && file2.getFileType() == SvgFileType.INSTANCE;
        e.getPresentation().setEnabledAndVisible(enabled);
    }
}

