/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.compact.psi.impl;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import org.intellij.plugins.relaxNG.compact.RncElementTypes;
import org.intellij.plugins.relaxNG.compact.RncFileType;
import org.intellij.plugins.relaxNG.compact.RncTokenTypes;
import org.intellij.plugins.relaxNG.compact.psi.RncDecl;
import org.intellij.plugins.relaxNG.compact.psi.RncElement;
import org.intellij.plugins.relaxNG.compact.psi.RncElementVisitor;
import org.intellij.plugins.relaxNG.compact.psi.RncFile;
import org.intellij.plugins.relaxNG.compact.psi.RncGrammar;
import org.intellij.plugins.relaxNG.compact.psi.RncName;
import org.intellij.plugins.relaxNG.compact.psi.impl.RncElementImpl;
import org.intellij.plugins.relaxNG.compact.psi.util.EscapeUtil;
import org.intellij.plugins.relaxNG.compact.psi.util.RenameUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RncNameImpl
extends RncElementImpl
implements RncName,
PsiReference,
EmptyResolveMessageProvider,
LocalQuickFixProvider {
    public RncNameImpl(ASTNode node) {
        super(node);
    }

    @Override
    @Nullable
    public String getPrefix() {
        String[] parts = EscapeUtil.unescapeText(this.getNode()).split(":", 2);
        return parts.length == 2 ? parts[0] : null;
    }

    @Override
    @NotNull
    public String getLocalPart() {
        String[] parts = EscapeUtil.unescapeText(this.getNode()).split(":", 2);
        String string = parts.length == 1 ? parts[0] : parts[1];
        if (string == null) {
            RncNameImpl.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public void accept(@NotNull RncElementVisitor visitor2) {
        if (visitor2 == null) {
            RncNameImpl.$$$reportNull$$$0(1);
        }
        visitor2.visitName(this);
    }

    @Override
    public PsiReference getReference() {
        return this.getPrefix() == null ? null : this;
    }

    @NotNull
    public PsiElement getElement() {
        RncNameImpl rncNameImpl = this;
        if (rncNameImpl == null) {
            RncNameImpl.$$$reportNull$$$0(2);
        }
        return rncNameImpl;
    }

    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = TextRange.from((int)0, (int)this.getText().indexOf(58));
        if (textRange == null) {
            RncNameImpl.$$$reportNull$$$0(3);
        }
        return textRange;
    }

    @Nullable
    public PsiElement resolve() {
        MyResolver resolver = new MyResolver(this.getPrefix(), this.getKind());
        this.getContainingFile().processDeclarations((PsiScopeProcessor)resolver, ResolveState.initial(), (PsiElement)this, (PsiElement)this);
        return resolver.getResult();
    }

    private Kind getKind() {
        IElementType parent = this.getNode().getTreeParent().getElementType();
        if (parent == RncElementTypes.DATATYPE_PATTERN) {
            return Kind.DATATYPES;
        }
        return Kind.NAMESPACE;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.getRangeInElement().substring(this.getText());
        if (string == null) {
            RncNameImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        ASTNode node = this.getNode();
        ASTNode child = RenameUtil.createPrefixedNode(this.getManager(), newElementName, this.getLocalPart());
        node.getTreeParent().replaceChild(node, child);
        return child.getPsi();
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            RncNameImpl.$$$reportNull$$$0(5);
        }
        throw new UnsupportedOperationException();
    }

    public boolean isReferenceTo(PsiElement element) {
        return element instanceof RncElement && Comparing.equal((Object)this.resolve(), (Object)element);
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            RncNameImpl.$$$reportNull$$$0(6);
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public boolean isSoft() {
        String prefix = this.getPrefix();
        return "xsd".equals(prefix) || "xml".equals(prefix);
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        if ("Unresolved namespace prefix ''{0}''" == null) {
            RncNameImpl.$$$reportNull$$$0(7);
        }
        return "Unresolved namespace prefix ''{0}''";
    }

    @Nullable
    public LocalQuickFix[] getQuickFixes() {
        if (this.getPrefix() != null) {
            return new LocalQuickFix[]{new CreateDeclFix(this)};
        }
        return LocalQuickFix.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/relaxNG/compact/psi/impl/RncNameImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalPart";
                break;
            }
            case 1: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/relaxNG/compact/psi/impl/RncNameImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class CreateDeclFix
    implements LocalQuickFix {
        private final RncNameImpl myReference;

        public CreateDeclFix(RncNameImpl reference) {
            this.myReference = reference;
        }

        @NotNull
        public String getName() {
            String string = this.getFamilyName() + " '" + this.myReference.getPrefix() + "'";
            if (string == null) {
                CreateDeclFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = "Create " + this.myReference.getKind().name().toLowerCase() + " declaration";
            if (string == null) {
                CreateDeclFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            Editor editor;
            RncGrammar rncGrammar;
            if (project == null) {
                CreateDeclFix.$$$reportNull$$$0(2);
            }
            if (descriptor2 == null) {
                CreateDeclFix.$$$reportNull$$$0(3);
            }
            String prefix = this.myReference.getPrefix();
            PsiFileFactory factory = PsiFileFactory.getInstance((Project)this.myReference.getProject());
            RncFile psiFile = (RncFile)factory.createFileFromText("dummy.rnc", RncFileType.getInstance(), (CharSequence)(this.myReference.getKind().name().toLowerCase() + " " + prefix + " = \"###\""));
            RncFile rncFile = (RncFile)this.myReference.getContainingFile();
            RncDecl[] declarations = rncFile.getDeclarations();
            RncDecl decl = psiFile.getDeclarations()[0];
            RncDecl e = declarations.length > 0 ? (RncDecl)rncFile.addAfter(decl, declarations[declarations.length - 1]) : ((rncGrammar = rncFile.getGrammar()) != null ? (RncDecl)rncFile.addBefore(decl, rncGrammar) : (RncDecl)rncFile.add(decl));
            ASTNode blockNode = e.getParent().getNode();
            assert (blockNode != null);
            ASTNode newNode = e.getNode();
            assert (newNode != null);
            CodeStyleManager.getInstance((Project)e.getManager().getProject()).reformatNewlyAddedElement(blockNode, newNode);
            PsiElement literal = e.getLastChild();
            assert (literal != null);
            ASTNode literalNode = literal.getNode();
            assert (literalNode != null);
            assert (literalNode.getElementType() == RncTokenTypes.LITERAL);
            int offset = literal.getTextRange().getStartOffset();
            literal.delete();
            VirtualFile virtualFile = this.myReference.getElement().getContainingFile().getVirtualFile();
            if (virtualFile != null && (editor = FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, virtualFile, offset), true)) != null) {
                RncDecl rncDecl = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement(e);
                TemplateManager manager = TemplateManager.getInstance(project);
                Template t = manager.createTemplate("", "");
                t.addTextSegment(" \"");
                Expression expression = new Expression(){

                    public Result calculateResult(ExpressionContext context) {
                        return new TextResult("");
                    }

                    public Result calculateQuickResult(ExpressionContext context) {
                        return this.calculateResult(context);
                    }

                    public LookupItem[] calculateLookupItems(ExpressionContext context) {
                        return LookupItem.EMPTY_ARRAY;
                    }
                };
                t.addVariable("uri", expression, expression, true);
                t.addTextSegment("\"");
                t.addEndVariable();
                editor.getCaretModel().moveToOffset(rncDecl.getTextRange().getEndOffset());
                manager.startTemplate(editor, t);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/intellij/plugins/relaxNG/compact/psi/impl/RncNameImpl$CreateDeclFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/intellij/plugins/relaxNG/compact/psi/impl/RncNameImpl$CreateDeclFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyResolver
    implements PsiScopeProcessor {
        private final String myPrefix;
        private final Kind myKind;
        private PsiElement myResult;

        public MyResolver(String prefix, Kind kind) {
            this.myPrefix = prefix;
            this.myKind = kind;
        }

        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState substitutor) {
            ASTNode node;
            if (element == null) {
                MyResolver.$$$reportNull$$$0(0);
            }
            if (substitutor == null) {
                MyResolver.$$$reportNull$$$0(1);
            }
            if ((node = element.getNode()) == null) {
                return true;
            }
            if (!(element instanceof RncDecl)) {
                return false;
            }
            IElementType type = node.getElementType();
            return !(this.myKind == Kind.NAMESPACE && type == RncElementTypes.NS_DECL ? this.checkDecl(element) : this.myKind == Kind.DATATYPES && type == RncElementTypes.DATATYPES_DECL && this.checkDecl(element));
        }

        private boolean checkDecl(PsiElement element) {
            if (this.myPrefix.equals(((RncDecl)element).getPrefix())) {
                this.myResult = element;
                return true;
            }
            return false;
        }

        public PsiElement getResult() {
            return this.myResult;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "substitutor";
                    break;
                }
            }
            objectArray[1] = "org/intellij/plugins/relaxNG/compact/psi/impl/RncNameImpl$MyResolver";
            objectArray[2] = "execute";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static enum Kind {
        NAMESPACE,
        DATATYPES;

    }
}

