/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.structureView;

import com.intellij.icons.AllIcons;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.util.treeView.smartTree.Group;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.editor.ResourceBundleEditorViewElement;
import com.intellij.lang.properties.editor.ResourceBundlePropertyStructureViewElement;
import com.intellij.lang.properties.structureView.PropertiesStructureViewElement;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertiesPrefixGroup
implements Group,
ResourceBundleEditorViewElement {
    private final Collection<TreeElement> myProperties;
    @NotNull
    private final String myPrefix;
    private final String myPresentableName;
    @NotNull
    private final String mySeparator;

    public PropertiesPrefixGroup(Collection<TreeElement> properties, @NotNull String prefix, String presentableName, @NotNull String separator) {
        if (prefix == null) {
            PropertiesPrefixGroup.$$$reportNull$$$0(0);
        }
        if (separator == null) {
            PropertiesPrefixGroup.$$$reportNull$$$0(1);
        }
        this.myProperties = properties;
        this.myPrefix = prefix;
        this.myPresentableName = presentableName;
        this.mySeparator = separator;
    }

    public String getPresentableName() {
        return this.myPresentableName;
    }

    @NotNull
    public String getSeparator() {
        String string = this.mySeparator;
        if (string == null) {
            PropertiesPrefixGroup.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getPrefix() {
        String string = this.myPrefix;
        if (string == null) {
            PropertiesPrefixGroup.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public ItemPresentation getPresentation() {
        ItemPresentation itemPresentation = new ItemPresentation(){

            public String getPresentableText() {
                return PropertiesPrefixGroup.this.myPresentableName;
            }

            public String getLocationString() {
                return null;
            }

            public Icon getIcon(boolean open) {
                return AllIcons.Nodes.Advice;
            }
        };
        if (itemPresentation == null) {
            PropertiesPrefixGroup.$$$reportNull$$$0(4);
        }
        return itemPresentation;
    }

    @NotNull
    public Collection<TreeElement> getChildren() {
        ArrayList<TreeElement> result = new ArrayList<TreeElement>();
        List prefixWords = StringUtil.split((String)this.myPrefix, (String)this.mySeparator);
        for (TreeElement treeElement : this.myProperties) {
            boolean startsWith;
            String key;
            Object value;
            if (!(treeElement instanceof StructureViewTreeElement) || !((value = ((StructureViewTreeElement)treeElement).getValue()) instanceof IProperty) || (key = ((IProperty)value).getUnescapedKey()) == null) continue;
            if (!key.equals(this.myPrefix)) {
                List keyWords = StringUtil.split((String)key, (String)this.mySeparator);
                boolean bl = startsWith = prefixWords.size() < keyWords.size();
                if (startsWith) {
                    for (int i = 0; i < prefixWords.size(); ++i) {
                        String prefixWord = (String)prefixWords.get(i);
                        String keyWord = (String)keyWords.get(i);
                        if (Comparing.strEqual((String)keyWord, (String)prefixWord)) continue;
                        startsWith = false;
                        break;
                    }
                }
            } else {
                startsWith = true;
            }
            if (!startsWith) continue;
            result.add(treeElement);
            String presentableName = key.substring(this.myPrefix.length());
            presentableName = StringUtil.trimStart((String)presentableName, (String)this.mySeparator);
            if (treeElement instanceof PropertiesStructureViewElement) {
                ((PropertiesStructureViewElement)treeElement).setPresentableName(presentableName);
            }
            if (!(treeElement instanceof ResourceBundlePropertyStructureViewElement)) continue;
            ((ResourceBundlePropertyStructureViewElement)treeElement).setPresentableName(presentableName);
        }
        ArrayList<TreeElement> arrayList = result;
        if (arrayList == null) {
            PropertiesPrefixGroup.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public IProperty[] getProperties() {
        List elements = ContainerUtil.mapNotNull(this.getChildren(), (Function)((NullableFunction)treeElement -> {
            if (treeElement instanceof PropertiesStructureViewElement) {
                PropertiesStructureViewElement propertiesElement = (PropertiesStructureViewElement)treeElement;
                return propertiesElement.getValue();
            }
            if (treeElement instanceof ResourceBundlePropertyStructureViewElement) {
                return ((ResourceBundlePropertyStructureViewElement)treeElement).getProperties()[0];
            }
            return null;
        }));
        IProperty[] iPropertyArray = elements.toArray(IProperty.EMPTY_ARRAY);
        if (iPropertyArray == null) {
            PropertiesPrefixGroup.$$$reportNull$$$0(6);
        }
        return iPropertyArray;
    }

    @Override
    @Nullable
    public PsiFile[] getFiles() {
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertiesPrefixGroup group = (PropertiesPrefixGroup)o;
        return this.myPrefix.equals(group.myPrefix);
    }

    public int hashCode() {
        return this.myPrefix.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/properties/structureView/PropertiesPrefixGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/properties/structureView/PropertiesPrefixGroup";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeparator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrefix";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

