/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.process.ColoredOutputTypeRegistry;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.LineSeparator;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnsiEscapeDecoder {
    private static final char ESC_CHAR = '\u001b';
    private static final String CSI = "\u001b[";
    private static final String M_CSI = "m\u001b[";
    private static final char BACKSPACE = '\b';
    private final ColoredOutputTypeRegistry myColoredOutputTypeRegistry = ColoredOutputTypeRegistry.getInstance();
    private String myUnhandledStdout;
    private String myUnhandledStderr;
    private ProcessOutputType myCurrentStdoutOutputType;
    private ProcessOutputType myCurrentStderrOutputType;

    public void escapeText(@NotNull String text, @NotNull Key outputType, @NotNull ColoredTextAcceptor textAcceptor) {
        if (text == null) {
            AnsiEscapeDecoder.$$$reportNull$$$0(0);
        }
        if (outputType == null) {
            AnsiEscapeDecoder.$$$reportNull$$$0(1);
        }
        if (textAcceptor == null) {
            AnsiEscapeDecoder.$$$reportNull$$$0(2);
        }
        text = this.prependUnhandledText(text, outputType);
        text = AnsiEscapeDecoder.normalizeAsciiControlCharacters(text);
        int pos = 0;
        List<Pair<String, Key>> chunks = null;
        int unhandledSuffixLength = 0;
        while (true) {
            int escSeqEndInd;
            int escSeqBeginInd;
            if ((escSeqBeginInd = AnsiEscapeDecoder.findEscSeqBeginIndex(text, pos)) < 0) {
                if (escSeqBeginInd < -1) {
                    unhandledSuffixLength = AnsiEscapeDecoder.decodeUnhandledSuffixLength(escSeqBeginInd);
                }
                if (pos >= text.length() - unhandledSuffixLength) break;
                chunks = this.processTextChunk(chunks, text.substring(pos, text.length() - unhandledSuffixLength), outputType, textAcceptor);
                break;
            }
            if (pos < escSeqBeginInd) {
                chunks = this.processTextChunk(chunks, text.substring(pos, escSeqBeginInd), outputType, textAcceptor);
            }
            if ((escSeqEndInd = AnsiEscapeDecoder.findConsecutiveEscSequencesEndIndex(text, escSeqBeginInd)) < 0) {
                if (escSeqEndInd >= -1) break;
                unhandledSuffixLength = AnsiEscapeDecoder.decodeUnhandledSuffixLength(escSeqEndInd);
                break;
            }
            if (text.charAt(escSeqEndInd) == 'm') {
                String escSeq = text.substring(escSeqBeginInd, escSeqEndInd + 1);
                String colorAttribute = StringUtil.replace((String)escSeq, (String)M_CSI, (String)";");
                ProcessOutputType resultType = this.myColoredOutputTypeRegistry.getOutputType(colorAttribute, outputType);
                if (resultType.isStdout()) {
                    this.myCurrentStdoutOutputType = resultType;
                } else if (resultType.isStderr()) {
                    this.myCurrentStderrOutputType = resultType;
                }
            }
            pos = escSeqEndInd + 1;
        }
        this.updateUnhandledSuffix(text, outputType, unhandledSuffixLength);
        if (chunks != null && textAcceptor instanceof ColoredChunksAcceptor) {
            ((ColoredChunksAcceptor)textAcceptor).coloredChunksAvailable(chunks);
        }
    }

    private void updateUnhandledSuffix(@NotNull String text, @NotNull Key outputType, int unhandledSuffixLength) {
        String unhandledSuffix;
        if (text == null) {
            AnsiEscapeDecoder.$$$reportNull$$$0(3);
        }
        if (outputType == null) {
            AnsiEscapeDecoder.$$$reportNull$$$0(4);
        }
        String string = unhandledSuffix = unhandledSuffixLength > 0 ? text.substring(text.length() - unhandledSuffixLength) : null;
        if (ProcessOutputType.isStdout((Key)outputType)) {
            this.myUnhandledStdout = unhandledSuffix;
        } else if (ProcessOutputType.isStderr((Key)outputType)) {
            this.myUnhandledStderr = unhandledSuffix;
        }
    }

    @NotNull
    private String prependUnhandledText(@NotNull String text, @NotNull Key outputType) {
        if (text == null) {
            AnsiEscapeDecoder.$$$reportNull$$$0(5);
        }
        if (outputType == null) {
            AnsiEscapeDecoder.$$$reportNull$$$0(6);
        }
        String prevUnhandledText = null;
        if (ProcessOutputType.isStdout((Key)outputType)) {
            prevUnhandledText = this.myUnhandledStdout;
            this.myUnhandledStdout = null;
        } else if (ProcessOutputType.isStderr((Key)outputType)) {
            prevUnhandledText = this.myUnhandledStderr;
            this.myUnhandledStderr = null;
        }
        String string = prevUnhandledText != null ? prevUnhandledText + text : text;
        if (string == null) {
            AnsiEscapeDecoder.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    private static String normalizeAsciiControlCharacters(@NotNull String text) {
        int ind;
        if (text == null) {
            AnsiEscapeDecoder.$$$reportNull$$$0(8);
        }
        if ((ind = text.indexOf(8)) == -1) {
            String string = text;
            if (string == null) {
                AnsiEscapeDecoder.$$$reportNull$$$0(9);
            }
            return string;
        }
        StringBuilder result2 = new StringBuilder();
        int i = 0;
        int guardIndex = 0;
        boolean removalFromPrevTextAttempted = false;
        while (i < text.length()) {
            LineSeparator lineSeparator = StringUtil.getLineSeparatorAt((CharSequence)text, (int)i);
            if (lineSeparator != null) {
                i += lineSeparator.getSeparatorString().length();
                result2.append(lineSeparator.getSeparatorString());
                guardIndex = result2.length();
                continue;
            }
            if (text.charAt(i) == '\b') {
                if (result2.length() > guardIndex) {
                    result2.setLength(result2.length() - 1);
                } else if (guardIndex == 0) {
                    removalFromPrevTextAttempted = true;
                }
            } else {
                result2.append(text.charAt(i));
            }
            ++i;
        }
        if (removalFromPrevTextAttempted) {
            result2.insert(0, LineSeparator.LF.getSeparatorString());
        }
        String string = result2.toString();
        if (string == null) {
            AnsiEscapeDecoder.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static int findEscSeqBeginIndex(@NotNull String text, int fromIndex) {
        int ind;
        if (text == null) {
            AnsiEscapeDecoder.$$$reportNull$$$0(11);
        }
        if ((ind = text.indexOf(CSI.charAt(0), fromIndex)) == -1) {
            return -1;
        }
        if (ind == text.length() - 1) {
            return AnsiEscapeDecoder.encodeUnhandledSuffixLength(text, ind);
        }
        return text.charAt(ind + 1) == CSI.charAt(1) ? ind : -1;
    }

    private static int findConsecutiveEscSequencesEndIndex(@NotNull String text, int firstEscSeqBeginInd) {
        int escSeqEndInd;
        if (text == null) {
            AnsiEscapeDecoder.$$$reportNull$$$0(12);
        }
        int escSeqBeginInd = firstEscSeqBeginInd;
        int lastMatchedColorEscSeqEndInd = -1;
        while ((escSeqEndInd = AnsiEscapeDecoder.findEscSeqEndIndex(text, escSeqBeginInd)) >= 0) {
            if (text.charAt(escSeqEndInd) != 'm') {
                return lastMatchedColorEscSeqEndInd > 0 ? lastMatchedColorEscSeqEndInd : escSeqEndInd;
            }
            escSeqBeginInd = escSeqEndInd + 1;
            lastMatchedColorEscSeqEndInd = escSeqEndInd;
            if (escSeqEndInd + 1 >= text.length()) {
                return AnsiEscapeDecoder.encodeUnhandledSuffixLength(text, firstEscSeqBeginInd);
            }
            if (text.charAt(escSeqEndInd + 1) != CSI.charAt(0)) break;
            if (escSeqEndInd + 2 >= text.length()) {
                return AnsiEscapeDecoder.encodeUnhandledSuffixLength(text, firstEscSeqBeginInd);
            }
            if (text.charAt(escSeqEndInd + 2) == CSI.charAt(1)) continue;
        }
        if (escSeqEndInd < -1) {
            return AnsiEscapeDecoder.encodeUnhandledSuffixLength(text, firstEscSeqBeginInd);
        }
        return lastMatchedColorEscSeqEndInd;
    }

    private static int findEscSeqEndIndex(@NotNull String text, int escSeqBeginInd) {
        char ch;
        int parameterEndInd;
        if (text == null) {
            AnsiEscapeDecoder.$$$reportNull$$$0(13);
        }
        for (parameterEndInd = escSeqBeginInd + CSI.length(); parameterEndInd < text.length() && (Character.isDigit(ch = text.charAt(parameterEndInd)) || ch == ';'); ++parameterEndInd) {
        }
        if (parameterEndInd == text.length()) {
            return AnsiEscapeDecoder.encodeUnhandledSuffixLength(text, escSeqBeginInd);
        }
        return StringUtil.containsChar((String)"ABCDEFGHJKSTfmisu", (char)text.charAt(parameterEndInd)) ? parameterEndInd : -1;
    }

    private static int encodeUnhandledSuffixLength(@NotNull String text, int suffixStartInd) {
        if (text == null) {
            AnsiEscapeDecoder.$$$reportNull$$$0(14);
        }
        return -1 - (text.length() - suffixStartInd);
    }

    private static int decodeUnhandledSuffixLength(int encodedUnhandledSuffixLength) {
        if (encodedUnhandledSuffixLength >= -1) {
            throw new AssertionError();
        }
        return -encodedUnhandledSuffixLength - 1;
    }

    @Nullable
    private List<Pair<String, Key>> processTextChunk(@Nullable List<Pair<String, Key>> buffer, @NotNull String text, @NotNull Key outputType, @NotNull ColoredTextAcceptor textAcceptor) {
        if (text == null) {
            AnsiEscapeDecoder.$$$reportNull$$$0(15);
        }
        if (outputType == null) {
            AnsiEscapeDecoder.$$$reportNull$$$0(16);
        }
        if (textAcceptor == null) {
            AnsiEscapeDecoder.$$$reportNull$$$0(17);
        }
        Key attributes = this.getCurrentOutputAttributes(outputType);
        if (textAcceptor instanceof ColoredChunksAcceptor) {
            if (buffer == null) {
                buffer = ContainerUtil.newArrayListWithCapacity((int)1);
            }
            buffer.add(Pair.create((Object)text, (Object)attributes));
        } else {
            textAcceptor.coloredTextAvailable(text, attributes);
        }
        return buffer;
    }

    @NotNull
    protected Key getCurrentOutputAttributes(@NotNull Key outputType) {
        if (outputType == null) {
            AnsiEscapeDecoder.$$$reportNull$$$0(18);
        }
        if (ProcessOutputType.isStdout((Key)outputType)) {
            Key key = (Key)ObjectUtils.notNull((Object)this.myCurrentStdoutOutputType, (Object)outputType);
            if (key == null) {
                AnsiEscapeDecoder.$$$reportNull$$$0(19);
            }
            return key;
        }
        if (ProcessOutputType.isStderr((Key)outputType)) {
            Key key = (Key)ObjectUtils.notNull((Object)this.myCurrentStderrOutputType, (Object)outputType);
            if (key == null) {
                AnsiEscapeDecoder.$$$reportNull$$$0(20);
            }
            return key;
        }
        Key key = outputType;
        if (key == null) {
            AnsiEscapeDecoder.$$$reportNull$$$0(21);
        }
        return key;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 19: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputType";
                break;
            }
            case 2: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textAcceptor";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/process/AnsiEscapeDecoder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/process/AnsiEscapeDecoder";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "prependUnhandledText";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeAsciiControlCharacters";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentOutputAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "escapeText";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateUnhandledSuffix";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "prependUnhandledText";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "normalizeAsciiControlCharacters";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findEscSeqBeginIndex";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findConsecutiveEscSequencesEndIndex";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findEscSeqEndIndex";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "encodeUnhandledSuffixLength";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processTextChunk";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentOutputAttributes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    public static interface ColoredTextAcceptor {
        public void coloredTextAvailable(@NotNull String var1, @NotNull Key var2);
    }

    public static interface ColoredChunksAcceptor
    extends ColoredTextAcceptor {
        public void coloredChunksAvailable(@NotNull List<Pair<String, Key>> var1);
    }
}

