/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

abstract class MnemonicWrapper<T extends JComponent>
implements Runnable,
PropertyChangeListener {
    final T myComponent;
    private final String myTextProperty;
    private final String myCodeProperty;
    private final String myIndexProperty;
    private int myCode;
    private int myIndex;
    private boolean myFocusable;
    private boolean myEvent;
    private boolean myTextChanged;
    private Runnable myRunnable;

    public static MnemonicWrapper getWrapper(Component component) {
        if (component == null || component.getClass().getName().equals("com.intellij.openapi.wm.impl.StripeButton")) {
            return null;
        }
        for (PropertyChangeListener listener : component.getPropertyChangeListeners()) {
            if (!(listener instanceof MnemonicWrapper)) continue;
            MnemonicWrapper wrapper = (MnemonicWrapper)listener;
            wrapper.run();
            return wrapper;
        }
        if (component instanceof JMenuItem) {
            return new MenuWrapper((AbstractButton)component);
        }
        if (component instanceof AbstractButton) {
            return new ButtonWrapper((AbstractButton)component);
        }
        if (component instanceof JLabel) {
            return new LabelWrapper((JLabel)component);
        }
        return null;
    }

    private MnemonicWrapper(T component, String text, String code, String index) {
        this.myComponent = component;
        this.myTextProperty = text;
        this.myCodeProperty = code;
        this.myIndexProperty = index;
        if (!this.updateText()) {
            this.myCode = this.getMnemonicCode();
            this.myIndex = this.getMnemonicIndex();
        }
        this.myFocusable = this.isFocusable();
        ((Container)this.myComponent).addPropertyChangeListener(this);
        this.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        boolean disabled = this.isDisabled();
        try {
            Component component;
            int index;
            InputMap map;
            int code;
            this.myEvent = true;
            if (this.myTextChanged) {
                this.updateText();
            }
            int n = code = disabled ? 0 : this.myCode;
            if (code != this.getMnemonicCode()) {
                this.setMnemonicCode(code);
            }
            if (SystemInfo.isMac && Registry.is((String)"ide.mac.alt.mnemonic.without.ctrl") && (map = ((JComponent)this.myComponent).getInputMap(2)) != null) {
                this.updateInputMap(map, code);
            }
            int n2 = index = disabled ? -1 : this.myIndex;
            if (index != this.getMnemonicIndex()) {
                try {
                    this.setMnemonicIndex(index);
                }
                catch (IllegalArgumentException cause) {
                    StringBuilder sb = new StringBuilder("cannot set mnemonic index ");
                    if (this.myTextChanged) {
                        sb.append("if text changed ");
                    }
                    String message = sb.append(this.myComponent).toString();
                    Logger.getInstance(MnemonicWrapper.class).warn(message, (Throwable)cause);
                }
            }
            if ((component = this.getFocusableComponent()) != null) {
                component.setFocusable(disabled || this.myFocusable);
            }
        }
        finally {
            this.myEvent = false;
            this.myTextChanged = false;
            this.myRunnable = null;
        }
    }

    @Override
    public final void propertyChange(PropertyChangeEvent event) {
        if (!this.myEvent) {
            String property2 = event.getPropertyName();
            if (this.myTextProperty.equals(property2)) {
                this.myTextChanged = true;
                this.updateRequest();
            } else if (this.myCodeProperty.equals(property2)) {
                this.myCode = this.getMnemonicCode();
                this.updateRequest();
            } else if (this.myIndexProperty.equals(property2)) {
                this.myIndex = this.getMnemonicIndex();
                this.updateRequest();
            } else if ("focusable".equals(property2) || "labelFor".equals(property2)) {
                this.myFocusable = this.isFocusable();
                this.updateRequest();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateText() {
        String text = this.getText();
        if (text != null) {
            int code = 0;
            int index = -1;
            int length = text.length();
            StringBuilder sb = new StringBuilder(length);
            for (int i = 0; i < length; ++i) {
                char ch = text.charAt(i);
                if (ch != '\u001b') {
                    sb.append(ch);
                    continue;
                }
                if (i + 1 >= length) continue;
                code = KeyEvent.getExtendedKeyCodeForChar(text.charAt(i + 1));
                index = sb.length();
            }
            if (code != 0) {
                try {
                    this.myEvent = true;
                    this.setText(sb.toString());
                }
                finally {
                    this.myEvent = false;
                }
                this.myCode = code;
                this.myIndex = index;
                return true;
            }
        }
        return false;
    }

    private void updateRequest() {
        if (this.myRunnable == null) {
            this.myRunnable = this;
            SwingUtilities.invokeLater(this);
        }
    }

    private boolean isFocusable() {
        Component component = this.getFocusableComponent();
        return component == null || component.isFocusable();
    }

    Component getFocusableComponent() {
        return this.myComponent;
    }

    boolean isDisabled() {
        return UISettings.getShadowInstance().getDisableMnemonicsInControls();
    }

    abstract String getText();

    abstract void setText(String var1);

    abstract int getMnemonicCode();

    abstract void setMnemonicCode(int var1);

    abstract int getMnemonicIndex();

    abstract void setMnemonicIndex(int var1);

    abstract void updateInputMap(InputMap var1, int var2);

    static KeyStroke fixMacKeyStroke(KeyStroke stroke, InputMap map, int code, boolean onKeyRelease, String action) {
        if (stroke != null && code != stroke.getKeyCode()) {
            map.remove(stroke);
            stroke = null;
        }
        if (stroke == null && code != 0) {
            stroke = KeyStroke.getKeyStroke(code, 520, onKeyRelease);
            map.put(stroke, action);
        }
        return stroke;
    }

    /* synthetic */ MnemonicWrapper(JComponent x0, String x1, String x2, String x3, 1 x4) {
        this(x0, x1, x2, x3);
    }

    private static class LabelWrapper
    extends MnemonicWrapper<JLabel> {
        private KeyStroke myStrokeRelease;

        private LabelWrapper(JLabel component) {
            super(component, "text", "displayedMnemonic", "displayedMnemonicIndex", null);
        }

        @Override
        void updateInputMap(InputMap map, int code) {
            this.myStrokeRelease = LabelWrapper.fixMacKeyStroke(this.myStrokeRelease, map, code, true, "release");
        }

        @Override
        String getText() {
            return ((JLabel)this.myComponent).getText();
        }

        @Override
        void setText(String text) {
            ((JLabel)this.myComponent).setText(text);
        }

        @Override
        int getMnemonicCode() {
            return ((JLabel)this.myComponent).getDisplayedMnemonic();
        }

        @Override
        void setMnemonicCode(int code) {
            ((JLabel)this.myComponent).setDisplayedMnemonic(code);
        }

        @Override
        int getMnemonicIndex() {
            return ((JLabel)this.myComponent).getDisplayedMnemonicIndex();
        }

        @Override
        void setMnemonicIndex(int index) {
            ((JLabel)this.myComponent).setDisplayedMnemonicIndex(index);
        }

        @Override
        Component getFocusableComponent() {
            return ((JLabel)this.myComponent).getLabelFor();
        }
    }

    private static abstract class AbstractButtonWrapper
    extends MnemonicWrapper<AbstractButton> {
        private AbstractButtonWrapper(AbstractButton component) {
            super(component, "text", "mnemonic", "displayedMnemonicIndex", null);
        }

        @Override
        String getText() {
            return ((AbstractButton)this.myComponent).getText();
        }

        @Override
        void setText(String text) {
            ((AbstractButton)this.myComponent).setText(text);
        }

        @Override
        int getMnemonicCode() {
            return ((AbstractButton)this.myComponent).getMnemonic();
        }

        @Override
        void setMnemonicCode(int code) {
            ((AbstractButton)this.myComponent).setMnemonic(code);
        }

        @Override
        int getMnemonicIndex() {
            return ((AbstractButton)this.myComponent).getDisplayedMnemonicIndex();
        }

        @Override
        void setMnemonicIndex(int index) {
            ((AbstractButton)this.myComponent).setDisplayedMnemonicIndex(index);
        }
    }

    private static class ButtonWrapper
    extends AbstractButtonWrapper {
        private KeyStroke myStrokePressed;
        private KeyStroke myStrokeReleased;

        private ButtonWrapper(AbstractButton component) {
            super(component);
        }

        @Override
        void updateInputMap(InputMap map, int code) {
            this.myStrokePressed = ButtonWrapper.fixMacKeyStroke(this.myStrokePressed, map, code, false, "pressed");
            this.myStrokeReleased = ButtonWrapper.fixMacKeyStroke(this.myStrokeReleased, map, code, true, "released");
        }
    }

    private static class MenuWrapper
    extends AbstractButtonWrapper {
        private KeyStroke myStrokePressed;

        private MenuWrapper(AbstractButton component) {
            super(component);
        }

        @Override
        void updateInputMap(InputMap map, int code) {
            this.myStrokePressed = MenuWrapper.fixMacKeyStroke(this.myStrokePressed, map, code, false, "selectMenu");
        }
    }
}

